/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import java.awt.Color;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class NimRODTheme
extends DefaultMetalTheme {
    public static final int DEFAULT_MENU_OPACITY = 195;
    public static final int DEFAULT_FRAME_OPACITY = 180;
    private ColorUIResource primary1 = new ColorUIResource(229, 189, 0);
    private ColorUIResource primary2 = new ColorUIResource(239, 199, 0);
    private ColorUIResource primary3 = new ColorUIResource(249, 209, 0);
    private ColorUIResource secondary1 = new ColorUIResource(217, 215, 173);
    private ColorUIResource secondary2 = new ColorUIResource(227, 225, 183);
    private ColorUIResource secondary3 = new ColorUIResource(237, 235, 193);
    private ColorUIResource black = new ColorUIResource(0, 0, 0);
    private ColorUIResource white = new ColorUIResource(255, 255, 255);
    private FontUIResource font = new FontUIResource("SansSerif", 0, 12);
    private FontUIResource boldFont = new FontUIResource("SansSerif", 1, 12);
    private int opacidadMenu = 195;
    private int opacidadFrame = 180;

    public NimRODTheme() {
    }

    public NimRODTheme(String string) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(string);
        }
        catch (Exception exception) {
            string = "/" + string;
            inputStream = this.getClass().getResourceAsStream(string);
        }
        if (inputStream != null) {
            try {
                properties.load(inputStream);
                ((InputStream)inputStream).close();
                this.initFromProps(properties);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public NimRODTheme(URL uRL) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            properties.load(inputStream);
            inputStream.close();
            this.initFromProps(properties);
        }
        catch (Exception exception) {
            return;
        }
    }

    private void initFromProps(Properties properties) {
        this.setPrimary1(Color.decode(properties.getProperty("nimrodlf.p1")));
        this.setPrimary2(Color.decode(properties.getProperty("nimrodlf.p2")));
        this.setPrimary3(Color.decode(properties.getProperty("nimrodlf.p3")));
        this.setSecondary1(Color.decode(properties.getProperty("nimrodlf.s1")));
        this.setSecondary2(Color.decode(properties.getProperty("nimrodlf.s2")));
        this.setSecondary3(Color.decode(properties.getProperty("nimrodlf.s3")));
        this.setWhite(Color.decode(properties.getProperty("nimrodlf.w")));
        this.setBlack(Color.decode(properties.getProperty("nimrodlf.b")));
        this.setMenuOpacity(Integer.parseInt(properties.getProperty("nimrodlf.menuOpacity")));
        this.setFrameOpacity(Integer.parseInt(properties.getProperty("nimrodlf.frameOpacity")));
        if (properties.getProperty("nimrodlf.font") != null) {
            this.setFont(Font.decode(properties.getProperty("nimrodlf.font")));
        }
    }

    public NimRODTheme(Color color) {
        this.setPrimary(color);
    }

    public NimRODTheme(Color color, Color color2) {
        this.setPrimary(color);
        this.setSecondary(color2);
    }

    @Override
    public String getName() {
        return "NimROD Theme";
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    @Override
    protected ColorUIResource getBlack() {
        return this.black;
    }

    @Override
    protected ColorUIResource getWhite() {
        return this.white;
    }

    public void setPrimary(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        this.primary1 = new ColorUIResource(new Color(n > 20 ? n - 20 : 0, n2 > 20 ? n2 - 20 : 0, n3 > 20 ? n3 - 20 : 0));
        this.primary2 = new ColorUIResource(new Color(n > 10 ? n - 10 : 0, n2 > 10 ? n2 - 10 : 0, n3 > 10 ? n3 - 10 : 0));
        this.primary3 = new ColorUIResource(color);
    }

    public void setSecondary(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        this.secondary1 = new ColorUIResource(new Color(n > 20 ? n - 20 : 0, n2 > 20 ? n2 - 20 : 0, n3 > 20 ? n3 - 20 : 0));
        this.secondary2 = new ColorUIResource(new Color(n > 10 ? n - 10 : 0, n2 > 10 ? n2 - 10 : 0, n3 > 10 ? n3 - 10 : 0));
        this.secondary3 = new ColorUIResource(color);
    }

    public void setPrimary1(Color color) {
        this.primary1 = new ColorUIResource(color);
    }

    public void setPrimary2(Color color) {
        this.primary2 = new ColorUIResource(color);
    }

    public void setPrimary3(Color color) {
        this.primary3 = new ColorUIResource(color);
    }

    public void setSecondary1(Color color) {
        this.secondary1 = new ColorUIResource(color);
    }

    public void setSecondary2(Color color) {
        this.secondary2 = new ColorUIResource(color);
    }

    public void setSecondary3(Color color) {
        this.secondary3 = new ColorUIResource(color);
    }

    public void setBlack(Color color) {
        this.black = new ColorUIResource(color);
    }

    public void setWhite(Color color) {
        this.white = new ColorUIResource(color);
    }

    public void setOpacity(int n) {
        this.setMenuOpacity(n);
    }

    public int getOpacity() {
        return this.getMenuOpacity();
    }

    public void setMenuOpacity(int n) {
        if (n < 0 || n > 255) {
            throw new NumberFormatException("MenuOpacity out of range [0,255]: " + n);
        }
        this.opacidadMenu = n;
    }

    public int getMenuOpacity() {
        return this.opacidadMenu;
    }

    public void setFrameOpacity(int n) {
        if (n < 0 || n > 255) {
            throw new NumberFormatException("MenuOpacity out of range [0,255]: " + n);
        }
        this.opacidadFrame = n;
    }

    public int getFrameOpacity() {
        return this.opacidadFrame;
    }

    public void setFont(Font font) {
        this.font = new FontUIResource(font);
        this.boldFont = new FontUIResource(font.deriveFont(1));
    }

    @Override
    public FontUIResource getControlTextFont() {
        return this.font;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return this.font;
    }

    @Override
    public FontUIResource getSubTextFont() {
        return this.font;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return this.boldFont;
    }

    @Override
    public FontUIResource getUserTextFont() {
        return this.font;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return this.boldFont;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("nimrodlf.p1=" + this.encode(this.primary1) + "\n");
        stringBuffer.append("nimrodlf.p2=" + this.encode(this.primary2) + "\n");
        stringBuffer.append("nimrodlf.p3=" + this.encode(this.primary3) + "\n");
        stringBuffer.append("nimrodlf.s1=" + this.encode(this.secondary1) + "\n");
        stringBuffer.append("nimrodlf.s2=" + this.encode(this.secondary2) + "\n");
        stringBuffer.append("nimrodlf.s3=" + this.encode(this.secondary3) + "\n");
        stringBuffer.append("nimrodlf.w=" + this.encode(this.white) + "\n");
        stringBuffer.append("nimrodlf.b=" + this.encode(this.black) + "\n");
        stringBuffer.append("nimrodlf.menuOpacity=" + this.opacidadMenu + "\n");
        stringBuffer.append("nimrodlf.frameOpacity=" + this.opacidadFrame + "\n");
        stringBuffer.append("nimrodlf.font=" + this.encode(this.font) + "\n");
        return stringBuffer.toString();
    }

    protected String encode(Font font) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(font.getName() + "-");
        if (font.isPlain()) {
            stringBuilder.append("PLAIN-");
        } else if (font.isBold() && font.isItalic()) {
            stringBuilder.append("BOLDITALIC-");
        } else if (font.isBold()) {
            stringBuilder.append("BOLD-");
        } else if (font.isItalic()) {
            stringBuilder.append("ITALIC-");
        }
        stringBuilder.append(font.getSize());
        return stringBuilder.toString();
    }

    protected String encode(Color color) {
        String string = Integer.toHexString(color.getRed()).toUpperCase();
        String string2 = Integer.toHexString(color.getGreen()).toUpperCase();
        String string3 = Integer.toHexString(color.getBlue()).toUpperCase();
        return "#" + (string.length() == 1 ? "0" + string : string) + (string2.length() == 1 ? "0" + string2 : string2) + (string3.length() == 1 ? "0" + string3 : string3);
    }
}

