/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommPortIdentifier;
import gnu.io.NativeResourceException;
import gnu.io.PortInUseException;
import gnu.io.RXTXCommDriver;
import gnu.io.RXTXPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class NRSerialPort {
    private RXTXPort serial;
    private String port = null;
    private boolean connected = false;
    private int baud = 115200;

    public NRSerialPort(String port, int baud) {
        this.setPort(port);
        this.setBaud(baud);
    }

    public boolean connect() {
        if (this.isConnected()) {
            System.err.println(this.port + " is already connected.");
            return true;
        }
        try {
            RXTXPort comm = null;
            CommPortIdentifier ident = null;
            if (System.getProperty("os.name").toLowerCase().indexOf("linux") != -1) {
                System.setProperty("gnu.io.rxtx.SerialPorts", this.port);
            }
            ident = CommPortIdentifier.getPortIdentifier(this.port);
            try {
                comm = ident.open("NRSerialPort", 2000);
            }
            catch (PortInUseException e) {
                System.err.println("This is a bug, passed the ownership test above: " + e.getMessage());
                return false;
            }
            if (!(comm instanceof RXTXPort)) {
                throw new UnsupportedCommOperationException("Non-serial connections are unsupported.");
            }
            this.serial = comm;
            this.serial.enableReceiveTimeout(100);
            this.serial.setSerialPortParams(this.getBaud(), 8, 1, 0);
            this.setConnected(true);
        }
        catch (NativeResourceException e) {
            throw new NativeResourceException(e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Failed to connect on port: " + this.port + " exception: ");
            e.printStackTrace();
            this.setConnected(false);
        }
        if (this.isConnected()) {
            this.serial.notifyOnDataAvailable(true);
        }
        return this.isConnected();
    }

    public InputStream getInputStream() {
        return this.serial.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.serial.getOutputStream();
    }

    private void setPort(String port) {
        this.port = port;
    }

    public void disconnect() {
        try {
            try {
                this.getInputStream().close();
                this.getOutputStream().close();
                this.serial.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.serial = null;
            this.setConnected(false);
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeResourceException(e.getMessage());
        }
    }

    public static Set<String> getAvailableSerialPorts() {
        HashSet<String> available = new HashSet<String>();
        try {
            RXTXCommDriver d = new RXTXCommDriver();
            Set<String> av = d.getPortIdentifiers();
            ArrayList<String> strs = new ArrayList<String>();
            for (String s : av) {
                strs.add(0, s);
            }
            for (String s : strs) {
                available.add(s);
            }
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            throw new NativeResourceException(e.getMessage());
        }
        return available;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        if (this.connected == connected) {
            return;
        }
        this.connected = connected;
    }

    public void setBaud(int baud) {
        switch (baud) {
            case 2400: 
            case 4800: 
            case 9600: 
            case 14400: 
            case 19200: 
            case 28800: 
            case 38400: 
            case 57600: 
            case 76800: 
            case 115200: 
            case 230400: {
                this.baud = baud;
                return;
            }
        }
        throw new RuntimeException("Invalid baudrate! " + baud);
    }

    public int getBaud() {
        return this.baud;
    }

    public void notifyOnDataAvailable(boolean b) {
        this.serial.notifyOnDataAvailable(b);
    }
}

