/*
 * Decompiled with CFR 0.152.
 */
package sbgc.common;

import java.util.Date;
import sbgc.common.IFirmwareInfo;
import sbgc.object.Sprav;

public class FirmwareInfoImpl
extends Sprav
implements IFirmwareInfo {
    public static final int BETA_STABLE = 9;
    private int version = -1;
    private int versionId = -1;
    private String title = null;
    private String description = null;
    private Date regDate = null;

    public FirmwareInfoImpl(int version, int versionId, String title, String description, Date regDate) {
        super(version, FirmwareInfoImpl.getVersionName(version));
        this.version = version;
        this.versionId = versionId;
        this.title = title;
        this.description = description;
        this.regDate = regDate;
    }

    public static String getVersionName(int ver) {
        int major = ver / 1000;
        int minor = ver % 1000 / 10;
        int beta = ver % 10;
        StringBuilder buffer = new StringBuilder();
        buffer.append(major).append(".").append(String.format("%02d", minor));
        if (beta != 9) {
            buffer.append(" b").append(beta);
        }
        return buffer.toString();
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersionId(int versionId) {
        this.versionId = versionId;
    }

    public int getVersionId() {
        return this.versionId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setRegDate(Date regDate) {
        this.regDate = regDate;
    }

    public Date getRegDate() {
        return this.regDate;
    }

    public String toString() {
        if (this.title != null) {
            return this.title;
        }
        return FirmwareInfoImpl.getVersionName(this.version);
    }
}

