/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.util.ArrayList;
import sbgc.object.BoardParams;
import sbgc.service.SerialCommand;
import sbgc.utils.DataLogger;

public class AutoPIDInfo {
    public int[] P = new int[]{0, 0, 0};
    public int[] I = new int[]{0, 0, 0};
    public int[] D = new int[]{0, 0, 0};
    public int[] rms_err = new int[]{0, 0, 0};
    public int[] freq = new int[]{0, 0, 0};
    public int[] good_cnt = new int[]{0, 0, 0};
    public int[] state = new int[]{0, 0, 0};

    public static AutoPIDInfo parse(SerialCommand cmd) throws Exception {
        AutoPIDInfo info = new AutoPIDInfo();
        cmd.readByteArr(info.P);
        cmd.readByteArr(info.I);
        cmd.readByteArr(info.D);
        for (int i = 0; i < 3; ++i) {
            info.rms_err[i] = cmd.readWordUnsigned();
            info.freq[i] = cmd.readWordUnsigned();
        }
        cmd.readByteArr(info.good_cnt);
        cmd.readByteArr(info.state);
        cmd.skipBytes(30);
        return info;
    }

    public static void log_header(DataLogger f) {
        ArrayList<String> h = new ArrayList<String>(30);
        for (int i = 0; i < 3; ++i) {
            String axis = BoardParams.getAxisName(i);
            h.add("P[" + axis + "]");
            h.add("I[" + axis + "]");
            h.add("D[" + axis + "]");
            h.add("RMS_ERR[" + axis + "]");
            h.add("FREQ[" + axis + "]");
            h.add("STATE[" + axis + "]");
            h.add("GOOD_CNT[" + axis + "]");
        }
        f.setHeader(h);
    }

    public void log_data(DataLogger f) {
        ArrayList<String> d = new ArrayList<String>(f.getHeader().size());
        for (int i = 0; i < 3; ++i) {
            d.add(Integer.toString(this.P[i]));
            d.add(Integer.toString(this.I[i]));
            d.add(Integer.toString(this.D[i]));
            d.add(Integer.toString(this.rms_err[i]));
            d.add(Integer.toString(this.freq[i]));
            d.add(Integer.toString(this.state[i]));
            d.add(Integer.toString(this.good_cnt[i]));
        }
        f.logData(d);
    }
}

