/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import sbgc.object.BoardParams;
import sbgc.service.SerialCommand;
import sbgc.utils.HexUtil;
import sbgc.utils.Settings;

public class BoardInfo {
    static final Logger logger = Logger.getLogger((String)BoardParams.class.getName());
    public static final int BOARD_FEATURE_3AXIS = 1;
    public static final int BOARD_FEATURE_BAT_MONITORING = 2;
    public static final int BOARD_FEATURE_ENCODERS = 4;
    public static final int CONNECTION_FLAG_USB = 1;
    public static final int PROFILE_NAME_SIZE = 48;
    public static final int EEPROM_PAGE_SIZE = 64;
    public static final int CMD_DATA_SIZE = 255;
    private static BoardInfo curBoardInfo = null;
    public int boardVer = 0;
    public int frwVer = 0;
    public int frwVerOrig = 0;
    public int debugMode = 0;
    public int boardFeatures = 0;
    public byte[] deviceId = null;
    public byte[] mcuId = null;
    public int connectionFlags = 0;
    public int eeprom_size = 0;
    public String[] profileNames = null;

    public static BoardInfo getBoardInfo() {
        return curBoardInfo;
    }

    public static void setBoardInfo(BoardInfo info) {
        curBoardInfo = info;
    }

    public int getBoardVersion() {
        return this.boardVer;
    }

    public int getFirmwareVersion() {
        return this.frwVer;
    }

    public String getDeviceId() {
        return this.deviceId != null ? HexUtil.toHex(this.deviceId) : "unknown";
    }

    public String getMcuId() {
        return this.mcuId != null ? HexUtil.toHex(this.mcuId) : "unknown";
    }

    public static BoardInfo parse(SerialCommand cmd) throws IOException {
        if (cmd.id == 86) {
            BoardInfo info = new BoardInfo();
            info.boardVer = cmd.readByte();
            info.frwVer = info.frwVerOrig = cmd.readWordUnsigned();
            try {
                info.frwVer += Integer.parseInt(Settings.get("firmware_version.shift", "0"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            info.debugMode = cmd.readByte();
            info.boardFeatures = cmd.readWordUnsigned();
            info.connectionFlags = cmd.readByte();
            cmd.skipBytes(11);
            cmd.checkFinished();
            curBoardInfo = info;
        } else if (cmd.id == 20) {
            if (curBoardInfo != null) {
                BoardInfo.curBoardInfo.deviceId = cmd.readBytes(9);
                BoardInfo.curBoardInfo.mcuId = cmd.readBytes(12);
                BoardInfo.curBoardInfo.eeprom_size = (int)cmd.readDWordUnsigned();
                cmd.skipBytes(44);
                cmd.checkFinished();
            } else {
                throw new IOException("Command CMD_BOARD_INFO_3 can't be parsed before CMD_BOARD_INFO!");
            }
        }
        return curBoardInfo;
    }

    public String toString() {
        return "boardVer: " + this.boardVer + ", frwVer: " + this.frwVer + ", deviceId: " + Arrays.toString(this.deviceId);
    }

    public boolean hasExpansionBoard() {
        return (this.boardFeatures & 1) > 0;
    }

    public static boolean hasBatterryMonitoring() {
        return curBoardInfo != null && (BoardInfo.curBoardInfo.boardVer >= 30 || (BoardInfo.curBoardInfo.boardFeatures & 2) > 0);
    }

    public static int getNumProfiles() {
        return curBoardInfo != null && BoardInfo.curBoardInfo.boardVer >= 30 ? 5 : 3;
    }

    public void parseProfileNames(SerialCommand cmd) throws IOException {
        BoardParams params = BoardParams.getCurParams();
        this.profileNames = new String[BoardInfo.getNumProfiles()];
        for (int i = 0; i < this.profileNames.length; ++i) {
            try {
                this.profileNames[i] = new String(cmd.readBytes(48), "UTF-8").replace('\u0000', ' ').trim();
                logger.debug((Object)("Profile name" + i + ": '" + this.profileNames[i] + "' [" + HexUtil.toHex(this.profileNames[i].getBytes()) + "]"));
            }
            catch (Exception e) {
                logger.error((Object)("Error parsing profile name: " + e.toString()));
            }
            if (this.profileNames[i] == null || this.profileNames[i].equals("")) {
                this.profileNames[i] = null;
                continue;
            }
            if (params == null) continue;
            params.setProfileName(i, this.profileNames[i]);
        }
    }

    public SerialCommand formatProfileNamesCmd() throws Exception {
        if (this.profileNames != null) {
            SerialCommand cmd = new SerialCommand(29, 512);
            for (int i = 0; i < this.profileNames.length; ++i) {
                byte[] buf;
                String name = this.profileNames[i];
                if (name == null) {
                    name = "";
                }
                if ((buf = name.getBytes("UTF-8")).length <= 48) {
                    cmd.write(buf);
                    for (int j = buf.length; j < 48; ++j) {
                        cmd.writeByte(0);
                    }
                    continue;
                }
                throw new Exception("Profile " + (i + 1) + " name is too long!");
            }
            return cmd;
        }
        throw new Exception("Saving profile names to board is not supported!");
    }

    public static boolean checkMinBoardVer(int ver) {
        return curBoardInfo != null && BoardInfo.curBoardInfo.boardVer >= ver;
    }

    public static boolean checkMinFirmwareVer(int ver) {
        return curBoardInfo != null && BoardInfo.curBoardInfo.frwVer >= ver;
    }

    public static boolean hasBoardFeature(int feature) {
        return curBoardInfo != null && (BoardInfo.curBoardInfo.boardFeatures & feature) > 0;
    }

    public static boolean hasExtendedParams() {
        return BoardInfo.checkMinBoardVer(30) && BoardInfo.checkMinFirmwareVer(2420);
    }

    public static boolean hasAdjVars() {
        return BoardInfo.checkMinBoardVer(30) && BoardInfo.checkMinFirmwareVer(2430);
    }

    public static boolean hasFilters() {
        return BoardInfo.checkMinBoardVer(30) && BoardInfo.checkMinFirmwareVer(2420);
    }

    public static boolean hasScripting() {
        return false;
    }

    public boolean canSaveProfileNames() {
        return this.profileNames != null;
    }

    public static boolean isDebugMode() {
        return curBoardInfo != null && BoardInfo.curBoardInfo.debugMode > 0;
    }

    public void setProfileName(int profileId, String name) {
        if (this.profileNames != null && profileId < this.profileNames.length) {
            this.profileNames[profileId] = name;
        }
    }
}

