/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import sbgc.object.AdjVarAnalogCfg;
import sbgc.object.AdjVarTriggerCfg;
import sbgc.object.BoardInfo;
import sbgc.object.BoardProfile;
import sbgc.service.SerialCommand;

@XStreamAlias(value="board-params")
public class BoardParams
implements Cloneable {
    static final Logger logger = Logger.getLogger((String)BoardParams.class.getName());
    public static final int ROLL = 0;
    public static final int PITCH = 1;
    public static final int YAW = 2;
    public static final String[] axisName = new String[]{"ROLL", "PITCH", "YAW"};
    public static final int NUM_PROFILES_MAX = 5;
    public static final int CMD_NO = 0;
    public static final int CMD_PROFILE1 = 1;
    public static final int CMD_PROFILE2 = 2;
    public static final int CMD_PROFILE3 = 3;
    public static final int CMD_SWAP_PITCH_ROLL = 4;
    public static final int CMD_SWAP_YAW_ROLL = 5;
    public static final int CMD_CALIB_ACC = 6;
    public static final int CMD_RESET = 7;
    public static final int CMD_SET_ANGLE = 8;
    public static final int CMD_CALIB_GYRO = 9;
    public static final int CMD_MOTOR_TOGGLE = 10;
    public static final int CMD_MOTOR_ON = 11;
    public static final int CMD_MOTOR_OFF = 12;
    public static final int CMD_FRAME_UPSIDE_DOWN = 13;
    public static final int CMD_PROFILE4 = 14;
    public static final int CMD_PROFILE5 = 15;
    public static final int CMD_AUTO_PID = 16;
    public static final int CMD_LOOK_DOWN = 17;
    public static final int CMD_HOME_POSITION = 18;
    public static final int CMD_RC_BIND = 19;
    public static final int RC_VIRT_MODE_NORMAL = 0;
    public static final int RC_VIRT_MODE_CPPM = 1;
    public static final int RC_VIRT_MODE_SBUS = 2;
    public static final int RC_VIRT_MODE_SPEKTRUM = 3;
    public static final int RC_INPUT_ANALOG_BIT = 32;
    public static final int RC_INPUT_VIRT_BIT = 64;
    public static final int RC_INPUT_API_VIRT_BIT = 128;
    public static final int INPUT_NO = 0;
    public static final int RC_INPUT_ROLL = 1;
    public static final int RC_INPUT_PITCH = 2;
    public static final int EXT_FC_INPUT_ROLL = 3;
    public static final int EXT_FC_INPUT_PITCH = 4;
    public static final int RC_INPUT_YAW = 5;
    public static final int RC_INPUT_ADC1 = 33;
    public static final int RC_INPUT_ADC2 = 34;
    public static final int RC_INPUT_ADC3 = 35;
    public static final int BEEPER_MODE_CALIBRATE = 1;
    public static final int BEEPER_MODE_CONFIRM = 2;
    public static final int BEEPER_MODE_ERROR = 4;
    public static final int BEEPER_MODE_ALARM = 8;
    public static final int BEEPER_MODE_MOTORS = 128;
    public static final int IMU_TYPE_MAIN = 1;
    public static final int IMU_TYPE_FRAME = 2;
    public static final int ENCODER_TYPE_MASK = 15;
    public static final int ENCODER_FORCE_BIT = 16;
    public static final int ENC_TYPE_AS5048A = 1;
    public static final int ENC_TYPE_AS5048B = 2;
    public static final int ENC_TYPE_AS5048_PWM = 3;
    public static final int ENC_TYPE_AMT203 = 4;
    public static final int ENC_TYPE_MA3_10BIT = 5;
    public static final int ENC_TYPE_MA3_12BIT = 6;
    public static final String[] ENC_TYPE_NAMES = new String[]{"DISABLED", "AS5048A (SPI)", "AS5048B (I2C)", "AS5048A,B (PWM)", "AMT203 (SPI)"};
    public static final int FLAG1_REMEBER_LAST_USED_PROFILE = 1;
    private static BoardParams curParams = new BoardParams();
    @XStreamOmitField
    public BoardProfile[] profiles;
    public int axisTop = 0;
    public int axisRight = 0;
    public int frameAxisTop = 0;
    public int frameAxisRight = 0;
    public int gyroLPF = 0;
    public int gyroSens = 0;
    public int frame_imu_pos = 0;
    public boolean i2c_pullups = false;
    public boolean skip_gyro_cal = false;
    public int[] rcCmd = new int[]{0, 0, 0};
    public int[] menuCmd = new int[]{0, 0, 0, 0, 0, 0};
    public int[] outputMap = new int[]{0, 0, 0};
    public int[] followOffset = new int[]{0, 0, 0};
    public int bat_threshold_alarm = 0;
    public int bat_threshold_motors = 0;
    public int bat_comp_ref = 0;
    public int beeper_modes;
    public int[] rcMemory = new int[]{0, 0, 0};
    public int general_flags1 = 0;
    public int encoder_type = 0;
    public int[] encoder_offset = new int[]{0, 0, 0};
    public int[] encoder_fld_offset = new int[]{0, 0, 0};
    public int[] manual_set_time = new int[]{0, 0, 0};
    public int[] motor_heating_factor = new int[]{0, 0, 0};
    public int[] motor_cooling_factor = new int[]{0, 0, 0};
    public int encoder_cfg = 0;
    public int encoder_lpf = 0;
    public int[] encoder_mag_link = new int[]{0, 0, 0};
    public int[] motor_gear = new int[]{0, 0, 0};
    public AdjVarTriggerCfg[] adj_vars_trigger = new AdjVarTriggerCfg[10];
    public AdjVarAnalogCfg[] adj_vars_analog = new AdjVarAnalogCfg[15];
    @XStreamOmitField
    public int curProfile = 0;
    @XStreamOmitField
    public int curIMU = 1;

    public static final String getAxisName(int axis) {
        return axisName[axis];
    }

    public BoardParams() {
        int i;
        this.profiles = new BoardProfile[5];
        for (i = 0; i < 5; ++i) {
            this.profiles[i] = new BoardProfile();
        }
        for (i = 0; i < this.adj_vars_trigger.length; ++i) {
            this.adj_vars_trigger[i] = new AdjVarTriggerCfg();
        }
        for (i = 0; i < this.adj_vars_analog.length; ++i) {
            this.adj_vars_analog[i] = new AdjVarAnalogCfg();
        }
    }

    public static int constrain(int val, int min, int max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static BoardParams getCurParams() {
        return curParams;
    }

    public static void setCurParams(BoardParams params) {
        curParams = params;
    }

    public BoardProfile getCurProfile() {
        return this.profiles[this.curProfile];
    }

    public void parse(SerialCommand cmd, int profile) throws IOException {
        logger.info((Object)("Parsing cmd " + cmd.id + " for profile " + profile + ".."));
        if (profile < 0 || profile >= 5) {
            throw new IOException("Wrong profile " + profile);
        }
        BoardProfile p = this.profiles[profile];
        if (cmd.id == 33) {
            p.notchFreq1 = cmd.readByte3();
            p.notchWidth1 = cmd.readByte3();
            p.notchFreq2 = cmd.readByte3();
            p.notchWidth2 = cmd.readByte3();
            p.notchFreq3 = cmd.readByte3();
            p.notchWidth3 = cmd.readByte3();
            p.lpfFreq = cmd.readWord3();
            int i = 0;
            while (i < 3) {
                int f = cmd.readByte();
                p.notchEnabled1[i] = (f & 1) > 0;
                p.notchEnabled2[i] = (f & 2) > 0;
                p.notchEnabled3[i] = (f & 4) > 0;
                p.lpfEnabled[i] = (f & 8) > 0;
                int n = i;
                p.notchFreq1[n] = p.notchFreq1[n] * 2;
                int n2 = i;
                p.notchFreq2[n2] = p.notchFreq2[n2] * 2;
                int n3 = i++;
                p.notchFreq3[n3] = p.notchFreq3[n3] * 2;
            }
            this.encoder_offset = cmd.readWord3();
            this.encoder_fld_offset = cmd.readWord3();
            this.manual_set_time = cmd.readByte3();
            this.motor_heating_factor = cmd.readByte3();
            this.motor_cooling_factor = cmd.readByte3();
            this.encoder_type = cmd.readByte();
            this.encoder_cfg = cmd.readByte();
            this.encoder_lpf = cmd.readByte();
            this.encoder_mag_link = cmd.readByte3();
            this.motor_gear = cmd.readWordUnsigned3();
            cmd.readByteArr(p.reserved_ext);
        } else {
            int i;
            for (i = 0; i < 3; ++i) {
                p.P[i] = cmd.readByte();
                p.I[i] = cmd.readByte();
                p.D[i] = cmd.readByte();
                p.power[i] = cmd.readByte();
                p.invert[i] = cmd.readBoolean();
                p.poles[i] = cmd.readByte();
            }
            p.angleAccLimit = cmd.readByte();
            for (i = 0; i < 2; ++i) {
                p.extFCGain[i] = cmd.readByteSigned();
            }
            for (i = 0; i < 3; ++i) {
                p.rcMinAngle[i] = cmd.readWord();
                p.rcMaxAngle[i] = cmd.readWord();
                p.rcMode[i] = cmd.readByte();
                p.rcLPF[i] = cmd.readByte();
                p.rcSpeed[i] = cmd.readByte();
                p.rcFollow[i] = cmd.readByteSigned();
            }
            p.gyroTrust = cmd.readByte();
            p.useModel = cmd.readBoolean();
            p.pwmFreq = cmd.readByte();
            p.serialSpeed = cmd.readByte();
            for (i = 0; i < p.rcTrim.length; ++i) {
                p.rcTrim[i] = cmd.readByteSigned();
            }
            p.rcDeadband = cmd.readByte();
            p.rcExpoRate = cmd.readByte();
            p.rcVirtMode = cmd.readByte();
            cmd.readByteArr(p.rcMap);
            cmd.readByteArr(p.rcMix);
            p.followMode = cmd.readByte();
            p.followDeadband = cmd.readByte();
            p.followExpoRate = cmd.readByte();
            for (i = 0; i < 3; ++i) {
                this.followOffset[i] = cmd.readByteSigned();
            }
            this.axisTop = cmd.readByteSigned();
            this.axisRight = cmd.readByteSigned();
            if (cmd.id != 82) {
                this.frameAxisTop = cmd.readByteSigned();
                this.frameAxisRight = cmd.readByteSigned();
                this.frame_imu_pos = cmd.readByte();
            }
            this.gyroLPF = cmd.readByte();
            this.gyroSens = cmd.readByte();
            this.i2c_pullups = cmd.readBoolean();
            this.skip_gyro_cal = cmd.readBoolean();
            cmd.readByteArr(this.rcCmd);
            cmd.readByteArr(this.menuCmd);
            cmd.readByteArr(this.outputMap);
            this.bat_threshold_alarm = cmd.readWord();
            this.bat_threshold_motors = cmd.readWord();
            this.bat_comp_ref = cmd.readWord();
            this.beeper_modes = cmd.readByte();
            p.follow_roll_mix_start = cmd.readByte();
            p.follow_roll_mix_range = cmd.readByte();
            cmd.readByteArr(p.boosterPower);
            cmd.readByteArr(p.followSpeed);
            p.frameAngleFromMotors = cmd.readBoolean();
            if (cmd.id != 82) {
                cmd.readWordArr(this.rcMemory);
                cmd.readByteArr(p.servoOut);
                p.servoRate = cmd.readByte() * 10;
                p.adaptivePIDEnabled = cmd.readByte();
                p.adaptivePIDThreshold = cmd.readByte();
                p.adaptivePIDRate = cmd.readByte();
                p.adaptivePIDRecoveryFactor = cmd.readByte();
                cmd.readByteArr(p.followLPF);
                this.general_flags1 = cmd.readWordUnsigned();
                p.profile_flags1 = cmd.readWordUnsigned();
                cmd.readByteArr(p.reserved);
                this.curIMU = cmd.readByte();
            }
            this.curProfile = BoardParams.constrain(cmd.readByte(), 0, 4);
        }
        cmd.checkFinished();
    }

    public void parseAdjVarsReadCmd(SerialCommand cmd) throws IOException {
        int i;
        logger.info((Object)"Parsing adj.vars configuration..");
        for (i = 0; i < this.adj_vars_trigger.length; ++i) {
            this.adj_vars_trigger[i].readCfgCmd(cmd);
        }
        for (i = 0; i < this.adj_vars_analog.length; ++i) {
            this.adj_vars_analog[i].readCfgCmd(cmd);
        }
    }

    public SerialCommand formatWriteCommand(int profile, boolean extended) throws IOException {
        try {
            int cmd_id = BoardInfo.getBoardInfo() == null || BoardInfo.getBoardInfo().boardVer < 30 ? 87 : (extended ? 34 : 22);
            SerialCommand cmd = new SerialCommand(cmd_id, 512);
            cmd.writeByte(profile);
            BoardProfile p = this.profiles[profile];
            if (cmd.id == 34) {
                int i;
                int[] freq1 = new int[3];
                int[] freq2 = new int[3];
                int[] freq3 = new int[3];
                for (i = 0; i < 3; ++i) {
                    freq1[i] = p.notchFreq1[i] / 2;
                    freq2[i] = p.notchFreq2[i] / 2;
                    freq3[i] = p.notchFreq3[i] / 2;
                }
                cmd.writeByteArr(freq1);
                cmd.writeByteArr(p.notchWidth1);
                cmd.writeByteArr(freq2);
                cmd.writeByteArr(p.notchWidth2);
                cmd.writeByteArr(freq3);
                cmd.writeByteArr(p.notchWidth3);
                cmd.writeWordArr(p.lpfFreq);
                for (i = 0; i < 3; ++i) {
                    int f = 0;
                    if (p.notchEnabled1[i]) {
                        f |= 1;
                    }
                    if (p.notchEnabled2[i]) {
                        f |= 2;
                    }
                    if (p.notchEnabled3[i]) {
                        f |= 4;
                    }
                    if (p.lpfEnabled[i]) {
                        f |= 8;
                    }
                    cmd.writeByte(f);
                }
                cmd.writeWordArr(this.encoder_offset);
                cmd.writeWordArr(this.encoder_fld_offset);
                cmd.writeByteArr(this.manual_set_time);
                cmd.writeByteArr(this.motor_heating_factor);
                cmd.writeByteArr(this.motor_cooling_factor);
                cmd.writeByte(this.encoder_type);
                cmd.writeByte(this.encoder_cfg);
                cmd.writeByte(this.encoder_lpf);
                cmd.writeByteArr(this.encoder_mag_link);
                cmd.writeWordArr(this.motor_gear);
                cmd.writeByteArr(p.reserved_ext);
            } else {
                int i;
                for (i = 0; i < 3; ++i) {
                    cmd.writeByte(p.P[i]);
                    cmd.writeByte(p.I[i]);
                    cmd.writeByte(p.D[i]);
                    cmd.writeByte(p.power[i]);
                    cmd.writeBoolean(p.invert[i]);
                    cmd.writeByte(p.poles[i]);
                }
                cmd.writeByte(p.angleAccLimit);
                for (i = 0; i < 2; ++i) {
                    cmd.writeByteSigned(p.extFCGain[i]);
                }
                for (i = 0; i < 3; ++i) {
                    cmd.writeWord(p.rcMinAngle[i]);
                    cmd.writeWord(p.rcMaxAngle[i]);
                    cmd.writeByte(p.rcMode[i]);
                    cmd.writeByte(p.rcLPF[i]);
                    cmd.writeByte(p.rcSpeed[i]);
                    cmd.writeByteSigned(p.rcFollow[i]);
                }
                cmd.writeByte(p.gyroTrust);
                cmd.writeBoolean(p.useModel);
                cmd.writeByte(p.pwmFreq);
                cmd.writeByte(p.serialSpeed);
                for (i = 0; i < p.rcTrim.length; ++i) {
                    cmd.writeByteSigned(p.rcTrim[i]);
                }
                cmd.writeByte(p.rcDeadband);
                cmd.writeByte(p.rcExpoRate);
                cmd.writeByte(p.rcVirtMode);
                for (i = 0; i < p.rcMap.length; ++i) {
                    cmd.writeByte(p.rcMap[i]);
                }
                for (i = 0; i < p.rcMix.length; ++i) {
                    cmd.writeByte(p.rcMix[i]);
                }
                cmd.writeByte(p.followMode);
                cmd.writeByte(p.followDeadband);
                cmd.writeByte(p.followExpoRate);
                for (i = 0; i < 3; ++i) {
                    cmd.writeByteSigned(this.followOffset[i]);
                }
                cmd.writeByteSigned(this.axisTop);
                cmd.writeByteSigned(this.axisRight);
                if (cmd.id != 87) {
                    cmd.writeByteSigned(this.frameAxisTop);
                    cmd.writeByteSigned(this.frameAxisRight);
                    cmd.writeByte(this.frame_imu_pos);
                }
                cmd.writeByte(this.gyroLPF);
                cmd.writeByte(this.gyroSens);
                cmd.writeBoolean(this.i2c_pullups);
                cmd.writeBoolean(this.skip_gyro_cal);
                for (i = 0; i < this.rcCmd.length; ++i) {
                    cmd.writeByte(this.rcCmd[i]);
                }
                for (i = 0; i < this.menuCmd.length; ++i) {
                    cmd.writeByte(this.menuCmd[i]);
                }
                for (i = 0; i < this.outputMap.length; ++i) {
                    cmd.writeByte(this.outputMap[i]);
                }
                cmd.writeWord(this.bat_threshold_alarm);
                cmd.writeWord(this.bat_threshold_motors);
                cmd.writeWord(this.bat_comp_ref);
                cmd.writeByte(this.beeper_modes);
                cmd.writeByte(p.follow_roll_mix_start);
                cmd.writeByte(p.follow_roll_mix_range);
                for (i = 0; i < 3; ++i) {
                    cmd.writeByte(p.boosterPower[i]);
                }
                for (i = 0; i < 3; ++i) {
                    cmd.writeByte(p.followSpeed[i]);
                }
                cmd.writeBoolean(p.frameAngleFromMotors);
                if (cmd.id != 87) {
                    cmd.writeWordArr(this.rcMemory);
                    cmd.writeByteArr(p.servoOut);
                    cmd.writeByte(p.servoRate / 10);
                    cmd.writeByte(p.adaptivePIDEnabled);
                    cmd.writeByte(p.adaptivePIDThreshold);
                    cmd.writeByte(p.adaptivePIDRate);
                    cmd.writeByte(p.adaptivePIDRecoveryFactor);
                    cmd.writeByteArr(p.followLPF);
                    cmd.writeWord(this.general_flags1);
                    cmd.writeWord(p.profile_flags1);
                    cmd.writeByteArr(p.reserved);
                    cmd.writeByte(this.curIMU);
                }
                cmd.writeByte(this.curProfile);
            }
            return cmd;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to format command from params: " + e.toString()));
            throw new IOException("Failed to format command from params", e);
        }
    }

    public SerialCommand formatAdjVarsWriteCmd() throws IOException {
        int i;
        logger.info((Object)"Formatting adj.vars configuration..");
        SerialCommand cmd = new SerialCommand(44, 512);
        for (i = 0; i < this.adj_vars_trigger.length; ++i) {
            this.adj_vars_trigger[i].writeCfgCmd(cmd);
        }
        for (i = 0; i < this.adj_vars_analog.length; ++i) {
            this.adj_vars_analog[i].writeCfgCmd(cmd);
        }
        cmd.writeEmptyArr(128 - cmd.len);
        return cmd;
    }

    public BoardParams clone() throws CloneNotSupportedException {
        BoardParams copy = (BoardParams)super.clone();
        copy.profiles = new BoardProfile[this.profiles.length];
        copy.followOffset = Arrays.copyOf(this.followOffset, this.followOffset.length);
        for (int i = 0; i < this.profiles.length; ++i) {
            copy.profiles[i] = this.profiles[i].clone();
        }
        copy.rcCmd = Arrays.copyOf(this.rcCmd, this.rcCmd.length);
        copy.menuCmd = Arrays.copyOf(this.menuCmd, this.menuCmd.length);
        copy.outputMap = Arrays.copyOf(this.outputMap, this.outputMap.length);
        copy.manual_set_time = Arrays.copyOf(this.manual_set_time, this.manual_set_time.length);
        copy.motor_heating_factor = Arrays.copyOf(this.motor_heating_factor, this.motor_heating_factor.length);
        copy.motor_cooling_factor = Arrays.copyOf(this.motor_cooling_factor, this.motor_cooling_factor.length);
        copy.encoder_offset = Arrays.copyOf(this.encoder_offset, this.encoder_offset.length);
        copy.encoder_fld_offset = Arrays.copyOf(this.encoder_fld_offset, this.encoder_fld_offset.length);
        copy.rcMemory = Arrays.copyOf(this.rcMemory, this.rcMemory.length);
        copy.encoder_mag_link = Arrays.copyOf(this.encoder_mag_link, this.encoder_mag_link.length);
        copy.motor_gear = Arrays.copyOf(this.motor_gear, this.motor_gear.length);
        copy.adj_vars_trigger = AdjVarTriggerCfg.copyOf(this.adj_vars_trigger);
        copy.adj_vars_analog = AdjVarAnalogCfg.copyOf(this.adj_vars_analog);
        return copy;
    }

    public boolean compare(BoardParams p, int profile) {
        boolean res = this.profiles[profile].equals(p.profiles[profile]);
        res &= this.axisTop == p.axisTop;
        res &= this.axisRight == p.axisRight;
        res &= this.frameAxisTop == p.frameAxisTop;
        res &= this.frameAxisRight == p.frameAxisRight;
        res &= this.gyroLPF == p.gyroLPF;
        res &= this.gyroSens == p.gyroSens;
        res &= this.i2c_pullups == p.i2c_pullups;
        res &= this.skip_gyro_cal == p.skip_gyro_cal;
        res &= this.frame_imu_pos == p.frame_imu_pos;
        res &= Arrays.equals(this.rcCmd, p.rcCmd);
        res &= Arrays.equals(this.menuCmd, p.menuCmd);
        res &= Arrays.equals(this.outputMap, p.outputMap);
        res &= Arrays.equals(this.followOffset, p.followOffset);
        res &= this.bat_threshold_alarm == p.bat_threshold_alarm;
        res &= this.bat_threshold_motors == p.bat_threshold_motors;
        res &= this.bat_comp_ref == p.bat_comp_ref;
        res &= this.beeper_modes == p.beeper_modes;
        res &= Arrays.equals(this.manual_set_time, p.manual_set_time);
        res &= Arrays.equals(this.motor_heating_factor, p.motor_heating_factor);
        res &= Arrays.equals(this.motor_cooling_factor, p.motor_cooling_factor);
        res &= Arrays.equals(this.encoder_offset, p.encoder_offset);
        res &= Arrays.equals(this.encoder_fld_offset, p.encoder_fld_offset);
        res &= this.encoder_type == p.encoder_type;
        res &= this.encoder_cfg == p.encoder_cfg;
        res &= Arrays.equals(this.rcMemory, p.rcMemory);
        res &= this.encoder_lpf == p.encoder_lpf;
        res &= Arrays.equals(this.encoder_mag_link, p.encoder_mag_link);
        res &= Arrays.equals(this.adj_vars_trigger, p.adj_vars_trigger);
        res &= Arrays.equals(this.adj_vars_analog, p.adj_vars_analog);
        return res &= Arrays.equals(this.motor_gear, p.motor_gear);
    }

    public static int axisMapToIndex(int val) {
        return val > 0 ? Math.min(val - 1, 2) : Math.min(2 - val, 5);
    }

    public static int axisIndexToMap(int index) {
        return index > 2 ? 2 - index : index + 1;
    }

    public static boolean is_encoder_SPI(int type) {
        return type == 1 || type == 4;
    }

    public void setProfileName(int profileId, String name) {
        if (profileId < this.profiles.length) {
            this.profiles[profileId].profileName = name;
        }
    }
}

