/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;

@XStreamAlias(value="saved-configuration")
public class BoardParamsSavedData {
    static final Logger logger = Logger.getLogger(BoardParamsSavedData.class.getName());
    @XStreamAlias(value="board-params")
    public BoardParams params = null;
    @XStreamAlias(value="profile")
    public BoardProfile profile = null;
    @XStreamAlias(value="all-profiles")
    public BoardProfile[] profiles = null;
    public Integer firmwareVer = null;

    public BoardParamsSavedData(BoardParams params, int profile_idx, BoardInfo info) {
        this.params = params;
        if (profile_idx >= 0) {
            this.profile = params.profiles[profile_idx];
        } else {
            this.profiles = params.profiles;
        }
        if (info != null) {
            this.firmwareVer = info.frwVer;
        }
    }

    public BoardParams join(BoardParams current, int currentProfile) throws Exception {
        BoardInfo info = BoardInfo.getBoardInfo();
        try {
            this.params.curProfile = currentProfile;
            if (current.profiles.length < currentProfile + 1) {
                throw new Exception("Current board params implementation does not support more than " + this.params.profiles.length + " profiles!");
            }
            if (this.profiles != null) {
                this.params.profiles = this.profiles;
            } else if (this.profile != null) {
                this.params.profiles = new BoardProfile[current.profiles.length];
                for (int i = 0; i < current.profiles.length; ++i) {
                    this.params.profiles[i] = current.profiles[i];
                }
                this.params.profiles[currentProfile] = this.profile;
            } else {
                throw new Exception("File contains no profile data!");
            }
            this.params = (BoardParams)BoardParamsSavedData.validate(this.params, current);
            if (this.firmwareVer == null || info == null || info.frwVer > 0) {
                // empty if block
            }
            return this.params;
        }
        catch (Exception e) {
            throw new Exception("Error applying loaded params: " + e.toString());
        }
    }

    static Object validate(Object new_obj, Object ref_obj) throws Exception {
        Object new_obj_copy = new_obj;
        if (new_obj != null && ref_obj != null) {
            if (new_obj.getClass().equals(ref_obj.getClass())) {
                if (ref_obj.getClass().isArray()) {
                    new_obj = ref_obj;
                    for (int i = 0; i < Math.min(Array.getLength(ref_obj), Array.getLength(new_obj_copy)); ++i) {
                        Array.set(new_obj, i, BoardParamsSavedData.validate(Array.get(new_obj_copy, i), Array.get(ref_obj, i)));
                    }
                } else if (!ref_obj.getClass().isAssignableFrom(Number.class) && !ref_obj.getClass().isAssignableFrom(String.class)) {
                    for (Field f : ref_obj.getClass().getFields()) {
                        if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
                        f.set(new_obj, BoardParamsSavedData.validate(f.get(new_obj), f.get(ref_obj)));
                    }
                }
            } else {
                logger.warning("Class mismatch: " + new_obj.getClass().getName() + " over " + ref_obj.getClass().getName());
                new_obj = ref_obj;
            }
        }
        return new_obj;
    }
}

