/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.text.DecimalFormat;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sbgc.object.ErrorInfo;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.utils.DataLogger;
import simplebgc_gui.SimpleBGC_GUIApp;

public class BodeTest {
    static final Logger logger = Logger.getLogger((String)BodeTest.class.getName());
    static DataLogger dataLogger = null;
    static long data_cnt = 0L;
    static int prev_cnt = 0;
    static int missed_cnt = 0;
    static float prev_in;
    static float prev_out;
    public static final int SAMPLING_FREQ = 1250;
    public static final long TEST_DURATION_CNT = 50000L;
    private static final DecimalFormat floatFormatter;
    private static int next_progress;

    public static boolean isActive() {
        return dataLogger != null;
    }

    public static void start(int axis, int stimulus, int gain, int system) throws Exception {
        String system_name = (new String[]{"", "controller_plant_open", "controller_plant_closed", "controller_open", "controller_closed", "plant_open", "overall_system"})[system];
        try {
            if (dataLogger != null) {
                dataLogger.finish();
            }
            dataLogger = new DataLogger("bode_test_log.csv", false);
        }
        catch (Exception e) {
            throw new Exception("Can't open log file for writing: " + e.toString());
        }
        data_cnt = 0L;
        prev_cnt = 0;
        prev_in = 0.0f;
        prev_out = 0.0f;
        missed_cnt = 0;
        try {
            SerialCommand cmd = new SerialCommand(37);
            cmd.writeByte(axis);
            cmd.writeByte(stimulus);
            cmd.writeWord(gain);
            cmd.writeByte(system);
            cmd.writeDWord(50000L);
            SerialCommandProcessor.sendCommand(cmd);
            ErrorInfo.updateStatus("System test started.");
            SimpleBGC_GUIApp.mainView.progressStart("Running system test..", false);
            next_progress = 5;
        }
        catch (Exception e) {
            throw new Exception("Failed to send CMD_BODE_TEST_START_STOP command: " + e.toString());
        }
    }

    public static void stop() {
        try {
            SerialCommand cmd = new SerialCommand(37);
            cmd.writeEmptyArr(9);
            SerialCommandProcessor.sendCommand(cmd);
            SimpleBGC_GUIApp.mainView.progressFinish();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void parse_data(SerialCommand cmd) {
        block7: {
            try {
                int cnt = cmd.readByte();
                float in = cmd.readFloat();
                float out = cmd.readFloat();
                cmd.checkFinished();
                int delta = cnt - prev_cnt & 0xFF;
                if (delta > 1) {
                    ErrorInfo.setErrorText("Missed data: " + (missed_cnt += delta));
                    for (int i = 1; i <= delta; ++i) {
                        float _in = prev_in + (in - prev_in) * (float)i / (float)delta;
                        float _out = prev_out + (out - prev_out) * (float)i / (float)delta;
                        BodeTest.logData(_in, _out);
                    }
                    data_cnt += (long)delta;
                } else {
                    BodeTest.logData(in, out);
                    ++data_cnt;
                }
                prev_in = in;
                prev_out = out;
                prev_cnt = cnt;
                final int progress = (int)(data_cnt * 100L / 50000L);
                if (progress < next_progress) break block7;
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SimpleBGC_GUIApp.mainView.onProgressChange(progress);
                        }
                    });
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                next_progress = progress + 5;
            }
            catch (Exception e) {
                logger.error((Object)("Error parsing CMD_BODE_TEST_DATA: " + e.toString()));
            }
        }
    }

    static void logData(float in, float out) {
        if (dataLogger != null) {
            dataLogger.logData(floatFormatter.format(in) + ";" + floatFormatter.format(out));
        }
    }

    public static void parse_stop(SerialCommand cmd) {
        try {
            if (dataLogger != null) {
                long cnt = cmd.readDWordUnsigned();
                if (cnt == data_cnt) {
                    ErrorInfo.setErrorText(null);
                } else {
                    ErrorInfo.setErrorText("Missed data during test: " + (cnt - data_cnt));
                    logger.debug((Object)("cnt: " + cnt + ", data_cnt: " + data_cnt));
                }
                dataLogger.finish();
                ErrorInfo.updateStatus("Test result successfuly stored to " + dataLogger.getLogFileName());
                dataLogger = null;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SimpleBGC_GUIApp.mainView.progressFinish();
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        floatFormatter = new DecimalFormat("0.#####E0");
        next_progress = 0;
    }
}

