/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.IOException;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import sbgc.object.DebugVar;
import sbgc.service.SerialCommand;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DebugVars {
    private static DebugVar[] vars = null;
    private static HashMap<String, Integer> byName = new HashMap();

    public static void parseInfo(SerialCommand cmd) throws IOException {
        int size = cmd.readByte();
        DebugVar[] tmp_vars = new DebugVar[size];
        for (int i = 0; i < size; ++i) {
            DebugVar var = new DebugVar();
            var.name = cmd.readString();
            int type = cmd.readByte();
            var.type = type & 0xF;
            var.flags = type & 0xC0;
            var.axis = ((type & 0x30) >> 4) - 1;
            var.arr_size = cmd.readWordUnsigned();
            tmp_vars[i] = var;
            byName.put(var.name, new Integer(i));
        }
        cmd.checkFinished();
        vars = tmp_vars;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    for (DebugVar v : vars) {
                        SimpleBGC_GUIApp.mainView.addDebugVar(v);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void parse(SerialCommand cmd) throws IOException {
        if (vars != null) {
            block9: for (DebugVar v : vars) {
                switch (v.type) {
                    case 1: {
                        v.value = cmd.readByte();
                        continue block9;
                    }
                    case 2: {
                        v.value = cmd.readByteSigned();
                        continue block9;
                    }
                    case 3: {
                        v.value = cmd.readWordUnsigned();
                        continue block9;
                    }
                    case 4: {
                        v.value = cmd.readWord();
                        continue block9;
                    }
                    case 5: {
                        v.value = (int)cmd.readDWordUnsigned();
                        continue block9;
                    }
                    case 6: {
                        v.value = (int)cmd.readDWord();
                        continue block9;
                    }
                    case 7: {
                        v.value = (int)cmd.readFloat();
                        continue block9;
                    }
                    default: {
                        throw new IOException("Unsupported var type: " + v.type);
                    }
                }
            }
        }
    }

    public static boolean hasInfo() {
        return vars != null;
    }

    public static DebugVar[] getVars() {
        return vars;
    }

    public static void setVars(DebugVar[] _vars) {
        vars = _vars;
    }

    public static DebugVar get(String name) {
        Integer i;
        if (vars != null && (i = byName.get(name)) != null && i < vars.length) {
            return vars[i];
        }
        return null;
    }
}

