/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import javax.swing.SwingUtilities;
import simplebgc_gui.SimpleBGC_GUIApp;

public class ErrorInfo {
    public static final int ERR_NO_SENSOR = 1;
    public static final int ERR_CALIB_ACC = 2;
    public static final int ERR_SET_POWER = 4;
    public static final int ERR_CALIB_POLES = 8;
    public static final int ERR_PROTECTION = 16;
    public static final int ERR_SERIAL_DATA_CORRUPTED = 32;
    public static final int ERR_LOW_BAT1 = 64;
    public static final int ERR_LOW_BAT2 = 128;
    public static final int ERR_GUI_VERSION = 256;
    public static final int ERR_MISS_STEPS = 512;
    public static final int ERR_SYTEM_ERROR = 1024;
    public static final int ERR_MISSED_DATA = 65536;
    private static int curError = 0;
    private static String curErrorText = null;

    public static String getCurErrors() {
        if (curError != 0 || curErrorText != null) {
            StringBuffer res = new StringBuffer();
            for (int i = 0; i < 15; ++i) {
                int code = 1 << i;
                if ((code & curError) == 0) continue;
                String title = SimpleBGC_GUIApp.getResourceMap(ErrorInfo.class).getString("error" + code + ".title", new Object[0]);
                if (title == null) {
                    title = "UNKNOWN ERROR: " + code;
                }
                if (res.length() > 0) {
                    res.append("; ");
                }
                res.append(title);
            }
            if (curErrorText != null) {
                if (res.length() > 0) {
                    res.append("; ");
                }
                res.append(curErrorText);
            }
            return res.toString();
        }
        return "";
    }

    public static String getCurErrorsDescr() {
        String descr = null;
        if (curError != 0) {
            for (int i = 0; i < 15; ++i) {
                int code = 1 << i;
                if ((code & curError) == 0) continue;
                descr = SimpleBGC_GUIApp.getResourceMap(ErrorInfo.class).getString("error" + code + ".descr", new Object[0]);
            }
        }
        return descr != null ? descr : "";
    }

    public static void setBoardError(int error) {
        int newCodes = curError & 0xFF00 | error;
        if ((curError ^ newCodes) != 0) {
            curError = newCodes;
            ErrorInfo.updateError();
        }
    }

    public static void addError(int error) {
        if ((curError & error) == 0) {
            curError |= error;
            ErrorInfo.updateError();
        }
    }

    public static void clearError(int error) {
        if ((curError & error) != 0) {
            curError &= ~error;
            ErrorInfo.updateError();
        }
    }

    public static boolean checkError(int error) {
        return (error & curError) != 0;
    }

    public static void updateStatus(final String text) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleBGC_GUIApp.mainView.updateStatus(text);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateError() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleBGC_GUIApp.mainView.updateError();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isError() {
        return curError != 0;
    }

    public static void setErrorText(String text) {
        curErrorText = text;
        ErrorInfo.updateError();
    }
}

