/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.IOException;
import java.util.Date;
import javax.swing.SwingUtilities;
import sbgc.object.BoardInfo;
import sbgc.object.ErrorInfo;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import simplebgc_gui.SimpleBGC_GUIApp;

public class RealtimeData {
    private static RealtimeData tmp1 = new RealtimeData();
    private static RealtimeData tmp2 = new RealtimeData();
    private static RealtimeData curRealtimeData = tmp1;
    public static final int RC_CHANNEL_ROLL = 0;
    public static final int RC_CHANNEL_PITCH = 1;
    public static final int RC_CHANNEL_YAW = 2;
    public static final int RC_CHANNEL_CMD = 3;
    public static final int RC_CHANNEL_FC_ROLL = 4;
    public static final int RC_CHANNEL_FC_PITCH = 5;
    public static final String[] RC_DATA_NAMES = new String[]{"RC_ROLL", "RC_PITCH", "RC_YAW", "RC_CMD", "EXT_FC_ROLL", "EXT_FC_PITCH"};
    public static final int RC_DATA_UNDEF = -8500;
    public static final float ANGLE14_DEGREE_SCALE = 0.021972656f;
    public static final float ANGLE14_RAD_SCALE = 3.834952E-4f;
    public static final int BALANCE_ERROR_MAX = 512;
    public Date regDate = new Date();
    public int[] acc = new int[3];
    public int[] gyro = new int[3];
    public int[] debug = new int[4];
    public int[] rcData = new int[]{-8500, -8500, -8500, -8500, -8500, -8500};
    public float[] angle = new float[3];
    public float[] frameIMUAngle = new float[3];
    public float[] rc_angle = new float[3];
    public int cycleTime;
    public int i2cErrorCount;
    public int errorCode;
    public int comErrCnt;
    public int bat_val;
    public boolean isPowered;
    public int curProfile;
    public int curIMU = 1;
    public int[] power = new int[3];
    public int[] balanceError = new int[3];
    public float[] frameAngle = new float[3];
    public boolean[] encoderEnabled = new boolean[]{false, false, false};

    public static RealtimeData getRealtimeData() {
        return curRealtimeData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(SerialCommand cmd) throws IOException {
        RealtimeData tmp;
        RealtimeData realtimeData = tmp = tmp1 == curRealtimeData ? tmp2 : tmp1;
        synchronized (realtimeData) {
            int i;
            tmp.regDate = new Date();
            int id = cmd.id == 68 ? 0 : cmd.id;
            for (int i2 = 0; i2 < 3; ++i2) {
                tmp.acc[i2] = cmd.readWord();
                tmp.gyro[i2] = cmd.readWord();
            }
            int tmpErrCode = 0;
            if (BoardInfo.isDebugMode()) {
                cmd.readWordArr(tmp.debug);
            } else {
                tmp.comErrCnt = cmd.readWordUnsigned();
                tmpErrCode = cmd.readWordUnsigned();
                cmd.skipBytes(4);
            }
            cmd.readWordArr(tmp.rcData);
            for (i = 0; i < 3; ++i) {
                tmp.angle[i] = (float)cmd.readWord() * 0.021972656f;
            }
            if (id >= 23) {
                for (i = 0; i < 3; ++i) {
                    tmp.frameIMUAngle[i] = (float)cmd.readWord() * 0.021972656f;
                }
            }
            for (i = 0; i < 3; ++i) {
                tmp.rc_angle[i] = (float)cmd.readWord() * 0.021972656f;
            }
            tmp.cycleTime = cmd.readWord();
            tmp.i2cErrorCount = cmd.readWordUnsigned();
            tmp.errorCode = cmd.readByte() | tmpErrCode;
            tmp.bat_val = cmd.readWord();
            boolean bl = tmp.isPowered = cmd.readByte() > 0;
            if (id >= 23) {
                tmp.curIMU = cmd.readByte();
            }
            tmp.curProfile = cmd.readByte();
            for (i = 0; i < 3; ++i) {
                tmp.power[i] = cmd.readByte();
            }
            if (id >= 25) {
                for (i = 0; i < 3; ++i) {
                    tmp.frameAngle[i] = (float)cmd.readWord() * 0.021972656f;
                }
                int enc_bits = cmd.readByte();
                for (int i3 = 0; i3 < 3; ++i3) {
                    tmp.encoderEnabled[i3] = (enc_bits & 1 << i3) != 0;
                }
                cmd.readWordArr(tmp.balanceError);
                cmd.skipBytes(48);
            }
        }
        cmd.checkFinished();
        ErrorInfo.setBoardError(tmp.errorCode);
        curRealtimeData = tmp;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleBGC_GUIApp.mainView.updateRealtimeData();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        RealtimeDataThread.logData();
    }

    public static void parseCmdAdjVarsState(SerialCommand cmd) throws IOException {
        final int triggerSignal = cmd.readWord();
        final int triggerAction = cmd.readByte();
        final int analogSignal = cmd.readWord();
        final long analogVal = cmd.readDWord();
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleBGC_GUIApp.mainView.panelAdjVars.updateRealtimeState(triggerSignal, triggerAction, analogSignal, analogVal);
                }
            });
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }
}

