/*
 * Decompiled with CFR 0.152.
 */
package sbgc.serial.command;

import java.io.IOException;
import org.apache.log4j.Logger;
import sbgc.service.SerialCommand;
import sbgc.utils.HexUtil;
import sbgc.utils.Log;

public class SerialCommandSignMessageImpl {
    private static final Log logger = new Log(Logger.getLogger((String)SerialCommandSignMessageImpl.class.getName()));
    private static SerialCommandSignMessageImpl lastSignMessageResult = null;
    private int[] sign = new int[32];

    public static SerialCommandSignMessageImpl getLastSignMessageResult() {
        return lastSignMessageResult;
    }

    public String getSign() {
        return HexUtil.toHex(this.sign);
    }

    public void setSign(int[] sign) {
        this.sign = sign;
    }

    public static SerialCommandSignMessageImpl parse(SerialCommand cmd) throws IOException {
        SerialCommandSignMessageImpl command = new SerialCommandSignMessageImpl();
        int[] signData = new int[32];
        for (int j = 0; j < 32; ++j) {
            signData[j] = cmd.readByte();
        }
        command.setSign(signData);
        cmd.checkFinished();
        lastSignMessageResult = command;
        return command;
    }

    public String toString() {
        return "sign: " + this.getSign().substring(0, 5) + "..";
    }
}

