/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import org.apache.log4j.Logger;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;

public class CommandResponseListener
implements Runnable {
    static final Logger logger = Logger.getLogger((String)CommandResponseListener.class.getName());
    private int commandId = -1;
    private boolean responseReceived = false;
    private SerialCommand cmd = null;
    private long timeout = 0L;

    public CommandResponseListener(int commandId) {
        this.commandId = commandId;
    }

    public CommandResponseListener(int commandId, long timeout) {
        this.commandId = commandId;
        this.timeout = timeout;
    }

    public int getCommandId() {
        return this.commandId;
    }

    public void onCommandReceived(SerialCommand cmd) {
        logger.trace((Object)"Listener onCommandReceived fired...");
        this.responseReceived = true;
        this.cmd = cmd;
    }

    public boolean isCommandResponseReceived() {
        return this.responseReceived;
    }

    public void setCommandResponseReceived(boolean state) {
        this.responseReceived = state;
    }

    public SerialCommand getReceivedCommand() {
        return this.cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerialCommand waitFor(int commandId, long timeout) {
        CommandResponseListener commandResponseListener = new CommandResponseListener(commandId, timeout);
        SerialCommandDispatcher.getInstance().addResponseListener(commandResponseListener);
        CommandResponseListener commandResponseListener2 = commandResponseListener;
        synchronized (commandResponseListener2) {
            try {
                commandResponseListener.wait(timeout);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        SerialCommandDispatcher.getInstance().removeResponseListener(commandResponseListener);
        return commandResponseListener.cmd;
    }

    public static boolean waitFor(SerialCommand command, long timeout) {
        return CommandResponseListener.waitFor(command, command.getId(), timeout);
    }

    public static boolean waitFor(SerialCommand command, int waitForCommandId, long timeout) {
        CommandResponseListener commandResponseListener = new CommandResponseListener(waitForCommandId, timeout);
        SerialCommandDispatcher.getInstance().addResponseListener(commandResponseListener);
        Thread waiter = new Thread((Runnable)commandResponseListener, "waiter");
        waiter.start();
        try {
            Thread.currentThread();
            Thread.sleep(300L);
        }
        catch (Exception e) {
            // empty catch block
        }
        SerialCommandProcessor.sendCommand(command);
        try {
            waiter.join(timeout + 5000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        SerialCommandDispatcher.getInstance().removeResponseListener(commandResponseListener);
        return commandResponseListener.isCommandResponseReceived();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.trace((Object)"Waiting command result...");
        CommandResponseListener commandResponseListener = this;
        synchronized (commandResponseListener) {
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.trace((Object)"Out from command waiting.");
        }
    }
}

