/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sbgc.object.BoardInfo;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.SerialPortService;
import sbgc.service.upgrade.VersionImpl;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;

public class ConnectThread
extends Thread {
    static final Logger logger = Logger.getLogger((String)ConnectThread.class.getName());
    private static ConnectThread worker = null;

    private ConnectThread() {
    }

    public void run() {
        Thread.currentThread().setName("ConnectThread");
        logger.info((Object)"Starting board connection..");
        BoardInfo.setBoardInfo(null);
        int lastBaudIndex = Integer.parseInt(Settings.get("latest.serial.baud", "0"));
        SerialCommand cmdEmpty = new SerialCommand(0);
        SerialCommand cmdBoardInfo = new SerialCommand(86);
        while (BoardInfo.getBoardInfo() == null) {
            for (int baudIndex = lastBaudIndex; baudIndex < SerialPortService.SERIAL_BAUD_RATES.length && BoardInfo.getBoardInfo() == null; ++baudIndex) {
                SerialPortService.setBaudIndex(baudIndex);
                for (int j = 0; j < 2 && BoardInfo.getBoardInfo() == null; ++j) {
                    SerialPortService.setParity(j == 0 ? 0 : 2);
                    SerialCommandProcessor.sendCommand(cmdEmpty);
                    SerialCommandProcessor.sendCommand(cmdBoardInfo);
                    try {
                        Thread.sleep(300L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        return;
                    }
                }
            }
            lastBaudIndex = 0;
        }
        Settings.set("latest.serial.baud", Integer.toString(SerialPortService.getBaudIndex()));
        Settings.save();
        BoardInfo info = BoardInfo.getBoardInfo();
        if (info != null) {
            if (info.boardVer >= 30) {
                SerialCommandProcessor.sendCommand(new SerialCommand(28));
                for (int i = 0; i < 30 && info.deviceId == null; ++i) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        return;
                    }
                }
            }
            VersionImpl frwVer = new VersionImpl(info.frwVer);
            SimpleBGC_GUIApp.mainView.setConnected(true);
            if (frwVer.getFullVer() != 0) {
                SerialCommandProcessor.readAllParams(-1);
                RealtimeDataThread.start();
                if (SimpleBGC_GUIApp.version.getFullVer() / 100 != frwVer.getFullVer() / 100) {
                    JOptionPane.showMessageDialog(null, SimpleBGC_GUIApp.mainView.getResourceMap().getString("error.version_mismatch", frwVer.toString(), SimpleBGC_GUIApp.version.toString()), SimpleBGC_GUIApp.mainView.getResourceMap().getString("messageDialog.error.title", new Object[0]), 2);
                }
            }
        }
    }

    public static void initConnection() {
        ConnectThread.stopConnection();
        worker = new ConnectThread();
        worker.start();
    }

    public static void reconnect(int delay) {
        logger.info((Object)"Reconnecting to the board..");
        boolean needReconnect = SimpleBGC_GUIApp.mainView.isSerialCommunicationActive();
        SimpleBGC_GUIApp.mainView.stopSerialCommunication();
        try {
            SerialPortService.disconnect();
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    SimpleBGC_GUIApp.mainView.disconnect();
                }
            });
            final String portName = SerialPortService.getLatestPortName();
            if (needReconnect && portName != null) {
                Thread.sleep(delay);
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SimpleBGC_GUIApp.mainView.connect(portName, true);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopConnection() {
        if (worker != null) {
            ConnectThread connectThread = worker;
            synchronized (connectThread) {
                worker.interrupt();
            }
        }
    }

    public static Thread getThread() {
        return worker;
    }
}

