/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;

class ParamsReaderThread
extends Thread {
    private SerialCommand read_cmd;
    private final Logger logger;
    private final int profileId;
    private float progress;
    private float progress_step;

    public ParamsReaderThread(int profileId, Logger logger) {
        this.profileId = profileId;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadParamsCmd(SerialCommand cmd) {
        this.read_cmd = cmd;
        ParamsReaderThread paramsReaderThread = this;
        synchronized (paramsReaderThread) {
            this.notify();
        }
    }

    private void progressStep() {
        this.progress += this.progress_step;
        SimpleBGC_GUIApp.mainView.onProgressChange((int)this.progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList<String> errors = new ArrayList<String>();
        boolean rt_pause_state = RealtimeDataThread.pause(true);
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        int[] read_cmd_ids = BoardInfo.hasExtendedParams() ? new int[]{82, 33} : new int[]{82};
        BoardParams params = null;
        try {
            SerialCommand cmd;
            params = BoardParams.getCurParams().clone();
            SimpleBGC_GUIApp.mainView.progressStart("Reading system configuration..", false);
            this.progress = 0.0f;
            this.progress_step = 100.0f / (float)((this.profileId == -1 ? params.profiles.length : 1) * read_cmd_ids.length + 1);
            for (int id = 0; id < params.profiles.length; ++id) {
                if (this.profileId != -1 && id != this.profileId) continue;
                for (int cmd_id : read_cmd_ids) {
                    this.read_cmd = null;
                    this.logger.info((Object)("Requesting profile " + id + " from the board.."));
                    cmd = new SerialCommand(cmd_id, 1);
                    cmd.writeByte(id);
                    SerialCommandProcessor.sendCommand(cmd);
                    ParamsReaderThread paramsReaderThread = this;
                    synchronized (paramsReaderThread) {
                        this.wait(3000L);
                    }
                    if (this.read_cmd != null && (cmd.id == this.read_cmd.id || cmd.id == 82 && this.read_cmd.id == 21)) {
                        int profile_id = this.read_cmd.readByte();
                        if (profile_id == id) {
                            params.parse(this.read_cmd, profile_id);
                            this.logger.info((Object)("Profile " + profile_id + " successfuly parsed"));
                        } else {
                            errors.add("-Received profile (" + profile_id + ") does not match the requested one (" + id + ")");
                        }
                    } else {
                        errors.add("-Error reading params for profile " + id);
                    }
                    this.progressStep();
                }
            }
            if (BoardInfo.hasAdjVars()) {
                this.logger.info((Object)"Requesting adj.vars from the board..");
                cmd = new SerialCommand(43);
                SerialCommandProcessor.sendCommand(cmd);
                ParamsReaderThread id = this;
                synchronized (id) {
                    this.wait(3000L);
                }
                if (this.read_cmd != null && this.read_cmd.id == cmd.id) {
                    params.parseAdjVarsReadCmd(this.read_cmd);
                    this.logger.info((Object)"Adj.vars parsed");
                } else {
                    errors.add("-Error reading adj. variables");
                }
            }
            this.progressStep();
            SimpleBGC_GUIApp.mainView.onProgressChange(100);
        }
        catch (InterruptedException ignore) {
        }
        catch (Exception e) {
            this.logger.error((Object)"unexpected exception!", (Throwable)e);
            errors.add("-Unexpected error: " + e.toString());
        }
        if (errors.isEmpty()) {
            BoardParams.setCurParams(params);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleBGC_GUIApp.mainView.updateBoardParams();
                    SimpleBGC_GUIApp.mainView.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.params_loaded", new Object[0]));
                }
            });
        } else {
            final String err = Log.join(errors, "\n");
            this.logger.error((Object)err);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleBGC_GUIApp.mainView.showErrorMessage("Something goes wrong when reading parameters: \n" + err, "Error reading parameters");
                }
            });
        }
        SimpleBGC_GUIApp.mainView.progressFinish();
        RealtimeDataThread.pause(rt_pause_state);
    }
}

