/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.ErrorInfo;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;

class ParamsWriterThread
extends Thread {
    private int confirmedCmdId;
    private final BoardParams params;
    private final Logger logger;
    private final int profileId;
    private float progress;
    private float progress_step;

    public ParamsWriterThread(BoardParams params, int profileId, Logger logger) {
        this.params = params;
        this.profileId = profileId;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWriteCmdConfirmation(int cmd_id, SerialCommand cmd) {
        this.confirmedCmdId = cmd_id;
        ParamsWriterThread paramsWriterThread = this;
        synchronized (paramsWriterThread) {
            this.notify();
        }
    }

    private void progressStep() {
        this.progress += this.progress_step;
        SimpleBGC_GUIApp.mainView.onProgressChange((int)this.progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList<String> errors = new ArrayList<String>();
        this.confirmedCmdId = 0;
        boolean rt_pause_state = RealtimeDataThread.pause(true);
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        SimpleBGC_GUIApp.mainView.progressStart("Writing system configuration..", false);
        try {
            SerialCommand cmd;
            this.progress = 0.0f;
            this.progress_step = 100.0f / (float)(2 * (this.profileId == -1 ? this.params.profiles.length : 1) + 1);
            if (BoardInfo.hasAdjVars()) {
                cmd = this.params.formatAdjVarsWriteCmd();
                SerialCommandProcessor.sendCommand(cmd);
                ParamsWriterThread paramsWriterThread = this;
                synchronized (paramsWriterThread) {
                    this.wait(3000L);
                }
                if (this.confirmedCmdId == cmd.id) {
                    this.logger.debug((Object)"Extended parameters writing is confirmed");
                } else {
                    errors.add("-No confirmation on writing configuration of adjustable variables");
                }
            }
            this.progressStep();
            for (int id = 0; id < this.params.profiles.length; ++id) {
                if (this.profileId != -1 && id != this.profileId) continue;
                cmd = this.params.formatWriteCommand(id, false);
                SerialCommandProcessor.sendCommand(cmd);
                ParamsWriterThread paramsWriterThread = this;
                synchronized (paramsWriterThread) {
                    this.wait(3000L);
                }
                if (this.confirmedCmdId == cmd.id) {
                    this.logger.debug((Object)"Main parameters writing is confirmed");
                } else {
                    errors.add("-No confirmation on writing main parameters");
                }
                this.progressStep();
                if (BoardInfo.hasExtendedParams()) {
                    cmd = this.params.formatWriteCommand(id, true);
                    SerialCommandProcessor.sendCommand(cmd);
                    paramsWriterThread = this;
                    synchronized (paramsWriterThread) {
                        this.wait(3000L);
                    }
                    if (this.confirmedCmdId == cmd.id) {
                        this.logger.debug((Object)"Extended parameters writing is confirmed");
                    } else {
                        errors.add("-No confirmation on writing extended parameters");
                    }
                }
                this.progressStep();
            }
            SimpleBGC_GUIApp.mainView.onProgressChange(100);
        }
        catch (InterruptedException ignore) {
        }
        catch (Exception e) {
            this.logger.error((Object)"unexpected exception!", (Throwable)e);
            errors.add("-Unexpected error: " + e.toString());
        }
        if (errors.isEmpty()) {
            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.profile_written", new Object[0]));
        } else {
            final String err = Log.join(errors, "\n");
            this.logger.error((Object)err);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleBGC_GUIApp.mainView.showErrorMessage("Something goes wrong when writing parameters: \n" + err, "Error writing parameters");
                }
            });
        }
        SimpleBGC_GUIApp.mainView.progressFinish();
        RealtimeDataThread.pause(rt_pause_state);
    }
}

