/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.log4j.Logger;
import sbgc.object.BoardInfo;
import sbgc.object.DebugVar;
import sbgc.object.DebugVars;
import sbgc.object.RealtimeData;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.utils.DataLogger;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealtimeDataThread {
    static final Logger logger = Logger.getLogger((String)RealtimeDataThread.class.getName());
    private static Integer frameRate;
    private static Thread thread;
    private static volatile boolean paused;
    private static DataLogger dataLogger;
    private static SimpleDateFormat logTimeFormat;
    private static boolean isMonitoringVisible;
    private static boolean isAdjVarsVisible;

    public static void start() {
        if (thread != null) {
            thread.interrupt();
        }
        logger.info((Object)"Starting realtime data thread..");
        frameRate = new Integer(SimpleBGC_GUIApp.mainView.getRTFrameRate());
        thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.currentThread().setName("RealtimeData");
                if (Settings.is("realtime.debug_vars")) {
                    SerialCommandProcessor.requestDebugVarsInfo();
                }
                if (Settings.is("realtime.log_to_file")) {
                    RealtimeDataThread.startLogging();
                }
                SerialCommand cmd_realtime_data = new SerialCommand(68);
                SerialCommand cmd_realtime_data_3 = new SerialCommand(BoardInfo.checkMinFirmwareVer(2410) ? 25 : 23);
                SerialCommand cmd_debug_vars_3 = new SerialCommand(254);
                while (!this.isInterrupted()) {
                    int delay;
                    Integer n = frameRate;
                    synchronized (n) {
                        delay = 1000 / frameRate;
                    }
                    try {
                        Object cmd;
                        if (BoardInfo.checkMinBoardVer(30)) {
                            SerialCommandProcessor.sendCommand(cmd_realtime_data_3);
                            Thread.sleep(delay / 2);
                            if ((isMonitoringVisible || dataLogger != null) && DebugVars.hasInfo()) {
                                SerialCommandProcessor.sendCommand(cmd_debug_vars_3);
                            }
                            if (isAdjVarsVisible) {
                                cmd = new SerialCommand(46);
                                ((SerialCommand)cmd).writeByte(SimpleBGC_GUIApp.mainView.panelAdjVars.trigger_cur_slot);
                                ((SerialCommand)cmd).writeByte(SimpleBGC_GUIApp.mainView.panelAdjVars.analog_cur_slot);
                                ((SerialCommand)cmd).writeEmptyArr(6);
                                SerialCommandProcessor.sendCommand((SerialCommand)cmd);
                            }
                            Thread.sleep(delay / 2);
                        } else {
                            SerialCommandProcessor.sendCommand(cmd_realtime_data);
                            Thread.sleep(delay);
                        }
                        cmd = thread;
                        synchronized (cmd) {
                            while (paused) {
                                this.wait();
                            }
                        }
                    }
                    catch (InterruptedException ignore) {
                        break;
                    }
                    catch (IOException e) {
                        logger.error((Object)e.toString());
                    }
                }
                RealtimeDataThread.stopLogging();
                logger.info((Object)"thread finished.");
            }
        };
        thread.start();
    }

    public static void stop() {
        logger.info((Object)"Finishing realtime data thread..");
        if (thread != null) {
            thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFrameRate(int rate) {
        Integer n = frameRate;
        synchronized (n) {
            frameRate = new Integer(rate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pause(boolean state) {
        boolean old_state = paused;
        paused = state;
        if (thread != null && !paused) {
            Thread thread = RealtimeDataThread.thread;
            synchronized (thread) {
                RealtimeDataThread.thread.notify();
            }
        }
        return old_state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopLogging() {
        if (dataLogger != null) {
            DataLogger dataLogger = RealtimeDataThread.dataLogger;
            synchronized (dataLogger) {
                RealtimeDataThread.dataLogger.finish();
                RealtimeDataThread.dataLogger = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startLogging() {
        if (dataLogger == null) {
            boolean rewrite = Settings.get("realtime.log_rewrite", "true").equals("true");
            try {
                DataLogger dataLogger = RealtimeDataThread.dataLogger = new DataLogger("realtime_data_log.csv", !rewrite);
                synchronized (dataLogger) {
                    RealtimeDataThread.dataLogger.setHeader(Arrays.asList("TIME", "ACC[ROLL]", "GYRO[ROLL]", "ANGLE[ROLL]", "TARGET_ANGLE[ROLL]", "FRAME_ANGLE[ROLL]", "POWER[ROLL]", "ACC[PITCH]", "GYRO[PITCH]", "ANGLE[PITCH]", "TARGET_ANGLE[PITCH]", "FRAME_ANGLE[PITCH]", "POWER[PITCH]", "ACC[YAW]", "GYRO[YAW]", "ANGLE[YAW]", "TARGET_ANGLE[YAW]", "FRAME_ANGLE[YAW]", "POWER[YAW]", "RC_ROLL", "RC_PITCH", "RC_YAW", "RC_CMD", "EXT_FC_ROLL", "EXT_FC_PITCH", "BAT_VOLTAGE", "RMS_ERR[ROLL]", "FREQ[ROLL]", "RMS_ERR[PITCH]", "FREQ[PITCH]", "RMS_ERR[YAW]", "FREQ[YAW]"));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    static void _addDebugVar(ArrayList<String> row, String name) {
        DebugVar v = DebugVars.get(name);
        if (v != null) {
            row.add(Integer.toString(v.value));
        } else {
            row.add("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logData() {
        if (dataLogger != null) {
            DataLogger dataLogger = RealtimeDataThread.dataLogger;
            synchronized (dataLogger) {
                int i;
                RealtimeData d = RealtimeData.getRealtimeData();
                ArrayList<String> row = new ArrayList<String>(RealtimeDataThread.dataLogger.getHeader().size());
                row.add(logTimeFormat.format(new Date()));
                for (i = 0; i < 3; ++i) {
                    row.add(Integer.toString(d.acc[i]));
                    row.add(Integer.toString(d.gyro[i]));
                    row.add(Float.toString(d.angle[i]));
                    row.add(Float.toString(d.rc_angle[i]));
                    row.add(Float.toString(d.frameAngle[i]));
                    row.add(Integer.toString(d.power[i]));
                }
                for (i = 0; i < 6; ++i) {
                    if (d.rcData[i] > -8500) {
                        row.add(Integer.toString(d.rcData[i]));
                        continue;
                    }
                    row.add("");
                }
                row.add(Integer.toString(d.bat_val));
                RealtimeDataThread._addDebugVar(row, "RMS_ERR_R");
                RealtimeDataThread._addDebugVar(row, "FREQ_R");
                RealtimeDataThread._addDebugVar(row, "RMS_ERR_P");
                RealtimeDataThread._addDebugVar(row, "FREQ_P");
                RealtimeDataThread._addDebugVar(row, "RMS_ERR_Y");
                RealtimeDataThread._addDebugVar(row, "FREQ_Y");
                RealtimeDataThread.dataLogger.logData(row);
            }
        }
    }

    public static void setAdjVarsVisible(boolean state) {
        isAdjVarsVisible = state;
    }

    public static void setMonitoringVisible(boolean state) {
        isMonitoringVisible = state;
    }

    static {
        thread = null;
        paused = false;
        dataLogger = null;
        logTimeFormat = new SimpleDateFormat("hh:mm:ss.SS");
        isMonitoringVisible = false;
        isAdjVarsVisible = false;
    }
}

