/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import sbgc.service.Checksum;
import sbgc.utils.HexUtil;

public class SerialCommand {
    public static final int SIGN_TYPE_FULL = 1;
    public static final int SIGN_TYPE_FIRMWARE_UPDATE = 2;
    public static final int SIGN_TYPE_AUTH_GUI = 3;
    public static final int SIGN_TYPE_CHECK_FIRMWARE = 4;
    public static final int SIGN_TYPE_ACTIVATE = 5;
    public static final int MAX_SIZE = 512;
    public static final byte START_BYTE = 62;
    public static final int CMD_READ_PARAMS = 82;
    public static final int CMD_WRITE_PARAMS = 87;
    public static final int CMD_REALTIME_DATA = 68;
    public static final int CMD_BOARD_INFO = 86;
    public static final int CMD_CALIB_ACC = 65;
    public static final int CMD_CALIB_GYRO = 103;
    public static final int CMD_CALIB_EXT_GAIN = 71;
    public static final int CMD_USE_DEFAULTS = 70;
    public static final int CMD_CALIB_POLES = 80;
    public static final int CMD_RESET = 114;
    public static final int CMD_WRITE_LICENSE = 76;
    public static final int CMD_ACTIVATE = 97;
    public static final int CMD_HELPER_DATA = 72;
    public static final int CMD_CALIB_OFFSET = 79;
    public static final int CMD_CALIB_BAT = 66;
    public static final int CMD_MOTORS_ON = 77;
    public static final int CMD_MOTORS_OFF = 109;
    public static final int CMD_CONFIRM = 67;
    public static final int CMD_BOARD_INFO_3 = 20;
    public static final int CMD_READ_PARAMS_3 = 21;
    public static final int CMD_WRITE_PARAMS_3 = 22;
    public static final int CMD_REALTIME_DATA_3 = 23;
    public static final int CMD_SELECT_IMU_3 = 24;
    public static final int CMD_REALTIME_DATA_4 = 25;
    public static final int CMD_ENCODERS_CALIB_OFFSET_4 = 26;
    public static final int CMD_ENCODERS_CALIB_FLD_OFFSET_4 = 27;
    public static final int CMD_READ_PROFILE_NAMES = 28;
    public static final int CMD_WRITE_PROFILE_NAMES = 29;
    public static final int CMD_QUEUE_PARAMS_INFO_3 = 30;
    public static final int CMD_SET_PARAMS_3 = 31;
    public static final int CMD_SAVE_PARAMS_3 = 32;
    public static final int CMD_READ_PARAMS_EXT = 33;
    public static final int CMD_WRITE_PARAMS_EXT = 34;
    public static final int CMD_AUTO_PID = 35;
    public static final int CMD_BODE_TEST_START_STOP = 37;
    public static final int CMD_BODE_TEST_DATA = 38;
    public static final int CMD_I2C_WRITE_REG_BUF = 39;
    public static final int CMD_I2C_READ_REG_BUF = 40;
    public static final int CMD_WRITE_EXTERNAL_DATA = 41;
    public static final int CMD_READ_EXTERNAL_DATA = 42;
    public static final int CMD_READ_ADJ_VARS_CFG = 43;
    public static final int CMD_WRITE_ADJ_VARS_CFG = 44;
    public static final int CMD_API_VIRT_CH_CONTROL = 45;
    public static final int CMD_ADJ_VARS_STATE = 46;
    public static final int CMD_EEPROM_WRITE = 47;
    public static final int CMD_EEPROM_READ = 48;
    public static final int CMD_DEBUG_VARS_INFO_3 = 253;
    public static final int CMD_DEBUG_VARS_3 = 254;
    public static final int CMD_SIGN_MESSAGE = 50;
    public static final int CMD_BOOT_MODE = 51;
    public static final int CMD_SYSTEM_STATE = 52;
    public final int id;
    public byte[] data = null;
    public int pos = 0;
    public int len;

    public SerialCommand(int id) {
        this(id, 0);
    }

    public int getId() {
        return this.id;
    }

    public SerialCommand(int id, int size) {
        this.id = id;
        this.data = new byte[512];
        this.len = 0;
    }

    public SerialCommand(int id, byte[] data) {
        this.id = id;
        this.data = data;
        this.len = data.length;
    }

    public void startReading() {
        this.pos = 0;
    }

    public byte[] getBytes() {
        Checksum cs = new Checksum();
        cs.update(this.id);
        cs.update(this.len);
        byte[] buf = new byte[this.len + 5];
        buf[0] = 62;
        buf[1] = (byte)this.id;
        buf[2] = (byte)this.len;
        buf[3] = (byte)cs.get();
        System.arraycopy(this.data, 0, buf, 4, this.len);
        buf[buf.length - 1] = (byte)new Checksum(this.data, this.len).get();
        return buf;
    }

    public String toString() {
        StringBuffer str = new StringBuffer((char)this.id + " [" + this.id + "," + this.len + "] [");
        for (int i = 0; i < this.len; ++i) {
            str.append(Integer.toHexString(this.data[i] & 0xFF));
            str.append(" ");
        }
        str.append("] " + Integer.toHexString(new Checksum(this.data, this.len).get()));
        return str.toString();
    }

    public int readByte() throws IOException {
        if (this.pos < this.len) {
            return this.data[this.pos++] & 0xFF;
        }
        throw new IOException("Limit reached!");
    }

    public int[] readByteArr(int size) throws IOException {
        int[] arr = new int[size];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readByte();
        }
        return arr;
    }

    public int[] readByte3() throws IOException {
        return this.readByteArr(3);
    }

    public void readByteArr(int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readByte();
        }
    }

    public int readByteSigned() throws IOException {
        if (this.pos < this.len) {
            return this.data[this.pos++];
        }
        throw new IOException("Limit reached!");
    }

    public int readWord() throws IOException {
        if (this.pos + 2 <= this.len) {
            return (this.data[this.pos++] & 0xFF) + (this.data[this.pos++] << 8);
        }
        throw new IOException("Limit reached!");
    }

    public int[] readWord3() throws IOException {
        int[] arr = new int[3];
        for (int i = 0; i < 3; ++i) {
            arr[i] = this.readWord();
        }
        return arr;
    }

    public void readWordArr(int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readWord();
        }
    }

    public int readWordUnsigned() throws IOException {
        if (this.pos + 2 <= this.len) {
            return (this.data[this.pos++] & 0xFF) + ((this.data[this.pos++] & 0xFF) << 8);
        }
        throw new IOException("Limit reached!");
    }

    public int[] readWordUnsigned3() throws IOException {
        int[] arr = new int[3];
        for (int i = 0; i < 3; ++i) {
            arr[i] = this.readWordUnsigned();
        }
        return arr;
    }

    public long readDWord() throws IOException {
        return (long)this.readWord() & 65535L + ((long)this.readWord() << 16);
    }

    public long readDWordUnsigned() throws IOException {
        return (long)this.readWordUnsigned() + ((long)this.readWordUnsigned() << 16);
    }

    public float readFloat() throws IOException {
        if (this.pos + 4 <= this.len) {
            Float f = Float.valueOf(ByteBuffer.wrap(this.data, this.pos, 4).order(ByteOrder.LITTLE_ENDIAN).getFloat());
            this.pos += 4;
            return f.floatValue();
        }
        throw new IOException("Limit reached!");
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    public String readString() throws IOException {
        int size = this.readByte();
        if (this.pos + size <= this.len) {
            String s = new String(this.data, this.pos, size, Charset.forName("ISO-8859-1"));
            this.pos += size;
            return s;
        }
        throw new IOException("Limit reached!");
    }

    public void read(byte[] buf) throws IOException {
        this.read(buf, 0, buf.length);
    }

    public void read(byte[] buf, int to_pos, int size) throws IOException {
        if (this.pos + size <= this.len) {
            System.arraycopy(this.data, this.pos, buf, to_pos, size);
            this.pos += size;
        } else {
            throw new IOException("Limit reached!");
        }
    }

    public byte[] readBytes(int size) throws IOException {
        if (this.pos + size <= this.len) {
            byte[] buf = new byte[size];
            System.arraycopy(this.data, this.pos, buf, 0, size);
            this.pos += size;
            return buf;
        }
        throw new IOException("Limit reached!");
    }

    public void skipBytes(int size) throws IOException {
        if (this.pos + size <= this.len) {
            this.pos += size;
        } else {
            throw new IOException("Limit reached!");
        }
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int from_pos, int size) throws IOException {
        if (this.len + size <= this.data.length) {
            System.arraycopy(buf, from_pos, this.data, this.len, size);
            this.len += size;
        } else {
            throw new IOException("Buffer oferflow!");
        }
    }

    public void writeByte(int val) throws IOException {
        if (this.len >= this.data.length) {
            throw new IOException("Buffer oferflow!");
        }
        this.data[this.len++] = (byte)(val & 0xFF);
    }

    public void writeByteArr(int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            this.writeByte(arr[i]);
        }
    }

    public void writeByteSigned(int val) throws IOException {
        if (this.len >= this.data.length) {
            throw new IOException("Buffer oferflow!");
        }
        this.data[this.len++] = (byte)val;
    }

    public void writeWord(int val) throws IOException {
        if (this.len + 2 > this.data.length) {
            throw new IOException("Buffer oferflow!");
        }
        this.data[this.len++] = (byte)(val & 0xFF);
        this.data[this.len++] = (byte)(val >> 8 & 0xFF);
    }

    public void writeWordArr(int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            this.writeWord(arr[i]);
        }
    }

    public void writeDWord(long val) throws IOException {
        this.writeWord((int)val);
        this.writeWord((int)(val >> 16));
    }

    public void writeBoolean(boolean val) throws IOException {
        this.writeByte(val ? 1 : 0);
    }

    public void writeEmptyArr(int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            this.writeByte(0);
        }
    }

    public final int getBytesAvailable() {
        return this.len - this.pos;
    }

    public final int getChecksum() {
        return new Checksum(this.data, this.len).get();
    }

    public final void checkFinished() throws IOException {
        if (this.getBytesAvailable() != 0) {
            throw new IOException("Wrong command format: left " + this.getBytesAvailable() + " bytes");
        }
    }

    public static SerialCommand getCommandSignMessage(String message, int signType) throws Exception {
        SerialCommand command = new SerialCommand(50);
        command.writeByte(signType);
        command.write(HexUtil.fromHex(message));
        return command;
    }

    public final boolean isHeavyDutyCommand() {
        return this.id == 38 || this.id == 68 || this.id == 254 || this.id == 23 || this.id == 25 || this.id == 46;
    }
}

