/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sbgc.object.AutoPIDInfo;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BodeTest;
import sbgc.object.DebugVars;
import sbgc.object.ErrorInfo;
import sbgc.object.RealtimeData;
import sbgc.serial.command.SerialCommandSignMessageImpl;
import sbgc.service.CommandResponseListener;
import sbgc.service.ConnectThread;
import sbgc.service.ICommandListener;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import simplebgc_gui.SimpleBGC_GUIApp;

public class SerialCommandDispatcher
implements ICommandListener {
    private static SerialCommandDispatcher instance = new SerialCommandDispatcher();
    static final Logger logger = Logger.getLogger((String)SerialCommandDispatcher.class.getName());
    private final ConcurrentHashMap<Integer, CopyOnWriteArrayList<CommandResponseListener>> listeners = new ConcurrentHashMap();

    public static SerialCommandDispatcher getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponseListener(CommandResponseListener listener) {
        ConcurrentHashMap<Integer, CopyOnWriteArrayList<CommandResponseListener>> concurrentHashMap = this.listeners;
        synchronized (concurrentHashMap) {
            CopyOnWriteArrayList<Object> commandListeners = null;
            if (this.listeners.get(listener.getCommandId()) != null) {
                commandListeners = this.listeners.get(listener.getCommandId());
            } else {
                commandListeners = new CopyOnWriteArrayList();
                this.listeners.put(listener.getCommandId(), commandListeners);
            }
            commandListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResponseListener(CommandResponseListener listener) {
        ConcurrentHashMap<Integer, CopyOnWriteArrayList<CommandResponseListener>> concurrentHashMap = this.listeners;
        synchronized (concurrentHashMap) {
            if (this.listeners.get(listener.getCommandId()) != null) {
                CopyOnWriteArrayList<CommandResponseListener> commandListeners = this.listeners.get(listener.getCommandId());
                commandListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serialCommandEvent(final SerialCommand cmd) {
        int commandIdForListener = cmd.id;
        try {
            block4 : switch (cmd.id) {
                case 21: 
                case 33: 
                case 43: 
                case 82: {
                    SerialCommandProcessor.onReadParamsCmd(cmd);
                    break;
                }
                case 67: {
                    int c;
                    commandIdForListener = c = cmd.readByte();
                    logger.debug((Object)("Command c (" + c + ") confirmed."));
                    switch (c) {
                        case 22: 
                        case 34: 
                        case 44: 
                        case 87: {
                            SerialCommandProcessor.onWriteCmdConfirmation(c, cmd);
                            break block4;
                        }
                        case 65: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.acc_calibration", new Object[0]));
                            break block4;
                        }
                        case 103: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.gyro_calibration", new Object[0]));
                            break block4;
                        }
                        case 80: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.poles_calibration", new Object[0]));
                            break block4;
                        }
                        case 71: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.ext_gain_calibration", new Object[0]));
                            break block4;
                        }
                        case 76: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.license_written", new Object[0]));
                            break block4;
                        }
                        case 97: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.activation_sent", new Object[0]));
                            break block4;
                        }
                        case 77: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.motors_on", new Object[0]));
                            break block4;
                        }
                        case 109: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.motors_off", new Object[0]));
                            break block4;
                        }
                        case 26: 
                        case 27: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.encoder_calibration", new Object[0]));
                            break block4;
                        }
                        case 35: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.auto_pid_started", new Object[0]));
                            break block4;
                        }
                        case 47: {
                            break block4;
                        }
                    }
                    ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.command_sent", new Object[0]));
                    break;
                }
                case 20: 
                case 86: {
                    BoardInfo info = BoardInfo.getBoardInfo();
                    if (cmd.id != 86 && (info == null || info.boardVer < 30)) break;
                    info = BoardInfo.parse(cmd);
                    logger.info((Object)info.toString());
                    if (info.boardVer >= 30 && cmd.id == 86) {
                        SerialCommandProcessor.sendCommand(new SerialCommand(20));
                        break;
                    }
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SimpleBGC_GUIApp.mainView.updateBoardInfo();
                            }
                        });
                    }
                    catch (Exception ignore) {}
                    break;
                }
                case 23: 
                case 25: 
                case 68: {
                    RealtimeData.parse(cmd);
                    break;
                }
                case 253: {
                    DebugVars.parseInfo(cmd);
                    break;
                }
                case 254: {
                    DebugVars.parse(cmd);
                    break;
                }
                case 50: {
                    logger.trace((Object)"Parsing sign message result...");
                    SerialCommandSignMessageImpl sign = SerialCommandSignMessageImpl.parse(cmd);
                    logger.trace((Object)sign.toString());
                    break;
                }
                case 28: {
                    if (BoardInfo.getBoardInfo() == null) break;
                    BoardInfo.getBoardInfo().parseProfileNames(cmd);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SimpleBGC_GUIApp.mainView.updateProfileNames();
                        }
                    });
                    break;
                }
                case 52: {
                    final StringBuffer buf = new StringBuffer(300);
                    int error = cmd.readWordUnsigned();
                    ErrorInfo.setBoardError(error);
                    buf.append("error:" + error + "\n");
                    buf.append("assert_line: " + cmd.readWordUnsigned() + "\n");
                    buf.append("assert_file: " + new String(cmd.readBytes(32), "US-ASCII").replace('\u0000', ' ').trim() + "\n");
                    buf.append("COM errors: " + cmd.readWordUnsigned() + "\n");
                    for (int axis = 0; axis < 3; ++axis) {
                        String name = "Encoder[" + BoardParams.axisName[axis] + "]";
                        int type = cmd.readByte();
                        if (type < BoardParams.ENC_TYPE_NAMES.length) {
                            buf.append(name + " type: " + BoardParams.ENC_TYPE_NAMES[type] + "\n");
                        } else {
                            buf.append(name + " type: " + type + " - UNKNOWN" + "\n");
                        }
                        int[] data = cmd.readByteArr(4);
                        if (type == 2 || type == 1) {
                            buf.append(name + " magnitude: " + data[0] + ", auto-gain: " + data[2] + "\n");
                            buf.append(name + " diagnostic: ");
                            if ((data[1] & 2) > 0) {
                                buf.append("CORDIC oferflow!");
                            } else if ((data[1] & 8) > 0) {
                                buf.append("Magnetic field is too low!");
                            } else if ((data[1] & 4) > 0) {
                                buf.append("Magnetic field is too high!");
                            } else {
                                buf.append("no problems");
                            }
                            buf.append("\n");
                        }
                        buf.append(name + " errors: " + cmd.readWordUnsigned() + "\n");
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SimpleBGC_GUIApp.mainView.debugMessage(buf.toString());
                        }
                    });
                    break;
                }
                case 35: {
                    final AutoPIDInfo p = AutoPIDInfo.parse(cmd);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SimpleBGC_GUIApp.mainView.updateAutoPIDInfo(p);
                        }
                    });
                    break;
                }
                case 38: {
                    BodeTest.parse_data(cmd);
                    break;
                }
                case 37: {
                    BodeTest.parse_stop(cmd);
                    break;
                }
                case 46: {
                    RealtimeData.parseCmdAdjVarsState(cmd);
                    break;
                }
                case 114: {
                    ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.reset", new Object[0]));
                    if ((BoardInfo.getBoardInfo().connectionFlags & 1) == 0 && SimpleBGC_GUIApp.mainView.isSerialCommunicationActive()) break;
                    new Thread(){

                        public void run() {
                            ConnectThread.reconnect(3000);
                        }
                    }.start();
                }
            }
            Integer key = new Integer(commandIdForListener);
            if (this.listeners.containsKey(key)) {
                logger.debug((Object)"Firing matched listeners...");
                CopyOnWriteArrayList<CommandResponseListener> matchedListeners = this.listeners.get(key);
                if (matchedListeners != null) {
                    Iterator<CommandResponseListener> i$ = matchedListeners.iterator();
                    while (i$.hasNext()) {
                        CommandResponseListener listener;
                        CommandResponseListener commandResponseListener = listener = i$.next();
                        synchronized (commandResponseListener) {
                            listener.onCommandReceived(cmd);
                            listener.notifyAll();
                        }
                    }
                }
            }
            if (SimpleBGC_GUIApp.debugMode && !cmd.isHeavyDutyCommand()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SimpleBGC_GUIApp.mainView.debugSerialCommand(cmd);
                    }
                });
            }
            return true;
        }
        catch (IOException e) {
            logger.warn((Object)("Error dispatching command " + cmd.id + ": " + e.toString()));
            ErrorInfo.addError(256);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

