/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.DebugVars;
import sbgc.object.ErrorInfo;
import sbgc.service.Checksum;
import sbgc.service.CommandResponseListener;
import sbgc.service.ICommandListener;
import sbgc.service.ParamsReaderThread;
import sbgc.service.ParamsWriterThread;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;

public class SerialCommandProcessor {
    static ICommandListener commandListener = null;
    static SerialPort serialPort = null;
    static final Logger logger = Logger.getLogger((String)SerialCommandProcessor.class.getName());
    static ParamsWriterThread writeParamsThread = null;
    static ParamsReaderThread readParamsThread = null;
    static int confirmedCmdId;
    private static Date lastPing;
    private static final int ONLINE_TIME_MS = 1000;

    public static void setCommandListener(ICommandListener l) {
        commandListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSerialPort(SerialPort s) {
        serialPort = s;
        if (serialPort != null) {
            SerialPort serialPort = SerialCommandProcessor.serialPort;
            synchronized (serialPort) {
                try {
                    SerialCommandProcessor.serialPort.enableReceiveTimeout(500);
                    SerialCommandProcessor.serialPort.removeEventListener();
                    SerialCommandProcessor.serialPort.addEventListener((SerialPortEventListener)new SerialReader(SerialCommandProcessor.serialPort.getInputStream()));
                    SerialCommandProcessor.serialPort.notifyOnDataAvailable(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SerialCommandProcessor.serialPort = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendCommand(SerialCommand cmd) {
        if (serialPort != null) {
            SerialPort serialPort = SerialCommandProcessor.serialPort;
            synchronized (serialPort) {
                try {
                    logger.info((Object)("Send command: " + cmd.toString()));
                    SerialCommandProcessor.serialPort.getOutputStream().write(cmd.getBytes());
                    SerialCommandProcessor.serialPort.getOutputStream().flush();
                }
                catch (Exception e) {
                    ErrorInfo.addError(32);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOnline() {
        Date date = lastPing;
        synchronized (date) {
            return new Date().getTime() - lastPing.getTime() < 1000L;
        }
    }

    public static boolean isReadParamsThreadActive() {
        return readParamsThread != null && readParamsThread.isAlive();
    }

    public static boolean isWriteParamsThreadActive() {
        return writeParamsThread != null && writeParamsThread.isAlive();
    }

    public static void readAllParams(int profileId) {
        if (!SerialCommandProcessor.isReadParamsThreadActive()) {
            logger.info((Object)("Reading all params for profile " + profileId + " from the board.."));
            readParamsThread = new ParamsReaderThread(profileId, logger);
            readParamsThread.start();
        }
    }

    public static void onReadParamsCmd(SerialCommand cmd) throws Exception {
        if (SerialCommandProcessor.isReadParamsThreadActive()) {
            readParamsThread.onReadParamsCmd(cmd);
        } else {
            int profile_id = cmd.readByte();
            BoardParams.getCurParams().parse(cmd, profile_id);
            logger.info((Object)("Profile " + profile_id + " successfuly parsed"));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleBGC_GUIApp.mainView.updateBoardParams();
                }
            });
        }
    }

    public static void requestDebugVarsInfo() {
        DebugVars.setVars(null);
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo != null && boardInfo.boardVer >= 30) {
            logger.info((Object)"Requesting debug variables info..");
            SerialCommandProcessor.sendCommand(new SerialCommand(253));
        }
    }

    public static void useDefaults(final int profile) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean rtState = RealtimeDataThread.pause(true);
                try {
                    SimpleBGC_GUIApp.mainView.progressStart("Resetting system to factory defaults settings...", true);
                    SerialCommand cmd = new SerialCommand(70, 1);
                    cmd.writeByte(profile);
                    SerialCommandProcessor.sendCommand(cmd);
                    SerialCommandProcessor.waitForReset(SimpleBGC_GUIApp.mainView);
                }
                catch (Exception e) {
                    logger.error((Object)e.toString());
                }
                finally {
                    RealtimeDataThread.pause(rtState);
                    SimpleBGC_GUIApp.mainView.progressFinish();
                }
                SerialCommandProcessor.readAllParams(-1);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForReset(IProgressListener progressListener) {
        CommandResponseListener commandResponseListener = new CommandResponseListener(114);
        SerialCommandDispatcher.getInstance().addResponseListener(commandResponseListener);
        try {
            int delay = 10000;
            for (int i = 0; i < 10000; i += 100) {
                CommandResponseListener commandResponseListener2 = commandResponseListener;
                synchronized (commandResponseListener2) {
                    if (commandResponseListener.isCommandResponseReceived()) {
                        i = 5000;
                        commandResponseListener.setCommandResponseReceived(false);
                    }
                }
                Thread.sleep(100L);
                if (progressListener == null || progressListener.onProgressChange(i * 100 / 10000)) continue;
                return;
            }
        }
        catch (Exception ignore) {
            return;
        }
        finally {
            SerialCommandDispatcher.getInstance().removeResponseListener(commandResponseListener);
        }
    }

    public static void writeAllParams(BoardParams params, int profileId) {
        if (!(params == null || writeParamsThread != null && writeParamsThread.isAlive())) {
            logger.info((Object)("Writing all params for profile " + profileId + " to the board.."));
            writeParamsThread = new ParamsWriterThread(params, profileId, logger);
            writeParamsThread.start();
        }
    }

    public static void onWriteCmdConfirmation(int cmd_id, SerialCommand cmd) {
        if (writeParamsThread != null) {
            writeParamsThread.onWriteCmdConfirmation(cmd_id, cmd);
        }
    }

    public static void stopSerialCommunication() {
        if (writeParamsThread != null) {
            writeParamsThread.interrupt();
        }
        if (SerialCommandProcessor.isReadParamsThreadActive()) {
            readParamsThread.interrupt();
        }
    }

    public static byte[] readEEPROM(IProgressListener progressListener) throws Exception {
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo != null && boardInfo.eeprom_size > 0) {
            logger.info((Object)("Reading EPROM " + boardInfo.eeprom_size + " bytes from the board.."));
            byte[] buf = new byte[boardInfo.eeprom_size];
            boolean rtState = RealtimeDataThread.pause(true);
            try {
                SerialCommand cmd = new SerialCommand(109, 0);
                SerialCommandProcessor.sendCommand(cmd);
                int part_size = 192;
                int addr = 0;
                while (addr < boardInfo.eeprom_size) {
                    cmd = new SerialCommand(48, 6);
                    cmd.writeDWord(addr);
                    cmd.writeWord(192);
                    SerialCommandProcessor.sendCommand(cmd);
                    SerialCommand resp = CommandResponseListener.waitFor(cmd.id, 1000L);
                    if (resp == null) {
                        throw new Exception("No response on CMD_EEPROM_READ command");
                    }
                    if (addr == (int)resp.readDWordUnsigned()) {
                        int size = resp.len - 4;
                        if (addr + size <= buf.length) {
                            resp.read(buf, addr, size);
                            if (progressListener == null || progressListener.onProgressChange((addr += size) * 100 / buf.length)) continue;
                            throw new InterruptedException("Operation is cancelled by user!");
                        }
                        throw new Exception("Wrong data received: addr=" + addr + ", size=" + size);
                    }
                    throw new Exception("Wrong data received while reading from addr=" + addr);
                }
            }
            catch (Exception e) {
                logger.error((Object)(e + Log.formatStackTrace(e)));
                throw e;
            }
            finally {
                RealtimeDataThread.pause(rtState);
            }
            return buf;
        }
        throw new Exception("BoardInfo is not received, or EEPROM reading is not supported!");
    }

    public static void writeEEPROM(byte[] data, IProgressListener progressListener) throws Exception {
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo != null && boardInfo.eeprom_size > 0) {
            if (data.length != boardInfo.eeprom_size) {
                throw new Exception("Data length (" + data.length + ") does no match the board's EEPROM size (" + boardInfo.eeprom_size + ")");
            }
            boolean rtState = RealtimeDataThread.pause(true);
            try {
                SerialCommand cmd = new SerialCommand(109, 0);
                SerialCommandProcessor.sendCommand(cmd);
                int part_size = 192;
                for (int addr = 0; addr < data.length; addr += part_size) {
                    cmd = new SerialCommand(47, 4);
                    cmd.writeDWord(addr);
                    if (addr + part_size > data.length) {
                        part_size = data.length - addr;
                    }
                    cmd.write(data, addr, part_size);
                    SerialCommandProcessor.sendCommand(cmd);
                    SerialCommand resp = CommandResponseListener.waitFor(cmd.id, 1000L);
                    if (resp == null) {
                        throw new Exception("No response on CMD_EEPROM_WRITE command");
                    }
                    if (addr == (int)resp.readDWordUnsigned()) {
                        if (progressListener == null || progressListener.onProgressChange(addr * 100 / data.length)) continue;
                        throw new InterruptedException("Operation is cancelled by user!");
                    }
                    throw new Exception("Wrong confirmation received while writing to addr=" + addr);
                }
            }
            catch (Exception e) {
                logger.error((Object)(e + Log.formatStackTrace(e)));
                throw e;
            }
            finally {
                RealtimeDataThread.pause(rtState);
            }
        } else {
            throw new Exception("BoardInfo is not received, or EEPROM writing is not supported!");
        }
    }

    static {
        lastPing = new Date();
    }

    public static class SerialReader
    implements SerialPortEventListener {
        InputStream in;
        boolean isActive;
        private boolean threadIsNamed = false;

        public SerialReader(InputStream in) {
            this.in = in;
            this.isActive = true;
        }

        public void serialEvent(SerialPortEvent arg0) {
            if (!this.threadIsNamed) {
                Thread.currentThread().setName("SerialPort");
            }
            try {
                while (this.in.available() > 0) {
                    int c = this.in.read();
                    if (c == 62) {
                        Checksum cs = new Checksum();
                        int id = this.in.read();
                        cs.update(id);
                        int size = this.in.read();
                        cs.update(size);
                        if (cs.check(this.in.read())) {
                            int data;
                            SerialCommand cmd = new SerialCommand(id, size);
                            int i = 0;
                            while (i++ < size && (data = this.in.read()) > -1) {
                                cmd.writeByte(data);
                            }
                            if (cmd.getChecksum() == this.in.read()) {
                                if (!cmd.isHeavyDutyCommand()) {
                                    logger.debug((Object)("CMD received: " + (char)cmd.id + " [" + cmd.id + "," + cmd.len + "]"));
                                }
                                ErrorInfo.clearError(32);
                                if (commandListener == null) continue;
                                cmd.startReading();
                                if (commandListener.serialCommandEvent(cmd)) {
                                    ErrorInfo.clearError(256);
                                    lastPing = new Date();
                                    continue;
                                }
                                logger.warn((Object)("Unknown command '" + (char)cmd.id + "'"));
                                ErrorInfo.addError(256);
                                continue;
                            }
                            logger.info((Object)("wrong data checksum! " + cmd.toString()));
                            ErrorInfo.addError(32);
                            continue;
                        }
                        logger.info((Object)("wrong header checksum! " + id + "+" + size + " should be " + cs.get()));
                        ErrorInfo.addError(32);
                        continue;
                    }
                    logger.info((Object)("Unknown start byte: " + c));
                    ErrorInfo.addError(32);
                }
            }
            catch (IOException e) {
                logger.warn((Object)("IO Exception: " + e.toString()));
                ErrorInfo.addError(32);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

