/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import gnu.io.CommPortIdentifier;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import sbgc.object.Sprav;
import sbgc.service.SerialPortListener;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialPortService {
    static final Log logger = new Log(Logger.getLogger((String)SerialPortService.class.getName()));
    static SerialPort serialPort = null;
    static boolean loaded = false;
    static boolean portOpened = false;
    private static String latestPortName = null;
    public static int[] SERIAL_BAUD_RATES = new int[]{115200, 57600, 38400, 19200, 9600, 256000};
    private static int baudIndex = 0;
    private static int parity = 0;

    public static void initSerialPortService() throws Exception {
        if (loaded) {
            return;
        }
    }

    public static void connect(String portName) throws Exception {
        CommPortIdentifier portIdentifier = null;
        try {
            portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        }
        catch (Exception e) {
            throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.cant_open_port", portName));
        }
        if (portIdentifier.isCurrentlyOwned()) {
            throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.port_occupied", portName));
        }
        RXTXPort commPort = portIdentifier.open(SerialPortListener.class.getName(), 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new Exception("This port type not supported: " + portName);
        }
        serialPort = (SerialPort)commPort;
        SerialPortService.updateSerialPortParams();
        portOpened = true;
        latestPortName = portName;
        logger.info("Opened " + portName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSerialPortParams() {
        if (serialPort != null) {
            SerialPort serialPort = SerialPortService.serialPort;
            synchronized (serialPort) {
                try {
                    SerialPortService.serialPort.setSerialPortParams(SERIAL_BAUD_RATES[baudIndex], 8, 1, parity);
                }
                catch (Exception e) {
                    logger.error("Error configuring serial port: " + e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnect() throws Exception {
        if (serialPort != null) {
            SerialPort serialPort = SerialPortService.serialPort;
            synchronized (serialPort) {
                logger.info("Removing event listener..");
                SerialPortService.serialPort.removeEventListener();
                logger.info("Closing serial port..");
                SerialPortService.serialPort.close();
                portOpened = false;
                SerialPortService.serialPort = null;
                logger.info("Serial port disconnected.");
            }
        }
    }

    public static void setBaudIndex(int _baudIndex) {
        if (_baudIndex < 0 || _baudIndex >= SERIAL_BAUD_RATES.length) {
            _baudIndex = 0;
        }
        if (baudIndex != _baudIndex) {
            baudIndex = _baudIndex;
            logger.info("Setting baudrate: " + SERIAL_BAUD_RATES[baudIndex]);
            SerialPortService.updateSerialPortParams();
        }
    }

    public static void setParity(int _parity) {
        if (parity != _parity) {
            parity = _parity;
            logger.info("Setting parity: " + parity);
            SerialPortService.updateSerialPortParams();
        }
    }

    public static int getBaudIndex() {
        return baudIndex;
    }

    public static void incBaudIndex() throws Exception {
        SerialPortService.setBaudIndex((baudIndex + 1) % SERIAL_BAUD_RATES.length);
    }

    public static final SerialPort getSerialPort() {
        return serialPort;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static boolean isPortOpened() {
        return portOpened;
    }

    public static ArrayList<Sprav> getPortList() {
        try {
            Enumeration portListIdentifiers = CommPortIdentifier.getPortIdentifiers();
            int index = 0;
            ArrayList<Sprav> portList = new ArrayList<Sprav>();
            while (portListIdentifiers.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portListIdentifiers.nextElement();
                if (portId.getPortType() != 1) continue;
                Sprav sp = new Sprav();
                sp.setId(index);
                sp.setName(portId.getName());
                portList.add(sp);
                ++index;
            }
            return portList;
        }
        catch (Exception e) {
            logger.trace("Failed to get available ports: " + e.toString());
            return null;
        }
    }

    public static String getLatestPortName() {
        return latestPortName;
    }
}

