/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.File;
import org.apache.log4j.Logger;
import sbgc.object.BoardInfo;
import sbgc.service.upgrade.IFirmwareDownloader;
import sbgc.service.upgrade.IProgressListener;
import sbgc.service.upgrade.VersionImpl;
import sbgc.utils.FileUtil;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import sbgc.utils.OSUtil;
import sbgc.utils.Settings;
import sbgc.utils.http.HttpTransportFactory;
import sbgc.utils.http.IHttpTransport;
import sbgc.utils.http.IRequest;
import sbgc.utils.http.IResponse;
import sbgc.utils.http.RequestFactory;

public class FirmwareDownloaderImpl
implements IFirmwareDownloader {
    public static final String TMP_DIRECTORY = "firmware";
    public static final String FIRMWARE_TEMPLATE = "yyyyMMddHHmmss";
    private static final Log logger = new Log(Logger.getLogger((String)FirmwareDownloaderImpl.class.getName()));
    private BoardInfo boardInfo = null;
    private int version = 0;
    private int versionId = 0;
    private ILogListener logListener = null;
    private IProgressListener progressListener = null;
    private boolean binFormat = false;

    public FirmwareDownloaderImpl(BoardInfo boardInfo, int version, int versionId, ILogListener logListener, IProgressListener progressListener, boolean binFormat) {
        this.boardInfo = boardInfo;
        this.version = version;
        this.versionId = versionId;
        this.logListener = logListener;
        this.progressListener = progressListener;
        this.binFormat = binFormat;
    }

    public File download() throws Exception {
        logger.trace("Downloading firmware...", this.logListener);
        try {
            String workingDirectory = Settings.getWorkingDirectory();
            File tmp = new File(workingDirectory + File.separatorChar + TMP_DIRECTORY);
            if (!tmp.exists()) {
                logger.warn("Creating temporary directory...", this.logListener);
                tmp.mkdirs();
            }
            logger.trace("Prepearing request...");
            IRequest request = RequestFactory.getRequest();
            request.addParameter("act", "sbgc.get_firmware");
            request.addParameter("device_id", this.boardInfo.getDeviceId());
            request.addParameter("mcu_id", this.boardInfo.getMcuId());
            request.addParameter("version", Integer.toString(this.version));
            request.addParameter("versionId", Integer.toString(this.versionId));
            request.addParameter("sign", Settings.get("temporary_signature"));
            request.addParameter("os", OSUtil.getOsName());
            request.addParameter("bin_format", this.binFormat ? "1" : "0");
            if ("1".equals(Settings.get("registration.data.sent"))) {
                if (Settings.get("registration.data.email") != null) {
                    request.addParameter("email", Settings.get("registration.data.email"));
                }
                if (Settings.get("registration.data.country") != null) {
                    request.addParameter("country", Settings.get("registration.data.country"));
                }
            }
            IHttpTransport transport = HttpTransportFactory.getTransport();
            IResponse response = transport.send(request);
            byte[] data = null;
            if (response.getErrorCode() == null || response.getErrorCode() != 0) {
                throw new Exception(response.getErrorMessage() != null ? response.getErrorMessage() : "Invalid response" + (response.getErrorCode() != null ? " code: " + response.getErrorCode() + "!" : "!"));
            }
            data = response.getFirmware();
            this.progressListener.onProgressChange(90);
            File firmware = new File(tmp.getAbsolutePath() + File.separatorChar + "simplebgc" + this.boardInfo.boardVer + "_v" + new VersionImpl(this.version).toString().replaceAll("[\\W]", "_") + "_" + this.boardInfo.getDeviceId() + (this.binFormat ? ".bin" : ".hex"));
            this.progressListener.onProgressChange(95);
            logger.trace("Writing data into file \"" + firmware.getAbsolutePath() + "\"...", this.logListener);
            FileUtil.save(firmware.getAbsolutePath(), data);
            this.progressListener.onProgressChange(100);
            logger.debug("Firmware is downloaded: " + data.length + " bytes", this.logListener);
            return firmware;
        }
        catch (Exception e) {
            throw new Exception("Error downloading firmware: " + e.toString());
        }
    }
}

