/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.File;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import sbgc.object.BoardInfo;
import sbgc.service.upgrade.FirmwareDownloaderImpl;
import sbgc.service.upgrade.FirmwareWriterAvrdudeImpl;
import sbgc.service.upgrade.FirmwareWriterDFUUtilImpl;
import sbgc.service.upgrade.FirmwareWriterSTM32LdImpl;
import sbgc.service.upgrade.FirmwareWriterSTMFlashLoaderImpl;
import sbgc.service.upgrade.IFirmwareUpgradeListener;
import sbgc.service.upgrade.IFirmwareUpgrader;
import sbgc.service.upgrade.IStatusListener;
import sbgc.service.upgrade.ProgressListenerImpl;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import sbgc.utils.OSUtil;
import sbgc.utils.Settings;
import sbgc.utils.http.HttpTransportFactory;
import sbgc.utils.http.IHttpTransport;
import sbgc.utils.http.IRequest;
import sbgc.utils.http.IResponse;
import sbgc.utils.http.RequestFactory;

public class FirmwareUpgraderImpl
implements IFirmwareUpgrader,
Runnable {
    private static final Log logger = new Log(Logger.getLogger((String)FirmwareUpgraderImpl.class.getName()));
    private int version = 0;
    private int versionId = 0;
    private Thread thread = null;
    private IFirmwareUpgradeListener listener = null;
    private ILogListener logListener = null;
    private IStatusListener statusListener = null;
    private String port = null;
    private File firmwareHexFile = null;
    private BoardInfo boardInfo = null;
    private final ResourceMap resourceMap;

    public FirmwareUpgraderImpl(BoardInfo boardInfo, int version, int versionId, String port, IFirmwareUpgradeListener listener, ILogListener logListener, IStatusListener statusListener, File firmwareHexFile, ResourceMap resourceMap) {
        this.version = version;
        this.versionId = versionId;
        this.boardInfo = boardInfo;
        this.port = port;
        this.listener = listener;
        this.logListener = logListener;
        this.statusListener = statusListener;
        this.firmwareHexFile = firmwareHexFile;
        this.resourceMap = resourceMap;
    }

    public void start() {
        this.thread = new Thread((Runnable)this, "Firmware Upgrader");
        this.thread.start();
    }

    public File downloadFirmware() throws Exception {
        boolean binFormat = true;
        FirmwareDownloaderImpl downloader = new FirmwareDownloaderImpl(this.boardInfo, this.version, this.versionId, this.logListener, new ProgressListenerImpl(0, 50, this.listener), binFormat);
        return downloader.download();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeFirmware(File firmware) throws Exception {
        void var2_7;
        ProgressListenerImpl progressListener = new ProgressListenerImpl(50, 50, this.listener);
        if (this.boardInfo.boardVer < 30) {
            FirmwareWriterAvrdudeImpl firmwareWriterAvrdudeImpl = new FirmwareWriterAvrdudeImpl(this.logListener, progressListener, this.resourceMap);
        } else if ((this.boardInfo.connectionFlags & 1) != 0) {
            if (!firmware.getName().endsWith(".bin")) throw new Exception("Unsupported file format: " + firmware.getName());
            FirmwareWriterDFUUtilImpl firmwareWriterDFUUtilImpl = new FirmwareWriterDFUUtilImpl(this.logListener, progressListener, this.resourceMap);
        } else if (firmware.getName().endsWith(".hex")) {
            if (!OSUtil.isWindows()) throw new Exception("*.hex file can be flashed only under Windows OS. Select *.bin file to flash under " + OSUtil.getOsName());
            FirmwareWriterSTMFlashLoaderImpl firmwareWriterSTMFlashLoaderImpl = new FirmwareWriterSTMFlashLoaderImpl(this.logListener, progressListener, this.resourceMap);
        } else {
            if (!firmware.getName().endsWith(".bin")) throw new Exception("Unsupported file format: " + firmware.getName());
            FirmwareWriterSTM32LdImpl firmwareWriterSTM32LdImpl = new FirmwareWriterSTM32LdImpl(this.logListener, progressListener, this.resourceMap);
        }
        var2_7.write(this.port, firmware);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        File downloadedFirmware = null;
        try {
            if (this.firmwareHexFile == null) {
                this.statusListener.onStatusChange("Downloading firmware...");
                downloadedFirmware = this.downloadFirmware();
            } else {
                downloadedFirmware = this.firmwareHexFile;
            }
            this.statusListener.onStatusChange("Writing firmware...");
            this.writeFirmware(downloadedFirmware);
            if (this.firmwareHexFile == null) {
                this.setFirmware(this.version);
            }
            this.listener.onFirmwareUpgradeEnd(null);
        }
        catch (Exception e) {
            if (this.listener != null) {
                this.listener.onFirmwareUpgradeEnd(e);
            }
        }
    }

    public void setFirmware(int version) throws Exception {
        try {
            logger.trace("Prepearing request...");
            IRequest request = RequestFactory.getRequest();
            request.addParameter("act", "sbgc.set_firmware");
            request.addParameter("device_id", this.boardInfo.getDeviceId());
            request.addParameter("mcu_id", this.boardInfo.getMcuId());
            request.addParameter("version", Integer.toString(version));
            request.addParameter("versionId", Integer.toString(this.versionId));
            request.addParameter("sign", Settings.get("temporary_signature"));
            IHttpTransport transport = HttpTransportFactory.getTransport();
            IResponse response = transport.send(request);
            if (response.getErrorCode() == null || response.getErrorCode() != 0) {
                throw new Exception(response.getErrorMessage() != null ? response.getErrorMessage() : "Invalid response" + (response.getErrorCode() != null ? " code: " + response.getErrorCode() + "!" : "!"));
            }
        }
        catch (Exception e) {
            throw new Exception("Can't confirm firmware upgrade: " + e.toString());
        }
    }
}

