/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import sbgc.service.upgrade.IFirmwareWriter;
import sbgc.service.upgrade.IProgressListener;
import sbgc.service.upgrade.OutReaderAvrdude;
import sbgc.service.upgrade.ProgressListenerImpl;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import sbgc.utils.Settings;

public class FirmwareWriterAvrdudeImpl
implements IFirmwareWriter {
    public static final String AVRDUDE_COMMAND = "{0}/bin/avrdude -C{1}/bin/avrdude.conf -patmega328p -carduino -P{2} -b115200 -D -V -Uflash:w:{3}:i";
    private static final Log logger = new Log(Logger.getLogger((String)FirmwareWriterAvrdudeImpl.class.getName()));
    private final ILogListener logListener;
    private final IProgressListener progressListener;
    private final ResourceMap resourceMap;
    private String lastAvrdudeErrorText = null;

    public FirmwareWriterAvrdudeImpl(ILogListener logListener, IProgressListener progressListener, ResourceMap resourceMap) {
        this.logListener = logListener;
        this.progressListener = progressListener;
        this.resourceMap = resourceMap;
    }

    public void onOutWrite(char c) {
        System.out.println(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutWrite(String message) {
        FirmwareWriterAvrdudeImpl firmwareWriterAvrdudeImpl = this;
        synchronized (firmwareWriterAvrdudeImpl) {
            if (message != null && message.toLowerCase().indexOf("avrdude:") > -1) {
                this.lastAvrdudeErrorText = message;
            }
            logger.trace(message, this.logListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String port, File firmware) throws Exception {
        if (port == null || port.isEmpty()) {
            throw new Exception(this.resourceMap.getString("error.port_is_not_selected", new Object[0]));
        }
        logger.trace("Writing firmware...", this.logListener);
        try {
            Runtime runtime = Runtime.getRuntime();
            String[] args = new String[]{Settings.getWorkingDirectory(), Settings.getWorkingDirectory(), port, firmware.getAbsolutePath()};
            String[] command = AVRDUDE_COMMAND.split("\\s");
            for (int i = 0; i < command.length; ++i) {
                command[i] = MessageFormat.format(command[i], args);
            }
            Process process = runtime.exec(command);
            this.progressListener.onProgressChange(10);
            InputStream stdout = process.getInputStream();
            InputStream stderr = process.getErrorStream();
            try {
                OutReaderAvrdude stdoutReader = new OutReaderAvrdude("stdout", stdout, this, null);
                stdoutReader.start();
                OutReaderAvrdude stderrReader = new OutReaderAvrdude("stderr", stderr, this, new ProgressListenerImpl(10, 80, this.progressListener));
                stderrReader.start();
                int result = process.waitFor();
                logger.trace("Process finished.", this.logListener);
                stdoutReader.join();
                stderrReader.join();
                this.progressListener.onProgressChange(100);
                if (result != 0) {
                    if (this.lastAvrdudeErrorText != null) {
                        throw new Exception("[" + result + "] " + this.lastAvrdudeErrorText);
                    }
                    throw new Exception("Invalid avrdude exit code (" + result + ")!");
                }
            }
            finally {
                stdout.close();
                stderr.close();
            }
        }
        catch (Exception e) {
            throw new Exception("Error writing firmware: " + e.getMessage());
        }
    }
}

