/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import sbgc.service.upgrade.IFirmwareWriter;
import sbgc.service.upgrade.IProgressListener;
import sbgc.service.upgrade.OutReaderDFUUtil;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import sbgc.utils.OSUtil;
import sbgc.utils.Settings;

public class FirmwareWriterDFUUtilImpl
implements IFirmwareWriter,
IProgressListener {
    private static final Log logger = new Log(Logger.getLogger((String)FirmwareWriterDFUUtilImpl.class.getName()));
    public static final String FLASH_TOOL_COMMAND_FLASH = "{0}/bin/{1} -a 0 -s 0x08000000:leave -D {2}";
    public static final int WAIT_TIMEOUT = 20;
    private final ILogListener logListener;
    private final IProgressListener progressListener;
    private ResourceMap resourceMap;
    private String lastErrorText = null;
    private int waitCnt = 0;

    public FirmwareWriterDFUUtilImpl(ILogListener logListener, IProgressListener progressListener, ResourceMap resourceMap) {
        this.logListener = logListener;
        this.progressListener = progressListener;
        this.resourceMap = resourceMap;
    }

    public synchronized void onOutWrite(String message, boolean isError) {
        logger.trace(message, this.logListener);
        if (isError) {
            this.lastErrorText = message;
        }
        this.waitCnt = 0;
    }

    public synchronized boolean onProgressChange(int percent) {
        int value = percent;
        if (value > 100) {
            value = 100;
        }
        if (this.progressListener != null) {
            this.progressListener.onProgressChange(10 + value * 80 / 100);
        }
        this.waitCnt = 0;
        return true;
    }

    public void write(String port, File firmware) throws Exception {
        logger.trace("Writing firmware...", this.logListener);
        try {
            this.exec_cmd(FLASH_TOOL_COMMAND_FLASH, port, firmware);
        }
        catch (Exception e) {
            throw new Exception("Error writing firmware: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec_cmd(String template, String serialPort, File firmware) throws Exception {
        if (!firmware.exists()) {
            throw new Exception(MessageFormat.format("Firmware file \"{0}\" isn't found!", firmware.getAbsolutePath()));
        }
        Runtime runtime = Runtime.getRuntime();
        String tool = OSUtil.isWindows() ? "dfu-util-windows.exe" : (OSUtil.isMacOS() ? "dfu-util-mac" : (OSUtil.isLinux() ? "dfu-util-linux" : "dfu-util"));
        String[] args = new String[]{Settings.getWorkingDirectory(), tool, firmware.getAbsolutePath()};
        String[] command = template.split("\\s");
        for (int i = 0; i < command.length; ++i) {
            command[i] = MessageFormat.format(command[i], args);
        }
        Process process = runtime.exec(command);
        this.progressListener.onProgressChange(10);
        InputStream stdout = process.getInputStream();
        InputStream stderr = process.getErrorStream();
        try {
            OutReaderDFUUtil stdoutReader = new OutReaderDFUUtil(false, stdout, this, this);
            stdoutReader.start();
            OutReaderDFUUtil stderrReader = new OutReaderDFUUtil(true, stderr, this, this);
            stderrReader.start();
            int result = -1;
            this.waitCnt = 0;
            while (true) {
                try {
                    result = process.exitValue();
                }
                catch (Exception ignore) {
                    FirmwareWriterDFUUtilImpl firmwareWriterDFUUtilImpl = this;
                    synchronized (firmwareWriterDFUUtilImpl) {
                        ++this.waitCnt;
                        if (this.waitCnt > 20) {
                            break;
                        }
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
            process.destroy();
            logger.trace("Process finished.", this.logListener);
            stdoutReader.join();
            stderrReader.join();
            this.progressListener.onProgressChange(100);
            if (result != 0) {
                if (this.lastErrorText != null) {
                    throw new Exception("[" + result + "] " + this.lastErrorText);
                }
                if (result == -1) {
                    throw new Exception("Timeout!");
                }
                throw new Exception("Flash tool execution failed (" + result + ")!");
            }
        }
        finally {
            stdout.close();
            stderr.close();
        }
    }
}

