/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import sbgc.service.upgrade.IFirmwareWriter;
import sbgc.service.upgrade.IProgressListener;
import sbgc.service.upgrade.OutReaderSTM32Ld;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import sbgc.utils.OSUtil;
import sbgc.utils.Settings;

public class FirmwareWriterSTM32LdImpl
implements IFirmwareWriter,
IProgressListener {
    private static final Log logger = new Log(Logger.getLogger((String)FirmwareWriterSTM32LdImpl.class.getName()));
    public static final String FLASH_TOOL_COMMAND_FLASH = "{0}/bin/{1} {2} 115200 {3} 1";
    public static final int WAIT_TIMEOUT = 20;
    private final ILogListener logListener;
    private final IProgressListener progressListener;
    private final ResourceMap resourceMap;
    private String lastErrorText = null;
    private int waitCnt = 0;

    public FirmwareWriterSTM32LdImpl(ILogListener logListener, IProgressListener progressListener, ResourceMap resourceMap) {
        this.logListener = logListener;
        this.progressListener = progressListener;
        this.resourceMap = resourceMap;
    }

    public synchronized void onOutWrite(String message, boolean isError) {
        logger.trace(message, this.logListener);
        if (isError) {
            this.lastErrorText = message;
        }
        this.waitCnt = 0;
    }

    public synchronized boolean onProgressChange(int percent) {
        int value = percent;
        if (value > 100) {
            value = 100;
        }
        if (this.progressListener != null) {
            this.progressListener.onProgressChange(10 + value * 80 / 100);
        }
        this.waitCnt = 0;
        return true;
    }

    public void write(String port, File firmware) throws Exception {
        if (port == null || port.isEmpty()) {
            throw new Exception(this.resourceMap.getString("error.port_is_not_selected", new Object[0]));
        }
        logger.trace("Writing firmware...", this.logListener);
        try {
            this.exec_cmd(FLASH_TOOL_COMMAND_FLASH, port, firmware);
        }
        catch (Exception e) {
            throw new Exception("Error writing firmware: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec_cmd(String template, String serialPort, File firmware) throws Exception {
        if (!firmware.exists()) {
            throw new Exception(MessageFormat.format("Firmware file \"{0}\" isn't found!", firmware.getAbsolutePath()));
        }
        Runtime runtime = Runtime.getRuntime();
        String port = serialPort;
        String tool = OSUtil.isWindows() ? "stm32ld_win.exe" : (OSUtil.isMacOS() ? "stm32ld_mac" : (OSUtil.isLinux() ? "stm32ld_linux" : "stm32ld"));
        String[] args = new String[]{Settings.getWorkingDirectory(), tool, port, firmware.getAbsolutePath()};
        String[] command = template.split("\\s");
        for (int i = 0; i < command.length; ++i) {
            command[i] = MessageFormat.format(command[i], args);
        }
        Process process = runtime.exec(command);
        this.progressListener.onProgressChange(10);
        InputStream stdout = process.getInputStream();
        InputStream stderr = process.getErrorStream();
        try {
            OutReaderSTM32Ld stdoutReader = new OutReaderSTM32Ld(false, stdout, this, this);
            stdoutReader.start();
            OutReaderSTM32Ld stderrReader = new OutReaderSTM32Ld(true, stderr, this, null);
            stderrReader.start();
            int result = -1;
            this.waitCnt = 0;
            while (true) {
                try {
                    result = process.exitValue();
                }
                catch (Exception ignore) {
                    FirmwareWriterSTM32LdImpl firmwareWriterSTM32LdImpl = this;
                    synchronized (firmwareWriterSTM32LdImpl) {
                        ++this.waitCnt;
                        if (this.waitCnt > 20) {
                            break;
                        }
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
            process.destroy();
            logger.trace("Process finished.", this.logListener);
            stdoutReader.join();
            stderrReader.join();
            this.progressListener.onProgressChange(100);
            if (result != 0) {
                if (this.lastErrorText != null) {
                    throw new Exception("[" + result + "] " + this.lastErrorText);
                }
                if (result == -1) {
                    throw new Exception("Timeout!");
                }
                throw new Exception("Flash tool execution failed (" + result + ")!");
            }
        }
        finally {
            stdout.close();
            stderr.close();
        }
    }
}

