/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.InputStream;
import org.apache.log4j.Logger;
import sbgc.service.upgrade.FirmwareWriterAvrdudeImpl;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.Log;

class OutReaderAvrdude
implements Runnable {
    public static final String ENCODING_FROM = "Cp1252";
    private String label = null;
    private InputStream in = null;
    private FirmwareWriterAvrdudeImpl firmwareWriter = null;
    private static final Log logger = new Log(Logger.getLogger((String)OutReaderAvrdude.class.getName()));
    private Thread thread = null;
    private IProgressListener progressListener = null;

    public OutReaderAvrdude(String label, InputStream in, FirmwareWriterAvrdudeImpl firmwareWriter, IProgressListener progressListener) {
        this.label = label;
        this.in = in;
        this.firmwareWriter = firmwareWriter;
        this.progressListener = progressListener;
    }

    public void start() {
        this.thread = new Thread((Runnable)this, "Firmware Upgrade (" + this.label + ")");
        this.thread.start();
    }

    public void join() {
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException ie) {
                logger.error("Waiting is interrupted!");
            }
        }
    }

    public void run() {
        int b = -1;
        try {
            byte[] line = new byte[1024];
            int size = 0;
            int progress = 0;
            while ((b = this.in.read()) > -1) {
                if (b == 35) {
                    ++progress;
                    if (this.progressListener != null) {
                        this.progressListener.onProgressChange(progress);
                    }
                }
                if (b == 10 || b == 13) {
                    if (size <= 0) continue;
                    this.firmwareWriter.onOutWrite(new String(line, 0, size, ENCODING_FROM));
                    size = 0;
                    continue;
                }
                if (size == 0) {
                    // empty if block
                }
                if (size >= line.length) continue;
                line[size++] = (byte)b;
            }
            if (size > 0) {
                this.firmwareWriter.onOutWrite(new String(line, 0, size, ENCODING_FROM));
            }
            if (this.progressListener != null) {
                this.progressListener.onProgressChange(100);
            }
            logger.trace("End of reading " + this.label + ": ");
        }
        catch (Exception e) {
            logger.error("Error reading " + this.label + ": " + e.toString());
        }
    }
}

