/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.io.InputStream;
import org.apache.log4j.Logger;
import sbgc.service.upgrade.FirmwareWriterSTMFlashLoaderImpl;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.Log;

class OutReaderSTMFlashLoader
implements Runnable {
    public static final String ENCODING_FROM = "Cp1252";
    private String label = null;
    private InputStream in = null;
    private FirmwareWriterSTMFlashLoaderImpl firmwareWriter = null;
    private static final Log logger = new Log(Logger.getLogger((String)OutReaderSTMFlashLoader.class.getName()));
    private Thread thread = null;
    private IProgressListener progressListener = null;
    private double progressChange = 1.0;

    public OutReaderSTMFlashLoader(String label, InputStream in, FirmwareWriterSTMFlashLoaderImpl firmwareWriter, IProgressListener progressListener, double progressChange) {
        this.label = label;
        this.in = in;
        this.firmwareWriter = firmwareWriter;
        this.progressListener = progressListener;
        this.progressChange = progressChange;
    }

    public void start() {
        this.thread = new Thread((Runnable)this, "Firmware Upgrade (" + this.label + ")");
        this.thread.start();
    }

    public void join() {
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException ie) {
                logger.error("Waiting is interrupted!");
            }
        }
    }

    public void run() {
        int b = -1;
        try {
            byte[] line = new byte[1024];
            int size = 0;
            double progress = 0.0;
            while ((b = this.in.read()) > -1) {
                if (b == 64) {
                    progress += this.progressChange;
                    if (this.progressListener != null && progress < 100.0) {
                        this.progressListener.onProgressChange((int)progress);
                    }
                }
                if (b == 10) {
                    if (size <= 0) continue;
                    this.firmwareWriter.onOutWrite(new String(line, 0, size, ENCODING_FROM));
                    size = 0;
                    continue;
                }
                if (size == 0) {
                    // empty if block
                }
                if (size >= line.length) continue;
                line[size++] = (byte)b;
            }
            if (size > 0) {
                this.firmwareWriter.onOutWrite(new String(line, 0, size, ENCODING_FROM));
            }
            if (this.progressListener != null) {
                this.progressListener.onProgressChange(100);
            }
            logger.trace("End of reading " + this.label + ": ");
        }
        catch (Exception e) {
            logger.error("Error reading " + this.label + ": " + e.toString());
        }
    }
}

