/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import org.apache.log4j.Logger;
import sbgc.service.upgrade.IVersionChecker;
import sbgc.service.upgrade.IVersionCheckerListener;
import sbgc.service.upgrade.VersionCheckerImpl;
import sbgc.utils.Log;

public class VersionCheckerFactory {
    private static final Log logger = new Log(Logger.getLogger((String)VersionCheckerFactory.class.getName()));

    public static IVersionChecker getVersionChecker() {
        VersionCheckerImpl checker = new VersionCheckerImpl();
        return checker;
    }

    public static boolean check(IVersionCheckerListener listener, boolean wait) throws Exception {
        IVersionChecker checker = VersionCheckerFactory.getVersionChecker();
        checker.addListener(listener);
        boolean result = checker.check();
        if (wait) {
            logger.trace("Waiting...");
            checker.await();
        }
        if (checker.hasError()) {
            logger.trace("There were errors while checking!");
            throw new Exception(checker.getError());
        }
        return result;
    }

    public static boolean checkAndWait(IVersionCheckerListener listener) throws Exception {
        return VersionCheckerFactory.check(listener, true);
    }

    public static boolean check(IVersionCheckerListener listener) throws Exception {
        return VersionCheckerFactory.check(listener, false);
    }
}

