/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.apache.log4j.Logger;
import sbgc.common.IFirmwareInfo;
import sbgc.object.BoardInfo;
import sbgc.service.upgrade.FirmwareInfoComparator;
import sbgc.service.upgrade.IVersion;
import sbgc.service.upgrade.IVersionChecker;
import sbgc.service.upgrade.IVersionCheckerListener;
import sbgc.service.upgrade.VersionFactory;
import sbgc.utils.DateUtil;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import sbgc.utils.http.HttpTransportFactory;
import sbgc.utils.http.IHttpTransport;
import sbgc.utils.http.IRequest;
import sbgc.utils.http.IResponse;
import sbgc.utils.http.RequestFactory;

public class VersionCheckerImpl
implements IVersionChecker,
Runnable {
    public static final String FIRMWARE = "firmware";
    public static final String GUI = "gui";
    private static final Log logger = new Log(Logger.getLogger((String)VersionCheckerImpl.class.getName()));
    private ArrayList<IVersionCheckerListener> listeners = new ArrayList();
    private static final Object blocker = new Object();
    private static boolean checking = false;
    private String error = null;
    private Thread checkingThread = null;

    public boolean hasError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }

    public void addListener(IVersionCheckerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check() {
        logger.trace("Version checking...");
        Object object = blocker;
        synchronized (object) {
            if (checking) {
                logger.trace("Version checking is already started.");
                return false;
            }
            logger.trace("Starting thread...");
            try {
                this.checkingThread = new Thread((Runnable)this, "VersionChecker");
                this.checkingThread.start();
            }
            catch (Exception e) {
                checking = false;
            }
            return true;
        }
    }

    public void await() {
        logger.trace("Waiting for thread execution...");
        if (this.checkingThread != null) {
            try {
                this.checkingThread.join();
                logger.trace("Out of waiting.");
            }
            catch (InterruptedException e) {
                logger.warn("Awaiting interrupted: " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block29: {
            Object object = blocker;
            synchronized (object) {
                checking = true;
            }
            try {
                for (IVersionCheckerListener listener : this.listeners) {
                    listener.onStartCheck();
                }
                logger.trace("Starting version checking...");
                IRequest request = RequestFactory.getRequest();
                request.addParameter("act", "sbgc.firmware_info");
                if (BoardInfo.getBoardInfo() == null) {
                    throw new Exception("BoardInfo is null. May be card is disconnected?");
                }
                request.addParameter("board_ver", Integer.toString(BoardInfo.getBoardInfo().getBoardVersion()));
                request.addParameter("firmware_ver", Integer.toString(BoardInfo.getBoardInfo().frwVerOrig));
                request.addParameter("device_id", BoardInfo.getBoardInfo().getDeviceId());
                request.addParameter("lang", Settings.getLocale().getLanguage());
                IHttpTransport transport = HttpTransportFactory.getTransport();
                IResponse response = transport.send(request);
                ArrayList<IFirmwareInfo> firmwares = null;
                String temporarySession = null;
                if (response.getErrorCode() != null && response.getErrorCode() == 0) {
                    temporarySession = response.getResultData().get("session");
                    firmwares = response.getFirmwareInfo();
                    Collections.sort(firmwares, new FirmwareInfoComparator());
                    Settings.set("last.version.check.date", DateUtil.format(new Date(), "yyyy.MM.dd"));
                    Settings.set("temporary_session", temporarySession);
                    if (response.isAllowReg()) {
                        Settings.set("registration.data.sent", "1");
                    } else {
                        Settings.set("registration.data.sent", "0");
                    }
                    if (response.getEmail() != null && Settings.get("registration.data.email") == null) {
                        logger.trace("Email: " + response.getEmail());
                        Settings.set("registration.data.email", response.getEmail());
                    }
                    if (response.getCountry() != null && Settings.get("registration.data.country") == null) {
                        logger.trace("Country: " + response.getCountry());
                        Settings.set("registration.data.country", response.getCountry());
                    }
                } else {
                    throw new Exception(response.getErrorMessage() != null ? response.getErrorMessage() : "Invalid response" + (response.getErrorCode() != null ? " code: " + response.getErrorCode() + "!" : "!"));
                }
                Settings.save();
                logger.debug("Versions: ");
                for (IFirmwareInfo finfo : firmwares) {
                    logger.debug("\t" + finfo.getVersion() + (finfo.getRegDate() != null ? "/" + DateUtil.format(finfo.getRegDate(), "dd.MM.yyyy") : ""));
                }
                if (firmwares.size() <= 0) break block29;
                IVersion latestFirmware = VersionFactory.getVersion(firmwares.get(0).getVersion());
                for (IVersionCheckerListener listener : this.listeners) {
                    listener.onLatestFirmwareVersion(latestFirmware);
                    listener.onVersionsLoaded(firmwares);
                }
            }
            catch (Exception e) {
                logger.error("Error checking version: " + e.toString());
                if (e.getMessage() != null) {
                    this.error = e.getMessage();
                }
                this.error = e.toString();
            }
            finally {
                Object e = blocker;
                synchronized (e) {
                    checking = false;
                }
                for (IVersionCheckerListener listener : this.listeners) {
                    listener.onEndCheck();
                }
            }
        }
    }
}

