/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import sbgc.service.upgrade.IVersion;

public class VersionImpl
implements IVersion {
    public static final int BETA_STABLE = 9;
    private Integer version = null;
    private int major = 0;
    private int minor = 0;
    private int beta = 0;

    public VersionImpl(int ver) {
        this.version = ver;
        this.major = ver / 1000;
        this.minor = ver % 1000 / 10;
        this.beta = ver % 10;
    }

    public int getMajorVer() {
        return this.major;
    }

    public int getMinorVer() {
        return this.minor;
    }

    public Integer getFullVer() {
        return this.version;
    }

    public int getComparableVersion() {
        return this.version != null ? this.version : 0;
    }

    public int compareTo(IVersion version) {
        if (this.getComparableVersion() > version.getComparableVersion()) {
            return 1;
        }
        if (this.getComparableVersion() < version.getComparableVersion()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.version != null) {
            buffer.append(this.major + "." + String.format("%02d", this.minor));
            if (this.beta != 9) {
                buffer.append(" b" + this.beta);
            }
        }
        return buffer.toString();
    }
}

