/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class ExpoCurvePanel
extends JPanel {
    private static final Color backgroundColor = new Color(85, 85, 85);
    private static final Color strokeColor = new Color(0, 153, 204);
    private static final int strokeWidth = 2;
    private static final Color labelColor = new Color(255, 255, 255, 150);
    private static final Font labelFont = new Font("Arial", 1, 10);
    private int max_val = 0;
    private int deadband = 0;
    private int[] lookup;

    public ExpoCurvePanel(int lookup_size, int max_val) {
        this.lookup = new int[lookup_size];
        this.max_val = max_val / this.lookup.length * this.lookup.length;
        this.setRate(0);
        this.setVisible(true);
    }

    public ExpoCurvePanel() {
        this(10, 500);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x0 = this.getInsets().left;
        int y0 = this.getInsets().top;
        int width = this.getWidth() - this.getInsets().left - this.getInsets().right - 1;
        int height = this.getHeight() - this.getInsets().top - this.getInsets().bottom - 1;
        g2d.setPaint(backgroundColor);
        g2d.fillRect(x0, y0, width, height);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(strokeColor);
        int py_prev = y0 + height;
        for (int px = 0; px < width; ++px) {
            int x = px * this.max_val / width;
            int y = x < this.deadband ? 0 : this.calculate(x - this.deadband);
            int py = y0 + height - y * height / this.max_val;
            g2d.drawLine(x0 + px, py_prev, x0 + px + 1, py);
            py_prev = py;
        }
    }

    public static int constrain(int val, int min, int max) {
        return val < min ? min : (val > max ? max : val);
    }

    public void setRate(int rate) {
        rate = ExpoCurvePanel.constrain(rate, 0, 100);
        for (int i = 0; i < this.lookup.length; ++i) {
            this.lookup[i] = (i * i * rate + (100 - rate) * (this.lookup.length * this.lookup.length)) * i * this.max_val / (100 * this.lookup.length * this.lookup.length * this.lookup.length);
        }
        this.repaint();
    }

    public void setDeadband(int deadband) {
        this.deadband = deadband;
        this.repaint();
    }

    public int calculate(int x) {
        int res;
        int step = this.max_val / this.lookup.length;
        int ax = Math.abs(x);
        int ind = ax / step;
        if (ind >= this.lookup.length - 1) {
            int last_ind = this.lookup.length - 1;
            res = this.lookup[last_ind] + (this.max_val - this.lookup[last_ind]) * (ax - step * last_ind) / step;
        } else {
            res = this.lookup[ind] + (this.lookup[ind + 1] - this.lookup[ind]) * (ax % step) / step;
        }
        return x < 0 ? -res : res;
    }
}

