/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.AdjVarAnalogCfg;
import sbgc.object.AdjVarTriggerCfg;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.Sprav;
import sbgc.ui.ParamsUIFactory;
import sbgc.ui.RCDataPanel;
import sbgc.ui.SpravComboBoxModel;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class JPanelAdjVars
extends JPanel {
    SimpleBGC_GUIView mainView = null;
    private static ResourceMap resourceMap;
    private static ResourceMap appResourceMap;
    private RCDataPanel triggerSignalPanel;
    private RCDataPanel analogSignalPanel;
    private JComboBox[] comboBoxTriggerAction = null;
    private AdjVarTriggerCfg[] adj_vars_trigger = null;
    private AdjVarAnalogCfg[] adj_vars_analog = null;
    public int trigger_cur_slot = 0;
    public int analog_cur_slot = 0;
    private boolean updateControlsMode = false;
    private JComboBox jComboBoxAnalogAdjVar;
    private JComboBox jComboBoxAnalogEditSlot;
    private JComboBox jComboBoxAnalogSrc;
    private JComboBox jComboBoxTriggerAct1;
    private JComboBox jComboBoxTriggerAct2;
    private JComboBox jComboBoxTriggerAct3;
    private JComboBox jComboBoxTriggerAct4;
    private JComboBox jComboBoxTriggerAct5;
    private JComboBox jComboBoxTriggerEditSlot;
    private JComboBox jComboBoxTriggerSrc;
    private JLabel jLabelActiveAction;
    private JLabel jLabelAdjVarMax;
    private JLabel jLabelAdjVarMin;
    private JLabel jLabelAnalogChannelEdit;
    private JLabel jLabelAnalogCurVal;
    private JLabel jLabelAnalogCurValueLabel;
    private JLabel jLabelAnalogSource;
    private JLabel jLabelAnalogVariable;
    private JLabel jLabelTriggerActions;
    private JLabel jLabelTriggerActiveAction;
    private JLabel jLabelTriggerChannelEdit;
    private JLabel jLabelTriggerSource;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanelAnalogSignal;
    private JPanel jPanelTriggerSignal;
    private JSlider jSliderAdjVarMax;
    private JSlider jSliderAdjVarMin;

    public JPanelAdjVars(SimpleBGC_GUIView mainView) {
        this.mainView = mainView;
        appResourceMap = SimpleBGC_GUIApp.getResourceMap();
        resourceMap = SimpleBGC_GUIApp.getResourceMap(JPanelAdjVars.class);
        this.initComponents();
        this.triggerSignalPanel = new RCDataPanel(null);
        this.triggerSignalPanel.setMin(-500.0f);
        this.triggerSignalPanel.setMax(500.0f);
        for (int i = -300; i < 500; i += 200) {
            this.triggerSignalPanel.addMarker(i);
        }
        this.jPanelTriggerSignal.add(this.triggerSignalPanel);
        this.analogSignalPanel = new RCDataPanel(null);
        this.analogSignalPanel.setMin(-500.0f);
        this.analogSignalPanel.setMax(500.0f);
        this.jPanelAnalogSignal.add(this.analogSignalPanel);
        this.comboBoxTriggerAction = new JComboBox[]{this.jComboBoxTriggerAct1, this.jComboBoxTriggerAct2, this.jComboBoxTriggerAct3, this.jComboBoxTriggerAct4, this.jComboBoxTriggerAct5};
        this.updateControls();
        this.updateBoardVerUI(null);
    }

    private void initComponents() {
        this.jPanel6 = new JPanel();
        this.jLabelTriggerActions = new JLabel();
        this.jComboBoxTriggerSrc = new JComboBox();
        this.jLabelTriggerSource = new JLabel();
        this.jComboBoxTriggerAct1 = new JComboBox();
        this.jComboBoxTriggerAct2 = new JComboBox();
        this.jComboBoxTriggerAct3 = new JComboBox();
        this.jComboBoxTriggerAct4 = new JComboBox();
        this.jComboBoxTriggerAct5 = new JComboBox();
        this.jLabelTriggerChannelEdit = new JLabel();
        this.jComboBoxTriggerEditSlot = new JComboBox();
        this.jPanelTriggerSignal = new JPanel();
        this.jLabelActiveAction = new JLabel();
        this.jLabelTriggerActiveAction = new JLabel();
        this.jPanel7 = new JPanel();
        this.jComboBoxAnalogSrc = new JComboBox();
        this.jLabelAnalogSource = new JLabel();
        this.jLabelAnalogChannelEdit = new JLabel();
        this.jComboBoxAnalogEditSlot = new JComboBox();
        this.jLabelAnalogVariable = new JLabel();
        this.jComboBoxAnalogAdjVar = new JComboBox();
        this.jLabelAdjVarMin = new JLabel();
        this.jSliderAdjVarMin = new JSlider();
        this.jLabelAdjVarMax = new JLabel();
        this.jSliderAdjVarMax = new JSlider();
        this.jPanelAnalogSignal = new JPanel();
        this.jLabelAnalogCurValueLabel = new JLabel();
        this.jLabelAnalogCurVal = new JLabel();
        this.setName("Form");
        this.setLayout((LayoutManager)new AbsoluteLayout());
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(JPanelAdjVars.class);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel6.border.title", new Object[0])));
        this.jPanel6.setName("jPanel6");
        this.jPanel6.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelTriggerActions.setText(resourceMap.getString("jLabelTriggerActions.text", new Object[0]));
        this.jLabelTriggerActions.setName("jLabelTriggerActions");
        this.jPanel6.add((Component)this.jLabelTriggerActions, new AbsoluteConstraints(400, 20, -1, -1));
        this.jComboBoxTriggerSrc.setName("jComboBoxTriggerSrc");
        this.jPanel6.add((Component)this.jComboBoxTriggerSrc, new AbsoluteConstraints(180, 40, 200, -1));
        this.jLabelTriggerSource.setText(resourceMap.getString("jLabelTriggerSource.text", new Object[0]));
        this.jLabelTriggerSource.setName("jLabelTriggerSource");
        this.jPanel6.add((Component)this.jLabelTriggerSource, new AbsoluteConstraints(180, 20, -1, -1));
        this.jComboBoxTriggerAct1.setName("jComboBoxTriggerAct1");
        this.jPanel6.add((Component)this.jComboBoxTriggerAct1, new AbsoluteConstraints(400, 40, 300, -1));
        this.jComboBoxTriggerAct2.setName("jComboBoxTriggerAct2");
        this.jPanel6.add((Component)this.jComboBoxTriggerAct2, new AbsoluteConstraints(400, 65, 300, -1));
        this.jComboBoxTriggerAct3.setName("jComboBoxTriggerAct3");
        this.jPanel6.add((Component)this.jComboBoxTriggerAct3, new AbsoluteConstraints(400, 90, 300, -1));
        this.jComboBoxTriggerAct4.setName("jComboBoxTriggerAct4");
        this.jPanel6.add((Component)this.jComboBoxTriggerAct4, new AbsoluteConstraints(400, 115, 300, -1));
        this.jComboBoxTriggerAct5.setName("jComboBoxTriggerAct5");
        this.jPanel6.add((Component)this.jComboBoxTriggerAct5, new AbsoluteConstraints(400, 140, 300, -1));
        this.jLabelTriggerChannelEdit.setText(resourceMap.getString("jLabelTriggerChannelEdit.text", new Object[0]));
        this.jLabelTriggerChannelEdit.setName("jLabelTriggerChannelEdit");
        this.jPanel6.add((Component)this.jLabelTriggerChannelEdit, new AbsoluteConstraints(20, 20, -1, -1));
        this.jComboBoxTriggerEditSlot.setName("jComboBoxTriggerEditSlot");
        this.jComboBoxTriggerEditSlot.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JPanelAdjVars.this.jComboBoxTriggerEditSlotItemStateChanged(evt);
            }
        });
        this.jPanel6.add((Component)this.jComboBoxTriggerEditSlot, new AbsoluteConstraints(20, 40, 140, -1));
        this.jPanelTriggerSignal.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanelTriggerSignal.setToolTipText(resourceMap.getString("jPanelTriggerSignal.toolTipText", new Object[0]));
        this.jPanelTriggerSignal.setName("jPanelTriggerSignal");
        this.jPanelTriggerSignal.setLayout(new BoxLayout(this.jPanelTriggerSignal, 2));
        this.jPanel6.add((Component)this.jPanelTriggerSignal, new AbsoluteConstraints(20, 80, 360, 20));
        this.jLabelActiveAction.setText(resourceMap.getString("jLabelActiveAction.text", new Object[0]));
        this.jLabelActiveAction.setName("jLabelActiveAction");
        this.jPanel6.add((Component)this.jLabelActiveAction, new AbsoluteConstraints(20, 110, 120, -1));
        this.jLabelTriggerActiveAction.setFont(resourceMap.getFont("jLabelTriggerActiveAction.font"));
        this.jLabelTriggerActiveAction.setText(resourceMap.getString("jLabelTriggerActiveAction.text", new Object[0]));
        this.jLabelTriggerActiveAction.setName("jLabelTriggerActiveAction");
        this.jPanel6.add((Component)this.jLabelTriggerActiveAction, new AbsoluteConstraints(150, 110, 230, -1));
        this.add((Component)this.jPanel6, new AbsoluteConstraints(10, 10, 720, 180));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel7.border.title", new Object[0])));
        this.jPanel7.setName("jPanel7");
        this.jPanel7.setLayout((LayoutManager)new AbsoluteLayout());
        this.jComboBoxAnalogSrc.setName("jComboBoxAnalogSrc");
        this.jPanel7.add((Component)this.jComboBoxAnalogSrc, new AbsoluteConstraints(180, 50, 200, -1));
        this.jLabelAnalogSource.setText(resourceMap.getString("jLabelTriggerSource.text", new Object[0]));
        this.jLabelAnalogSource.setName("jLabelAnalogSource");
        this.jPanel7.add((Component)this.jLabelAnalogSource, new AbsoluteConstraints(180, 30, -1, -1));
        this.jLabelAnalogChannelEdit.setText(resourceMap.getString("jLabelTriggerChannelEdit.text", new Object[0]));
        this.jLabelAnalogChannelEdit.setName("jLabelAnalogChannelEdit");
        this.jPanel7.add((Component)this.jLabelAnalogChannelEdit, new AbsoluteConstraints(20, 30, -1, -1));
        this.jComboBoxAnalogEditSlot.setName("jComboBoxAnalogEditSlot");
        this.jComboBoxAnalogEditSlot.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JPanelAdjVars.this.jComboBoxAnalogEditSlotItemStateChanged(evt);
            }
        });
        this.jPanel7.add((Component)this.jComboBoxAnalogEditSlot, new AbsoluteConstraints(20, 50, 140, -1));
        this.jLabelAnalogVariable.setText(resourceMap.getString("jLabelAnalogVariable.text", new Object[0]));
        this.jLabelAnalogVariable.setName("jLabelAnalogVariable");
        this.jPanel7.add((Component)this.jLabelAnalogVariable, new AbsoluteConstraints(400, 30, -1, -1));
        this.jComboBoxAnalogAdjVar.setName("jComboBoxAnalogAdjVar");
        this.jPanel7.add((Component)this.jComboBoxAnalogAdjVar, new AbsoluteConstraints(400, 50, 300, -1));
        this.jLabelAdjVarMin.setText(resourceMap.getString("jLabelAdjVarMin.text", new Object[0]));
        this.jLabelAdjVarMin.setName("jLabelAdjVarMin");
        this.jPanel7.add((Component)this.jLabelAdjVarMin, new AbsoluteConstraints(400, 80, -1, -1));
        this.jSliderAdjVarMin.setForeground(resourceMap.getColor("jSliderAdjVarMin.foreground"));
        this.jSliderAdjVarMin.setMajorTickSpacing(25);
        this.jSliderAdjVarMin.setMaximum(250);
        this.jSliderAdjVarMin.setMinorTickSpacing(5);
        this.jSliderAdjVarMin.setPaintTicks(true);
        this.jSliderAdjVarMin.setValue(0);
        this.jSliderAdjVarMin.setName("jSliderAdjVarMin");
        this.jSliderAdjVarMin.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JPanelAdjVars.this.jSliderAdjVarMinStateChanged(evt);
            }
        });
        this.jPanel7.add((Component)this.jSliderAdjVarMin, new AbsoluteConstraints(430, 80, 270, -1));
        this.jLabelAdjVarMax.setText(resourceMap.getString("jLabelAdjVarMax.text", new Object[0]));
        this.jLabelAdjVarMax.setName("jLabelAdjVarMax");
        this.jPanel7.add((Component)this.jLabelAdjVarMax, new AbsoluteConstraints(400, 110, -1, -1));
        this.jSliderAdjVarMax.setForeground(resourceMap.getColor("jSliderAdjVarMax.foreground"));
        this.jSliderAdjVarMax.setMaximum(250);
        this.jSliderAdjVarMax.setName("jSliderAdjVarMax");
        this.jSliderAdjVarMax.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JPanelAdjVars.this.jSliderAdjVarMaxStateChanged(evt);
            }
        });
        this.jPanel7.add((Component)this.jSliderAdjVarMax, new AbsoluteConstraints(430, 110, 270, -1));
        this.jPanelAnalogSignal.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanelAnalogSignal.setToolTipText(resourceMap.getString("jPanelAnalogSignal.toolTipText", new Object[0]));
        this.jPanelAnalogSignal.setName("jPanelAnalogSignal");
        this.jPanelAnalogSignal.setLayout(new BoxLayout(this.jPanelAnalogSignal, 2));
        this.jPanel7.add((Component)this.jPanelAnalogSignal, new AbsoluteConstraints(20, 90, 360, 20));
        this.jLabelAnalogCurValueLabel.setText(resourceMap.getString("jLabelAnalogCurValueLabel.text", new Object[0]));
        this.jLabelAnalogCurValueLabel.setName("jLabelAnalogCurValueLabel");
        this.jPanel7.add((Component)this.jLabelAnalogCurValueLabel, new AbsoluteConstraints(20, 120, 120, -1));
        this.jLabelAnalogCurVal.setFont(resourceMap.getFont("jLabelAnalogCurVal.font"));
        this.jLabelAnalogCurVal.setText(resourceMap.getString("jLabelAnalogCurVal.text", new Object[0]));
        this.jLabelAnalogCurVal.setName("jLabelAnalogCurVal");
        this.jPanel7.add((Component)this.jLabelAnalogCurVal, new AbsoluteConstraints(150, 120, 110, -1));
        this.add((Component)this.jPanel7, new AbsoluteConstraints(10, 190, 720, 150));
    }

    private void jSliderAdjVarMinStateChanged(ChangeEvent evt) {
    }

    private void jSliderAdjVarMaxStateChanged(ChangeEvent evt) {
    }

    private void jComboBoxTriggerEditSlotItemStateChanged(ItemEvent evt) {
        if (!this.updateControlsMode) {
            this.applyControls();
            this.trigger_cur_slot = this.jComboBoxTriggerEditSlot.getSelectedIndex();
            this.updateControls();
        }
    }

    private void jComboBoxAnalogEditSlotItemStateChanged(ItemEvent evt) {
        if (!this.updateControlsMode) {
            this.applyControls();
            this.analog_cur_slot = this.jComboBoxAnalogEditSlot.getSelectedIndex();
            this.updateControls();
        }
    }

    public void updateBoardVerUI(BoardInfo info) {
        int boardVer = 0;
        if (info != null) {
            boardVer = info.boardVer;
        }
        this.jComboBoxAnalogSrc.setModel(new SpravComboBoxModel(ParamsUIFactory.getRCMapList(info)));
        this.jComboBoxTriggerSrc.setModel(new SpravComboBoxModel(ParamsUIFactory.getRCMapList(info)));
        for (int i = 0; i < this.comboBoxTriggerAction.length; ++i) {
            this.comboBoxTriggerAction[i].setModel(new SpravComboBoxModel(ParamsUIFactory.getCmdList(boardVer)));
        }
        this.jComboBoxAnalogAdjVar.setModel(new SpravComboBoxModel(ParamsUIFactory.getAdjVarsList(info)));
    }

    public void updateBoardParams() {
        BoardParams params = BoardParams.getCurParams();
        try {
            this.adj_vars_trigger = AdjVarTriggerCfg.copyOf(params.adj_vars_trigger);
            this.adj_vars_analog = AdjVarAnalogCfg.copyOf(params.adj_vars_analog);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateControls();
    }

    public void updateControls() {
        DefaultComboBoxModel<String> m;
        int i;
        Cloneable var;
        this.updateControlsMode = true;
        if (this.adj_vars_trigger != null) {
            if (this.trigger_cur_slot >= 0 && this.trigger_cur_slot < this.adj_vars_trigger.length) {
                var = this.adj_vars_trigger[this.trigger_cur_slot];
                ((SpravComboBoxModel)this.jComboBoxTriggerSrc.getModel()).setCurrent(var.src_ch);
                for (i = 0; i < var.action.length && i < this.comboBoxTriggerAction.length; ++i) {
                    ((SpravComboBoxModel)this.comboBoxTriggerAction[i].getModel()).setCurrent(var.action[i]);
                }
            }
            m = new DefaultComboBoxModel<String>();
            for (i = 0; i < this.adj_vars_trigger.length; ++i) {
                m.addElement(resourceMap.getString("comboBox.slotToEdit", new Object[0]) + " " + (i + 1) + (this.adj_vars_trigger[i].src_ch != 0 ? " #" : ""));
            }
            this.jComboBoxTriggerEditSlot.setModel(m);
            this.jComboBoxTriggerEditSlot.setSelectedIndex(this.trigger_cur_slot);
        }
        if (this.adj_vars_analog != null) {
            if (this.analog_cur_slot >= 0 && this.analog_cur_slot < this.adj_vars_analog.length) {
                var = this.adj_vars_analog[this.analog_cur_slot];
                ((SpravComboBoxModel)this.jComboBoxAnalogSrc.getModel()).setCurrent(((AdjVarAnalogCfg)var).src_ch);
                ((SpravComboBoxModel)this.jComboBoxAnalogAdjVar.getModel()).setCurrent(((AdjVarAnalogCfg)var).var_id);
                this.jSliderAdjVarMin.setValue(((AdjVarAnalogCfg)var).min_val);
                this.jSliderAdjVarMax.setValue(((AdjVarAnalogCfg)var).max_val);
            }
            m = new DefaultComboBoxModel();
            for (i = 0; i < this.adj_vars_analog.length; ++i) {
                m.addElement(resourceMap.getString("comboBox.slotToEdit", new Object[0]) + " " + (i + 1) + (this.adj_vars_analog[i].src_ch != 0 ? " #" : ""));
            }
            this.jComboBoxAnalogEditSlot.setModel(m);
            this.jComboBoxAnalogEditSlot.setSelectedIndex(this.analog_cur_slot);
        }
        this.updateControlsMode = false;
    }

    public void applyBoardParams(BoardParams params) {
        this.applyControls();
        try {
            params.adj_vars_trigger = AdjVarTriggerCfg.copyOf(this.adj_vars_trigger);
            params.adj_vars_analog = AdjVarAnalogCfg.copyOf(this.adj_vars_analog);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void applyControls() {
        Cloneable var;
        if (this.adj_vars_trigger != null && this.trigger_cur_slot >= 0 && this.trigger_cur_slot < this.adj_vars_trigger.length) {
            var = this.adj_vars_trigger[this.trigger_cur_slot];
            var.src_ch = ((SpravComboBoxModel)this.jComboBoxTriggerSrc.getModel()).getCurrentId();
            for (int i = 0; i < var.action.length && i < this.comboBoxTriggerAction.length; ++i) {
                var.action[i] = ((SpravComboBoxModel)this.comboBoxTriggerAction[i].getModel()).getCurrentId();
            }
        }
        if (this.adj_vars_analog != null && this.analog_cur_slot >= 0 && this.analog_cur_slot < this.adj_vars_analog.length) {
            var = this.adj_vars_analog[this.analog_cur_slot];
            ((AdjVarAnalogCfg)var).src_ch = ((SpravComboBoxModel)this.jComboBoxAnalogSrc.getModel()).getCurrentId();
            ((AdjVarAnalogCfg)var).var_id = ((SpravComboBoxModel)this.jComboBoxAnalogAdjVar.getModel()).getCurrentId();
            ((AdjVarAnalogCfg)var).min_val = this.jSliderAdjVarMin.getValue();
            ((AdjVarAnalogCfg)var).max_val = this.jSliderAdjVarMax.getValue();
        }
    }

    public void updateRealtimeState(int triggerSignal, int triggerAction, int analogSignal, long analogVal) {
        this.triggerSignalPanel.setData(triggerSignal > -8500 ? Integer.valueOf(triggerSignal) : null);
        this.analogSignalPanel.setData(analogSignal > -8500 ? Integer.valueOf(analogSignal) : null);
        this.jLabelAnalogCurVal.setText(Long.toString(analogVal));
        if (triggerAction < this.comboBoxTriggerAction[0].getItemCount()) {
            Sprav item = ((SpravComboBoxModel)this.comboBoxTriggerAction[0].getModel()).findElement(triggerAction);
            this.jLabelTriggerActiveAction.setText(item != null ? item.getName() : "--");
        }
    }
}

