/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.util.ArrayList;
import org.jdesktop.application.ResourceMap;
import sbgc.object.BatInfo;
import sbgc.object.BoardInfo;
import sbgc.object.Sprav;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamsUIFactory {
    public static final int BOARD_VER_3 = 30;

    public static ArrayList<Sprav> getCmdList(int boardVer) {
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, r.getString("cmd.no_action", new Object[0])));
        list.add(new Sprav(1, r.getString("cmd.use_profile", SimpleBGC_GUIView.getProfileName(0))));
        list.add(new Sprav(2, r.getString("cmd.use_profile", SimpleBGC_GUIView.getProfileName(1))));
        list.add(new Sprav(3, r.getString("cmd.use_profile", SimpleBGC_GUIView.getProfileName(2))));
        if (boardVer >= 30) {
            list.add(new Sprav(14, r.getString("cmd.use_profile", SimpleBGC_GUIView.getProfileName(3))));
            list.add(new Sprav(15, r.getString("cmd.use_profile", SimpleBGC_GUIView.getProfileName(4))));
        }
        list.add(new Sprav(6, r.getString("cmd.calibrate_acc", new Object[0])));
        list.add(new Sprav(9, r.getString("cmd.calibrate_gyro", new Object[0])));
        list.add(new Sprav(4, r.getString("cmd.swap_roll_pitch", new Object[0])));
        list.add(new Sprav(5, r.getString("cmd.swap_yaw_roll", new Object[0])));
        list.add(new Sprav(8, r.getString("cmd.set_tilt_by_hands", new Object[0])));
        list.add(new Sprav(7, r.getString("cmd.reset", new Object[0])));
        list.add(new Sprav(10, r.getString("cmd.motor_toggle", new Object[0])));
        list.add(new Sprav(11, r.getString("cmd.motor_on", new Object[0])));
        list.add(new Sprav(12, r.getString("cmd.motor_off", new Object[0])));
        list.add(new Sprav(13, r.getString("cmd.frame_upside_down", new Object[0])));
        list.add(new Sprav(16, r.getString("cmd.auto_pid", new Object[0])));
        list.add(new Sprav(17, r.getString("cmd.look_down", new Object[0])));
        list.add(new Sprav(18, r.getString("cmd.home_position", new Object[0])));
        list.add(new Sprav(19, r.getString("cmd.rc_bind", new Object[0])));
        return list;
    }

    public static ArrayList<Sprav> getRCMapList(BoardInfo info) {
        int i;
        int boardVer = 0;
        int firmwareVer = 0;
        if (info != null) {
            boardVer = info.getBoardVersion();
            firmwareVer = info.getFirmwareVersion();
        }
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, r.getString("option.noInput", new Object[0])));
        if (boardVer >= 30) {
            list.add(new Sprav(1, "RC_ROLL - PWM"));
            list.add(new Sprav(2, "RC_PITCH - PWM"));
            list.add(new Sprav(5, "RC_YAW - PWM"));
            list.add(new Sprav(3, "FC_ROLL - PWM"));
            list.add(new Sprav(4, "FC_PITCH - PWM"));
            list.add(new Sprav(33, "ADC1 - analog"));
            list.add(new Sprav(34, "ADC2 - analog"));
            list.add(new Sprav(35, "ADC3 - analog"));
        } else {
            list.add(new Sprav(1, "RC_ROLL - PWM"));
            list.add(new Sprav(2, "RC_PITCH - PWM"));
            list.add(new Sprav(3, "EXT_ROLL - PWM"));
            list.add(new Sprav(4, "EXT_PITCH - PWM"));
            list.add(new Sprav(33, "RC_ROLL - analog"));
            list.add(new Sprav(34, "RC_PITCH - analog"));
            list.add(new Sprav(35, "EXT_ROLL - analog"));
            list.add(new Sprav(36, "EXT_PITCH - analog"));
        }
        int maxChannels = 8;
        if (boardVer >= 30) {
            maxChannels = 32;
        }
        for (i = 1; i <= maxChannels; ++i) {
            list.add(new Sprav(0x40 | i, "RC_VIRT_CH_" + i));
        }
        if (boardVer >= 30 && firmwareVer >= 2430) {
            for (i = 1; i <= 32; ++i) {
                list.add(new Sprav(0x80 | i, "API_VIRT_CH_" + i));
            }
        }
        return list;
    }

    public static ArrayList<Sprav> getRCVirtModeList(int boardVer) {
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "Normal (PWM or Analog)"));
        list.add(new Sprav(1, "Sum-PPM"));
        if (boardVer >= 30) {
            list.add(new Sprav(2, "Futaba s-bus"));
            list.add(new Sprav(3, "Spektrum"));
        }
        return list;
    }

    public static String[] getOutputList(int boardVer) {
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        return new String[]{r.getString("option.disabled", new Object[0]), "ROLL " + r.getString("option.out", new Object[0]), "PITCH " + r.getString("option.out", new Object[0]), "YAW " + (boardVer >= 30 ? r.getString("option.out", new Object[0]) : r.getString("option.extBoard", new Object[0]))};
    }

    public static ArrayList<BatInfo> getBatInfoList() {
        ArrayList<BatInfo> list = new ArrayList<BatInfo>();
        list.add(new BatInfo(1, 2));
        list.add(new BatInfo(1, 3));
        list.add(new BatInfo(1, 4));
        list.add(new BatInfo(2, 2));
        list.add(new BatInfo(2, 3));
        list.add(new BatInfo(2, 4));
        list.add(new BatInfo(2, 5));
        return list;
    }

    public static ArrayList<Sprav> getRCOutList(int boardVer) {
        ResourceMap r = SimpleBGC_GUIApp.getResourceMap();
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, r.getString("option.disabled", new Object[0])));
        if (boardVer >= 30) {
            for (int i = 1; i <= 32; ++i) {
                list.add(new Sprav(i, "VIRT_CH_" + i));
            }
        }
        return list;
    }

    public static ArrayList<Sprav> getAdjVarsList(BoardInfo info) {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        list.add(new Sprav(0, "P_ROLL"));
        list.add(new Sprav(1, "P_PITCH"));
        list.add(new Sprav(2, "P_YAW"));
        list.add(new Sprav(3, "I_ROLL"));
        list.add(new Sprav(4, "I_PITCH"));
        list.add(new Sprav(5, "I_YAW"));
        list.add(new Sprav(6, "D_ROLL"));
        list.add(new Sprav(7, "D_PITCH"));
        list.add(new Sprav(8, "D_YAW"));
        list.add(new Sprav(9, "POWER_ROLL"));
        list.add(new Sprav(10, "POWER_PITCH"));
        list.add(new Sprav(11, "POWER_YAW"));
        list.add(new Sprav(12, "ACC_LIMITER"));
        list.add(new Sprav(13, "FOLLOW_SPEED_ROLL"));
        list.add(new Sprav(14, "FOLLOW_SPEED_PITCH"));
        list.add(new Sprav(15, "FOLLOW_SPEED_YAW"));
        list.add(new Sprav(16, "FOLLOW_LPF_ROLL"));
        list.add(new Sprav(17, "FOLLOW_LPF_PITCH"));
        list.add(new Sprav(18, "FOLLOW_LPF_YAW"));
        list.add(new Sprav(19, "RC_SPEED_ROLL"));
        list.add(new Sprav(20, "RC_SPEED_PITCH"));
        list.add(new Sprav(21, "RC_SPEED_YAW"));
        list.add(new Sprav(22, "RC_LPF_ROLL"));
        list.add(new Sprav(23, "RC_LPF_PITCH"));
        list.add(new Sprav(24, "RC_LPF_YAW"));
        list.add(new Sprav(25, "RC_TRIM_ROLL"));
        list.add(new Sprav(26, "RC_TRIM_PITCH"));
        list.add(new Sprav(27, "RC_TRIM_YAW"));
        list.add(new Sprav(28, "RC_DEADBAND"));
        list.add(new Sprav(29, "RC_EXPO_RATE"));
        list.add(new Sprav(30, "FOLLOW_MODE"));
        list.add(new Sprav(31, "RC_FOLLOW_YAW"));
        list.add(new Sprav(32, "FOLLOW_DEADBAND"));
        list.add(new Sprav(33, "FOLLOW_EXPO_RATE"));
        list.add(new Sprav(34, "FOLLOW_ROLL_MIX_START"));
        list.add(new Sprav(35, "FOLLOW_ROLL_MIX_RANGE"));
        list.add(new Sprav(36, "GYRO_TRUST"));
        return list;
    }
}

