/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import sbgc.ui.chart.JRealTrace;

public class JRealChart
extends JPanel {
    private Image buf1;
    private Image buf2;
    private Image curBuf;
    private Image prevBuf;
    private int shiftStep = 3;
    private JRealTrace highlight = null;
    private int centerY;
    private float zoomY = 0.1f;
    private int width;
    private int height;
    private int gridStepX = 50;
    private int gridStepY = 100;
    private Color gridColor = null;
    private Stroke gridStroke = null;
    private Color backgroundColor = null;
    private int lastGridX = 0;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(255, 255, 255);
    public static final Color DEFAULT_GRID_COLOR = new Color(204, 204, 204);
    public static final Stroke DEFAULT_GRID_STROKE = new BasicStroke(1.0f);
    public ArrayList<JRealTrace> traces;

    public JRealChart() {
        this.setVisible(true);
        this.backgroundColor = DEFAULT_BACKGROUND_COLOR;
        this.gridColor = DEFAULT_GRID_COLOR;
        this.gridStroke = DEFAULT_GRID_STROKE;
        this.traces = new ArrayList();
    }

    public void addTrace(JRealTrace trace) {
        trace.id = this.traces.size();
        this.traces.add(trace);
    }

    private int gridStepRound(float gridStep) {
        int step;
        int scale = 1;
        do {
            step = (int)(gridStep * (float)scale);
            scale += 10;
        } while (step < 10);
        return step;
    }

    private void drawGrid(Graphics2D bufG, int offset) {
        bufG.setColor(this.backgroundColor);
        bufG.fillRect(0, 0, this.width, this.height);
        bufG.setColor(this.gridColor);
        bufG.setStroke(this.gridStroke);
        int step = this.gridStepRound((float)this.gridStepY * this.zoomY);
        int y1 = this.centerY;
        for (int y2 = this.centerY + 1; y1 < this.height && y2 > 0; y1 += step, y2 -= step) {
            bufG.drawLine(0, y1, this.width - 1, y1);
            bufG.drawLine(0, y2, this.width - 1, y2);
        }
        for (int x = this.width - 1 - offset; x > 0; x -= this.gridStepX) {
            bufG.drawLine(x, 0, x, this.height - 1);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.curBuf == null) {
            this.buf1 = this.createImage(this.getWidth(), this.getHeight());
            Graphics2D bufG = (Graphics2D)this.buf1.getGraphics();
            bufG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.width = this.buf1.getWidth(this);
            this.height = this.buf1.getHeight(this);
            this.centerY = this.height / 2;
            this.curBuf = this.buf2 = this.createImage(this.getWidth(), this.getHeight());
            bufG = (Graphics2D)this.buf2.getGraphics();
            bufG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.drawGrid(bufG, 0);
        }
        g.drawImage(this.curBuf, 0, 0, this);
    }

    public void update() {
        if (this.curBuf == null || !this.isShowing()) {
            return;
        }
        if (this.curBuf == this.buf1) {
            this.curBuf = this.buf2;
            this.prevBuf = this.buf1;
        } else {
            this.curBuf = this.buf1;
            this.prevBuf = this.buf2;
        }
        Graphics2D bufG = (Graphics2D)this.curBuf.getGraphics();
        bufG.drawImage(this.prevBuf, -this.shiftStep, 0, this);
        int x1 = this.width - this.shiftStep;
        int x2 = this.width - 1;
        bufG.setColor(this.backgroundColor);
        bufG.fillRect(x1, 0, this.shiftStep, this.height);
        bufG.setColor(this.gridColor);
        bufG.setStroke(this.gridStroke);
        int step = this.gridStepRound((float)this.gridStepY * this.zoomY);
        int y1 = this.centerY;
        for (int y2 = this.centerY + 1; y1 < this.height && y2 > 0; y1 += step, y2 -= step) {
            bufG.drawLine(x1, y1, x2, y1);
            bufG.drawLine(x1, y2, x2, y2);
        }
        this.lastGridX += this.shiftStep;
        if (this.lastGridX >= this.gridStepX) {
            int x = this.width - (this.lastGridX - this.gridStepX) - 1;
            bufG.drawLine(x, 0, x, this.height);
            this.lastGridX -= this.gridStepX;
        }
        for (JRealTrace trace : this.traces) {
            if (!trace.isEnabled()) continue;
            bufG.setColor(trace.getColor());
            bufG.setStroke(trace.getStroke());
            bufG.drawLine(x1, this.centerY - (int)((float)trace.getLastData(1) * this.zoomY), x2, this.centerY - (int)((float)trace.getLastData(0) * this.zoomY));
        }
        this.repaint();
    }

    public void redraw() {
        if (this.curBuf == null || !this.isShowing()) {
            return;
        }
        Graphics2D bufG = (Graphics2D)this.curBuf.getGraphics();
        this.drawGrid(bufG, this.lastGridX);
        for (JRealTrace trace : this.traces) {
            if (!trace.isEnabled()) continue;
            bufG.setColor(trace.getColor());
            bufG.setStroke(trace.getStroke());
            Iterator<Integer> it = trace.iterator();
            int prev = it.next();
            for (int x = this.width - 1; x > -this.shiftStep && it.hasNext(); x -= this.shiftStep) {
                int val = it.next();
                bufG.drawLine(x, this.centerY - (int)((float)prev * this.zoomY), x - this.shiftStep, this.centerY - (int)((float)val * this.zoomY));
                prev = val;
            }
        }
        this.repaint();
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public Stroke getGridStroke() {
        return this.gridStroke;
    }

    public void setGridStroke(Stroke gridStroke) {
        this.gridStroke = gridStroke;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public float getZoomY() {
        return this.zoomY;
    }

    public void setZoomY(float zoomY) {
        this.zoomY = Math.max(zoomY, 0.001f);
        this.redraw();
    }

    public void setHighlight(JRealTrace highlight) {
        this.highlight = highlight;
        this.redraw();
    }
}

