/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRealTrace
implements Iterable<Integer> {
    private static int colorCnt = 0;
    private Color color = null;
    private Stroke stroke = null;
    private int[] data;
    protected int curPos = 0;
    private String name;
    private boolean enabled = true;
    public int id = 0;
    public static final int DEFAULT_BUF_SIZE = 1000;
    public static final Color[] DEFAULT_COLORS = new Color[]{new Color(0, 25, 229), new Color(117, 0, 229), new Color(226, 0, 229), new Color(229, 0, 43), new Color(230, 145, 0), new Color(167, 179, 0), new Color(0, 179, 13), new Color(6, 155, 244), new Color(0, 179, 177), new Color(0, 120, 179), new Color(83, 109, 151), new Color(147, 62, 141), Color.BLACK, Color.RED, Color.BLUE, Color.MAGENTA};
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);

    public JRealTrace(String name, boolean enabled) {
        this.name = name;
        this.enabled = enabled;
        this.data = new int[1000];
        this.color = JRealTrace.getNextColor();
        this.stroke = DEFAULT_STROKE;
    }

    public static Color getNextColor() {
        return DEFAULT_COLORS[colorCnt++ % DEFAULT_COLORS.length];
    }

    public void setBufSize(int size) {
        this.data = new int[size];
    }

    public synchronized void addData(int x) {
        this.data[this.curPos++] = x;
        this.curPos %= this.data.length;
    }

    public synchronized int getLastData(int offset) {
        return this.data[(this.curPos + this.data.length - 1 - offset) % this.data.length];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new DataBackIterator(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DataBackIterator
    implements Iterator<Integer> {
        private int pos = 0;
        private int fixedPos = 0;
        JRealTrace trace = null;

        public DataBackIterator(JRealTrace trace) {
            this.trace = trace;
            this.pos = this.fixedPos = trace.curPos;
        }

        @Override
        public boolean hasNext() {
            return this.pos != this.fixedPos;
        }

        @Override
        public Integer next() {
            this.pos = this.pos > 0 ? --this.pos : this.trace.data.length - 1;
            return new Integer(this.trace.data[this.pos]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

