/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.text.MessageFormat;
import java.util.zip.CRC32;
import javax.swing.JOptionPane;
import sbgc.object.BoardInfo;
import sbgc.service.upgrade.VersionImpl;
import simplebgc_gui.SimpleBGC_GUIApp;

public class FileUtil {
    public static final int BUFFER_SIZE = 1024;
    public static final int BACKUP_DATA_EEPROM_IMAGE = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void move(String source, String destination) throws Exception {
        try {
            File sourceFile = new File(source);
            if (!sourceFile.exists()) {
                throw new Exception("File \"" + source + "\" doesn't exist!");
            }
            byte[] tmp = new byte[1024];
            FileInputStream fis = new FileInputStream(sourceFile);
            try {
                FileOutputStream fos = new FileOutputStream(destination);
                try {
                    int read = 0;
                    while ((read = fis.read(tmp, 0, 1024)) > 0) {
                        fos.write(tmp, 0, read);
                    }
                }
                finally {
                    fos.close();
                }
            }
            finally {
                fis.close();
            }
        }
        catch (Exception e) {
            throw new Exception(MessageFormat.format("Error moving file from \"{0}\" to \"{1}\": ", source, destination));
        }
    }

    public static void save(String file, StringBuffer content) throws Exception {
        FileUtil.save(file, content.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String file, String content) throws Exception {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(file)));
            try {
                out.write(content);
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + "\n> Error saving file!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String file, byte[] content) throws Exception {
        try {
            FileOutputStream out = new FileOutputStream(new File(file));
            try {
                out.write(content);
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + "\n> Error saving file!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String file, ByteArrayOutputStream content) throws Exception {
        try {
            FileOutputStream out = new FileOutputStream(new File(file));
            try {
                content.writeTo(out);
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + "\n> Error saving file!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer read(String file) throws Exception {
        try {
            StringBuffer content = new StringBuffer();
            BufferedReader in = new BufferedReader(new FileReader(new File(file)));
            try {
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (content.length() > 0) {
                        content.append("\n");
                    }
                    content.append(line);
                }
            }
            finally {
                in.close();
            }
            return content;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + "\n> Error reading file!");
        }
    }

    public static void saveBackupData(int dataType, File f, byte[] data) throws Exception {
        FilterOutputStream output = null;
        try {
            output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            ((DataOutputStream)output).writeByte(1);
            ((DataOutputStream)output).writeByte(dataType);
            ((DataOutputStream)output).writeShort(BoardInfo.getBoardInfo().frwVer);
            ((DataOutputStream)output).writeShort(BoardInfo.getBoardInfo().boardVer);
            ((DataOutputStream)output).writeInt(data.length);
            CRC32 crc = new CRC32();
            crc.update(data);
            ((DataOutputStream)output).writeLong(crc.getValue());
            for (int i = 0; i < 32; ++i) {
                ((DataOutputStream)output).writeByte(0);
            }
            output.write(data);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static byte[] readBackupData(int dataType, File f) throws Exception {
        FilterInputStream input = null;
        try {
            Exception corruptedException = new Exception("Data is corrupted or wrong file is selected");
            input = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
            byte formatVer = ((DataInputStream)input).readByte();
            if (formatVer == 0 || formatVer > 1) {
                throw corruptedException;
            }
            byte type = ((DataInputStream)input).readByte();
            short frwVer = ((DataInputStream)input).readShort();
            short boardVer = ((DataInputStream)input).readShort();
            int dataLength = ((DataInputStream)input).readInt();
            if (dataLength > 1000000) {
                throw corruptedException;
            }
            long crcData = ((DataInputStream)input).readLong();
            for (int i = 0; i < 32; ++i) {
                ((DataInputStream)input).readByte();
            }
            byte[] data = new byte[dataLength];
            ((DataInputStream)input).read(data);
            CRC32 crc = new CRC32();
            crc.update(data);
            if (type != dataType || data.length != dataLength || crcData != crc.getValue()) {
                throw corruptedException;
            }
            BoardInfo boardInfo = BoardInfo.getBoardInfo();
            if (boardInfo != null && (boardInfo.frwVer != frwVer || boardInfo.boardVer != boardVer) && JOptionPane.showConfirmDialog(SimpleBGC_GUIApp.mainView.getFrame(), SimpleBGC_GUIApp.getResourceMap().getString("confirm.restore_EEPROM.firmware_ver_mismatch", new VersionImpl(frwVer).toString()), SimpleBGC_GUIApp.getResourceMap().getString("messageDialog.confirm.title", new Object[0]), 0) != 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }
}

