/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import sbgc.utils.ILogListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log {
    private Logger logger = null;

    public Log(Logger logger) {
        this.logger = logger;
    }

    public void trace(String message, ILogListener listener) {
        this.trace(message);
        if (listener != null) {
            listener.trace(message);
        }
    }

    public void trace(String message) {
        this.logger.trace((Object)message);
    }

    public void trace(String message, Object[] data) {
        this.trace(MessageFormat.format(message, data));
    }

    public void debug(String message, ILogListener listener) {
        this.debug(message);
        if (listener != null) {
            listener.debug(message);
        }
    }

    public void debug(String message) {
        this.logger.debug((Object)message);
    }

    public void info(String message, ILogListener listener) {
        this.info(message);
        if (listener != null) {
            listener.info(message);
        }
    }

    public void info(String message) {
        this.logger.info((Object)message);
    }

    public void warn(String message, ILogListener listener) {
        this.warn(message);
        if (listener != null) {
            listener.warn(message);
        }
    }

    public void warn(String message) {
        this.logger.warn((Object)message);
    }

    public void error(String message, ILogListener listener) {
        this.error(message);
        if (listener != null) {
            listener.error(message);
        }
    }

    public void error(String message) {
        this.logger.error((Object)message);
    }

    public static String join(List<String> arr, String glue) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < arr.size(); ++i) {
            res.append(arr.get(i));
            if (i >= arr.size() - 1) continue;
            res.append(glue);
        }
        return res.toString();
    }

    public static String formatStackTrace(Throwable e) {
        StringBuffer res = new StringBuffer();
        for (StackTraceElement st : e.getStackTrace()) {
            res.append("\n..at ");
            res.append(st.toString());
        }
        return res.toString();
    }
}

