/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import sbgc.utils.Log;

public class Settings {
    public static final String LAST_USED_PROFILES_DIRECTORY = "last_used_profiles_directory";
    public static final String LAST_USED_FIRMWARE_DIRECTORY = "last_used_firmware_directory";
    public static final String CONF_DIRECTORY = "conf";
    public static final String PROFILES_DIRECTORY = "profiles";
    public static final String PROPERTIES_FILE = "bgc.properties";
    public static final String LATEST_VERSION_AUTOCHECK = "latest.versions.autocheck";
    public static final String LAST_VERSION_CHECK_DATE = "last.version.check.date";
    public static final String LAST_USED_PORT = "last.used.port";
    public static final String LATEST_VERSION_GUI = "latest.version.gui";
    public static final String LATEST_VERSION_FIRMWARE = "latest.version.firmware";
    public static final String LATEST_SERIAL_BAUD = "latest.serial.baud";
    public static final String IGNORED_FIRMWARE_VERSION = "ignored.firmware.version";
    public static final String REGISTRATION_DATA_SENT = "registration.data.sent";
    public static final String REGISTRATION_DATA_NAME = "registration.data.name";
    public static final String REGISTRATION_DATA_EMAIL = "registration.data.email";
    public static final String REGISTRATION_DATA_COUNTRY = "registration.data.country";
    public static final String BGC_SERVER_HOST = "bgc_server_host";
    public static final String BGC_SERVER_PORT = "bgc_server_port";
    public static final String BGC_SERVER_PATH = "bgc_server_path";
    public static final String BGC_SERVER_TIMEOUT = "bgc_server_timeout";
    public static final String DEFAULT_BGC_SERVER_HOST = "www.basecamelectronics.com";
    public static final String DEFAULT_BGC_SERVER_PORT = "443";
    public static final String DEFAULT_BGC_SERVER_PATH = "/cgi-bin/main.cgi";
    public static final String DEFAULT_BGC_SERVER_TIMEOUT = "30";
    public static final String TEMPORARY_SESSION = "temporary_session";
    public static final String TEMPORARY_SIGNATURE = "temporary_signature";
    public static final String REALTIME_DATA_PAUSED = "realtime.data.paused";
    public static final String REQUEST_DEBUG_VARS = "realtime.debug_vars";
    public static final String LOG_RT_DATA = "realtime.log_to_file";
    public static final String LOG_RT_DATA_REWRITE = "realtime.log_rewrite";
    private static final Log logger = new Log(Logger.getLogger((String)Settings.class.getName()));
    private static final Properties properties = new Properties();

    public static void load() {
        logger.trace("Loading application settings...");
        String propertiesFileName = null;
        try {
            propertiesFileName = Settings.getPropertiesFileName();
            properties.load(new FileInputStream(propertiesFileName));
            logger.debug("Settings were loaded.");
        }
        catch (IOException e) {
            logger.error("Error loading properties file (" + propertiesFileName + "): " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            logger.trace("Saving application settings...");
            String propertiesFileName = null;
            try {
                propertiesFileName = Settings.getPropertiesFileName();
                properties.store(new FileOutputStream(propertiesFileName), "");
            }
            catch (IOException e) {
                logger.error("Error saving properties file (" + propertiesFileName + "): " + e.toString());
            }
            return;
        }
    }

    public static String getWorkingDirectory() throws IOException {
        return new File(".").getCanonicalPath();
    }

    protected static String getPropertiesFileName() throws IOException {
        String workingDirectoryPath = Settings.getWorkingDirectory();
        File confDirectory = new File(workingDirectoryPath + File.separatorChar + CONF_DIRECTORY);
        if (!confDirectory.exists()) {
            logger.debug("Creating conf directory...");
            confDirectory.mkdirs();
        }
        String propertiesFileName = confDirectory.getPath() + File.separatorChar + PROPERTIES_FILE;
        return propertiesFileName;
    }

    public static boolean is(String name) {
        String value = Settings.get(name);
        return value != null && ("1".equals(value) || "true".equalsIgnoreCase(value));
    }

    public static String get(String name) {
        return Settings.get(name, null);
    }

    public static String get(String name, String defaultValue) {
        String value = properties.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void set(String name, String value) {
        properties.setProperty(name, value);
    }

    public static Locale getLocale() {
        String language = Settings.get("locale.language", "en");
        String country = Settings.get("locale.country", "EN");
        Locale locale = new Locale(language, country);
        return locale;
    }
}

