/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils.http;

import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class X509TrustManagerOnCertificate
implements X509TrustManager {
    private X509TrustManager trustManager;

    public X509TrustManagerOnCertificate(Collection<? extends Certificate> certificates) throws Exception {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null);
        for (Certificate certificate : certificates) {
            keystore.setCertificateEntry(UUID.randomUUID().toString(), certificate);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keystore);
        TrustManager[] trustManagerArray = tmf.getTrustManagers();
        for (int i = 0; i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
            this.trustManager = (X509TrustManager)trustManagerArray[i];
            return;
        }
        throw new NoSuchAlgorithmException("No X509TrustManager in TrustManagerFactory");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] issuers = this.trustManager.getAcceptedIssuers();
        return issuers;
    }
}

