/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils.xml;

import java.io.StringReader;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import sbgc.utils.xml.IParseable;

public class XmlUtils
implements ContentHandler,
ErrorHandler {
    private StringBuffer content = null;
    private Locator locator = null;
    private IParseable parseable = null;

    public static void parse(byte[] data, IParseable parseable) throws Exception {
        XmlUtils.parse(new String(data), parseable);
    }

    public XmlUtils(IParseable parseable) {
        this.parseable = parseable;
    }

    public static void parse(String data, IParseable parseable) throws Exception {
        XmlUtils utils = new XmlUtils(parseable);
        SAXParser xr = new SAXParser();
        xr.setContentHandler(utils);
        xr.setErrorHandler(utils);
        xr.parse(new InputSource(new StringReader(data)));
    }

    private String locate() {
        return "[" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber() + "] - ";
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.content = new StringBuffer();
        try {
            this.parseable.onStartElement(localName, atts);
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            String contentString = this.content.toString();
            if (contentString != null && contentString.trim().length() == 0) {
                contentString = null;
            }
            this.parseable.onEndElement(localName, contentString);
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.content.append(ch, start, length);
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void warning(SAXParseException exception) {
    }

    public void error(SAXParseException exception) throws SAXException {
        throw new SAXException(this.locate() + exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw new SAXException(this.locate() + exception.getMessage());
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

