/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import sbgc.object.BoardInfo;
import sbgc.serial.command.SerialCommandSignMessageImpl;
import sbgc.service.CommandResponseListener;
import sbgc.service.ConnectThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.FirmwareUpgraderImpl;
import sbgc.service.upgrade.IFirmwareUpgradeListener;
import sbgc.service.upgrade.IStatusListener;
import sbgc.service.upgrade.IVersion;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class DialogFirmwareUpgrade
extends JDialog
implements ILogListener,
IFirmwareUpgradeListener,
IStatusListener,
Runnable {
    protected static final Log logger = new Log(Logger.getLogger((String)DialogFirmwareUpgrade.class.getName()));
    private String portToUpgrade = null;
    private SimpleBGC_GUIView parent = null;
    private File firmwareHexFile = null;
    private boolean canClose = false;
    private static ResourceMap resourceMap = null;
    private int version = 0;
    private int versionId = 0;
    private BoardInfo boardInfo = null;
    private JButton buttonCancel;
    private JLabel labelFirmwareUpgrade;
    private JPanel panelButtonDetail;
    private JPanel panelButtons;
    private JPanel panelDetail;
    private JPanel panelScrollPane;
    private JPanel panelTitleAndProgress;
    private JProgressBar progressBarFirmwareUpgrade;
    private JScrollPane scrollPaneDetails;
    private JTextArea textAreaDetails;
    private JToggleButton toggleButtonDetails;

    public DialogFirmwareUpgrade(int version, int versionId, SimpleBGC_GUIView parent, boolean modal, String portToUpgrade, File firmwareHexFile, BoardInfo boardInfo) {
        super((Frame)parent.getFrame(), modal);
        this.version = version;
        this.versionId = versionId;
        this.parent = parent;
        this.portToUpgrade = portToUpgrade;
        this.firmwareHexFile = firmwareHexFile;
        resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogFirmwareUpgrade.class);
        this.boardInfo = boardInfo;
        this.initComponents();
        this.myInitialize();
    }

    public void start() {
        Thread executor = new Thread((Runnable)this, "Upgrader");
        executor.start();
    }

    public DialogFirmwareUpgrade(int version, int versionId, SimpleBGC_GUIView parent, boolean modal, String portToUpgrade) {
        this(version, versionId, parent, modal, portToUpgrade, null, null);
    }

    public final void myInitialize() {
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                DialogFirmwareUpgrade.this.onWindowOpened();
            }

            public void windowClosing(WindowEvent e) {
                if (DialogFirmwareUpgrade.this.canClose) {
                    DialogFirmwareUpgrade.this.onCancel();
                }
            }
        });
        this.panelScrollPane.setVisible(false);
        this.pack();
    }

    public static void flash(int version, int versionId, SimpleBGC_GUIView parent, String port, File firmwareHexFile, BoardInfo boardInfo) {
        DialogFirmwareUpgrade dialogFirmwareUpgrade = new DialogFirmwareUpgrade(version, versionId, parent, true, port, firmwareHexFile, boardInfo);
        DialogFirmwareUpgrade.work(dialogFirmwareUpgrade, parent);
    }

    public static void upgrade(int version, int versionId, SimpleBGC_GUIView parent, String port) {
        DialogFirmwareUpgrade dialogFirmwareUpgrade = new DialogFirmwareUpgrade(version, versionId, parent, true, port);
        DialogFirmwareUpgrade.work(dialogFirmwareUpgrade, parent);
    }

    public static void work(DialogFirmwareUpgrade dialog, SimpleBGC_GUIView parent) {
        dialog.setLocationRelativeTo(parent.getFrame());
        SimpleBGC_GUIApp.getApplication().show(dialog);
    }

    public void trace(final String message) {
        logger.trace(message);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogFirmwareUpgrade.this.textAreaDetails.append(message);
                DialogFirmwareUpgrade.this.textAreaDetails.append("\n");
            }
        });
    }

    public void append(final String part) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogFirmwareUpgrade.this.textAreaDetails.append(part);
            }
        });
    }

    public void debug(String message) {
        this.trace(message);
    }

    public void info(String message) {
        this.trace(message);
    }

    public void warn(String message) {
        this.trace(message);
    }

    public void error(String message) {
        this.trace(message);
    }

    public boolean onProgressChange(final int val) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogFirmwareUpgrade.this.progressBarFirmwareUpgrade.setValue(DialogFirmwareUpgrade.this.progressBarFirmwareUpgrade.getMaximum() * val / 100);
            }
        });
        return true;
    }

    public void setCanClose(boolean close) {
        this.canClose = close;
        if (close) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogFirmwareUpgrade.this.buttonCancel.setEnabled(true);
                    DialogFirmwareUpgrade.this.buttonCancel.setText(resourceMap.getString("buttonCancel.close.text", new Object[0]));
                    DialogFirmwareUpgrade.this.labelFirmwareUpgrade.setText(resourceMap.getString("labelFirmwareUpgrade.finished.text", new Object[0]));
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogFirmwareUpgrade.this.buttonCancel.setEnabled(false);
                }
            });
        }
    }

    public void onFirmwareUpgradeEnd(Exception e) {
        this.setCanClose(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogFirmwareUpgrade.this.buttonCancel.setEnabled(true);
                DialogFirmwareUpgrade.this.buttonCancel.setText(resourceMap.getString("buttonCancel.close.text", new Object[0]));
                DialogFirmwareUpgrade.this.labelFirmwareUpgrade.setText(resourceMap.getString("labelFirmwareUpgrade.finished.text", new Object[0]));
            }
        });
        if (e != null) {
            logger.error(resourceMap.getString("error.upgrading_firmware", e.getMessage()), null);
            JOptionPane.showMessageDialog(null, resourceMap.getString("error.failed_to_upload", e.getMessage()), resourceMap.getString("error.title", new Object[0]), 0);
        } else {
            IVersion newFirmwareVersion = SimpleBGC_GUIApp.mainView.getCurrentFirmwareVersion();
            logger.trace("firmware is written, new version is " + (newFirmwareVersion != null ? newFirmwareVersion.toString() : ""));
            this.dispose();
            JOptionPane.showMessageDialog(null, resourceMap.getString("messageDialog.firmware_uploaded.text", new Object[0]), resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
        }
    }

    @Action
    public void showDetails() {
        this.panelScrollPane.setVisible(this.toggleButtonDetails.isSelected());
        if (!this.panelScrollPane.isVisible()) {
            this.setSize(new Dimension((int)this.getSize().getWidth(), (int)(this.getSize().getHeight() - 300.0)));
            this.setResizable(false);
            this.setLocationRelativeTo(this.parent.getFrame());
        } else {
            this.setSize(new Dimension((int)this.getSize().getWidth(), (int)(this.getSize().getHeight() + 300.0)));
            this.setResizable(true);
            this.setLocationRelativeTo(this.parent.getFrame());
        }
    }

    public void onWindowOpened() {
        this.start();
    }

    @Action
    public void onCancel() {
        this.dispose();
    }

    private void updateStatus(final String status) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogFirmwareUpgrade.this.labelFirmwareUpgrade.setText(status);
                DialogFirmwareUpgrade.this.textAreaDetails.append(status + "\n");
            }
        });
    }

    public void onStatusChange(String status) {
        this.updateStatus(status);
    }

    @Action
    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.firmwareHexFile == null) {
                if (!this.parent.isConnected()) {
                    this.updateStatus("Connecting to board..");
                    String port = this.portToUpgrade;
                    this.parent.connect(port, true);
                    if (ConnectThread.getThread() != null) {
                        try {
                            ConnectThread.getThread().join(5000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!this.parent.isConnected()) {
                        this.error(resourceMap.getString("error.reconnect_usb", new Object[0]));
                        this.parent.disconnect();
                        JOptionPane.showMessageDialog(null, resourceMap.getString("error.reconnect_usb", new Object[0]), resourceMap.getString("messageDialog.error.title", new Object[0]), 2);
                        this.setCanClose(true);
                        return;
                    }
                }
                if (this.boardInfo == null) {
                    this.boardInfo = BoardInfo.getBoardInfo();
                }
                this.info("Signing request..");
                try {
                    String sign = null;
                    SerialCommand command = SerialCommand.getCommandSignMessage(Settings.get("temporary_session"), 2);
                    if (!CommandResponseListener.waitFor(command, 5000L)) {
                        this.error("No answer from board");
                        JOptionPane.showMessageDialog(null, resourceMap.getString("error.reconnect_usb", new Object[0]), resourceMap.getString("messageDialog.error.title", new Object[0]), 2);
                        this.setCanClose(true);
                        return;
                    }
                    sign = SerialCommandSignMessageImpl.getLastSignMessageResult().getSign();
                    Settings.set("temporary_signature", sign);
                    logger.trace("Sign: " + sign.substring(0, 5) + "...");
                    logger.trace(" OK");
                }
                catch (Exception e) {
                    logger.error(resourceMap.getString("error.upgrading_firmware", e.toString()), this);
                    this.onFirmwareUpgradeEnd(e);
                    return;
                }
            }
            if (this.parent.isConnected()) {
                try {
                    int cmd_id;
                    this.parent.stopSerialCommunication();
                    Thread.sleep(500L);
                    this.info("Entering boot mode...");
                    if ((this.boardInfo.connectionFlags & 1) != 0) {
                        JOptionPane.showMessageDialog(null, resourceMap.getString("info.close_flash_jumper", new Object[0]), resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
                        cmd_id = 114;
                    } else {
                        cmd_id = 51;
                    }
                    SerialCommand cmd = new SerialCommand(cmd_id, 3);
                    if (BoardInfo.checkMinFirmwareVer(2434)) {
                        cmd.writeByte(1);
                        cmd.writeWord(0);
                    }
                    SerialCommandProcessor.sendCommand(cmd);
                    for (int time = 0; time < 3000 && this.parent.isConnected(); time += 100) {
                        Thread.sleep(100L);
                    }
                    if (this.parent.isConnected()) {
                        this.parent.disconnect();
                    }
                    this.info("Waiting for bootloader to start...");
                    Thread.sleep(4000L);
                }
                catch (InterruptedException ex) {}
            }
        }
        catch (Exception e) {
            this.setCanClose(true);
            logger.error(e.toString());
        }
        try {
            if (this.boardInfo == null) {
                throw new Exception("BoardInfo is null!");
            }
            FirmwareUpgraderImpl firmwareUpgrader = new FirmwareUpgraderImpl(this.boardInfo, this.version, this.versionId, this.portToUpgrade, this, this, this, this.firmwareHexFile, resourceMap);
            this.buttonCancel.setEnabled(false);
            firmwareUpgrader.start();
        }
        catch (Exception e) {
            logger.error(resourceMap.getString("error.upgrading_firmware", e.toString()), this);
            this.onFirmwareUpgradeEnd(e);
        }
    }

    private void initComponents() {
        this.panelTitleAndProgress = new JPanel();
        this.labelFirmwareUpgrade = new JLabel();
        this.progressBarFirmwareUpgrade = new JProgressBar();
        this.panelButtons = new JPanel();
        this.buttonCancel = new JButton();
        this.panelDetail = new JPanel();
        this.panelButtonDetail = new JPanel();
        this.toggleButtonDetails = new JToggleButton();
        this.panelScrollPane = new JPanel();
        this.scrollPaneDetails = new JScrollPane();
        this.textAreaDetails = new JTextArea();
        this.setDefaultCloseOperation(0);
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogFirmwareUpgrade.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setMinimumSize(new Dimension(800, 180));
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.panelTitleAndProgress.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelTitleAndProgress.setName("panelTitleAndProgress");
        this.panelTitleAndProgress.setLayout(new BorderLayout(5, 5));
        this.labelFirmwareUpgrade.setText(resourceMap.getString("labelFirmwareUpgrade.text", new Object[0]));
        this.labelFirmwareUpgrade.setName("labelFirmwareUpgrade");
        this.panelTitleAndProgress.add((Component)this.labelFirmwareUpgrade, "North");
        this.progressBarFirmwareUpgrade.setMaximum(1000);
        this.progressBarFirmwareUpgrade.setName("progressBarFirmwareUpgrade");
        this.panelTitleAndProgress.add((Component)this.progressBarFirmwareUpgrade, "South");
        this.getContentPane().add((Component)this.panelTitleAndProgress, "North");
        this.panelButtons.setName("panelButtons");
        this.panelButtons.setLayout(new FlowLayout(2));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogFirmwareUpgrade.class, this);
        this.buttonCancel.setAction(actionMap.get("onCancel"));
        this.buttonCancel.setText(resourceMap.getString("buttonCancel.text", new Object[0]));
        this.buttonCancel.setEnabled(false);
        this.buttonCancel.setName("buttonCancel");
        this.panelButtons.add(this.buttonCancel);
        this.getContentPane().add((Component)this.panelButtons, "South");
        this.panelDetail.setName("panelDetail");
        this.panelDetail.setRequestFocusEnabled(false);
        this.panelDetail.setLayout(new BorderLayout());
        this.panelButtonDetail.setName("panelButtonDetail");
        this.panelButtonDetail.setLayout(new FlowLayout(0));
        this.toggleButtonDetails.setAction(actionMap.get("showDetails"));
        this.toggleButtonDetails.setText(resourceMap.getString("toggleButtonDetails.text", new Object[0]));
        this.toggleButtonDetails.setName("toggleButtonDetails");
        this.panelButtonDetail.add(this.toggleButtonDetails);
        this.panelDetail.add((Component)this.panelButtonDetail, "North");
        this.panelScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelScrollPane.setName("panelScrollPane");
        this.panelScrollPane.setLayout(new BorderLayout());
        this.scrollPaneDetails.setMinimumSize(null);
        this.scrollPaneDetails.setName("scrollPaneDetails");
        this.textAreaDetails.setBackground(resourceMap.getColor("textAreaDetails.background"));
        this.textAreaDetails.setColumns(20);
        this.textAreaDetails.setForeground(resourceMap.getColor("textAreaDetails.foreground"));
        this.textAreaDetails.setRows(5);
        this.textAreaDetails.setMinimumSize(null);
        this.textAreaDetails.setName("textAreaDetails");
        this.textAreaDetails.setPreferredSize(null);
        this.scrollPaneDetails.setViewportView(this.textAreaDetails);
        this.panelScrollPane.add((Component)this.scrollPaneDetails, "Center");
        this.panelDetail.add((Component)this.panelScrollPane, "Center");
        this.getContentPane().add((Component)this.panelDetail, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }
}

