/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODTheme;
import java.awt.Font;
import java.awt.Window;
import java.util.Locale;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTheme;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import sbgc.service.upgrade.IVersion;
import sbgc.service.upgrade.VersionFactory;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIView;

public class SimpleBGC_GUIApp
extends SingleFrameApplication {
    public static final String PROJECT_URI = "http://www.basecamelectronics.com";
    public static final String PROJECT_URI_TITLE = "basecamelectronics.com";
    public static final String BUG_REPORT_URI = "http://forum.basecamelectronics.com/index.php?p=/categories/new-ideas";
    public static SimpleBGC_GUIView mainView;
    private static final Log logger;
    public static final IVersion version;
    public static String theme;
    public static boolean debugMode;

    protected void initialize(String[] args) {
        debugMode = args.length > 0 && args[0].equals("DEBUG_MODE") || System.getenv("DEBUG_MODE") != null;
    }

    protected void startup() {
        Thread.currentThread().setName("EDT");
        Settings.load();
        Locale current = Settings.getLocale();
        logger.debug("Current locale: " + current.toString());
        Locale.setDefault(current);
        SimpleBGC_GUIApp.setTheme(Settings.get("view.theme", "Classic"), false);
        mainView = new SimpleBGC_GUIView(this);
        this.show(mainView);
    }

    protected void configureWindow(Window root) {
    }

    public static SimpleBGC_GUIApp getApplication() {
        return Application.getInstance(SimpleBGC_GUIApp.class);
    }

    public static void main(String[] args) {
        SimpleBGC_GUIApp.launch(SimpleBGC_GUIApp.class, args);
    }

    public static ResourceMap getResourceMap(Class cls) {
        return Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(cls);
    }

    public static ResourceMap getResourceMap() {
        return Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(SimpleBGC_GUIApp.class);
    }

    public static void setTheme(String _theme, boolean save) {
        if (!_theme.equals(theme)) {
            theme = _theme;
            try {
                NimRODLookAndFeel lookAndFeel = new NimRODLookAndFeel();
                NimRODTheme nt = new NimRODTheme(SimpleBGC_GUIApp.class.getResource("/simplebgc_gui/resources/" + theme + ".theme"));
                NimRODLookAndFeel.setCurrentTheme((MetalTheme)nt);
                UIManager.setLookAndFeel((LookAndFeel)lookAndFeel);
                String ln = Locale.getDefault().getLanguage();
                if (ln.equals("ja") || ln.equals("zh")) {
                    Font bFont = UIManager.getFont("Button.font");
                    Font newFont = new Font(bFont.getName(), bFont.getStyle(), bFont.getSize() + 2);
                    UIManager.put("Button.font", newFont);
                    UIManager.put("ToggleButton.font", newFont);
                }
                if (mainView != null) {
                    SwingUtilities.updateComponentTreeUI(mainView.getFrame());
                    mainView.getFrame().pack();
                }
                if (save) {
                    Settings.set("view.theme", theme);
                    Settings.save();
                }
            }
            catch (Exception e) {
                logger.error("Failed to set theme " + theme + ": " + e.getMessage());
            }
        }
    }

    static {
        logger = new Log(Logger.getLogger((String)SimpleBGC_GUIApp.class.getName()));
        version = VersionFactory.getVersion(2436);
        theme = "";
    }
}

