/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultCaret;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.common.IFirmwareInfo;
import sbgc.common.IReferenceItem;
import sbgc.object.AdjVarAnalogCfg;
import sbgc.object.AdjVarTriggerCfg;
import sbgc.object.AutoPIDInfo;
import sbgc.object.BatInfo;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardParamsSavedData;
import sbgc.object.BoardProfile;
import sbgc.object.BodeTest;
import sbgc.object.DebugVar;
import sbgc.object.DebugVars;
import sbgc.object.ErrorInfo;
import sbgc.object.RealtimeData;
import sbgc.object.Sprav;
import sbgc.service.ConnectThread;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.SerialPortService;
import sbgc.service.upgrade.IProgressListener;
import sbgc.service.upgrade.IVersion;
import sbgc.service.upgrade.IVersionCheckerListener;
import sbgc.service.upgrade.VersionCheckerFactory;
import sbgc.service.upgrade.VersionFactory;
import sbgc.ui.AnglePanel;
import sbgc.ui.BatComboBoxModel;
import sbgc.ui.ComboBoxModelReferenceImpl;
import sbgc.ui.ExpoCurvePanel;
import sbgc.ui.JPanelAdjVars;
import sbgc.ui.ParamsUIFactory;
import sbgc.ui.RCDataPanel;
import sbgc.ui.SpravComboBoxModel;
import sbgc.ui.chart.JRealChart;
import sbgc.ui.chart.JRealTrace;
import sbgc.utils.DataLogger;
import sbgc.utils.DateUtil;
import sbgc.utils.DefaultConstructorConverter;
import sbgc.utils.FileUtil;
import sbgc.utils.Log;
import sbgc.utils.OSUtil;
import sbgc.utils.Settings;
import simplebgc_gui.DialogAutoPID;
import simplebgc_gui.DialogFirmwareUpgrade;
import simplebgc_gui.DialogProgress;
import simplebgc_gui.DialogRegistrationData;
import simplebgc_gui.SimpleBGC_GUIAboutBox;
import simplebgc_gui.SimpleBGC_GUIApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBGC_GUIView
extends FrameView
implements IVersionCheckerListener,
IProgressListener {
    private static ResourceMap resourceMap = null;
    private static final Log logger = new Log(Logger.getLogger((String)SimpleBGC_GUIView.class.getName()));
    public static final String GUI_DOWNLOAD_URL = "http://www.simplebgc.com";
    private IVersion latestVersionFirmware = null;
    private IVersion latestVersionGui = null;
    private IVersion currentVersionFirmware = null;
    private int progressRange = 100;
    private int oldProfile = 0;
    DialogAutoPID dialogAutoPID = null;
    DataLogger autoPIDLog = null;
    public JPanelAdjVars panelAdjVars = null;
    DialogProgress progressDialog = null;
    private JMenu boardMenu;
    private JMenuItem bugReportMenuItem;
    private JButton buttonCheckLatestVersion;
    private JButton buttonCheckVersion;
    private JButton buttonFirmwareHexFileBrowse;
    private JButton buttonFirmwareHexFileFlash;
    private JButton buttonFirmwareUpgrade;
    private JButton buttonFirmwareUpgradeStart;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroupFollow;
    private ButtonGroup buttonGroupIMU;
    private ButtonGroup buttonGroupLang;
    private ButtonGroup buttonGroupRCPitchMode;
    private ButtonGroup buttonGroupRCRollMode;
    private ButtonGroup buttonGroupRCSource;
    private ButtonGroup buttonGroupRCYawMode;
    private ButtonGroup buttonGroupView;
    private JButton buttonGuiDownload;
    private JButton buttonReadDeviceSN;
    private JCheckBox checkBoxCheckLatestVersionsAtStartup;
    private JCheckBox checkBoxCheckOnStartup;
    private JComboBox comboBoxBoardType;
    private JComboBox comboBoxVersionTitle;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButtonAutoExtFCGain;
    private JButton jButtonAutoPID;
    private JButton jButtonAutoPoles;
    private JButton jButtonAutoTrim;
    private JButton jButtonBatCalibrate;
    private JButton jButtonBodeTestStart;
    private JButton jButtonCalibACC;
    private JButton jButtonCalibFldOffset;
    private JButton jButtonCalibGyro;
    private JButton jButtonConnect;
    private JButton jButtonDebugClear;
    private JButton jButtonDebugCmd;
    private JButton jButtonDebugConnect;
    private JButton jButtonDebugRequestState;
    private JButton jButtonEncodersCalibOffset;
    private JButton jButtonOffsetAuto;
    private JButton jButtonRead;
    private JButton jButtonScriptLoadFile;
    private JButton jButtonScriptPanorama;
    private JButton jButtonScriptRead;
    private JButton jButtonScriptSaveFile;
    private JButton jButtonScriptValidate;
    private JButton jButtonScriptWrite;
    private JButton jButtonWrite;
    private JComboBox jCBPortList;
    private JPanel jChart;
    private JCheckBox jCheckBoxADC1Auto;
    private JCheckBox jCheckBoxADC2Auto;
    private JCheckBox jCheckBoxADC3Auto;
    private JCheckBox jCheckBoxAdaptivePIDPitch;
    private JCheckBox jCheckBoxAdaptivePIDRoll;
    private JCheckBox jCheckBoxAdaptivePIDYaw;
    private JCheckBox jCheckBoxAngleAccLimit;
    private JCheckBox jCheckBoxBatAlarm;
    private JCheckBox jCheckBoxBatComp;
    private JCheckBox jCheckBoxBatMotors;
    private JCheckBox jCheckBoxBeepMotors;
    private JCheckBox jCheckBoxBeeperAlarm;
    private JCheckBox jCheckBoxBeeperCalibration;
    private JCheckBox jCheckBoxBeeperConfirm;
    private JCheckBox jCheckBoxBeeperError;
    private JCheckBox jCheckBoxDebugVars;
    private JCheckBox jCheckBoxEncoderForce;
    private JCheckBox jCheckBoxFollowYaw;
    private JCheckBox jCheckBoxFrameAngleFromMotors;
    private JCheckBox jCheckBoxGyroSens;
    private JCheckBox jCheckBoxLPFPitchEnabled;
    private JCheckBox jCheckBoxLPFRollEnabled;
    private JCheckBox jCheckBoxLPFYawEnabled;
    private JCheckBox jCheckBoxLogRTData;
    private JCheckBox jCheckBoxLogRTDataRewrite;
    private JCheckBox jCheckBoxNotchPitchEnabled1;
    private JCheckBox jCheckBoxNotchPitchEnabled2;
    private JCheckBox jCheckBoxNotchPitchEnabled3;
    private JCheckBox jCheckBoxNotchRollEnabled1;
    private JCheckBox jCheckBoxNotchRollEnabled2;
    private JCheckBox jCheckBoxNotchRollEnabled3;
    private JCheckBox jCheckBoxNotchYawEnabled1;
    private JCheckBox jCheckBoxNotchYawEnabled2;
    private JCheckBox jCheckBoxNotchYawEnabled3;
    private JCheckBox jCheckBoxParity;
    private JCheckBox jCheckBoxPitchInvert;
    private JCheckBox jCheckBoxRCPitchInverse;
    private JCheckBox jCheckBoxRCRollInverse;
    private JCheckBox jCheckBoxRCYawInverse;
    private JCheckBox jCheckBoxRememberLastUsedProfile;
    private JCheckBox jCheckBoxRollInvert;
    private JCheckBox jCheckBoxSkipGyroCal;
    private JCheckBox jCheckBoxUseModel;
    private JCheckBox jCheckBoxYawInvert;
    private JCheckBox jCheckBox_i2c_pullups;
    private JComboBox jComboBoxAxisRight;
    private JComboBox jComboBoxAxisTop;
    private JComboBox jComboBoxBatDefault;
    private JComboBox jComboBoxBodeTestAxis;
    private JComboBox jComboBoxBodeTestStimulus;
    private JComboBox jComboBoxBodeTestSystem;
    private JComboBox jComboBoxEncoderSPI;
    private JComboBox jComboBoxEncoderType;
    private JComboBox jComboBoxFCPitchCh;
    private JComboBox jComboBoxFCRollCh;
    private JComboBox jComboBoxFrameIMU;
    private JComboBox jComboBoxMenu1;
    private JComboBox jComboBoxMenu2;
    private JComboBox jComboBoxMenu3;
    private JComboBox jComboBoxMenu4;
    private JComboBox jComboBoxMenu5;
    private JComboBox jComboBoxMenuLong;
    private JComboBox jComboBoxMixPitch;
    private JComboBox jComboBoxMixRoll;
    private JComboBox jComboBoxOutputPitch;
    private JComboBox jComboBoxOutputRoll;
    private JComboBox jComboBoxOutputYaw;
    private JComboBox jComboBoxPWMFreq;
    private JComboBox jComboBoxProfile;
    private JComboBox jComboBoxRCCmdCh;
    private JComboBox jComboBoxRCHighCmd;
    private JComboBox jComboBoxRCLowCmd;
    private JComboBox jComboBoxRCMidCmd;
    private JComboBox jComboBoxRCOut1;
    private JComboBox jComboBoxRCOut2;
    private JComboBox jComboBoxRCOut3;
    private JComboBox jComboBoxRCOut4;
    private JComboBox jComboBoxRCPitchCh;
    private JComboBox jComboBoxRCRollCh;
    private JComboBox jComboBoxRCVirtMode;
    private JComboBox jComboBoxRCYawCh;
    private JComboBox jComboBoxScriptSlot;
    private JComboBox jComboBoxSerialSpeed;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel100;
    private JLabel jLabel101;
    private JLabel jLabel102;
    private JLabel jLabel103;
    private JLabel jLabel104;
    private JLabel jLabel105;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel4;
    private JLabel jLabel40;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel52;
    private JLabel jLabel53;
    private JLabel jLabel54;
    private JLabel jLabel55;
    private JLabel jLabel56;
    private JLabel jLabel57;
    private JLabel jLabel58;
    private JLabel jLabel59;
    private JLabel jLabel6;
    private JLabel jLabel60;
    private JLabel jLabel61;
    private JLabel jLabel62;
    private JLabel jLabel63;
    private JLabel jLabel64;
    private JLabel jLabel65;
    private JLabel jLabel66;
    private JLabel jLabel67;
    private JLabel jLabel68;
    private JLabel jLabel69;
    private JLabel jLabel7;
    private JLabel jLabel70;
    private JLabel jLabel71;
    private JLabel jLabel72;
    private JLabel jLabel73;
    private JLabel jLabel74;
    private JLabel jLabel75;
    private JLabel jLabel76;
    private JLabel jLabel77;
    private JLabel jLabel78;
    private JLabel jLabel79;
    private JLabel jLabel8;
    private JLabel jLabel80;
    private JLabel jLabel81;
    private JLabel jLabel82;
    private JLabel jLabel83;
    private JLabel jLabel84;
    private JLabel jLabel85;
    private JLabel jLabel86;
    private JLabel jLabel87;
    private JLabel jLabel88;
    private JLabel jLabel89;
    private JLabel jLabel9;
    private JLabel jLabel90;
    private JLabel jLabel91;
    private JLabel jLabel92;
    private JLabel jLabel93;
    private JLabel jLabel94;
    private JLabel jLabel95;
    private JLabel jLabel96;
    private JLabel jLabel97;
    private JLabel jLabel98;
    private JLabel jLabel99;
    private JLabel jLabelADCAutoDetection;
    private JLabel jLabelBatVal;
    private JLabel jLabelBoostPower;
    private JLabel jLabelConnState;
    private JLabel jLabelCycleTime;
    private JLabel jLabelEncType;
    private JLabel jLabelEncoderFFLPF;
    private JLabel jLabelEncoderGear;
    private JLabel jLabelEncoderMagneticLinkage;
    private JLabel jLabelEncoderOffset;
    private JLabel jLabelEncoderOffset1;
    private JLabel jLabelErrorDescr;
    private JLabel jLabelErrorTitle;
    private JLabel jLabelFollowLPF;
    private JLabel jLabelFollowOffset;
    private JLabel jLabelFrameIMUPlace;
    private JLabel jLabelHeatModelCooling;
    private JLabel jLabelHeatModelHeating;
    private JLabel jLabelI2CErrors;
    private JLabel jLabelManualSetTime;
    private JLabel jLabelPitch;
    private JLabel jLabelRCInverse;
    private JLabel jLabelRoll;
    private JLabel jLabelStatus;
    private JLabel jLabelThreshold;
    private JLabel jLabelToggleImu;
    private JLabel jLabelYaw;
    private JList jList1;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel18;
    private JPanel jPanel19;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel23;
    private JPanel jPanel25;
    private JPanel jPanel27;
    private JPanel jPanel28;
    private JPanel jPanel29;
    private JPanel jPanel3;
    private JPanel jPanel30;
    private JPanel jPanel31;
    private JPanel jPanel32;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanelBat;
    private JPanel jPanelBatControls;
    private JPanel jPanelChartToggle;
    private JPanel jPanelExpoCurve;
    private JPanel jPanelFollowExpo;
    private JPanel jPanelMain;
    private JPanel jPanelMiscSettings;
    private JPanel jPanelMixChannels;
    private JPanel jPanelPitchAngle;
    private JPanel jPanelRCCmd;
    private JPanel jPanelRCData;
    private JPanel jPanelRCOther;
    private JPanel jPanelRCOutput;
    private JPanel jPanelRCSubtrim;
    private JPanel jPanelRollAngle;
    private JPanel jPanelYawAngle;
    private JProgressBar jProgressBarMain;
    private JRadioButton jRBFollowDisabled;
    private JRadioButton jRBFollowFC;
    private JRadioButton jRBFollowPitch;
    private JRadioButton jRButtonPitchModeAbs;
    private JRadioButton jRButtonPitchModeInc;
    private JRadioButton jRButtonRollModeAbs;
    private JRadioButton jRButtonRollModeInc;
    private JRadioButton jRButtonYawModeAbs;
    private JRadioButton jRButtonYawModeInc;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPaneRC;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JSlider jSliderScale;
    private JSpinner jSpinnerAdaptivePIDRate;
    private JSpinner jSpinnerAdaptivePIDRecoveryFactor;
    private JSpinner jSpinnerAdaptivePIDThreshold;
    private JSpinner jSpinnerAngleAccLimit;
    private JSpinner jSpinnerBatCompRef;
    private JSpinner jSpinnerBatThresholdAlarm;
    private JSpinner jSpinnerBatThresholdMotors;
    private JSpinner jSpinnerBodeTestGain;
    private JSpinner jSpinnerCoolingPitch;
    private JSpinner jSpinnerCoolingRoll;
    private JSpinner jSpinnerCoolingYaw;
    private JSpinner jSpinnerDeadband;
    private JSpinner jSpinnerEncoderFFLPF;
    private JSpinner jSpinnerEncoderFldOffsetPitch;
    private JSpinner jSpinnerEncoderFldOffsetRoll;
    private JSpinner jSpinnerEncoderFldOffsetYaw;
    private JSpinner jSpinnerEncoderMagLinkPitch;
    private JSpinner jSpinnerEncoderMagLinkRoll;
    private JSpinner jSpinnerEncoderMagLinkYaw;
    private JSpinner jSpinnerEncoderOffsetPitch;
    private JSpinner jSpinnerEncoderOffsetRoll;
    private JSpinner jSpinnerEncoderOffsetYaw;
    private JSpinner jSpinnerExpoRate;
    private JSpinner jSpinnerFollowDeadband;
    private JSpinner jSpinnerFollowExpoRate;
    private JSpinner jSpinnerFollowPitchLPF;
    private JSpinner jSpinnerFollowPitchSpeed;
    private JSpinner jSpinnerFollowRollLPF;
    private JSpinner jSpinnerFollowRollMixRange;
    private JSpinner jSpinnerFollowRollMixStart;
    private JSpinner jSpinnerFollowRollSpeed;
    private JSpinner jSpinnerFollowYawLPF;
    private JSpinner jSpinnerFollowYawSpeed;
    private JSpinner jSpinnerFrameRate;
    private JSpinner jSpinnerGyroLPF;
    private JSpinner jSpinnerGyroTrust;
    private JSpinner jSpinnerHeatingPitch;
    private JSpinner jSpinnerHeatingRoll;
    private JSpinner jSpinnerHeatingYaw;
    private JSpinner jSpinnerLPFPitchFreq;
    private JSpinner jSpinnerLPFRollFreq;
    private JSpinner jSpinnerLPFYawFreq;
    private JSpinner jSpinnerManualSetTimePitch;
    private JSpinner jSpinnerManualSetTimeRoll;
    private JSpinner jSpinnerManualSetTimeYaw;
    private JSpinner jSpinnerMixPitch;
    private JSpinner jSpinnerMixRoll;
    private JSpinner jSpinnerMotorGearPitch;
    private JSpinner jSpinnerMotorGearRoll;
    private JSpinner jSpinnerMotorGearYaw;
    private JSpinner jSpinnerNotchPitchFreq1;
    private JSpinner jSpinnerNotchPitchFreq2;
    private JSpinner jSpinnerNotchPitchFreq3;
    private JSpinner jSpinnerNotchPitchWidth1;
    private JSpinner jSpinnerNotchPitchWidth2;
    private JSpinner jSpinnerNotchPitchWidth3;
    private JSpinner jSpinnerNotchRollFreq1;
    private JSpinner jSpinnerNotchRollFreq2;
    private JSpinner jSpinnerNotchRollFreq3;
    private JSpinner jSpinnerNotchRollWidth1;
    private JSpinner jSpinnerNotchRollWidth2;
    private JSpinner jSpinnerNotchRollWidth3;
    private JSpinner jSpinnerNotchYawFreq1;
    private JSpinner jSpinnerNotchYawFreq2;
    private JSpinner jSpinnerNotchYawFreq3;
    private JSpinner jSpinnerNotchYawWidth1;
    private JSpinner jSpinnerNotchYawWidth2;
    private JSpinner jSpinnerNotchYawWidth3;
    private JSpinner jSpinnerOffsetPitch;
    private JSpinner jSpinnerOffsetRoll;
    private JSpinner jSpinnerOffsetYaw;
    private JSpinner jSpinnerPitchBooster;
    private JSpinner jSpinnerPitchD;
    private JSpinner jSpinnerPitchExtGain;
    private JSpinner jSpinnerPitchI;
    private JSpinner jSpinnerPitchP;
    private JSpinner jSpinnerPitchPoles;
    private JSpinner jSpinnerPitchPower;
    private JSpinner jSpinnerRCOutRate;
    private JSpinner jSpinnerRCPitchFollow;
    private JSpinner jSpinnerRCPitchLPF;
    private JSpinner jSpinnerRCPitchMax;
    private JSpinner jSpinnerRCPitchMemory;
    private JSpinner jSpinnerRCPitchMin;
    private JSpinner jSpinnerRCPitchSpeed;
    private JSpinner jSpinnerRCRollFollow;
    private JSpinner jSpinnerRCRollLPF;
    private JSpinner jSpinnerRCRollMax;
    private JSpinner jSpinnerRCRollMemory;
    private JSpinner jSpinnerRCRollMin;
    private JSpinner jSpinnerRCRollSpeed;
    private JSpinner jSpinnerRCYawLPF;
    private JSpinner jSpinnerRCYawMax;
    private JSpinner jSpinnerRCYawMemory;
    private JSpinner jSpinnerRCYawMin;
    private JSpinner jSpinnerRCYawSpeed;
    private JSpinner jSpinnerRollBooster;
    private JSpinner jSpinnerRollD;
    private JSpinner jSpinnerRollExtGain;
    private JSpinner jSpinnerRollI;
    private JSpinner jSpinnerRollP;
    private JSpinner jSpinnerRollPoles;
    private JSpinner jSpinnerRollPower;
    private JSpinner jSpinnerTrimPitch;
    private JSpinner jSpinnerTrimRoll;
    private JSpinner jSpinnerTrimYaw;
    private JSpinner jSpinnerYawBooster;
    private JSpinner jSpinnerYawD;
    private JSpinner jSpinnerYawI;
    private JSpinner jSpinnerYawP;
    private JSpinner jSpinnerYawPoles;
    private JSpinner jSpinnerYawPower;
    private JSplitPane jSplitPane1;
    private JTextArea jTextAreaDebugCmd;
    private JTextField jTextFieldDebugCmd;
    private JTextField jTextFieldDebugCmdData;
    private JTextPane jTextPaneScript;
    private JToggleButton jToggleButtonMotors;
    private JToggleButton jToggleButtonPause;
    private JToggleButton jToggleImuFrame;
    private JToggleButton jToggleImuMain;
    private JLabel labelCurrentFirmwareVersionValue;
    private JLabel labelCurrentGuiVersionTitle;
    private JLabel labelCurrentGuiVersionValue;
    private JLabel labelCurrentVersion2;
    private JLabel labelCurrentVersionTitle;
    private JLabel labelCurrentVersionValue;
    private JLabel labelDeviceSN;
    private JLabel labelFirmwareUpgradeHex;
    private JLabel labelFirmwareUpgradeHex1;
    private JLabel labelFirmwareVersionValue;
    private JLabel labelLatestFirmwareVersionTitle;
    private JLabel labelLatestFirmwareVersionValue;
    private JLabel labelLatestGuiVersionTitle;
    private JLabel labelLatestGuiVersionValue;
    private JLabel labelLatestVersion;
    private JLabel labelLatestVersion2;
    private JLabel labelUpgradeToVersion;
    private JMenu languageMenu;
    private JPanel mainPanel;
    private JMenuItem menBackupEEPROM;
    private JMenuBar menuBar;
    private JCheckBoxMenuItem menuCN;
    private JCheckBoxMenuItem menuCZ;
    private JMenuItem menuCalibAcc;
    private JMenuItem menuCalibrateGyro;
    private JCheckBoxMenuItem menuDE;
    private JCheckBoxMenuItem menuEN;
    private JMenuItem menuEraseEEPROM;
    private JCheckBoxMenuItem menuFR;
    private JCheckBoxMenuItem menuIT;
    private JCheckBoxMenuItem menuJP;
    private JMenuItem menuLoadProfile;
    private JCheckBoxMenuItem menuPL;
    private JCheckBoxMenuItem menuRU;
    private JMenuItem menuReadParams;
    private JMenuItem menuRestoreEEPROM;
    private JCheckBoxMenuItem menuSE;
    private JMenuItem menuSaveAllProfiles;
    private JMenuItem menuSaveProfile;
    private JMenuItem menuUseDefaults;
    private JCheckBoxMenuItem menuViewClassic;
    private JCheckBoxMenuItem menuViewHighContrastDark;
    private JCheckBoxMenuItem menuViewHighContrastLight;
    private JMenuItem menuWriteParams;
    private JMenuItem menuWriteParamsAll;
    private JPanel panelAdvanced;
    private JPanel panelAdvancedExtFCGain;
    private JPanel panelBasic;
    private JPanel panelDebug;
    private JPanel panelEncoders;
    private JPanel panelFilters;
    private JPanel panelFirmwareUpgrade;
    private JPanel panelFirmwareUpgradeAutomatic;
    private JPanel panelFirmwareUpgradeLog;
    private JPanel panelFirmwareUpgradeManual;
    private JPanel panelFirmwareUpgradeOptions;
    private JPanel panelFollow;
    private JPanel panelMonitoring;
    private JPanel panelRC;
    private JPanel panelScriptEditor;
    private JPanel panelService;
    private JPanel panelUpgradeFromFile;
    private JScrollPane scrollPaneVersionDetails;
    private JMenu sensorMenu;
    private JPanel statusPanel;
    private JTabbedPane tabbedPaneFirmwareUpdateWay;
    private JTabbedPane tabbedPaneMain;
    private JTextArea textAreaVersionDetails;
    private JTextField textFieldDeviceSN;
    private JTextField textFieldFirmwareHexFile;
    private JMenu viewMenu;
    private JDialog aboutBox;
    private DialogFirmwareUpgrade dialogFirmwareUpgrade = null;
    private boolean isPortConnected = false;
    private boolean isConnected = false;
    private boolean serialCommunicationActive = false;
    private AnglePanel[] anglePanels = new AnglePanel[3];
    private RCDataPanel[] rcPanels = new RCDataPanel[RealtimeData.RC_DATA_NAMES.length];
    private RCDataPanel rcCmdPanel;
    private RCDataPanel batPanel;
    private JRealChart chart;
    private ArrayList<JToggleButton> chartToggles;
    private ArrayList<JLabel> chartLabels;
    private JSpinner[] spinnerP;
    private JSpinner[] spinnerI;
    private JSpinner[] spinnerD;
    private JSpinner[] spinnerR;
    private JSpinner[] spinnerPower;
    private JSpinner[] spinnerBooster;
    private JSpinner[] spinnerPoles;
    private JSpinner[] spinnerExtGain;
    private JSpinner[] spinnerRCMin;
    private JSpinner[] spinnerRCMax;
    private JSpinner[] spinnerRCLPF;
    private JSpinner[] spinnerRCSpeed;
    private JSpinner[] spinnerRCFollow;
    private JSpinner[] spinnerRCTrim;
    private JSpinner[] spinnerRCMix;
    private JSpinner[] spinnerFollowSpeed;
    private JSpinner[] spinnerRCMemory;
    private JSpinner[] spinnerFollowLPF;
    private JSpinner[] spinnerManualSetTime;
    private JSpinner[] spinnerHeating;
    private JSpinner[] spinnerCooling;
    private JSpinner[] spinnerEncoderOffset;
    private JSpinner[] spinnerEncoderFldOffset;
    private JSpinner[] spinnerEncoderMagLink;
    private JSpinner[] spinnerMotorGear;
    private JSpinner[] spinnerNotchFreq1;
    private JSpinner[] spinnerNotchFreq2;
    private JSpinner[] spinnerNotchFreq3;
    private JSpinner[] spinnerNotchWidth1;
    private JSpinner[] spinnerNotchWidth2;
    private JSpinner[] spinnerNotchWidth3;
    private JSpinner[] spinnerLPFFreq;
    private JCheckBox[] checkBoxNotchEnabled1;
    private JCheckBox[] checkBoxNotchEnabled2;
    private JCheckBox[] checkBoxNotchEnabled3;
    private JCheckBox[] checkBoxLPFEnabled;
    private JCheckBox[] checkBoxInvert;
    private JCheckBox[] checkBoxRCInverse;
    private JComboBox[] comboBoxRCCmd;
    private JComboBox[] comboBoxRCMap;
    private JComboBox[] comboBoxMenu;
    private JComboBox[] comboBoxOutput;
    private JComboBox[] comboBoxRCMix;
    private JComboBox[] comboBoxRCOut;
    private JRadioButton[] rbRCModeAngle;
    private JRadioButton[] rbRCModeSpeed;
    private JComponent[] rollList;
    private JComponent[] pitchList;
    private JComponent[] yawList;
    private JComponent[] ver3Components;
    ExpoCurvePanel expoCurvePanel;
    ExpoCurvePanel followExpoCurvePanel;
    private int curIMUset = -1;
    private static String errorTitle = "";
    private static String errorDescr = "";
    private int cycleCnt = 0;
    private boolean inFullScreen = false;
    boolean realtimeDataThreadPaused;

    private static SpinnerNumberModel spinnerModel_50u() {
        return new SpinnerNumberModel(0, 0, 50, 1);
    }

    private static SpinnerNumberModel spinnerModel_100u() {
        return new SpinnerNumberModel(0, 0, 100, 1);
    }

    private static SpinnerNumberModel spinnerModel_255u() {
        return new SpinnerNumberModel(0, 0, 255, 1);
    }

    private static SpinnerNumberModel spinnerModel_500u() {
        return new SpinnerNumberModel(0, 0, 500, 2);
    }

    private static SpinnerNumberModel spinnerModel_127s() {
        return new SpinnerNumberModel(0, -127, 127, 1);
    }

    private static SpinnerNumberModel spinnerModel_50f() {
        return new SpinnerNumberModel(0.0, 0.0, 0.5, 0.01f);
    }

    private static SpinnerNumberModel spinnerModel_255f() {
        return new SpinnerNumberModel(0.0, 0.0, 2.5500001907348633, 0.01f);
    }

    private static SpinnerNumberModel spinnerModel_16u() {
        return new SpinnerNumberModel(0, 0, 16, 1);
    }

    private static SpinnerNumberModel spinnerModel_5000f() {
        return new SpinnerNumberModel(0.0, 0.0, 50.0, 0.01f);
    }

    private static SpinnerNumberModel spinnerModel_word() {
        return new SpinnerNumberModel(0, Short.MIN_VALUE, Short.MAX_VALUE, 1);
    }

    private static SpinnerNumberModel spinnerModel_1000u() {
        return new SpinnerNumberModel(0, 0, 1000, 1);
    }

    public SimpleBGC_GUIView(SingleFrameApplication app) {
        super(app);
        this.getFrame().setTitle(SimpleBGC_GUIApp.getResourceMap().getString("Application.title", new Object[0]) + " v" + SimpleBGC_GUIApp.version.toString());
        this.initComponents();
        SerialCommandProcessor.setCommandListener(SerialCommandDispatcher.getInstance());
        if (!SimpleBGC_GUIApp.debugMode) {
            this.tabbedPaneMain.remove(this.panelDebug);
        }
        resourceMap = this.getResourceMap();
        this.MyInitComponents();
        this.getFrame().setResizable(false);
    }

    public String getSelectedPort() {
        return (String)this.jCBPortList.getSelectedItem();
    }

    public boolean isPortConnected() {
        return this.isPortConnected;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isSerialCommunicationActive() {
        return this.serialCommunicationActive;
    }

    @Action
    public synchronized void upgradeFirmware() throws Exception {
        if (this.jCBPortList.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("error.select_port.text", new Object[0]), resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            return;
        }
        if (DialogRegistrationData.isSuccessfull(this.getFrame())) {
            DialogFirmwareUpgrade.upgrade(0, 0, this, (String)this.jCBPortList.getSelectedItem());
        }
    }

    @Action
    public void downloadGui() {
        try {
            if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                throw new Exception(resourceMap.getString("error.browser_not_supported", new Object[0]));
            }
            Desktop.getDesktop().browse(new URI(GUI_DOWNLOAD_URL));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("info.new_gui_download", GUI_DOWNLOAD_URL), resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
        }
    }

    @Action
    public void checkLatestVersions() {
        try {
            if (VersionCheckerFactory.checkAndWait(this)) {
                this.buttonFirmwareUpgradeStart.setEnabled(false);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("error.check_version", e.toString()), resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
        }
    }

    public void checkLatestVersionsWithoutWaiting() {
        try {
            VersionCheckerFactory.check(this);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("error.check_version", e.toString()), resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
        }
    }

    @Override
    public void onEndCheck() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    SimpleBGC_GUIView.this.buttonCheckLatestVersion.setEnabled(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void onStartCheck() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    SimpleBGC_GUIView.this.buttonCheckLatestVersion.setEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public IVersion getCurrentFirmwareVersion() {
        return this.currentVersionFirmware;
    }

    @Override
    public void onLatestFirmwareVersion(final IVersion version) {
        this.latestVersionFirmware = version;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimpleBGC_GUIView.this.labelLatestFirmwareVersionValue.setText(version.toString());
                SimpleBGC_GUIView.this.labelLatestVersion.setText(version.toString());
                if (SimpleBGC_GUIView.this.latestVersionFirmware != null && SimpleBGC_GUIView.this.currentVersionFirmware != null && SimpleBGC_GUIView.this.latestVersionFirmware.compareTo(SimpleBGC_GUIView.this.currentVersionFirmware) > 0) {
                    SimpleBGC_GUIView.this.buttonFirmwareUpgrade.setEnabled(true);
                    int ignoredVersionFirmware = 0;
                    if (Settings.get("ignored.firmware.version") != null) {
                        ignoredVersionFirmware = Integer.parseInt(Settings.get("ignored.firmware.version"));
                    }
                    if (SimpleBGC_GUIView.this.latestVersionFirmware.getFullVer() > ignoredVersionFirmware) {
                        Object[] options = new String[]{resourceMap.getString("info.ignore_version", new Object[0]), resourceMap.getString("info.go_to_upgrade", new Object[0]), resourceMap.getString("info.cancel", new Object[0])};
                        int option = JOptionPane.showOptionDialog(SimpleBGC_GUIView.this.getFrame(), resourceMap.getString("info.new_firmware_available", SimpleBGC_GUIView.this.latestVersionFirmware.toString()), resourceMap.getString("messageDialog.info.title", new Object[0]), -1, 1, null, options, options[0]);
                        if (option == 0) {
                            Settings.set("ignored.firmware.version", "" + SimpleBGC_GUIView.this.latestVersionFirmware.getFullVer());
                            Settings.save();
                        } else if (option == 1) {
                            SimpleBGC_GUIView.this.tabbedPaneMain.setSelectedComponent(SimpleBGC_GUIView.this.panelFirmwareUpgrade);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void onVersionsLoaded(ArrayList<IFirmwareInfo> firmwares) {
        if (firmwares.size() > 0) {
            ArrayList<IReferenceItem> references = new ArrayList<IReferenceItem>();
            for (IFirmwareInfo firmware : firmwares) {
                references.add(firmware);
            }
            ComboBoxModelReferenceImpl model = new ComboBoxModelReferenceImpl(references);
            this.comboBoxVersionTitle.setModel(model);
            this.comboBoxVersionTitle.setSelectedItem(references.get(0));
            this.buttonFirmwareUpgradeStart.setEnabled(false);
        }
    }

    @Override
    public void onLatestGuiVersion(final IVersion version) {
        this.latestVersionGui = version;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimpleBGC_GUIView.this.labelLatestGuiVersionValue.setText(version.toString());
                if (SimpleBGC_GUIView.this.latestVersionGui != null && SimpleBGC_GUIView.this.latestVersionGui.compareTo(SimpleBGC_GUIApp.version) > 0) {
                    SimpleBGC_GUIView.this.buttonGuiDownload.setEnabled(true);
                    if (!SimpleBGC_GUIView.this.latestVersionGui.toString().equals(Settings.get("latest.version.gui"))) {
                        JOptionPane.showMessageDialog(SimpleBGC_GUIView.this.getFrame(), resourceMap.getString("info.new_gui_available", SimpleBGC_GUIView.this.latestVersionGui.toString()), resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
                        Settings.set("latest.version.gui", SimpleBGC_GUIView.this.latestVersionGui.toString());
                        Settings.save();
                        SimpleBGC_GUIView.this.tabbedPaneMain.setSelectedComponent(SimpleBGC_GUIView.this.panelFirmwareUpgrade);
                    }
                }
            }
        });
    }

    public void setDeviceSN() {
        String deviceSN = null;
        if (BoardInfo.getBoardInfo() != null) {
            deviceSN = BoardInfo.getBoardInfo().boardVer < 30 ? "n/a" : BoardInfo.getBoardInfo().getDeviceId();
            this.textFieldDeviceSN.setText(deviceSN);
            this.buttonCheckVersion.setEnabled(true);
        }
    }

    @Action
    public void updateDeviceSN() {
        if (!this.isConnected) {
            if (this.jCBPortList.getSelectedIndex() != -1) {
                String port = (String)this.jCBPortList.getSelectedItem();
                this.connect(port, true);
                if (ConnectThread.getThread() != null) {
                    try {
                        ConnectThread.getThread().join(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!this.isConnected) {
                    this.disconnect();
                    JOptionPane.showMessageDialog(null, resourceMap.getString("error.serial_connect", "Timeout!"), resourceMap.getString("messageDialog.error.title", new Object[0]), 2);
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(null, resourceMap.getString("error.select_port", new Object[0]), resourceMap.getString("messageDialog.error.title", new Object[0]), 2);
            }
        }
        if (this.isConnected) {
            this.setDeviceSN();
        }
    }

    @Action
    public void latestVersionAutocheckChanged() {
        Settings.set("latest.versions.autocheck", new Boolean(this.checkBoxCheckOnStartup.isSelected()).toString());
        Settings.save();
    }

    private void changeLocale(String language, String country) {
        Locale locale = new Locale(language, country);
        Settings.set("locale.language", language);
        Settings.set("locale.country", country);
        Settings.save();
        this.changeLocaleMenuSelection();
        Object[] options = new Object[]{"Exit", "Later"};
        int res = JOptionPane.showOptionDialog(null, "Application should be restarted to reflect changes.", resourceMap.getString("messageDialog.question.title", new Object[0]), 0, 3, null, options, options[1]);
        if (res == 0) {
            this.getApplication().quit(null);
        }
    }

    @Action
    public void changeEnglishLocale() {
        this.changeLocale("en", "EN");
    }

    @Action
    public void changeRussianLocale() {
        this.changeLocale("ru", "RU");
    }

    @Action
    public void changeDeutscheLocale() {
        this.changeLocale("de", "DE");
    }

    @Action
    public void changeFrenchLocale() {
        this.changeLocale("fr", "FR");
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = SimpleBGC_GUIApp.getApplication().getMainFrame();
            this.aboutBox = new SimpleBGC_GUIAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        SimpleBGC_GUIApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void renameProfile() {
        try {
            int profileId = this.jComboBoxProfile.getSelectedIndex();
            String previousProfileName = (String)this.jComboBoxProfile.getItemAt(profileId);
            Object returned = JOptionPane.showInputDialog(this.getFrame(), resourceMap.getString("input.profile_name", new Object[0]), resourceMap.getString("input.profile_name.title", new Object[0]), -1, null, null, (String)this.jComboBoxProfile.getItemAt(profileId));
            if (returned != null && ((String)returned).trim().length() > 0 && !((String)returned).trim().equals(previousProfileName)) {
                BoardParams params;
                BoardInfo boardInfo = BoardInfo.getBoardInfo();
                if (boardInfo != null && boardInfo.canSaveProfileNames()) {
                    boardInfo.setProfileName(profileId, (String)returned);
                    if (this.isConnected) {
                        SerialCommandProcessor.sendCommand(boardInfo.formatProfileNamesCmd());
                    }
                }
                if ((params = BoardParams.getCurParams()) != null) {
                    params.setProfileName(profileId, (String)returned);
                }
                Settings.set("profile." + profileId + ".name", (String)returned);
                Settings.save();
                this.updateProfileNames();
                this.setSelectedProfile(profileId);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getFrame(), "Error renaming profile: " + e.getMessage(), resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
        }
    }

    public void pauseRealtimeData() {
        this.jToggleButtonPause.setSelected(true);
        RealtimeDataThread.pause(true);
    }

    /*
     * Opcode count of 16530 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jPanelMain = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButtonConnect = new JButton();
        this.jCBPortList = new JComboBox();
        this.jLabelConnState = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.labelFirmwareVersionValue = new JLabel();
        this.jPanel3 = new JPanel();
        this.jComboBoxProfile = new JComboBox();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jLabel3 = new JLabel();
        this.tabbedPaneMain = new JTabbedPane();
        this.panelBasic = new JPanel();
        this.jPanel12 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jSpinnerRollP = new JSpinner();
        this.jSpinnerRollI = new JSpinner();
        this.jSpinnerRollD = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jSpinnerPitchP = new JSpinner();
        this.jSpinnerPitchI = new JSpinner();
        this.jSpinnerPitchD = new JSpinner();
        this.jSpinnerYawP = new JSpinner();
        this.jSpinnerYawI = new JSpinner();
        this.jSpinnerYawD = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jButtonAutoPID = new JButton();
        this.jCheckBoxAdaptivePIDRoll = new JCheckBox();
        this.jLabel42 = new JLabel();
        this.jSpinnerAdaptivePIDRate = new JSpinner();
        this.jLabel91 = new JLabel();
        this.jSpinnerAdaptivePIDThreshold = new JSpinner();
        this.jLabel92 = new JLabel();
        this.jSpinnerAdaptivePIDRecoveryFactor = new JSpinner();
        this.jLabel100 = new JLabel();
        this.jCheckBoxAdaptivePIDPitch = new JCheckBox();
        this.jCheckBoxAdaptivePIDYaw = new JCheckBox();
        this.jPanel14 = new JPanel();
        this.jLabel12 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jSpinnerRollPower = new JSpinner();
        this.jLabel17 = new JLabel();
        this.jCheckBoxRollInvert = new JCheckBox();
        this.jLabel18 = new JLabel();
        this.jSpinnerRollPoles = new JSpinner();
        this.jSpinnerPitchPower = new JSpinner();
        this.jSpinnerYawPower = new JSpinner();
        this.jCheckBoxPitchInvert = new JCheckBox();
        this.jCheckBoxYawInvert = new JCheckBox();
        this.jSpinnerPitchPoles = new JSpinner();
        this.jSpinnerYawPoles = new JSpinner();
        this.jButtonAutoPoles = new JButton();
        this.jLabelBoostPower = new JLabel();
        this.jSpinnerRollBooster = new JSpinner();
        this.jSpinnerPitchBooster = new JSpinner();
        this.jSpinnerYawBooster = new JSpinner();
        this.jPanel25 = new JPanel();
        this.jButtonCalibACC = new JButton();
        this.jLabel21 = new JLabel();
        this.jComboBoxAxisTop = new JComboBox();
        this.jLabel22 = new JLabel();
        this.jComboBoxAxisRight = new JComboBox();
        this.jCheckBoxSkipGyroCal = new JCheckBox();
        this.jButtonCalibGyro = new JButton();
        this.jLabelToggleImu = new JLabel();
        this.jToggleImuMain = new JToggleButton();
        this.jToggleImuFrame = new JToggleButton();
        this.panelAdvanced = new JPanel();
        this.jPanel16 = new JPanel();
        this.jLabel36 = new JLabel();
        this.jSpinnerGyroTrust = new JSpinner();
        this.jCheckBoxUseModel = new JCheckBox();
        this.jPanel19 = new JPanel();
        this.jLabel44 = new JLabel();
        this.jComboBoxSerialSpeed = new JComboBox();
        this.jLabel45 = new JLabel();
        this.jComboBoxPWMFreq = new JComboBox();
        this.jPanel21 = new JPanel();
        this.jPanel23 = new JPanel();
        this.jLabel53 = new JLabel();
        this.jComboBoxOutputRoll = new JComboBox();
        this.jLabel54 = new JLabel();
        this.jComboBoxOutputPitch = new JComboBox();
        this.jLabel55 = new JLabel();
        this.jComboBoxOutputYaw = new JComboBox();
        this.jPanel15 = new JPanel();
        this.jLabel23 = new JLabel();
        this.jSpinnerGyroLPF = new JSpinner();
        this.jCheckBox_i2c_pullups = new JCheckBox();
        this.jCheckBoxGyroSens = new JCheckBox();
        this.jLabelFrameIMUPlace = new JLabel();
        this.jComboBoxFrameIMU = new JComboBox();
        this.panelAdvancedExtFCGain = new JPanel();
        this.jLabel10 = new JLabel();
        this.jSpinnerRollExtGain = new JSpinner();
        this.jLabel11 = new JLabel();
        this.jSpinnerPitchExtGain = new JSpinner();
        this.jButtonAutoExtFCGain = new JButton();
        this.jPanelMiscSettings = new JPanel();
        this.jCheckBoxLogRTData = new JCheckBox();
        this.jCheckBoxLogRTDataRewrite = new JCheckBox();
        this.panelRC = new JPanel();
        this.jScrollPaneRC = new JScrollPane();
        this.jPanel32 = new JPanel();
        this.jPanel17 = new JPanel();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jComboBoxRCRollCh = new JComboBox();
        this.jLabel26 = new JLabel();
        this.jComboBoxRCPitchCh = new JComboBox();
        this.jLabel27 = new JLabel();
        this.jComboBoxRCYawCh = new JComboBox();
        this.jLabel28 = new JLabel();
        this.jComboBoxRCCmdCh = new JComboBox();
        this.jComboBoxRCVirtMode = new JComboBox();
        this.jLabel67 = new JLabel();
        this.jComboBoxFCRollCh = new JComboBox();
        this.jLabel71 = new JLabel();
        this.jComboBoxFCPitchCh = new JComboBox();
        this.jPanel18 = new JPanel();
        this.jPanelRCCmd = new JPanel();
        this.jLabel29 = new JLabel();
        this.jComboBoxRCLowCmd = new JComboBox();
        this.jLabel30 = new JLabel();
        this.jComboBoxRCMidCmd = new JComboBox();
        this.jLabel31 = new JLabel();
        this.jComboBoxRCHighCmd = new JComboBox();
        this.jPanel20 = new JPanel();
        this.jLabel32 = new JLabel();
        this.jLabel33 = new JLabel();
        this.jSpinnerRCRollMin = new JSpinner();
        this.jLabel34 = new JLabel();
        this.jSpinnerRCRollMax = new JSpinner();
        this.jLabel35 = new JLabel();
        this.jRButtonRollModeAbs = new JRadioButton();
        this.jLabel37 = new JLabel();
        this.jRButtonRollModeInc = new JRadioButton();
        this.jLabel38 = new JLabel();
        this.jSpinnerRCRollLPF = new JSpinner();
        this.jLabel40 = new JLabel();
        this.jSpinnerRCPitchMin = new JSpinner();
        this.jLabel41 = new JLabel();
        this.jSpinnerRCYawMin = new JSpinner();
        this.jSpinnerRCPitchMax = new JSpinner();
        this.jRButtonPitchModeAbs = new JRadioButton();
        this.jRButtonPitchModeInc = new JRadioButton();
        this.jSpinnerRCPitchLPF = new JSpinner();
        this.jSpinnerRCYawMax = new JSpinner();
        this.jRButtonYawModeAbs = new JRadioButton();
        this.jRButtonYawModeInc = new JRadioButton();
        this.jSpinnerRCYawLPF = new JSpinner();
        this.jLabel43 = new JLabel();
        this.jSpinnerRCRollSpeed = new JSpinner();
        this.jSpinnerRCPitchSpeed = new JSpinner();
        this.jSpinnerRCYawSpeed = new JSpinner();
        this.jLabel87 = new JLabel();
        this.jSpinnerRCYawMemory = new JSpinner();
        this.jSpinnerRCRollMemory = new JSpinner();
        this.jSpinnerRCPitchMemory = new JSpinner();
        this.jLabelRCInverse = new JLabel();
        this.jCheckBoxRCRollInverse = new JCheckBox();
        this.jCheckBoxRCPitchInverse = new JCheckBox();
        this.jCheckBoxRCYawInverse = new JCheckBox();
        this.jPanelMixChannels = new JPanel();
        this.jLabel72 = new JLabel();
        this.jLabel73 = new JLabel();
        this.jComboBoxMixPitch = new JComboBox();
        this.jComboBoxMixRoll = new JComboBox();
        this.jLabel74 = new JLabel();
        this.jLabel75 = new JLabel();
        this.jSpinnerMixPitch = new JSpinner();
        this.jSpinnerMixRoll = new JSpinner();
        this.jPanelRCSubtrim = new JPanel();
        this.jLabel56 = new JLabel();
        this.jLabel57 = new JLabel();
        this.jLabel58 = new JLabel();
        this.jSpinnerExpoRate = new JSpinner();
        this.jSpinnerDeadband = new JSpinner();
        this.jSpinnerTrimPitch = new JSpinner();
        this.jSpinnerTrimRoll = new JSpinner();
        this.jLabel59 = new JLabel();
        this.jButtonAutoTrim = new JButton();
        this.jLabel61 = new JLabel();
        this.jSpinnerTrimYaw = new JSpinner();
        this.jPanelExpoCurve = new JPanel();
        this.jLabelADCAutoDetection = new JLabel();
        this.jCheckBoxADC2Auto = new JCheckBox();
        this.jCheckBoxADC1Auto = new JCheckBox();
        this.jCheckBoxADC3Auto = new JCheckBox();
        this.jPanelRCOther = new JPanel();
        this.jCheckBoxAngleAccLimit = new JCheckBox();
        this.jSpinnerAngleAccLimit = new JSpinner();
        this.jLabel76 = new JLabel();
        this.jPanelRCOutput = new JPanel();
        this.jLabel101 = new JLabel();
        this.jComboBoxRCOut1 = new JComboBox();
        this.jComboBoxRCOut2 = new JComboBox();
        this.jLabel102 = new JLabel();
        this.jComboBoxRCOut3 = new JComboBox();
        this.jLabel103 = new JLabel();
        this.jComboBoxRCOut4 = new JComboBox();
        this.jLabel104 = new JLabel();
        this.jLabel105 = new JLabel();
        this.jSpinnerRCOutRate = new JSpinner();
        this.panelService = new JPanel();
        this.jPanel27 = new JPanel();
        this.jLabel52 = new JLabel();
        this.jLabel46 = new JLabel();
        this.jComboBoxMenu1 = new JComboBox();
        this.jComboBoxMenu2 = new JComboBox();
        this.jLabel47 = new JLabel();
        this.jComboBoxMenu3 = new JComboBox();
        this.jLabel48 = new JLabel();
        this.jLabel49 = new JLabel();
        this.jComboBoxMenu4 = new JComboBox();
        this.jLabel50 = new JLabel();
        this.jComboBoxMenu5 = new JComboBox();
        this.jLabel51 = new JLabel();
        this.jComboBoxMenuLong = new JComboBox();
        this.jCheckBoxRememberLastUsedProfile = new JCheckBox();
        this.jPanelBatControls = new JPanel();
        this.jCheckBoxBatAlarm = new JCheckBox();
        this.jLabelThreshold = new JLabel();
        this.jSpinnerBatThresholdAlarm = new JSpinner();
        this.jCheckBoxBatMotors = new JCheckBox();
        this.jLabel68 = new JLabel();
        this.jSpinnerBatThresholdMotors = new JSpinner();
        this.jCheckBoxBatComp = new JCheckBox();
        this.jLabel69 = new JLabel();
        this.jSpinnerBatCompRef = new JSpinner();
        this.jLabelBatVal = new JLabel();
        this.jButtonBatCalibrate = new JButton();
        this.jLabel70 = new JLabel();
        this.jComboBoxBatDefault = new JComboBox();
        this.jPanel29 = new JPanel();
        this.jCheckBoxBeeperConfirm = new JCheckBox();
        this.jCheckBoxBeeperCalibration = new JCheckBox();
        this.jCheckBoxBeeperError = new JCheckBox();
        this.jCheckBoxBeeperAlarm = new JCheckBox();
        this.jCheckBoxBeepMotors = new JCheckBox();
        this.panelFollow = new JPanel();
        this.jRBFollowFC = new JRadioButton();
        this.jRBFollowPitch = new JRadioButton();
        this.jLabel60 = new JLabel();
        this.jLabel62 = new JLabel();
        this.jSpinnerRCRollFollow = new JSpinner();
        this.jSpinnerRCPitchFollow = new JSpinner();
        this.jCheckBoxFollowYaw = new JCheckBox();
        this.jRBFollowDisabled = new JRadioButton();
        this.jPanelFollowExpo = new JPanel();
        this.jLabel64 = new JLabel();
        this.jSpinnerFollowExpoRate = new JSpinner();
        this.jSpinnerFollowDeadband = new JSpinner();
        this.jLabel65 = new JLabel();
        this.jSpinnerOffsetPitch = new JSpinner();
        this.jSpinnerOffsetYaw = new JSpinner();
        this.jButtonOffsetAuto = new JButton();
        this.jLabel79 = new JLabel();
        this.jSpinnerFollowRollMixStart = new JSpinner();
        this.jLabel80 = new JLabel();
        this.jSpinnerFollowRollMixRange = new JSpinner();
        this.jLabel66 = new JLabel();
        this.jSpinnerFollowRollSpeed = new JSpinner();
        this.jSpinnerFollowPitchSpeed = new JSpinner();
        this.jSpinnerFollowYawSpeed = new JSpinner();
        this.jLabel83 = new JLabel();
        this.jLabel84 = new JLabel();
        this.jLabel85 = new JLabel();
        this.jLabelFollowOffset = new JLabel();
        this.jSpinnerOffsetRoll = new JSpinner();
        this.jCheckBoxFrameAngleFromMotors = new JCheckBox();
        this.jSpinnerFollowRollLPF = new JSpinner();
        this.jSpinnerFollowPitchLPF = new JSpinner();
        this.jSpinnerFollowYawLPF = new JSpinner();
        this.jLabelFollowLPF = new JLabel();
        this.panelMonitoring = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel11 = new JPanel();
        this.jSpinnerFrameRate = new JSpinner();
        this.jLabel15 = new JLabel();
        this.jSliderScale = new JSlider();
        this.jToggleButtonPause = new JToggleButton();
        this.jCheckBoxDebugVars = new JCheckBox();
        this.jPanelRCData = new JPanel();
        this.jChart = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelChartToggle = new JPanel();
        this.panelFirmwareUpgrade = new JPanel();
        this.tabbedPaneFirmwareUpdateWay = new JTabbedPane();
        this.panelFirmwareUpgradeAutomatic = new JPanel();
        this.panelFirmwareUpgradeOptions = new JPanel();
        this.labelDeviceSN = new JLabel();
        this.textFieldDeviceSN = new JTextField();
        this.buttonReadDeviceSN = new JButton();
        this.labelCurrentVersion2 = new JLabel();
        this.labelLatestVersion2 = new JLabel();
        this.labelCurrentVersionValue = new JLabel();
        this.labelLatestVersion = new JLabel();
        this.buttonCheckVersion = new JButton();
        this.checkBoxCheckOnStartup = new JCheckBox();
        this.labelUpgradeToVersion = new JLabel();
        this.comboBoxVersionTitle = new JComboBox();
        this.buttonFirmwareUpgradeStart = new JButton();
        this.panelFirmwareUpgradeLog = new JPanel();
        this.scrollPaneVersionDetails = new JScrollPane();
        this.textAreaVersionDetails = new JTextArea();
        this.panelFirmwareUpgradeManual = new JPanel();
        this.jPanel28 = new JPanel();
        this.buttonCheckLatestVersion = new JButton();
        this.checkBoxCheckLatestVersionsAtStartup = new JCheckBox();
        this.labelCurrentFirmwareVersionValue = new JLabel();
        this.labelLatestFirmwareVersionTitle = new JLabel();
        this.labelCurrentVersionTitle = new JLabel();
        this.labelCurrentGuiVersionTitle = new JLabel();
        this.labelCurrentGuiVersionValue = new JLabel();
        this.labelLatestGuiVersionTitle = new JLabel();
        this.buttonFirmwareUpgrade = new JButton();
        this.buttonGuiDownload = new JButton();
        this.labelLatestFirmwareVersionValue = new JLabel();
        this.labelLatestGuiVersionValue = new JLabel();
        this.panelUpgradeFromFile = new JPanel();
        this.labelFirmwareUpgradeHex = new JLabel();
        this.textFieldFirmwareHexFile = new JTextField();
        this.buttonFirmwareHexFileBrowse = new JButton();
        this.buttonFirmwareHexFileFlash = new JButton();
        this.comboBoxBoardType = new JComboBox();
        this.labelFirmwareUpgradeHex1 = new JLabel();
        this.jLabel39 = new JLabel();
        this.panelDebug = new JPanel();
        this.jLabel77 = new JLabel();
        this.jTextFieldDebugCmd = new JTextField();
        this.jTextFieldDebugCmdData = new JTextField();
        this.jButtonDebugCmd = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaDebugCmd = new JTextArea();
        this.jButtonDebugClear = new JButton();
        this.jLabel78 = new JLabel();
        this.jButtonDebugConnect = new JButton();
        this.jCheckBoxParity = new JCheckBox();
        this.jLabel81 = new JLabel();
        this.jButtonDebugRequestState = new JButton();
        this.jComboBoxBodeTestAxis = new JComboBox();
        this.jComboBoxBodeTestStimulus = new JComboBox();
        this.jSpinnerBodeTestGain = new JSpinner();
        this.jComboBoxBodeTestSystem = new JComboBox();
        this.jButtonBodeTestStart = new JButton();
        this.panelEncoders = new JPanel();
        this.jLabelManualSetTime = new JLabel();
        this.jSpinnerManualSetTimeYaw = new JSpinner();
        this.jLabel63 = new JLabel();
        this.jLabel82 = new JLabel();
        this.jLabel86 = new JLabel();
        this.jSpinnerManualSetTimeRoll = new JSpinner();
        this.jSpinnerManualSetTimePitch = new JSpinner();
        this.jLabelHeatModelHeating = new JLabel();
        this.jSpinnerHeatingRoll = new JSpinner();
        this.jSpinnerHeatingPitch = new JSpinner();
        this.jSpinnerHeatingYaw = new JSpinner();
        this.jLabelHeatModelCooling = new JLabel();
        this.jSpinnerCoolingRoll = new JSpinner();
        this.jSpinnerCoolingPitch = new JSpinner();
        this.jSpinnerCoolingYaw = new JSpinner();
        this.jButtonEncodersCalibOffset = new JButton();
        this.jButtonCalibFldOffset = new JButton();
        this.jLabelEncoderOffset = new JLabel();
        this.jSpinnerEncoderOffsetRoll = new JSpinner();
        this.jSpinnerEncoderOffsetPitch = new JSpinner();
        this.jSpinnerEncoderOffsetYaw = new JSpinner();
        this.jLabelEncoderOffset1 = new JLabel();
        this.jSpinnerEncoderFldOffsetRoll = new JSpinner();
        this.jSpinnerEncoderFldOffsetPitch = new JSpinner();
        this.jSpinnerEncoderFldOffsetYaw = new JSpinner();
        this.jLabelEncType = new JLabel();
        this.jComboBoxEncoderType = new JComboBox();
        this.jCheckBoxEncoderForce = new JCheckBox();
        this.jComboBoxEncoderSPI = new JComboBox();
        this.jLabelEncoderFFLPF = new JLabel();
        this.jSpinnerEncoderFFLPF = new JSpinner();
        this.jLabelEncoderMagneticLinkage = new JLabel();
        this.jSpinnerEncoderMagLinkRoll = new JSpinner();
        this.jSpinnerEncoderMagLinkPitch = new JSpinner();
        this.jSpinnerEncoderMagLinkYaw = new JSpinner();
        this.jLabelEncoderGear = new JLabel();
        this.jSpinnerMotorGearRoll = new JSpinner();
        this.jSpinnerMotorGearPitch = new JSpinner();
        this.jSpinnerMotorGearYaw = new JSpinner();
        this.panelFilters = new JPanel();
        this.jPanel30 = new JPanel();
        this.jLabelRoll = new JLabel();
        this.jLabel88 = new JLabel();
        this.jLabel89 = new JLabel();
        this.jLabel90 = new JLabel();
        this.jSpinnerNotchRollWidth1 = new JSpinner();
        this.jSpinnerNotchRollFreq1 = new JSpinner();
        this.jCheckBoxNotchRollEnabled1 = new JCheckBox();
        this.jSpinnerNotchRollFreq2 = new JSpinner();
        this.jSpinnerNotchRollWidth2 = new JSpinner();
        this.jCheckBoxNotchRollEnabled2 = new JCheckBox();
        this.jSpinnerNotchRollFreq3 = new JSpinner();
        this.jSpinnerNotchRollWidth3 = new JSpinner();
        this.jCheckBoxNotchRollEnabled3 = new JCheckBox();
        this.jSeparator6 = new JSeparator();
        this.jLabelPitch = new JLabel();
        this.jSpinnerNotchPitchFreq1 = new JSpinner();
        this.jSpinnerNotchPitchWidth1 = new JSpinner();
        this.jCheckBoxNotchPitchEnabled1 = new JCheckBox();
        this.jSeparator7 = new JSeparator();
        this.jSpinnerNotchPitchFreq2 = new JSpinner();
        this.jSpinnerNotchPitchWidth2 = new JSpinner();
        this.jCheckBoxNotchPitchEnabled2 = new JCheckBox();
        this.jSpinnerNotchPitchFreq3 = new JSpinner();
        this.jSpinnerNotchPitchWidth3 = new JSpinner();
        this.jCheckBoxNotchPitchEnabled3 = new JCheckBox();
        this.jLabelYaw = new JLabel();
        this.jSeparator8 = new JSeparator();
        this.jSpinnerNotchYawFreq1 = new JSpinner();
        this.jSpinnerNotchYawWidth1 = new JSpinner();
        this.jCheckBoxNotchYawEnabled1 = new JCheckBox();
        this.jSpinnerNotchYawFreq2 = new JSpinner();
        this.jSpinnerNotchYawWidth2 = new JSpinner();
        this.jCheckBoxNotchYawEnabled2 = new JCheckBox();
        this.jSpinnerNotchYawFreq3 = new JSpinner();
        this.jSpinnerNotchYawWidth3 = new JSpinner();
        this.jCheckBoxNotchYawEnabled3 = new JCheckBox();
        this.jPanel31 = new JPanel();
        this.jLabel93 = new JLabel();
        this.jLabel94 = new JLabel();
        this.jSpinnerLPFRollFreq = new JSpinner();
        this.jCheckBoxLPFRollEnabled = new JCheckBox();
        this.jLabel95 = new JLabel();
        this.jLabel96 = new JLabel();
        this.jSpinnerLPFPitchFreq = new JSpinner();
        this.jCheckBoxLPFPitchEnabled = new JCheckBox();
        this.jLabel97 = new JLabel();
        this.jSpinnerLPFYawFreq = new JSpinner();
        this.jCheckBoxLPFYawEnabled = new JCheckBox();
        this.panelScriptEditor = new JPanel();
        this.jButtonScriptLoadFile = new JButton();
        this.jLabel98 = new JLabel();
        this.jButtonScriptSaveFile = new JButton();
        this.jLabel99 = new JLabel();
        this.jButtonScriptWrite = new JButton();
        this.jButtonScriptRead = new JButton();
        this.jComboBoxScriptSlot = new JComboBox();
        this.jButtonScriptValidate = new JButton();
        this.jButtonScriptPanorama = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPaneScript = new JTextPane();
        this.jScrollPane4 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel4 = new JPanel();
        this.jLabelErrorTitle = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabelErrorDescr = new JLabel();
        this.jLabelI2CErrors = new JLabel();
        this.jLabelCycleTime = new JLabel();
        this.jLabel13 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jPanelYawAngle = new JPanel();
        this.jPanelRollAngle = new JPanel();
        this.jPanelPitchAngle = new JPanel();
        this.jButtonRead = new JButton();
        this.jButtonWrite = new JButton();
        this.jToggleButtonMotors = new JToggleButton();
        this.jProgressBarMain = new JProgressBar();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.menuLoadProfile = new JMenuItem();
        this.menuSaveProfile = new JMenuItem();
        this.menuSaveAllProfiles = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        JMenuItem exitMenuItem = new JMenuItem();
        this.boardMenu = new JMenu();
        this.menuReadParams = new JMenuItem();
        this.menuWriteParams = new JMenuItem();
        this.menuWriteParamsAll = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.sensorMenu = new JMenu();
        this.menuCalibAcc = new JMenuItem();
        this.menuCalibrateGyro = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.menuUseDefaults = new JMenuItem();
        this.menuEraseEEPROM = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.menBackupEEPROM = new JMenuItem();
        this.menuRestoreEEPROM = new JMenuItem();
        this.languageMenu = new JMenu();
        this.menuEN = new JCheckBoxMenuItem();
        this.menuRU = new JCheckBoxMenuItem();
        this.menuDE = new JCheckBoxMenuItem();
        this.menuFR = new JCheckBoxMenuItem();
        this.menuCN = new JCheckBoxMenuItem();
        this.menuPL = new JCheckBoxMenuItem();
        this.menuIT = new JCheckBoxMenuItem();
        this.menuCZ = new JCheckBoxMenuItem();
        this.menuSE = new JCheckBoxMenuItem();
        this.menuJP = new JCheckBoxMenuItem();
        this.viewMenu = new JMenu();
        this.menuViewClassic = new JCheckBoxMenuItem();
        this.menuViewHighContrastDark = new JCheckBoxMenuItem();
        this.menuViewHighContrastLight = new JCheckBoxMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItem1 = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.bugReportMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.jLabelStatus = new JLabel();
        this.jPanelBat = new JPanel();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroupRCYawMode = new ButtonGroup();
        this.buttonGroupRCRollMode = new ButtonGroup();
        this.buttonGroupRCPitchMode = new ButtonGroup();
        this.buttonGroupRCSource = new ButtonGroup();
        this.buttonGroupLang = new ButtonGroup();
        this.buttonGroupFollow = new ButtonGroup();
        this.buttonGroupView = new ButtonGroup();
        this.buttonGroupIMU = new ButtonGroup();
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setPreferredSize(new Dimension(950, 650));
        this.mainPanel.setLayout(new GridBagLayout());
        this.jPanelMain.setName("jPanelMain");
        this.jPanelMain.setLayout((LayoutManager)new AbsoluteLayout());
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(SimpleBGC_GUIView.class);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupConnection.border.title", new Object[0])));
        this.jPanel2.setName("groupConnection");
        this.jPanel2.setLayout((LayoutManager)new AbsoluteLayout());
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(SimpleBGC_GUIView.class, this);
        this.jButtonConnect.setAction(actionMap.get("connectDisconnect"));
        this.jButtonConnect.setText(resourceMap.getString("buttonConnect.text", new Object[0]));
        this.jButtonConnect.setName("buttonConnect");
        this.jPanel2.add((Component)this.jButtonConnect, new AbsoluteConstraints(200, 20, 170, -1));
        this.jCBPortList.setName("comboBoxPortList");
        this.jCBPortList.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SimpleBGC_GUIView.this.jCBPortListPopupMenuWillBecomeVisible(evt);
            }
        });
        this.jPanel2.add((Component)this.jCBPortList, new AbsoluteConstraints(10, 20, 180, -1));
        this.jLabelConnState.setText(resourceMap.getString("labelConnectionState.text", new Object[0]));
        this.jLabelConnState.setName("labelConnectionState");
        this.jPanel2.add((Component)this.jLabelConnState, new AbsoluteConstraints(70, 60, 180, -1));
        this.jLabel2.setText(resourceMap.getString("labelFirmware.text", new Object[0]));
        this.jLabel2.setName("labelFirmware");
        this.jPanel2.add((Component)this.jLabel2, new AbsoluteConstraints(290, 60, -1, -1));
        this.jLabel1.setText(resourceMap.getString("labelBoard.text", new Object[0]));
        this.jLabel1.setName("labelBoard");
        this.jPanel2.add((Component)this.jLabel1, new AbsoluteConstraints(10, 60, -1, -1));
        this.labelFirmwareVersionValue.setText(resourceMap.getString("labelFirmwareVersion.text", new Object[0]));
        this.labelFirmwareVersionValue.setName("labelFirmwareVersion");
        this.jPanel2.add((Component)this.labelFirmwareVersionValue, new AbsoluteConstraints(380, 60, 70, -1));
        this.jPanelMain.add((Component)this.jPanel2, new AbsoluteConstraints(0, 0, 450, 90));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupProfile.border.title", new Object[0])));
        this.jPanel3.setName("groupProfile");
        this.jPanel3.setLayout((LayoutManager)new AbsoluteLayout());
        this.jComboBoxProfile.setToolTipText(resourceMap.getString("comboBoxProfile.toolTipText", new Object[0]));
        this.jComboBoxProfile.setName("comboBoxProfile");
        this.jComboBoxProfile.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SimpleBGC_GUIView.this.jComboBoxProfileItemStateChanged(evt);
            }
        });
        this.jPanel3.add((Component)this.jComboBoxProfile, new AbsoluteConstraints(10, 20, 280, -1));
        this.jButton4.setAction(actionMap.get("renameProfile"));
        this.jButton4.setText(resourceMap.getString("buttonProfileRename.text", new Object[0]));
        this.jButton4.setName("buttonProfileRename");
        this.jPanel3.add((Component)this.jButton4, new AbsoluteConstraints(310, 30, 160, -1));
        this.jButton5.setAction(actionMap.get("loadProfile"));
        this.jButton5.setText(resourceMap.getString("buttonProfileLoad.text", new Object[0]));
        this.jButton5.setToolTipText(resourceMap.getString("buttonProfileLoad.toolTipText", new Object[0]));
        this.jButton5.setName("buttonProfileLoad");
        this.jPanel3.add((Component)this.jButton5, new AbsoluteConstraints(10, 50, 140, -1));
        this.jButton6.setAction(actionMap.get("saveProfile"));
        this.jButton6.setText(resourceMap.getString("buttonProfileSave.text", new Object[0]));
        this.jButton6.setToolTipText(resourceMap.getString("buttonProfileSave.toolTipText", new Object[0]));
        this.jButton6.setName("buttonProfileSave");
        this.jPanel3.add((Component)this.jButton6, new AbsoluteConstraints(150, 50, 140, -1));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jPanel3.add((Component)this.jLabel3, new AbsoluteConstraints(300, 60, 160, -1));
        this.jPanelMain.add((Component)this.jPanel3, new AbsoluteConstraints(450, 0, 480, 90));
        this.tabbedPaneMain.setName("tabbedPane");
        this.tabbedPaneMain.setPreferredSize(new Dimension(500, 459));
        this.tabbedPaneMain.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimpleBGC_GUIView.this.tabbedPaneMainStateChanged(evt);
            }
        });
        this.panelBasic.setName("panelBasic");
        this.panelBasic.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel12.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupPidController.border.title", new Object[0])));
        this.jPanel12.setToolTipText(resourceMap.getString("groupPidController.toolTipText", new Object[0]));
        this.jPanel12.setName("groupPidController");
        this.jPanel12.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel4.setText(resourceMap.getString("labelPidControllerRoll.text", new Object[0]));
        this.jLabel4.setName("labelPidControllerRoll");
        this.jPanel12.add((Component)this.jLabel4, new AbsoluteConstraints(20, 50, -1, -1));
        this.jSpinnerRollP.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerRollP.setName("jSpinnerRollP");
        this.jPanel12.add((Component)this.jSpinnerRollP, new AbsoluteConstraints(110, 50, 50, -1));
        this.jSpinnerRollI.setModel(SimpleBGC_GUIView.spinnerModel_255f());
        this.jSpinnerRollI.setName("jSpinnerRollI");
        this.jPanel12.add((Component)this.jSpinnerRollI, new AbsoluteConstraints(170, 50, 50, -1));
        this.jSpinnerRollD.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerRollD.setName("jSpinnerRollD");
        this.jPanel12.add((Component)this.jSpinnerRollD, new AbsoluteConstraints(230, 50, 50, -1));
        this.jLabel6.setText(resourceMap.getString("labelPidControllerPitch.text", new Object[0]));
        this.jLabel6.setName("labelPidControllerPitch");
        this.jPanel12.add((Component)this.jLabel6, new AbsoluteConstraints(20, 80, -1, -1));
        this.jLabel7.setText(resourceMap.getString("labelPidControllerLaw.text", new Object[0]));
        this.jLabel7.setName("labelPidControllerLaw");
        this.jPanel12.add((Component)this.jLabel7, new AbsoluteConstraints(20, 110, -1, -1));
        this.jSpinnerPitchP.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerPitchP.setName("jSpinnerPitchP");
        this.jPanel12.add((Component)this.jSpinnerPitchP, new AbsoluteConstraints(110, 80, 50, -1));
        this.jSpinnerPitchI.setModel(SimpleBGC_GUIView.spinnerModel_255f());
        this.jSpinnerPitchI.setName("jSpinnerPitchI");
        this.jPanel12.add((Component)this.jSpinnerPitchI, new AbsoluteConstraints(170, 80, 50, -1));
        this.jSpinnerPitchD.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerPitchD.setName("jSpinnerPitchD");
        this.jPanel12.add((Component)this.jSpinnerPitchD, new AbsoluteConstraints(230, 80, 50, -1));
        this.jSpinnerYawP.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerYawP.setName("jSpinnerYawP");
        this.jPanel12.add((Component)this.jSpinnerYawP, new AbsoluteConstraints(110, 110, 50, -1));
        this.jSpinnerYawI.setModel(SimpleBGC_GUIView.spinnerModel_255f());
        this.jSpinnerYawI.setName("jSpinnerYawI");
        this.jPanel12.add((Component)this.jSpinnerYawI, new AbsoluteConstraints(170, 110, 50, -1));
        this.jSpinnerYawD.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerYawD.setName("jSpinnerYawD");
        this.jPanel12.add((Component)this.jSpinnerYawD, new AbsoluteConstraints(230, 110, 50, -1));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText(resourceMap.getString("labelPidControllerP.text", new Object[0]));
        this.jLabel5.setName("labelPidControllerP");
        this.jPanel12.add((Component)this.jLabel5, new AbsoluteConstraints(110, 30, 46, -1));
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText(resourceMap.getString("labelPidControllerI.text", new Object[0]));
        this.jLabel8.setName("labelPidControllerI");
        this.jPanel12.add((Component)this.jLabel8, new AbsoluteConstraints(170, 30, 46, -1));
        this.jLabel9.setHorizontalAlignment(0);
        this.jLabel9.setText(resourceMap.getString("labelPidControllerD.text", new Object[0]));
        this.jLabel9.setName("labelPidControllerD");
        this.jPanel12.add((Component)this.jLabel9, new AbsoluteConstraints(230, 30, 46, -1));
        this.jButtonAutoPID.setAction(actionMap.get("buttonAutoPID"));
        this.jButtonAutoPID.setText(resourceMap.getString("buttonAutoMotorConfiguration.text", new Object[0]));
        this.jButtonAutoPID.setName("jButtonAutoPID");
        this.jPanel12.add((Component)this.jButtonAutoPID, new AbsoluteConstraints(113, 140, 160, -1));
        this.jCheckBoxAdaptivePIDRoll.setText(resourceMap.getString("jCheckBoxAdaptivePIDRoll.text", new Object[0]));
        this.jCheckBoxAdaptivePIDRoll.setToolTipText(resourceMap.getString("jCheckBoxAdaptivePIDRoll.toolTipText", new Object[0]));
        this.jCheckBoxAdaptivePIDRoll.setName("jCheckBoxAdaptivePIDRoll");
        this.jPanel12.add((Component)this.jCheckBoxAdaptivePIDRoll, new AbsoluteConstraints(40, 200, -1, -1));
        this.jLabel42.setText(resourceMap.getString("jLabel42.text", new Object[0]));
        this.jLabel42.setName("jLabel42");
        this.jPanel12.add((Component)this.jLabel42, new AbsoluteConstraints(50, 230, -1, -1));
        this.jSpinnerAdaptivePIDRate.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerAdaptivePIDRate.setToolTipText(resourceMap.getString("jSpinnerAdaptivePIDRate.toolTipText", new Object[0]));
        this.jSpinnerAdaptivePIDRate.setName("jSpinnerAdaptivePIDRate");
        this.jPanel12.add((Component)this.jSpinnerAdaptivePIDRate, new AbsoluteConstraints(230, 250, 50, -1));
        this.jLabel91.setText(resourceMap.getString("jLabel91.text", new Object[0]));
        this.jLabel91.setName("jLabel91");
        this.jPanel12.add((Component)this.jLabel91, new AbsoluteConstraints(50, 250, -1, -1));
        this.jSpinnerAdaptivePIDThreshold.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerAdaptivePIDThreshold.setToolTipText(resourceMap.getString("jSpinnerAdaptivePIDThreshold.toolTipText", new Object[0]));
        this.jSpinnerAdaptivePIDThreshold.setName("jSpinnerAdaptivePIDThreshold");
        this.jPanel12.add((Component)this.jSpinnerAdaptivePIDThreshold, new AbsoluteConstraints(230, 230, 50, -1));
        this.jLabel92.setText(resourceMap.getString("jLabel92.text", new Object[0]));
        this.jLabel92.setName("jLabel92");
        this.jPanel12.add((Component)this.jLabel92, new AbsoluteConstraints(50, 270, -1, -1));
        this.jSpinnerAdaptivePIDRecoveryFactor.setModel(new SpinnerNumberModel(0, 0, 10, 1));
        this.jSpinnerAdaptivePIDRecoveryFactor.setToolTipText(resourceMap.getString("jSpinnerAdaptivePIDRecoveryFactor.toolTipText", new Object[0]));
        this.jSpinnerAdaptivePIDRecoveryFactor.setName("jSpinnerAdaptivePIDRecoveryFactor");
        this.jPanel12.add((Component)this.jSpinnerAdaptivePIDRecoveryFactor, new AbsoluteConstraints(230, 270, 50, -1));
        this.jLabel100.setText(resourceMap.getString("jLabel100.text", new Object[0]));
        this.jLabel100.setName("jLabel100");
        this.jPanel12.add((Component)this.jLabel100, new AbsoluteConstraints(20, 180, -1, -1));
        this.jCheckBoxAdaptivePIDPitch.setText(resourceMap.getString("jCheckBoxAdaptivePIDPitch.text", new Object[0]));
        this.jCheckBoxAdaptivePIDPitch.setToolTipText(resourceMap.getString("jCheckBoxAdaptivePIDPitch.toolTipText", new Object[0]));
        this.jCheckBoxAdaptivePIDPitch.setName("jCheckBoxAdaptivePIDPitch");
        this.jPanel12.add((Component)this.jCheckBoxAdaptivePIDPitch, new AbsoluteConstraints(130, 200, -1, -1));
        this.jCheckBoxAdaptivePIDYaw.setText(resourceMap.getString("jCheckBoxAdaptivePIDYaw.text", new Object[0]));
        this.jCheckBoxAdaptivePIDYaw.setToolTipText(resourceMap.getString("jCheckBoxAdaptivePIDYaw.toolTipText", new Object[0]));
        this.jCheckBoxAdaptivePIDYaw.setName("jCheckBoxAdaptivePIDYaw");
        this.jPanel12.add((Component)this.jCheckBoxAdaptivePIDYaw, new AbsoluteConstraints(220, 200, -1, -1));
        this.panelBasic.add((Component)this.jPanel12, new AbsoluteConstraints(10, 10, 310, 330));
        this.jPanel14.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupMotorConfiguration.border.title", new Object[0])));
        this.jPanel14.setToolTipText(resourceMap.getString("groupMotorConfiguration.toolTipText", new Object[0]));
        this.jPanel14.setName("groupMotorConfiguration");
        this.jPanel14.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel12.setText(resourceMap.getString("labelMotorConfigurationRoll.text", new Object[0]));
        this.jLabel12.setName("labelMotorConfigurationRoll");
        this.jPanel14.add((Component)this.jLabel12, new AbsoluteConstraints(20, 50, -1, -1));
        this.jLabel19.setText(resourceMap.getString("labelMotorConfigurationPitch.text", new Object[0]));
        this.jLabel19.setName("labelMotorConfigurationPitch");
        this.jPanel14.add((Component)this.jLabel19, new AbsoluteConstraints(20, 80, -1, -1));
        this.jLabel20.setText(resourceMap.getString("labelMotorConfigurationYaw.text", new Object[0]));
        this.jLabel20.setName("labelMotorConfigurationYaw");
        this.jPanel14.add((Component)this.jLabel20, new AbsoluteConstraints(20, 110, -1, -1));
        this.jLabel16.setHorizontalAlignment(0);
        this.jLabel16.setText(resourceMap.getString("labelMotorConfigurationPower.text", new Object[0]));
        this.jLabel16.setName("labelMotorConfigurationPower");
        this.jPanel14.add((Component)this.jLabel16, new AbsoluteConstraints(50, 30, 90, -1));
        this.jSpinnerRollPower.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerRollPower.setToolTipText(resourceMap.getString("jSpinnerRollPower.toolTipText", new Object[0]));
        this.jSpinnerRollPower.setName("jSpinnerRollPower");
        this.jPanel14.add((Component)this.jSpinnerRollPower, new AbsoluteConstraints(70, 50, 50, -1));
        this.jLabel17.setHorizontalAlignment(0);
        this.jLabel17.setText(resourceMap.getString("labelMotorConfigurationInvert.text", new Object[0]));
        this.jLabel17.setName("labelMotorConfigurationInvert");
        this.jPanel14.add((Component)this.jLabel17, new AbsoluteConstraints(180, 30, 70, -1));
        this.jCheckBoxRollInvert.setToolTipText(resourceMap.getString("jCheckBoxRollInvert.toolTipText", new Object[0]));
        this.jCheckBoxRollInvert.setName("jCheckBoxRollInvert");
        this.jPanel14.add((Component)this.jCheckBoxRollInvert, new AbsoluteConstraints(200, 50, -1, -1));
        this.jLabel18.setHorizontalAlignment(0);
        this.jLabel18.setText(resourceMap.getString("labelMotorConfigurationNumProfiles.text", new Object[0]));
        this.jLabel18.setName("labelMotorConfigurationNumProfiles");
        this.jPanel14.add((Component)this.jLabel18, new AbsoluteConstraints(250, 30, 100, -1));
        this.jSpinnerRollPoles.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerRollPoles.setToolTipText(resourceMap.getString("jSpinnerRollPoles.toolTipText", new Object[0]));
        this.jSpinnerRollPoles.setName("jSpinnerRollPoles");
        this.jPanel14.add((Component)this.jSpinnerRollPoles, new AbsoluteConstraints(270, 50, 50, -1));
        this.jSpinnerPitchPower.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerPitchPower.setToolTipText(resourceMap.getString("jSpinnerRollPower.toolTipText", new Object[0]));
        this.jSpinnerPitchPower.setName("jSpinnerPitchPower");
        this.jPanel14.add((Component)this.jSpinnerPitchPower, new AbsoluteConstraints(70, 80, 50, -1));
        this.jSpinnerYawPower.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerYawPower.setToolTipText(resourceMap.getString("jSpinnerRollPower.toolTipText", new Object[0]));
        this.jSpinnerYawPower.setName("jSpinnerYawPower");
        this.jPanel14.add((Component)this.jSpinnerYawPower, new AbsoluteConstraints(70, 110, 50, -1));
        this.jCheckBoxPitchInvert.setToolTipText(resourceMap.getString("jCheckBoxRollInvert.toolTipText", new Object[0]));
        this.jCheckBoxPitchInvert.setName("jCheckBoxPitchInvert");
        this.jPanel14.add((Component)this.jCheckBoxPitchInvert, new AbsoluteConstraints(200, 80, -1, -1));
        this.jCheckBoxYawInvert.setToolTipText(resourceMap.getString("jCheckBoxRollInvert.toolTipText", new Object[0]));
        this.jCheckBoxYawInvert.setName("jCheckBoxYawInvert");
        this.jPanel14.add((Component)this.jCheckBoxYawInvert, new AbsoluteConstraints(200, 110, -1, -1));
        this.jSpinnerPitchPoles.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerPitchPoles.setToolTipText(resourceMap.getString("jSpinnerRollPoles.toolTipText", new Object[0]));
        this.jSpinnerPitchPoles.setName("jSpinnerPitchPoles");
        this.jPanel14.add((Component)this.jSpinnerPitchPoles, new AbsoluteConstraints(270, 80, 50, -1));
        this.jSpinnerYawPoles.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerYawPoles.setToolTipText(resourceMap.getString("jSpinnerRollPoles.toolTipText", new Object[0]));
        this.jSpinnerYawPoles.setName("jSpinnerYawPoles");
        this.jPanel14.add((Component)this.jSpinnerYawPoles, new AbsoluteConstraints(270, 110, 50, -1));
        this.jButtonAutoPoles.setAction(actionMap.get("buttonAutoPolesAction"));
        this.jButtonAutoPoles.setText(resourceMap.getString("buttonAutoMotorConfiguration.text", new Object[0]));
        this.jButtonAutoPoles.setToolTipText(resourceMap.getString("buttonAutoMotorConfiguration.toolTipText", new Object[0]));
        this.jButtonAutoPoles.setName("buttonAutoMotorConfiguration");
        this.jPanel14.add((Component)this.jButtonAutoPoles, new AbsoluteConstraints(190, 135, 130, -1));
        this.jLabelBoostPower.setHorizontalAlignment(0);
        this.jLabelBoostPower.setText(resourceMap.getString("jLabelBoostPower.text", new Object[0]));
        this.jLabelBoostPower.setName("jLabelBoostPower");
        this.jPanel14.add((Component)this.jLabelBoostPower, new AbsoluteConstraints(150, 30, 20, -1));
        this.jSpinnerRollBooster.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerRollBooster.setToolTipText(resourceMap.getString("jSpinnerRollBooster.toolTipText", new Object[0]));
        this.jSpinnerRollBooster.setName("jSpinnerRollBooster");
        this.jPanel14.add((Component)this.jSpinnerRollBooster, new AbsoluteConstraints(130, 50, 50, -1));
        this.jSpinnerPitchBooster.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerPitchBooster.setToolTipText(resourceMap.getString("jSpinnerRollBooster.toolTipText", new Object[0]));
        this.jSpinnerPitchBooster.setName("jSpinnerPitchBooster");
        this.jPanel14.add((Component)this.jSpinnerPitchBooster, new AbsoluteConstraints(130, 80, 50, -1));
        this.jSpinnerYawBooster.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerYawBooster.setToolTipText(resourceMap.getString("jSpinnerRollBooster.toolTipText", new Object[0]));
        this.jSpinnerYawBooster.setName("jSpinnerYawBooster");
        this.jPanel14.add((Component)this.jSpinnerYawBooster, new AbsoluteConstraints(130, 110, 50, -1));
        this.panelBasic.add((Component)this.jPanel14, new AbsoluteConstraints(320, 10, 380, 170));
        this.jPanel25.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupSensor.border.title", new Object[0])));
        this.jPanel25.setName("jPanel25");
        this.jPanel25.setLayout((LayoutManager)new AbsoluteLayout());
        this.jButtonCalibACC.setAction(actionMap.get("buttonCalibACCAction"));
        this.jButtonCalibACC.setText(resourceMap.getString("jButtonCalibACC.text", new Object[0]));
        this.jButtonCalibACC.setToolTipText(resourceMap.getString("jButtonCalibACC.toolTipText", new Object[0]));
        this.jButtonCalibACC.setName("jButtonCalibACC");
        this.jPanel25.add((Component)this.jButtonCalibACC, new AbsoluteConstraints(20, 80, 160, -1));
        this.jLabel21.setText(resourceMap.getString("labelSensorAxisTop.text", new Object[0]));
        this.jLabel21.setName("labelSensorAxisTop");
        this.jPanel25.add((Component)this.jLabel21, new AbsoluteConstraints(20, 30, -1, -1));
        this.jComboBoxAxisTop.setModel(new DefaultComboBoxModel<String>(new String[]{"X", "Y", "Z", "-X", "-Y", "-Z"}));
        this.jComboBoxAxisTop.setToolTipText(resourceMap.getString("jComboBoxAxisTop.toolTipText", new Object[0]));
        this.jComboBoxAxisTop.setName("jComboBoxAxisTop");
        this.jPanel25.add((Component)this.jComboBoxAxisTop, new AbsoluteConstraints(120, 30, 50, -1));
        this.jLabel22.setText(resourceMap.getString("labelSensorRight.text", new Object[0]));
        this.jLabel22.setName("labelSensorRight");
        this.jPanel25.add((Component)this.jLabel22, new AbsoluteConstraints(190, 30, -1, -1));
        this.jComboBoxAxisRight.setModel(new DefaultComboBoxModel<String>(new String[]{" X", " Y", " Z", "-X", "-Y", "-Z"}));
        this.jComboBoxAxisRight.setToolTipText(resourceMap.getString("jComboBoxAxisRight.toolTipText", new Object[0]));
        this.jComboBoxAxisRight.setName("jComboBoxAxisRight");
        this.jPanel25.add((Component)this.jComboBoxAxisRight, new AbsoluteConstraints(270, 30, 50, -1));
        this.jCheckBoxSkipGyroCal.setText(resourceMap.getString("jCheckBoxSkipGyroCal.text", new Object[0]));
        this.jCheckBoxSkipGyroCal.setToolTipText(resourceMap.getString("jCheckBoxSkipGyroCal.toolTipText", new Object[0]));
        this.jCheckBoxSkipGyroCal.setName("jCheckBoxSkipGyroCal");
        this.jPanel25.add((Component)this.jCheckBoxSkipGyroCal, new AbsoluteConstraints(20, 50, -1, -1));
        this.jButtonCalibGyro.setAction(actionMap.get("buttonCalibGyroAction"));
        this.jButtonCalibGyro.setText(resourceMap.getString("jButtonCalibGyro.text", new Object[0]));
        this.jButtonCalibGyro.setToolTipText(resourceMap.getString("jButtonCalibGyro.toolTipText", new Object[0]));
        this.jButtonCalibGyro.setName("jButtonCalibGyro");
        this.jPanel25.add((Component)this.jButtonCalibGyro, new AbsoluteConstraints(190, 80, 150, -1));
        this.jLabelToggleImu.setText(resourceMap.getString("jLabelToggleImu.text", new Object[0]));
        this.jLabelToggleImu.setName("jLabelToggleImu");
        this.jPanel25.add((Component)this.jLabelToggleImu, new AbsoluteConstraints(20, 120, -1, -1));
        this.jToggleImuMain.setAction(actionMap.get("buttonCameraIMU"));
        this.buttonGroupIMU.add(this.jToggleImuMain);
        this.jToggleImuMain.setSelected(true);
        this.jToggleImuMain.setText(resourceMap.getString("jToggleImuMain.text", new Object[0]));
        this.jToggleImuMain.setName("jToggleImuMain");
        this.jPanel25.add((Component)this.jToggleImuMain, new AbsoluteConstraints(100, 120, 120, -1));
        this.jToggleImuFrame.setAction(actionMap.get("buttonFrameIMU"));
        this.buttonGroupIMU.add(this.jToggleImuFrame);
        this.jToggleImuFrame.setText(resourceMap.getString("jToggleImuFrame.text", new Object[0]));
        this.jToggleImuFrame.setName("jToggleImuFrame");
        this.jPanel25.add((Component)this.jToggleImuFrame, new AbsoluteConstraints(220, 120, 120, -1));
        this.panelBasic.add((Component)this.jPanel25, new AbsoluteConstraints(320, 180, 380, 160));
        this.tabbedPaneMain.addTab(resourceMap.getString("panelBasic.TabConstraints.tabTitle", new Object[0]), this.panelBasic);
        this.panelAdvanced.setName("panelAdvanced");
        this.panelAdvanced.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel16.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel16.border.title", new Object[0])));
        this.jPanel16.setName("jPanel16");
        this.jPanel16.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel36.setText(resourceMap.getString("jLabel36.text", new Object[0]));
        this.jLabel36.setName("jLabel36");
        this.jPanel16.add((Component)this.jLabel36, new AbsoluteConstraints(20, 30, 130, -1));
        this.jSpinnerGyroTrust.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerGyroTrust.setToolTipText(resourceMap.getString("jSpinnerGyroTrust.toolTipText", new Object[0]));
        this.jSpinnerGyroTrust.setName("jSpinnerGyroTrust");
        this.jPanel16.add((Component)this.jSpinnerGyroTrust, new AbsoluteConstraints(160, 30, 55, -1));
        this.jCheckBoxUseModel.setText(resourceMap.getString("jCheckBoxUseModel.text", new Object[0]));
        this.jCheckBoxUseModel.setToolTipText(resourceMap.getString("jCheckBoxUseModel.toolTipText", new Object[0]));
        this.jCheckBoxUseModel.setName("jCheckBoxUseModel");
        this.jPanel16.add((Component)this.jCheckBoxUseModel, new AbsoluteConstraints(20, 60, -1, -1));
        this.panelAdvanced.add((Component)this.jPanel16, new AbsoluteConstraints(10, 10, 260, 100));
        this.jPanel19.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel19.border.title", new Object[0])));
        this.jPanel19.setName("jPanel19");
        this.jPanel19.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel44.setText(resourceMap.getString("jLabel44.text", new Object[0]));
        this.jLabel44.setName("jLabel44");
        this.jPanel19.add((Component)this.jLabel44, new AbsoluteConstraints(20, 30, 150, -1));
        this.jComboBoxSerialSpeed.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxSerialSpeed.setToolTipText(resourceMap.getString("jComboBoxSerialSpeed.toolTipText", new Object[0]));
        this.jComboBoxSerialSpeed.setName("jComboBoxSerialSpeed");
        this.jPanel19.add((Component)this.jComboBoxSerialSpeed, new AbsoluteConstraints(220, 30, 190, -1));
        this.jLabel45.setText(resourceMap.getString("jLabel45.text", new Object[0]));
        this.jLabel45.setName("jLabel45");
        this.jPanel19.add((Component)this.jLabel45, new AbsoluteConstraints(20, 60, 150, -1));
        this.jComboBoxPWMFreq.setModel(new DefaultComboBoxModel<String>(new String[]{"LOW (noisy)", "HIGH (silent)", "ULTRA-HIGH"}));
        this.jComboBoxPWMFreq.setToolTipText(resourceMap.getString("jComboBoxPWMFreq.toolTipText", new Object[0]));
        this.jComboBoxPWMFreq.setName("jComboBoxPWMFreq");
        this.jPanel19.add((Component)this.jComboBoxPWMFreq, new AbsoluteConstraints(220, 60, 190, -1));
        this.panelAdvanced.add((Component)this.jPanel19, new AbsoluteConstraints(270, 10, 460, 100));
        this.jPanel21.setName("jPanel21");
        GroupLayout jPanel21Layout = new GroupLayout(this.jPanel21);
        this.jPanel21.setLayout(jPanel21Layout);
        jPanel21Layout.setHorizontalGroup(jPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 660, Short.MAX_VALUE));
        jPanel21Layout.setVerticalGroup(jPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.panelAdvanced.add((Component)this.jPanel21, new AbsoluteConstraints(10, 124, -1, -1));
        this.jPanel23.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel23.border.title", new Object[0])));
        this.jPanel23.setName("jPanel23");
        this.jPanel23.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel53.setText(resourceMap.getString("jLabel53.text", new Object[0]));
        this.jLabel53.setName("jLabel53");
        this.jPanel23.add((Component)this.jLabel53, new AbsoluteConstraints(20, 30, 80, -1));
        this.jComboBoxOutputRoll.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxOutputRoll.setToolTipText(resourceMap.getString("jComboBoxOutputRoll.toolTipText", new Object[0]));
        this.jComboBoxOutputRoll.setName("jComboBoxOutputRoll");
        this.jPanel23.add((Component)this.jComboBoxOutputRoll, new AbsoluteConstraints(110, 30, 130, -1));
        this.jLabel54.setText(resourceMap.getString("jLabel54.text", new Object[0]));
        this.jLabel54.setName("jLabel54");
        this.jPanel23.add((Component)this.jLabel54, new AbsoluteConstraints(20, 55, 80, -1));
        this.jComboBoxOutputPitch.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxOutputPitch.setToolTipText(resourceMap.getString("jComboBoxOutputRoll.toolTipText", new Object[0]));
        this.jComboBoxOutputPitch.setName("jComboBoxOutputPitch");
        this.jPanel23.add((Component)this.jComboBoxOutputPitch, new AbsoluteConstraints(110, 55, 130, -1));
        this.jLabel55.setText(resourceMap.getString("jLabel55.text", new Object[0]));
        this.jLabel55.setName("jLabel55");
        this.jPanel23.add((Component)this.jLabel55, new AbsoluteConstraints(20, 80, 80, -1));
        this.jComboBoxOutputYaw.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxOutputYaw.setToolTipText(resourceMap.getString("jComboBoxOutputRoll.toolTipText", new Object[0]));
        this.jComboBoxOutputYaw.setName("jComboBoxOutputYaw");
        this.jPanel23.add((Component)this.jComboBoxOutputYaw, new AbsoluteConstraints(110, 80, 130, -1));
        this.panelAdvanced.add((Component)this.jPanel23, new AbsoluteConstraints(10, 110, 260, 130));
        this.jPanel15.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupSensor.border.title", new Object[0])));
        this.jPanel15.setToolTipText(resourceMap.getString("groupSensor.toolTipText", new Object[0]));
        this.jPanel15.setName("groupSensor");
        this.jPanel15.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel23.setText(resourceMap.getString("labelSensorGyroLpf.text", new Object[0]));
        this.jLabel23.setName("labelSensorGyroLpf");
        this.jPanel15.add((Component)this.jLabel23, new AbsoluteConstraints(20, 20, 150, -1));
        this.jSpinnerGyroLPF.setModel(SimpleBGC_GUIView.spinnerModel_16u());
        this.jSpinnerGyroLPF.setToolTipText(resourceMap.getString("jSpinnerGyroLPF.toolTipText", new Object[0]));
        this.jSpinnerGyroLPF.setName("jSpinnerGyroLPF");
        this.jPanel15.add((Component)this.jSpinnerGyroLPF, new AbsoluteConstraints(180, 20, 55, -1));
        this.jCheckBox_i2c_pullups.setText(resourceMap.getString("jCheckBox_i2c_pullups.text", new Object[0]));
        this.jCheckBox_i2c_pullups.setToolTipText(resourceMap.getString("jCheckBox_i2c_pullups.toolTipText", new Object[0]));
        this.jCheckBox_i2c_pullups.setName("jCheckBox_i2c_pullups");
        this.jPanel15.add((Component)this.jCheckBox_i2c_pullups, new AbsoluteConstraints(20, 60, 170, -1));
        this.jCheckBoxGyroSens.setText(resourceMap.getString("jCheckBoxGyroSens.text", new Object[0]));
        this.jCheckBoxGyroSens.setToolTipText(resourceMap.getString("jCheckBoxGyroSens.toolTipText", new Object[0]));
        this.jCheckBoxGyroSens.setName("jCheckBoxGyroSens");
        this.jPanel15.add((Component)this.jCheckBoxGyroSens, new AbsoluteConstraints(20, 40, -1, -1));
        this.jLabelFrameIMUPlace.setText(resourceMap.getString("jLabelFrameIMUPlace.text", new Object[0]));
        this.jLabelFrameIMUPlace.setName("jLabelFrameIMUPlace");
        this.jPanel15.add((Component)this.jLabelFrameIMUPlace, new AbsoluteConstraints(20, 100, -1, -1));
        this.jComboBoxFrameIMU.setModel(new DefaultComboBoxModel<String>(new String[]{"Disabled", "Below YAW", "Above YAW", "Below YAW + PID source"}));
        this.jComboBoxFrameIMU.setToolTipText(resourceMap.getString("jComboBoxFrameIMU.toolTipText", new Object[0]));
        this.jComboBoxFrameIMU.setName("jComboBoxFrameIMU");
        this.jPanel15.add((Component)this.jComboBoxFrameIMU, new AbsoluteConstraints(100, 95, 140, -1));
        this.panelAdvanced.add((Component)this.jPanel15, new AbsoluteConstraints(470, 110, 260, 130));
        this.panelAdvancedExtFCGain.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupExternalFcGain.border.title", new Object[0])));
        this.panelAdvancedExtFCGain.setToolTipText(resourceMap.getString("groupExternalFcGain.toolTipText", new Object[0]));
        this.panelAdvancedExtFCGain.setName("groupExternalFcGain");
        this.panelAdvancedExtFCGain.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel10.setText(resourceMap.getString("labelExternalFcGainRoll.text", new Object[0]));
        this.jLabel10.setName("labelExternalFcGainRoll");
        this.panelAdvancedExtFCGain.add((Component)this.jLabel10, new AbsoluteConstraints(20, 30, -1, -1));
        this.jSpinnerRollExtGain.setModel(SimpleBGC_GUIView.spinnerModel_127s());
        this.jSpinnerRollExtGain.setToolTipText(resourceMap.getString("groupExternalFcGain.toolTipText", new Object[0]));
        this.jSpinnerRollExtGain.setName("jSpinnerRollExtGain");
        this.panelAdvancedExtFCGain.add((Component)this.jSpinnerRollExtGain, new AbsoluteConstraints(110, 30, 46, -1));
        this.jLabel11.setText(resourceMap.getString("labelExternalFcGainPitch.text", new Object[0]));
        this.jLabel11.setName("labelExternalFcGainPitch");
        this.panelAdvancedExtFCGain.add((Component)this.jLabel11, new AbsoluteConstraints(20, 60, -1, -1));
        this.jSpinnerPitchExtGain.setModel(SimpleBGC_GUIView.spinnerModel_127s());
        this.jSpinnerPitchExtGain.setToolTipText(resourceMap.getString("groupExternalFcGain.toolTipText", new Object[0]));
        this.jSpinnerPitchExtGain.setName("jSpinnerPitchExtGain");
        this.panelAdvancedExtFCGain.add((Component)this.jSpinnerPitchExtGain, new AbsoluteConstraints(110, 60, 46, -1));
        this.jButtonAutoExtFCGain.setAction(actionMap.get("buttonCalibExtGain"));
        this.jButtonAutoExtFCGain.setText(resourceMap.getString("jButtonAutoExtFCGain.text", new Object[0]));
        this.jButtonAutoExtFCGain.setToolTipText(resourceMap.getString("jButtonAutoExtFCGain.toolTipText", new Object[0]));
        this.jButtonAutoExtFCGain.setName("jButtonAutoExtFCGain");
        this.panelAdvancedExtFCGain.add((Component)this.jButtonAutoExtFCGain, new AbsoluteConstraints(60, 90, 100, -1));
        this.panelAdvanced.add((Component)this.panelAdvancedExtFCGain, new AbsoluteConstraints(270, 110, 200, 130));
        this.jPanelMiscSettings.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelMiscSettings.border.title", new Object[0])));
        this.jPanelMiscSettings.setName("jPanelMiscSettings");
        this.jPanelMiscSettings.setLayout((LayoutManager)new AbsoluteLayout());
        this.jCheckBoxLogRTData.setText(resourceMap.getString("jCheckBoxLogRTData.text", new Object[0]));
        this.jCheckBoxLogRTData.setName("jCheckBoxLogRTData");
        this.jCheckBoxLogRTData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimpleBGC_GUIView.this.jCheckBoxLogRTDataActionPerformed(evt);
            }
        });
        this.jPanelMiscSettings.add((Component)this.jCheckBoxLogRTData, new AbsoluteConstraints(20, 20, -1, -1));
        this.jCheckBoxLogRTDataRewrite.setText(resourceMap.getString("jCheckBoxLogRTDataRewrite.text", new Object[0]));
        this.jCheckBoxLogRTDataRewrite.setName("jCheckBoxLogRTDataRewrite");
        this.jCheckBoxLogRTDataRewrite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimpleBGC_GUIView.this.jCheckBoxLogRTDataRewriteActionPerformed(evt);
            }
        });
        this.jPanelMiscSettings.add((Component)this.jCheckBoxLogRTDataRewrite, new AbsoluteConstraints(40, 40, -1, -1));
        this.panelAdvanced.add((Component)this.jPanelMiscSettings, new AbsoluteConstraints(10, 240, 260, 100));
        this.tabbedPaneMain.addTab(resourceMap.getString("panelAdvanced.TabConstraints.tabTitle", new Object[0]), this.panelAdvanced);
        this.panelRC.setName("panelRcSettings");
        this.panelRC.setLayout(new BoxLayout(this.panelRC, 2));
        this.jScrollPaneRC.setBorder(null);
        this.jScrollPaneRC.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneRC.setVerticalScrollBarPolicy(22);
        this.jScrollPaneRC.setName("jScrollPaneRC");
        this.jPanel32.setName("jPanel32");
        this.jPanel32.setPreferredSize(new Dimension(710, 645));
        this.jPanel32.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel17.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupRcInputMapping.border.title", new Object[0])));
        this.jPanel17.setName("groupRcInputMapping");
        this.jPanel17.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel24.setText(resourceMap.getString("labelRCRollMode.text", new Object[0]));
        this.jLabel24.setName("labelRcInputMappingSource");
        this.jPanel17.add((Component)this.jLabel24, new AbsoluteConstraints(20, 20, -1, -1));
        this.jLabel25.setText(resourceMap.getString("labelRcInputMappingRoll.text", new Object[0]));
        this.jLabel25.setName("labelRcInputMappingRoll");
        this.jPanel17.add((Component)this.jLabel25, new AbsoluteConstraints(20, 50, -1, -1));
        this.jComboBoxRCRollCh.setToolTipText(resourceMap.getString("comboBoxRcInputMappingRollState.toolTipText", new Object[0]));
        this.jComboBoxRCRollCh.setName("comboBoxRcInputMappingRollState");
        this.jPanel17.add((Component)this.jComboBoxRCRollCh, new AbsoluteConstraints(160, 50, 190, -1));
        this.jLabel26.setText(resourceMap.getString("labelRcInputMappingPitch.text", new Object[0]));
        this.jLabel26.setName("labelRcInputMappingPitch");
        this.jPanel17.add((Component)this.jLabel26, new AbsoluteConstraints(20, 70, -1, -1));
        this.jComboBoxRCPitchCh.setToolTipText(resourceMap.getString("comboBoxRcInputMappingRollState.toolTipText", new Object[0]));
        this.jComboBoxRCPitchCh.setName("comboBoxRcInputMappingPitchState");
        this.jPanel17.add((Component)this.jComboBoxRCPitchCh, new AbsoluteConstraints(160, 70, 190, -1));
        this.jLabel27.setText(resourceMap.getString("labelRcInputMappingYaw.text", new Object[0]));
        this.jLabel27.setName("labelRcInputMappingYaw");
        this.jPanel17.add((Component)this.jLabel27, new AbsoluteConstraints(20, 90, -1, -1));
        this.jComboBoxRCYawCh.setToolTipText(resourceMap.getString("comboBoxRcInputMappingRollState.toolTipText", new Object[0]));
        this.jComboBoxRCYawCh.setName("comboBoxRcInputMappingYawState");
        this.jPanel17.add((Component)this.jComboBoxRCYawCh, new AbsoluteConstraints(160, 90, 190, -1));
        this.jLabel28.setText(resourceMap.getString("labelRcInputMappingCmd.text", new Object[0]));
        this.jLabel28.setName("labelRcInputMappingCmd");
        this.jPanel17.add((Component)this.jLabel28, new AbsoluteConstraints(20, 120, -1, -1));
        this.jComboBoxRCCmdCh.setToolTipText(resourceMap.getString("comboBoxRcInputMappingRollState.toolTipText", new Object[0]));
        this.jComboBoxRCCmdCh.setName("comboBoxRcInputMappingCmdState");
        this.jPanel17.add((Component)this.jComboBoxRCCmdCh, new AbsoluteConstraints(160, 120, 190, -1));
        this.jComboBoxRCVirtMode.setName("jComboBoxRCVirtMode");
        this.jPanel17.add((Component)this.jComboBoxRCVirtMode, new AbsoluteConstraints(160, 20, 190, -1));
        this.jLabel67.setText(resourceMap.getString("jLabel67.text", new Object[0]));
        this.jLabel67.setName("jLabel67");
        this.jPanel17.add((Component)this.jLabel67, new AbsoluteConstraints(20, 170, -1, -1));
        this.jComboBoxFCRollCh.setToolTipText(resourceMap.getString("comboBoxRcInputMappingRollState.toolTipText", new Object[0]));
        this.jComboBoxFCRollCh.setName("jComboBoxFCRollCh");
        this.jPanel17.add((Component)this.jComboBoxFCRollCh, new AbsoluteConstraints(160, 150, 190, -1));
        this.jLabel71.setText(resourceMap.getString("jLabel71.text", new Object[0]));
        this.jLabel71.setName("jLabel71");
        this.jPanel17.add((Component)this.jLabel71, new AbsoluteConstraints(20, 150, -1, -1));
        this.jComboBoxFCPitchCh.setToolTipText(resourceMap.getString("comboBoxRcInputMappingRollState.toolTipText", new Object[0]));
        this.jComboBoxFCPitchCh.setName("jComboBoxFCPitchCh");
        this.jPanel17.add((Component)this.jComboBoxFCPitchCh, new AbsoluteConstraints(160, 170, 190, -1));
        this.jPanel32.add((Component)this.jPanel17, new AbsoluteConstraints(10, 10, 370, 210));
        this.jPanel18.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupCommandAssignment.border.title", new Object[0])));
        this.jPanel18.setName("groupCommandAssignment");
        this.jPanel18.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanelRCCmd.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanelRCCmd.setToolTipText(resourceMap.getString("panelCommandAssignment.toolTipText", new Object[0]));
        this.jPanelRCCmd.setName("panelCommandAssignment");
        this.jPanelRCCmd.setLayout(new BoxLayout(this.jPanelRCCmd, 2));
        this.jPanel18.add((Component)this.jPanelRCCmd, new AbsoluteConstraints(16, 20, 300, 20));
        this.jLabel29.setText(resourceMap.getString("labelCommandAssignmentLow.text", new Object[0]));
        this.jLabel29.setName("labelCommandAssignmentLow");
        this.jPanel18.add((Component)this.jLabel29, new AbsoluteConstraints(20, 50, -1, -1));
        this.jComboBoxRCLowCmd.setToolTipText(resourceMap.getString("comboBoxCommandAssignmentLow.toolTipText", new Object[0]));
        this.jComboBoxRCLowCmd.setName("comboBoxCommandAssignmentLow");
        this.jPanel18.add((Component)this.jComboBoxRCLowCmd, new AbsoluteConstraints(90, 50, 230, -1));
        this.jLabel30.setText(resourceMap.getString("labelCommandAssignmentMid.text", new Object[0]));
        this.jLabel30.setName("labelCommandAssignmentMid");
        this.jPanel18.add((Component)this.jLabel30, new AbsoluteConstraints(20, 70, -1, -1));
        this.jComboBoxRCMidCmd.setToolTipText(resourceMap.getString("comboBoxCommandAssignmentMid.toolTipText", new Object[0]));
        this.jComboBoxRCMidCmd.setName("comboBoxCommandAssignmentMid");
        this.jPanel18.add((Component)this.jComboBoxRCMidCmd, new AbsoluteConstraints(90, 70, 230, -1));
        this.jLabel31.setText(resourceMap.getString("labelCommandAssignmentHigh.text", new Object[0]));
        this.jLabel31.setName("labelCommandAssignmentHigh");
        this.jPanel18.add((Component)this.jLabel31, new AbsoluteConstraints(20, 90, -1, -1));
        this.jComboBoxRCHighCmd.setToolTipText(resourceMap.getString("comboBoxCommandAssignmentHigh.toolTipText", new Object[0]));
        this.jComboBoxRCHighCmd.setName("comboBoxCommandAssignmentHigh");
        this.jPanel18.add((Component)this.jComboBoxRCHighCmd, new AbsoluteConstraints(90, 90, 230, -1));
        this.jPanel32.add((Component)this.jPanel18, new AbsoluteConstraints(380, 10, 330, 130));
        this.jPanel20.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupRcSettings.border.title", new Object[0])));
        this.jPanel20.setName("groupRcSettings");
        this.jPanel20.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel32.setHorizontalAlignment(0);
        this.jLabel32.setText(resourceMap.getString("labelRcSettingsMinAngle.text", new Object[0]));
        this.jLabel32.setName("labelRcSettingsMinAngle");
        this.jPanel20.add((Component)this.jLabel32, new AbsoluteConstraints(270, 40, 90, -1));
        this.jLabel33.setText(resourceMap.getString("labelRcSettingsRoll.text", new Object[0]));
        this.jLabel33.setName("labelRcSettingsRoll");
        this.jPanel20.add((Component)this.jLabel33, new AbsoluteConstraints(20, 60, -1, -1));
        this.jSpinnerRCRollMin.setModel(new SpinnerNumberModel(0, -720, 720, 1));
        this.jSpinnerRCRollMin.setToolTipText(resourceMap.getString("jSpinnerRCRollMin.toolTipText", new Object[0]));
        this.jSpinnerRCRollMin.setName("jSpinnerRCRollMin");
        this.jPanel20.add((Component)this.jSpinnerRCRollMin, new AbsoluteConstraints(290, 60, 50, -1));
        this.jLabel34.setHorizontalAlignment(0);
        this.jLabel34.setText(resourceMap.getString("labelRcSettingsMaxAngle.text", new Object[0]));
        this.jLabel34.setName("labelRcSettingsMaxAngle");
        this.jPanel20.add((Component)this.jLabel34, new AbsoluteConstraints(360, 40, 90, -1));
        this.jSpinnerRCRollMax.setModel(new SpinnerNumberModel(0, -720, 720, 1));
        this.jSpinnerRCRollMax.setToolTipText(resourceMap.getString("jSpinnerRCRollMax.toolTipText", new Object[0]));
        this.jSpinnerRCRollMax.setName("jSpinnerRCRollMax");
        this.jPanel20.add((Component)this.jSpinnerRCRollMax, new AbsoluteConstraints(380, 60, 50, -1));
        this.jLabel35.setHorizontalAlignment(0);
        this.jLabel35.setText(resourceMap.getString("labelRcSettingsNormal.text", new Object[0]));
        this.jLabel35.setVerticalAlignment(3);
        this.jLabel35.setName("labelRcSettingsNormal");
        this.jPanel20.add((Component)this.jLabel35, new AbsoluteConstraints(50, 20, 70, 34));
        this.buttonGroupRCRollMode.add(this.jRButtonRollModeAbs);
        this.jRButtonRollModeAbs.setText(resourceMap.getString("jRButtonRollModeAbs.text", new Object[0]));
        this.jRButtonRollModeAbs.setToolTipText(resourceMap.getString("jRButtonRollModeAbs.toolTipText", new Object[0]));
        this.jRButtonRollModeAbs.setName("jRButtonRollModeAbs");
        this.jPanel20.add((Component)this.jRButtonRollModeAbs, new AbsoluteConstraints(70, 60, -1, -1));
        this.jLabel37.setHorizontalAlignment(0);
        this.jLabel37.setText(resourceMap.getString("labelRcSettingsIncMode.text", new Object[0]));
        this.jLabel37.setVerticalAlignment(3);
        this.jLabel37.setName("labelRcSettingsIncMode");
        this.jPanel20.add((Component)this.jLabel37, new AbsoluteConstraints(120, 20, 70, 34));
        this.buttonGroupRCRollMode.add(this.jRButtonRollModeInc);
        this.jRButtonRollModeInc.setText(resourceMap.getString("jRButtonRollModeInc.text", new Object[0]));
        this.jRButtonRollModeInc.setToolTipText(resourceMap.getString("jRButtonRollModeInc.toolTipText", new Object[0]));
        this.jRButtonRollModeInc.setName("jRButtonRollModeInc");
        this.jPanel20.add((Component)this.jRButtonRollModeInc, new AbsoluteConstraints(140, 60, -1, -1));
        this.jLabel38.setHorizontalAlignment(0);
        this.jLabel38.setText(resourceMap.getString("labelRcSettingsLpfSpd.text", new Object[0]));
        this.jLabel38.setName("labelRcSettingsLpfSpd");
        this.jPanel20.add((Component)this.jLabel38, new AbsoluteConstraints(550, 40, 50, -1));
        this.jSpinnerRCRollLPF.setModel(SimpleBGC_GUIView.spinnerModel_16u());
        this.jSpinnerRCRollLPF.setToolTipText(resourceMap.getString("jSpinnerRCRollLPF.toolTipText", new Object[0]));
        this.jSpinnerRCRollLPF.setName("jSpinnerRCRollLPF");
        this.jPanel20.add((Component)this.jSpinnerRCRollLPF, new AbsoluteConstraints(550, 60, 50, -1));
        this.jLabel40.setText(resourceMap.getString("labelRcSettingsPitch.text", new Object[0]));
        this.jLabel40.setName("labelRcSettingsPitch");
        this.jPanel20.add((Component)this.jLabel40, new AbsoluteConstraints(20, 90, -1, -1));
        this.jSpinnerRCPitchMin.setModel(new SpinnerNumberModel(0, -720, 720, 1));
        this.jSpinnerRCPitchMin.setToolTipText(resourceMap.getString("jSpinnerRCRollMin.toolTipText", new Object[0]));
        this.jSpinnerRCPitchMin.setName("jSpinnerRCPitchMin");
        this.jPanel20.add((Component)this.jSpinnerRCPitchMin, new AbsoluteConstraints(290, 90, 50, -1));
        this.jLabel41.setText(resourceMap.getString("labelRcSettingsYaw.text", new Object[0]));
        this.jLabel41.setName("labelRcSettingsYaw");
        this.jPanel20.add((Component)this.jLabel41, new AbsoluteConstraints(20, 120, -1, -1));
        this.jSpinnerRCYawMin.setModel(new SpinnerNumberModel(0, -720, 720, 1));
        this.jSpinnerRCYawMin.setToolTipText(resourceMap.getString("jSpinnerRCRollMin.toolTipText", new Object[0]));
        this.jSpinnerRCYawMin.setName("jSpinnerRCYawMin");
        this.jPanel20.add((Component)this.jSpinnerRCYawMin, new AbsoluteConstraints(290, 120, 50, -1));
        this.jSpinnerRCPitchMax.setModel(new SpinnerNumberModel(0, -720, 720, 1));
        this.jSpinnerRCPitchMax.setToolTipText(resourceMap.getString("jSpinnerRCRollMax.toolTipText", new Object[0]));
        this.jSpinnerRCPitchMax.setName("jSpinnerRCPitchMax");
        this.jPanel20.add((Component)this.jSpinnerRCPitchMax, new AbsoluteConstraints(380, 90, 50, -1));
        this.buttonGroupRCPitchMode.add(this.jRButtonPitchModeAbs);
        this.jRButtonPitchModeAbs.setToolTipText(resourceMap.getString("jRButtonRollModeAbs.toolTipText", new Object[0]));
        this.jRButtonPitchModeAbs.setName("jRButtonPitchModeAbs");
        this.jPanel20.add((Component)this.jRButtonPitchModeAbs, new AbsoluteConstraints(70, 90, -1, -1));
        this.buttonGroupRCPitchMode.add(this.jRButtonPitchModeInc);
        this.jRButtonPitchModeInc.setToolTipText(resourceMap.getString("jRButtonRollModeInc.toolTipText", new Object[0]));
        this.jRButtonPitchModeInc.setName("jRButtonPitchModeInc");
        this.jPanel20.add((Component)this.jRButtonPitchModeInc, new AbsoluteConstraints(140, 90, -1, -1));
        this.jSpinnerRCPitchLPF.setModel(SimpleBGC_GUIView.spinnerModel_16u());
        this.jSpinnerRCPitchLPF.setToolTipText(resourceMap.getString("jSpinnerRCRollLPF.toolTipText", new Object[0]));
        this.jSpinnerRCPitchLPF.setName("jSpinnerRCPitchLPF");
        this.jPanel20.add((Component)this.jSpinnerRCPitchLPF, new AbsoluteConstraints(550, 90, 50, -1));
        this.jSpinnerRCYawMax.setModel(new SpinnerNumberModel(0, -720, 720, 1));
        this.jSpinnerRCYawMax.setToolTipText(resourceMap.getString("jSpinnerRCRollMax.toolTipText", new Object[0]));
        this.jSpinnerRCYawMax.setName("jSpinnerRCYawMax");
        this.jPanel20.add((Component)this.jSpinnerRCYawMax, new AbsoluteConstraints(380, 120, 50, -1));
        this.buttonGroupRCYawMode.add(this.jRButtonYawModeAbs);
        this.jRButtonYawModeAbs.setToolTipText(resourceMap.getString("jRButtonRollModeAbs.toolTipText", new Object[0]));
        this.jRButtonYawModeAbs.setName("jRButtonYawModeAbs");
        this.jPanel20.add((Component)this.jRButtonYawModeAbs, new AbsoluteConstraints(70, 120, -1, -1));
        this.buttonGroupRCYawMode.add(this.jRButtonYawModeInc);
        this.jRButtonYawModeInc.setToolTipText(resourceMap.getString("jRButtonRollModeInc.toolTipText", new Object[0]));
        this.jRButtonYawModeInc.setName("jRButtonYawModeInc");
        this.jPanel20.add((Component)this.jRButtonYawModeInc, new AbsoluteConstraints(140, 120, -1, -1));
        this.jSpinnerRCYawLPF.setModel(SimpleBGC_GUIView.spinnerModel_16u());
        this.jSpinnerRCYawLPF.setToolTipText(resourceMap.getString("jSpinnerRCRollLPF.toolTipText", new Object[0]));
        this.jSpinnerRCYawLPF.setName("jSpinnerRCYawLPF");
        this.jPanel20.add((Component)this.jSpinnerRCYawLPF, new AbsoluteConstraints(550, 120, 50, -1));
        this.jLabel43.setHorizontalAlignment(0);
        this.jLabel43.setText(resourceMap.getString("jLabel43.text", new Object[0]));
        this.jLabel43.setName("jLabel43");
        this.jPanel20.add((Component)this.jLabel43, new AbsoluteConstraints(450, 40, 100, -1));
        this.jSpinnerRCRollSpeed.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerRCRollSpeed.setToolTipText(resourceMap.getString("jSpinnerRCRollSpeed.toolTipText", new Object[0]));
        this.jSpinnerRCRollSpeed.setName("jSpinnerRCRollSpeed");
        this.jPanel20.add((Component)this.jSpinnerRCRollSpeed, new AbsoluteConstraints(470, 60, 50, -1));
        this.jSpinnerRCPitchSpeed.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerRCPitchSpeed.setToolTipText(resourceMap.getString("jSpinnerRCRollSpeed.toolTipText", new Object[0]));
        this.jSpinnerRCPitchSpeed.setName("jSpinnerRCPitchSpeed");
        this.jPanel20.add((Component)this.jSpinnerRCPitchSpeed, new AbsoluteConstraints(470, 90, 50, -1));
        this.jSpinnerRCYawSpeed.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerRCYawSpeed.setToolTipText(resourceMap.getString("jSpinnerRCRollSpeed.toolTipText", new Object[0]));
        this.jSpinnerRCYawSpeed.setName("jSpinnerRCYawSpeed");
        this.jPanel20.add((Component)this.jSpinnerRCYawSpeed, new AbsoluteConstraints(470, 120, 50, -1));
        this.jLabel87.setHorizontalAlignment(0);
        this.jLabel87.setText(resourceMap.getString("jLabel87.text", new Object[0]));
        this.jLabel87.setVerticalAlignment(3);
        this.jLabel87.setName("jLabel87");
        this.jPanel20.add((Component)this.jLabel87, new AbsoluteConstraints(610, 20, 90, 34));
        this.jSpinnerRCYawMemory.setModel(new SpinnerNumberModel(0.0, -360.0, 360.0, 0.01f));
        this.jSpinnerRCYawMemory.setToolTipText(resourceMap.getString("jSpinnerRCRollMemory.toolTipText", new Object[0]));
        this.jSpinnerRCYawMemory.setName("jSpinnerRCYawMemory");
        this.jPanel20.add((Component)this.jSpinnerRCYawMemory, new AbsoluteConstraints(630, 120, 50, -1));
        this.jSpinnerRCRollMemory.setModel(new SpinnerNumberModel(0.0, -360.0, 360.0, 0.01f));
        this.jSpinnerRCRollMemory.setToolTipText(resourceMap.getString("jSpinnerRCRollMemory.toolTipText", new Object[0]));
        this.jSpinnerRCRollMemory.setName("jSpinnerRCRollMemory");
        this.jPanel20.add((Component)this.jSpinnerRCRollMemory, new AbsoluteConstraints(630, 60, 50, -1));
        this.jSpinnerRCPitchMemory.setModel(new SpinnerNumberModel(0.0, -360.0, 360.0, 0.01f));
        this.jSpinnerRCPitchMemory.setToolTipText(resourceMap.getString("jSpinnerRCRollMemory.toolTipText", new Object[0]));
        this.jSpinnerRCPitchMemory.setName("jSpinnerRCPitchMemory");
        this.jPanel20.add((Component)this.jSpinnerRCPitchMemory, new AbsoluteConstraints(630, 90, 50, -1));
        this.jLabelRCInverse.setHorizontalAlignment(0);
        this.jLabelRCInverse.setText(resourceMap.getString("jLabelRCInverse.text", new Object[0]));
        this.jLabelRCInverse.setName("jLabelRCInverse");
        this.jPanel20.add((Component)this.jLabelRCInverse, new AbsoluteConstraints(190, 40, 80, -1));
        this.jCheckBoxRCRollInverse.setText(resourceMap.getString("jCheckBoxRCRollInverse.text", new Object[0]));
        this.jCheckBoxRCRollInverse.setName("jCheckBoxRCRollInverse");
        this.jPanel20.add((Component)this.jCheckBoxRCRollInverse, new AbsoluteConstraints(210, 60, -1, -1));
        this.jCheckBoxRCPitchInverse.setName("jCheckBoxRCPitchInverse");
        this.jPanel20.add((Component)this.jCheckBoxRCPitchInverse, new AbsoluteConstraints(210, 90, -1, -1));
        this.jCheckBoxRCYawInverse.setName("jCheckBoxRCYawInverse");
        this.jPanel20.add((Component)this.jCheckBoxRCYawInverse, new AbsoluteConstraints(210, 120, -1, -1));
        this.jPanel32.add((Component)this.jPanel20, new AbsoluteConstraints(10, 220, 700, 160));
        this.jPanelMixChannels.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelMixChannels.border.title", new Object[0])));
        this.jPanelMixChannels.setName("jPanelMixChannels");
        this.jPanelMixChannels.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel72.setText(resourceMap.getString("jLabel72.text", new Object[0]));
        this.jLabel72.setName("jLabel72");
        this.jPanelMixChannels.add((Component)this.jLabel72, new AbsoluteConstraints(20, 23, -1, -1));
        this.jLabel73.setText(resourceMap.getString("jLabel73.text", new Object[0]));
        this.jLabel73.setName("jLabel73");
        this.jPanelMixChannels.add((Component)this.jLabel73, new AbsoluteConstraints(20, 43, -1, -1));
        this.jComboBoxMixPitch.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "ROLL", "PITCH", "YAW"}));
        this.jComboBoxMixPitch.setName("jComboBoxMixPitch");
        this.jPanelMixChannels.add((Component)this.jComboBoxMixPitch, new AbsoluteConstraints(90, 40, 140, -1));
        this.jComboBoxMixRoll.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "ROLL", "PITCH", "YAW"}));
        this.jComboBoxMixRoll.setName("jComboBoxMixRoll");
        this.jPanelMixChannels.add((Component)this.jComboBoxMixRoll, new AbsoluteConstraints(90, 20, 140, -1));
        this.jLabel74.setText(resourceMap.getString("jLabel74.text", new Object[0]));
        this.jLabel74.setName("jLabel74");
        this.jPanelMixChannels.add((Component)this.jLabel74, new AbsoluteConstraints(310, 40, -1, -1));
        this.jLabel75.setText(resourceMap.getString("jLabel75.text", new Object[0]));
        this.jLabel75.setName("jLabel75");
        this.jPanelMixChannels.add((Component)this.jLabel75, new AbsoluteConstraints(310, 20, -1, -1));
        this.jSpinnerMixPitch.setModel(SimpleBGC_GUIView.spinnerModel_100u());
        this.jSpinnerMixPitch.setName("jSpinnerMixPitch");
        this.jPanelMixChannels.add((Component)this.jSpinnerMixPitch, new AbsoluteConstraints(240, 40, 60, -1));
        this.jSpinnerMixRoll.setModel(SimpleBGC_GUIView.spinnerModel_100u());
        this.jSpinnerMixRoll.setName("jSpinnerMixRoll");
        this.jPanelMixChannels.add((Component)this.jSpinnerMixRoll, new AbsoluteConstraints(240, 20, 60, -1));
        this.jPanel32.add((Component)this.jPanelMixChannels, new AbsoluteConstraints(380, 140, 330, 80));
        this.jPanelRCSubtrim.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelRCSubtrim.border.title", new Object[0])));
        this.jPanelRCSubtrim.setName("jPanelRCSubtrim");
        this.jPanelRCSubtrim.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel56.setText(resourceMap.getString("jLabel56.text", new Object[0]));
        this.jLabel56.setName("jLabel56");
        this.jPanelRCSubtrim.add((Component)this.jLabel56, new AbsoluteConstraints(20, 30, 80, -1));
        this.jLabel57.setText(resourceMap.getString("jLabel57.text", new Object[0]));
        this.jLabel57.setName("jLabel57");
        this.jPanelRCSubtrim.add((Component)this.jLabel57, new AbsoluteConstraints(20, 60, 80, -1));
        this.jLabel58.setText(resourceMap.getString("jLabel58.text", new Object[0]));
        this.jLabel58.setName("jLabel58");
        this.jPanelRCSubtrim.add((Component)this.jLabel58, new AbsoluteConstraints(20, 90, 80, -1));
        this.jSpinnerExpoRate.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.jSpinnerExpoRate.setToolTipText(resourceMap.getString("jSpinnerExpoRate.toolTipText", new Object[0]));
        this.jSpinnerExpoRate.setName("jSpinnerExpoRate");
        this.jSpinnerExpoRate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimpleBGC_GUIView.this.jSpinnerExpoRateStateChanged(evt);
            }
        });
        this.jPanelRCSubtrim.add((Component)this.jSpinnerExpoRate, new AbsoluteConstraints(100, 120, 50, -1));
        this.jSpinnerDeadband.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerDeadband.setToolTipText(resourceMap.getString("jSpinnerDeadband.toolTipText", new Object[0]));
        this.jSpinnerDeadband.setName("jSpinnerDeadband");
        this.jSpinnerDeadband.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimpleBGC_GUIView.this.jSpinnerDeadbandStateChanged(evt);
            }
        });
        this.jPanelRCSubtrim.add((Component)this.jSpinnerDeadband, new AbsoluteConstraints(100, 170, 50, -1));
        this.jSpinnerTrimPitch.setModel(SimpleBGC_GUIView.spinnerModel_127s());
        this.jSpinnerTrimPitch.setToolTipText(resourceMap.getString("jSpinnerTrimRoll.toolTipText", new Object[0]));
        this.jSpinnerTrimPitch.setName("jSpinnerTrimPitch");
        this.jPanelRCSubtrim.add((Component)this.jSpinnerTrimPitch, new AbsoluteConstraints(100, 60, 50, -1));
        this.jSpinnerTrimRoll.setModel(SimpleBGC_GUIView.spinnerModel_127s());
        this.jSpinnerTrimRoll.setToolTipText(resourceMap.getString("jSpinnerTrimRoll.toolTipText", new Object[0]));
        this.jSpinnerTrimRoll.setName("jSpinnerTrimRoll");
        this.jPanelRCSubtrim.add((Component)this.jSpinnerTrimRoll, new AbsoluteConstraints(100, 30, 50, -1));
        this.jLabel59.setText(resourceMap.getString("jLabel59.text", new Object[0]));
        this.jLabel59.setName("jLabel59");
        this.jPanelRCSubtrim.add((Component)this.jLabel59, new AbsoluteConstraints(20, 150, -1, -1));
        this.jButtonAutoTrim.setAction(actionMap.get("buttonAutoTrim"));
        this.jButtonAutoTrim.setText(resourceMap.getString("jButtonAutoTrim.text", new Object[0]));
        this.jButtonAutoTrim.setToolTipText(resourceMap.getString("jButtonAutoTrim.toolTipText", new Object[0]));
        this.jButtonAutoTrim.setName("jButtonAutoTrim");
        this.jPanelRCSubtrim.add((Component)this.jButtonAutoTrim, new AbsoluteConstraints(160, 30, -1, -1));
        this.jLabel61.setText(resourceMap.getString("jLabel61.text", new Object[0]));
        this.jLabel61.setName("jLabel61");
        this.jPanelRCSubtrim.add((Component)this.jLabel61, new AbsoluteConstraints(20, 120, -1, -1));
        this.jSpinnerTrimYaw.setModel(SimpleBGC_GUIView.spinnerModel_127s());
        this.jSpinnerTrimYaw.setToolTipText(resourceMap.getString("jSpinnerTrimRoll.toolTipText", new Object[0]));
        this.jSpinnerTrimYaw.setName("jSpinnerTrimYaw");
        this.jPanelRCSubtrim.add((Component)this.jSpinnerTrimYaw, new AbsoluteConstraints(100, 90, 50, -1));
        this.jPanelExpoCurve.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelExpoCurve.setToolTipText(resourceMap.getString("jPanelExpoCurve.toolTipText", new Object[0]));
        this.jPanelExpoCurve.setName("jPanelExpoCurve");
        this.jPanelExpoCurve.setLayout(new BoxLayout(this.jPanelExpoCurve, 2));
        this.jPanelRCSubtrim.add((Component)this.jPanelExpoCurve, new AbsoluteConstraints(170, 90, 190, 100));
        this.jLabelADCAutoDetection.setText(resourceMap.getString("jLabelADCAutoDetection.text", new Object[0]));
        this.jLabelADCAutoDetection.setName("jLabelADCAutoDetection");
        this.jPanelRCSubtrim.add((Component)this.jLabelADCAutoDetection, new AbsoluteConstraints(20, 205, -1, -1));
        this.jCheckBoxADC2Auto.setText(resourceMap.getString("jCheckBoxADC2Auto.text", new Object[0]));
        this.jCheckBoxADC2Auto.setName("jCheckBoxADC2Auto");
        this.jPanelRCSubtrim.add((Component)this.jCheckBoxADC2Auto, new AbsoluteConstraints(250, 200, -1, -1));
        this.jCheckBoxADC1Auto.setText(resourceMap.getString("jCheckBoxADC1Auto.text", new Object[0]));
        this.jCheckBoxADC1Auto.setName("jCheckBoxADC1Auto");
        this.jPanelRCSubtrim.add((Component)this.jCheckBoxADC1Auto, new AbsoluteConstraints(190, 200, -1, -1));
        this.jCheckBoxADC3Auto.setText(resourceMap.getString("jCheckBoxADC3Auto.text", new Object[0]));
        this.jCheckBoxADC3Auto.setName("jCheckBoxADC3Auto");
        this.jPanelRCSubtrim.add((Component)this.jCheckBoxADC3Auto, new AbsoluteConstraints(310, 200, -1, -1));
        this.jPanel32.add((Component)this.jPanelRCSubtrim, new AbsoluteConstraints(10, 380, 380, 260));
        this.jPanelRCOther.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelRCOther.border.title", new Object[0])));
        this.jPanelRCOther.setName("jPanelRCOther");
        this.jPanelRCOther.setLayout((LayoutManager)new AbsoluteLayout());
        this.jCheckBoxAngleAccLimit.setText(resourceMap.getString("jCheckBoxAngleAccLimit.text", new Object[0]));
        this.jCheckBoxAngleAccLimit.setName("jCheckBoxAngleAccLimit");
        this.jCheckBoxAngleAccLimit.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimpleBGC_GUIView.this.jCheckBoxAngleAccLimitStateChanged(evt);
            }
        });
        this.jPanelRCOther.add((Component)this.jCheckBoxAngleAccLimit, new AbsoluteConstraints(10, 30, -1, -1));
        this.jSpinnerAngleAccLimit.setModel(new SpinnerNumberModel(5, 0, 1000, 5));
        this.jSpinnerAngleAccLimit.setEnabled(false);
        this.jSpinnerAngleAccLimit.setName("jSpinnerAngleAccLimit");
        this.jPanelRCOther.add((Component)this.jSpinnerAngleAccLimit, new AbsoluteConstraints(160, 30, 70, -1));
        this.jLabel76.setText(resourceMap.getString("jLabel76.text", new Object[0]));
        this.jLabel76.setName("jLabel76");
        this.jPanelRCOther.add((Component)this.jLabel76, new AbsoluteConstraints(240, 30, -1, 20));
        this.jPanel32.add((Component)this.jPanelRCOther, new AbsoluteConstraints(390, 570, 320, 70));
        this.jPanelRCOutput.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelRCOutput.border.title", new Object[0])));
        this.jPanelRCOutput.setToolTipText(resourceMap.getString("jPanelRCOutput.toolTipText", new Object[0]));
        this.jPanelRCOutput.setName("jPanelRCOutput");
        this.jPanelRCOutput.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel101.setText(resourceMap.getString("jLabel101.text", new Object[0]));
        this.jLabel101.setName("jLabel101");
        this.jPanelRCOutput.add((Component)this.jLabel101, new AbsoluteConstraints(20, 30, -1, -1));
        this.jComboBoxRCOut1.setToolTipText(resourceMap.getString("jPanelRCOutput.toolTipText", new Object[0]));
        this.jComboBoxRCOut1.setName("jComboBoxRCOut1");
        this.jPanelRCOutput.add((Component)this.jComboBoxRCOut1, new AbsoluteConstraints(100, 30, 200, -1));
        this.jComboBoxRCOut2.setToolTipText(resourceMap.getString("jPanelRCOutput.toolTipText", new Object[0]));
        this.jComboBoxRCOut2.setName("jComboBoxRCOut2");
        this.jPanelRCOutput.add((Component)this.jComboBoxRCOut2, new AbsoluteConstraints(100, 60, 200, -1));
        this.jLabel102.setText(resourceMap.getString("jLabel102.text", new Object[0]));
        this.jLabel102.setName("jLabel102");
        this.jPanelRCOutput.add((Component)this.jLabel102, new AbsoluteConstraints(20, 60, -1, -1));
        this.jComboBoxRCOut3.setToolTipText(resourceMap.getString("jPanelRCOutput.toolTipText", new Object[0]));
        this.jComboBoxRCOut3.setName("jComboBoxRCOut3");
        this.jPanelRCOutput.add((Component)this.jComboBoxRCOut3, new AbsoluteConstraints(100, 90, 200, -1));
        this.jLabel103.setText(resourceMap.getString("jLabel103.text", new Object[0]));
        this.jLabel103.setName("jLabel103");
        this.jPanelRCOutput.add((Component)this.jLabel103, new AbsoluteConstraints(20, 90, -1, -1));
        this.jComboBoxRCOut4.setToolTipText(resourceMap.getString("jPanelRCOutput.toolTipText", new Object[0]));
        this.jComboBoxRCOut4.setName("jComboBoxRCOut4");
        this.jPanelRCOutput.add((Component)this.jComboBoxRCOut4, new AbsoluteConstraints(100, 120, 200, -1));
        this.jLabel104.setText(resourceMap.getString("jLabel104.text", new Object[0]));
        this.jLabel104.setName("jLabel104");
        this.jPanelRCOutput.add((Component)this.jLabel104, new AbsoluteConstraints(20, 120, -1, -1));
        this.jLabel105.setText(resourceMap.getString("jLabel105.text", new Object[0]));
        this.jLabel105.setName("jLabel105");
        this.jPanelRCOutput.add((Component)this.jLabel105, new AbsoluteConstraints(20, 160, -1, -1));
        this.jSpinnerRCOutRate.setModel(new SpinnerNumberModel(50, 50, 400, 10));
        this.jSpinnerRCOutRate.setToolTipText(resourceMap.getString("jSpinnerRCOutRate.toolTipText", new Object[0]));
        this.jSpinnerRCOutRate.setName("jSpinnerRCOutRate");
        this.jPanelRCOutput.add((Component)this.jSpinnerRCOutRate, new AbsoluteConstraints(250, 150, 50, -1));
        this.jPanel32.add((Component)this.jPanelRCOutput, new AbsoluteConstraints(390, 380, 320, 190));
        this.jScrollPaneRC.setViewportView(this.jPanel32);
        this.panelRC.add(this.jScrollPaneRC);
        this.tabbedPaneMain.addTab(resourceMap.getString("panelRcSettings.TabConstraints.tabTitle", new Object[0]), this.panelRC);
        this.panelService.setName("panelMenuButton");
        this.panelService.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel27.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("panelMenuButton.TabConstraints.tabTitle", new Object[0])));
        this.jPanel27.setName("jPanel27");
        this.jPanel27.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel52.setText(resourceMap.getString("jLabel52.text", new Object[0]));
        this.jLabel52.setName("jLabel52");
        this.jPanel27.add((Component)this.jLabel52, new AbsoluteConstraints(110, 20, -1, -1));
        this.jLabel46.setHorizontalAlignment(4);
        this.jLabel46.setText(resourceMap.getString("jLabel46.text", new Object[0]));
        this.jLabel46.setName("jLabel46");
        this.jPanel27.add((Component)this.jLabel46, new AbsoluteConstraints(-20, 40, 120, -1));
        this.jComboBoxMenu1.setToolTipText(resourceMap.getString("jComboBoxMenu1.toolTipText", new Object[0]));
        this.jComboBoxMenu1.setName("jComboBoxMenu1");
        this.jPanel27.add((Component)this.jComboBoxMenu1, new AbsoluteConstraints(110, 40, 256, -1));
        this.jComboBoxMenu2.setName("jComboBoxMenu2");
        this.jPanel27.add((Component)this.jComboBoxMenu2, new AbsoluteConstraints(110, 70, 256, -1));
        this.jLabel47.setHorizontalAlignment(4);
        this.jLabel47.setText(resourceMap.getString("jLabel47.text", new Object[0]));
        this.jLabel47.setName("jLabel47");
        this.jPanel27.add((Component)this.jLabel47, new AbsoluteConstraints(-20, 70, 120, -1));
        this.jComboBoxMenu3.setName("jComboBoxMenu3");
        this.jPanel27.add((Component)this.jComboBoxMenu3, new AbsoluteConstraints(110, 100, 256, -1));
        this.jLabel48.setHorizontalAlignment(4);
        this.jLabel48.setText(resourceMap.getString("jLabel48.text", new Object[0]));
        this.jLabel48.setName("jLabel48");
        this.jPanel27.add((Component)this.jLabel48, new AbsoluteConstraints(-20, 100, 120, -1));
        this.jLabel49.setHorizontalAlignment(4);
        this.jLabel49.setText(resourceMap.getString("jLabel49.text", new Object[0]));
        this.jLabel49.setName("jLabel49");
        this.jPanel27.add((Component)this.jLabel49, new AbsoluteConstraints(-20, 130, 120, -1));
        this.jComboBoxMenu4.setName("jComboBoxMenu4");
        this.jPanel27.add((Component)this.jComboBoxMenu4, new AbsoluteConstraints(110, 130, 256, -1));
        this.jLabel50.setHorizontalAlignment(4);
        this.jLabel50.setText(resourceMap.getString("jLabel50.text", new Object[0]));
        this.jLabel50.setName("jLabel50");
        this.jPanel27.add((Component)this.jLabel50, new AbsoluteConstraints(-20, 160, 120, -1));
        this.jComboBoxMenu5.setName("jComboBoxMenu5");
        this.jPanel27.add((Component)this.jComboBoxMenu5, new AbsoluteConstraints(110, 160, 256, -1));
        this.jLabel51.setHorizontalAlignment(4);
        this.jLabel51.setText(resourceMap.getString("jLabel51.text", new Object[0]));
        this.jLabel51.setName("jLabel51");
        this.jPanel27.add((Component)this.jLabel51, new AbsoluteConstraints(-20, 190, 120, -1));
        this.jComboBoxMenuLong.setName("jComboBoxMenuLong");
        this.jPanel27.add((Component)this.jComboBoxMenuLong, new AbsoluteConstraints(110, 190, 256, -1));
        this.jCheckBoxRememberLastUsedProfile.setText(resourceMap.getString("jCheckBoxRememberLastUsedProfile.text", new Object[0]));
        this.jCheckBoxRememberLastUsedProfile.setName("jCheckBoxRememberLastUsedProfile");
        this.jPanel27.add((Component)this.jCheckBoxRememberLastUsedProfile, new AbsoluteConstraints(110, 220, -1, -1));
        this.panelService.add((Component)this.jPanel27, new AbsoluteConstraints(10, 10, 390, 260));
        this.jPanelBatControls.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelBatControls.border.title", new Object[0])));
        this.jPanelBatControls.setName("jPanelBatControls");
        this.jPanelBatControls.setLayout((LayoutManager)new AbsoluteLayout());
        this.jCheckBoxBatAlarm.setText(resourceMap.getString("jCheckBoxBatAlarm.text", new Object[0]));
        this.jCheckBoxBatAlarm.setName("jCheckBoxBatAlarm");
        this.jPanelBatControls.add((Component)this.jCheckBoxBatAlarm, new AbsoluteConstraints(10, 60, -1, -1));
        this.jLabelThreshold.setText(resourceMap.getString("jLabelThreshold.text", new Object[0]));
        this.jLabelThreshold.setName("jLabelThreshold");
        this.jPanelBatControls.add((Component)this.jLabelThreshold, new AbsoluteConstraints(30, 90, -1, -1));
        this.jSpinnerBatThresholdAlarm.setModel(SimpleBGC_GUIView.spinnerModel_5000f());
        this.jSpinnerBatThresholdAlarm.setName("jSpinnerBatThresholdAlarm");
        this.jPanelBatControls.add((Component)this.jSpinnerBatThresholdAlarm, new AbsoluteConstraints(220, 80, 60, -1));
        this.jCheckBoxBatMotors.setText(resourceMap.getString("jCheckBoxBatMotors.text", new Object[0]));
        this.jCheckBoxBatMotors.setName("jCheckBoxBatMotors");
        this.jPanelBatControls.add((Component)this.jCheckBoxBatMotors, new AbsoluteConstraints(10, 110, -1, -1));
        this.jLabel68.setText(resourceMap.getString("jLabelThreshold.text", new Object[0]));
        this.jLabel68.setName("jLabel68");
        this.jPanelBatControls.add((Component)this.jLabel68, new AbsoluteConstraints(30, 140, -1, -1));
        this.jSpinnerBatThresholdMotors.setModel(SimpleBGC_GUIView.spinnerModel_5000f());
        this.jSpinnerBatThresholdMotors.setName("jSpinnerBatThresholdMotors");
        this.jPanelBatControls.add((Component)this.jSpinnerBatThresholdMotors, new AbsoluteConstraints(220, 130, 60, -1));
        this.jCheckBoxBatComp.setText(resourceMap.getString("jCheckBoxBatComp.text", new Object[0]));
        this.jCheckBoxBatComp.setName("jCheckBoxBatComp");
        this.jPanelBatControls.add((Component)this.jCheckBoxBatComp, new AbsoluteConstraints(10, 160, -1, -1));
        this.jLabel69.setText(resourceMap.getString("jLabel69.text", new Object[0]));
        this.jLabel69.setName("jLabel69");
        this.jPanelBatControls.add((Component)this.jLabel69, new AbsoluteConstraints(30, 190, -1, -1));
        this.jSpinnerBatCompRef.setModel(SimpleBGC_GUIView.spinnerModel_5000f());
        this.jSpinnerBatCompRef.setName("jSpinnerBatCompRef");
        this.jPanelBatControls.add((Component)this.jSpinnerBatCompRef, new AbsoluteConstraints(220, 180, 60, -1));
        this.jLabelBatVal.setFont(resourceMap.getFont("jLabelBatVal.font"));
        this.jLabelBatVal.setText("0.00 V");
        this.jLabelBatVal.setName("jLabelBatVal");
        this.jPanelBatControls.add((Component)this.jLabelBatVal, new AbsoluteConstraints(20, 30, -1, -1));
        this.jButtonBatCalibrate.setAction(actionMap.get("buttonBatCalibrate"));
        this.jButtonBatCalibrate.setText(resourceMap.getString("jButtonBatCalibrate.text", new Object[0]));
        this.jButtonBatCalibrate.setName("jButtonBatCalibrate");
        this.jPanelBatControls.add((Component)this.jButtonBatCalibrate, new AbsoluteConstraints(140, 30, 150, -1));
        this.jLabel70.setText(resourceMap.getString("jLabel70.text", new Object[0]));
        this.jLabel70.setName("jLabel70");
        this.jPanelBatControls.add((Component)this.jLabel70, new AbsoluteConstraints(10, 220, -1, -1));
        this.jComboBoxBatDefault.setName("jComboBoxBatDefault");
        this.jComboBoxBatDefault.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SimpleBGC_GUIView.this.jComboBoxBatDefaultItemStateChanged(evt);
            }
        });
        this.jPanelBatControls.add((Component)this.jComboBoxBatDefault, new AbsoluteConstraints(190, 220, 90, -1));
        this.panelService.add((Component)this.jPanelBatControls, new AbsoluteConstraints(410, 10, 310, 260));
        this.jPanel29.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel29.border.title", new Object[0])));
        this.jPanel29.setName("jPanel29");
        this.jPanel29.setLayout((LayoutManager)new AbsoluteLayout());
        this.jCheckBoxBeeperConfirm.setText(resourceMap.getString("jCheckBoxBeeperConfirm.text", new Object[0]));
        this.jCheckBoxBeeperConfirm.setName("jCheckBoxBeeperConfirm");
        this.jPanel29.add((Component)this.jCheckBoxBeeperConfirm, new AbsoluteConstraints(10, 20, -1, -1));
        this.jCheckBoxBeeperCalibration.setText(resourceMap.getString("jCheckBoxBeeperCalibration.text", new Object[0]));
        this.jCheckBoxBeeperCalibration.setName("jCheckBoxBeeperCalibration");
        this.jPanel29.add((Component)this.jCheckBoxBeeperCalibration, new AbsoluteConstraints(10, 40, -1, -1));
        this.jCheckBoxBeeperError.setText(resourceMap.getString("jCheckBoxBeeperError.text", new Object[0]));
        this.jCheckBoxBeeperError.setName("jCheckBoxBeeperError");
        this.jPanel29.add((Component)this.jCheckBoxBeeperError, new AbsoluteConstraints(250, 40, -1, -1));
        this.jCheckBoxBeeperAlarm.setText(resourceMap.getString("jCheckBoxBeeperAlarm.text", new Object[0]));
        this.jCheckBoxBeeperAlarm.setName("jCheckBoxBeeperAlarm");
        this.jPanel29.add((Component)this.jCheckBoxBeeperAlarm, new AbsoluteConstraints(250, 20, -1, -1));
        this.jCheckBoxBeepMotors.setText(resourceMap.getString("jCheckBoxBeepMotors.text", new Object[0]));
        this.jCheckBoxBeepMotors.setToolTipText(resourceMap.getString("jCheckBoxBeepMotors.toolTipText", new Object[0]));
        this.jCheckBoxBeepMotors.setName("jCheckBoxBeepMotors");
        this.jPanel29.add((Component)this.jCheckBoxBeepMotors, new AbsoluteConstraints(410, 20, -1, -1));
        this.panelService.add((Component)this.jPanel29, new AbsoluteConstraints(10, 270, 710, 70));
        this.tabbedPaneMain.addTab(resourceMap.getString("panelService.TabConstraints.tabTitle", new Object[0]), this.panelService);
        this.panelFollow.setName("panelFollow");
        this.panelFollow.setLayout((LayoutManager)new AbsoluteLayout());
        this.buttonGroupFollow.add(this.jRBFollowFC);
        this.jRBFollowFC.setText(resourceMap.getString("jRBFollowFC.text", new Object[0]));
        this.jRBFollowFC.setToolTipText(resourceMap.getString("jRBFollowFC.toolTipText", new Object[0]));
        this.jRBFollowFC.setName("jRBFollowFC");
        this.panelFollow.add((Component)this.jRBFollowFC, new AbsoluteConstraints(10, 80, -1, -1));
        this.buttonGroupFollow.add(this.jRBFollowPitch);
        this.jRBFollowPitch.setText(resourceMap.getString("jRBFollowPitch.text", new Object[0]));
        this.jRBFollowPitch.setToolTipText(resourceMap.getString("jRBFollowPitch.toolTipText", new Object[0]));
        this.jRBFollowPitch.setName("jRBFollowPitch");
        this.panelFollow.add((Component)this.jRBFollowPitch, new AbsoluteConstraints(10, 170, -1, -1));
        this.jLabel60.setText(resourceMap.getString("jLabel60.text", new Object[0]));
        this.jLabel60.setName("jLabel60");
        this.panelFollow.add((Component)this.jLabel60, new AbsoluteConstraints(50, 110, -1, -1));
        this.jLabel62.setText(resourceMap.getString("jLabel62.text", new Object[0]));
        this.jLabel62.setName("jLabel62");
        this.panelFollow.add((Component)this.jLabel62, new AbsoluteConstraints(50, 140, -1, -1));
        this.jSpinnerRCRollFollow.setModel(new SpinnerNumberModel(0, -127, 127, 1));
        this.jSpinnerRCRollFollow.setToolTipText(resourceMap.getString("jSpinnerRCRollFollow.toolTipText", new Object[0]));
        this.jSpinnerRCRollFollow.setName("jSpinnerRCRollFollow");
        this.panelFollow.add((Component)this.jSpinnerRCRollFollow, new AbsoluteConstraints(230, 110, 50, -1));
        this.jSpinnerRCPitchFollow.setModel(new SpinnerNumberModel(0, -127, 127, 1));
        this.jSpinnerRCPitchFollow.setToolTipText(resourceMap.getString("jSpinnerRCRollFollow.toolTipText", new Object[0]));
        this.jSpinnerRCPitchFollow.setName("jSpinnerRCPitchFollow");
        this.panelFollow.add((Component)this.jSpinnerRCPitchFollow, new AbsoluteConstraints(230, 140, 50, -1));
        this.jCheckBoxFollowYaw.setText(resourceMap.getString("jCheckBoxFollowYaw.text", new Object[0]));
        this.jCheckBoxFollowYaw.setToolTipText(resourceMap.getString("jCheckBoxFollowYaw.toolTipText", new Object[0]));
        this.jCheckBoxFollowYaw.setName("jCheckBoxFollowYaw");
        this.panelFollow.add((Component)this.jCheckBoxFollowYaw, new AbsoluteConstraints(10, 260, -1, -1));
        this.buttonGroupFollow.add(this.jRBFollowDisabled);
        this.jRBFollowDisabled.setText(resourceMap.getString("jRBFollowDisabled.text", new Object[0]));
        this.jRBFollowDisabled.setToolTipText(resourceMap.getString("jRBFollowDisabled.toolTipText", new Object[0]));
        this.jRBFollowDisabled.setName("jRBFollowDisabled");
        this.panelFollow.add((Component)this.jRBFollowDisabled, new AbsoluteConstraints(10, 20, -1, -1));
        this.jPanelFollowExpo.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelFollowExpo.setToolTipText(resourceMap.getString("jPanelFollowExpo.toolTipText", new Object[0]));
        this.jPanelFollowExpo.setName("jPanelFollowExpo");
        this.jPanelFollowExpo.setLayout(new BoxLayout(this.jPanelFollowExpo, 2));
        this.panelFollow.add((Component)this.jPanelFollowExpo, new AbsoluteConstraints(380, 80, 240, 110));
        this.jLabel64.setText(resourceMap.getString("jLabel64.text", new Object[0]));
        this.jLabel64.setName("jLabel64");
        this.panelFollow.add((Component)this.jLabel64, new AbsoluteConstraints(380, 50, -1, -1));
        this.jSpinnerFollowExpoRate.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.jSpinnerFollowExpoRate.setToolTipText(resourceMap.getString("jSpinnerFollowExpoRate.toolTipText", new Object[0]));
        this.jSpinnerFollowExpoRate.setName("jSpinnerFollowExpoRate");
        this.jSpinnerFollowExpoRate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimpleBGC_GUIView.this.jSpinnerFollowExpoRateStateChanged(evt);
            }
        });
        this.panelFollow.add((Component)this.jSpinnerFollowExpoRate, new AbsoluteConstraints(570, 50, 50, -1));
        this.jSpinnerFollowDeadband.setModel(new SpinnerNumberModel(0.0, 0.0, 20.0, 0.09999f));
        this.jSpinnerFollowDeadband.setToolTipText(resourceMap.getString("jSpinnerFollowDeadband.toolTipText", new Object[0]));
        this.jSpinnerFollowDeadband.setName("jSpinnerFollowDeadband");
        this.jSpinnerFollowDeadband.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimpleBGC_GUIView.this.jSpinnerFollowDeadbandStateChanged(evt);
            }
        });
        this.panelFollow.add((Component)this.jSpinnerFollowDeadband, new AbsoluteConstraints(570, 20, 50, -1));
        this.jLabel65.setText(resourceMap.getString("jLabel65.text", new Object[0]));
        this.jLabel65.setName("jLabel65");
        this.panelFollow.add((Component)this.jLabel65, new AbsoluteConstraints(380, 20, -1, -1));
        this.jSpinnerOffsetPitch.setModel(SimpleBGC_GUIView.spinnerModel_127s());
        this.jSpinnerOffsetPitch.setToolTipText(resourceMap.getString("jSpinnerOffsetPitch.toolTipText", new Object[0]));
        this.jSpinnerOffsetPitch.setName("jSpinnerOffsetPitch");
        this.panelFollow.add((Component)this.jSpinnerOffsetPitch, new AbsoluteConstraints(380, 260, 50, -1));
        this.jSpinnerOffsetYaw.setModel(SimpleBGC_GUIView.spinnerModel_127s());
        this.jSpinnerOffsetYaw.setToolTipText(resourceMap.getString("jSpinnerOffsetPitch.toolTipText", new Object[0]));
        this.jSpinnerOffsetYaw.setName("jSpinnerOffsetYaw");
        this.panelFollow.add((Component)this.jSpinnerOffsetYaw, new AbsoluteConstraints(380, 290, 50, -1));
        this.jButtonOffsetAuto.setAction(actionMap.get("buttonOffsetAuto"));
        this.jButtonOffsetAuto.setText(resourceMap.getString("jButtonOffsetAuto.text", new Object[0]));
        this.jButtonOffsetAuto.setToolTipText(resourceMap.getString("jButtonOffsetAuto.toolTipText", new Object[0]));
        this.jButtonOffsetAuto.setName("jButtonOffsetAuto");
        this.panelFollow.add((Component)this.jButtonOffsetAuto, new AbsoluteConstraints(440, 260, -1, -1));
        this.jLabel79.setText(resourceMap.getString("jLabel79.text", new Object[0]));
        this.jLabel79.setToolTipText(resourceMap.getString("jSpinnerFollowRollMixRange.toolTipText", new Object[0]));
        this.jLabel79.setName("jLabel79");
        this.panelFollow.add((Component)this.jLabel79, new AbsoluteConstraints(50, 230, -1, -1));
        this.jSpinnerFollowRollMixStart.setModel(new SpinnerNumberModel(0, 0, 90, 1));
        this.jSpinnerFollowRollMixStart.setToolTipText(resourceMap.getString("jSpinnerFollowRollMixStart.toolTipText", new Object[0]));
        this.jSpinnerFollowRollMixStart.setName("jSpinnerFollowRollMixStart");
        this.panelFollow.add((Component)this.jSpinnerFollowRollMixStart, new AbsoluteConstraints(230, 200, 50, -1));
        this.jLabel80.setText(resourceMap.getString("jLabel80.text", new Object[0]));
        this.jLabel80.setToolTipText(resourceMap.getString("jSpinnerFollowRollMixStart.toolTipText", new Object[0]));
        this.jLabel80.setName("jLabel80");
        this.panelFollow.add((Component)this.jLabel80, new AbsoluteConstraints(50, 200, -1, -1));
        this.jSpinnerFollowRollMixRange.setModel(new SpinnerNumberModel(0, 0, 90, 1));
        this.jSpinnerFollowRollMixRange.setToolTipText(resourceMap.getString("jSpinnerFollowRollMixRange.toolTipText", new Object[0]));
        this.jSpinnerFollowRollMixRange.setName("jSpinnerFollowRollMixRange");
        this.panelFollow.add((Component)this.jSpinnerFollowRollMixRange, new AbsoluteConstraints(230, 230, 50, -1));
        this.jLabel66.setHorizontalAlignment(0);
        this.jLabel66.setText(resourceMap.getString("jLabel43.text", new Object[0]));
        this.jLabel66.setName("jLabel66");
        this.panelFollow.add((Component)this.jLabel66, new AbsoluteConstraints(490, 210, 100, -1));
        this.jSpinnerFollowRollSpeed.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerFollowRollSpeed.setToolTipText(resourceMap.getString("jSpinnerFollowRollSpeed.toolTipText", new Object[0]));
        this.jSpinnerFollowRollSpeed.setName("jSpinnerFollowRollSpeed");
        this.panelFollow.add((Component)this.jSpinnerFollowRollSpeed, new AbsoluteConstraints(520, 230, 50, -1));
        this.jSpinnerFollowPitchSpeed.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerFollowPitchSpeed.setToolTipText(resourceMap.getString("jSpinnerFollowRollSpeed.toolTipText", new Object[0]));
        this.jSpinnerFollowPitchSpeed.setName("jSpinnerFollowPitchSpeed");
        this.panelFollow.add((Component)this.jSpinnerFollowPitchSpeed, new AbsoluteConstraints(520, 260, 50, -1));
        this.jSpinnerFollowYawSpeed.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerFollowYawSpeed.setToolTipText(resourceMap.getString("jSpinnerFollowRollSpeed.toolTipText", new Object[0]));
        this.jSpinnerFollowYawSpeed.setName("jSpinnerFollowYawSpeed");
        this.panelFollow.add((Component)this.jSpinnerFollowYawSpeed, new AbsoluteConstraints(520, 290, 50, -1));
        this.jLabel83.setText(resourceMap.getString("jLabel83.text", new Object[0]));
        this.jLabel83.setName("jLabel83");
        this.panelFollow.add((Component)this.jLabel83, new AbsoluteConstraints(320, 230, -1, -1));
        this.jLabel84.setText(resourceMap.getString("jLabel84.text", new Object[0]));
        this.jLabel84.setName("jLabel84");
        this.panelFollow.add((Component)this.jLabel84, new AbsoluteConstraints(320, 260, -1, -1));
        this.jLabel85.setText(resourceMap.getString("jLabel85.text", new Object[0]));
        this.jLabel85.setName("jLabel85");
        this.panelFollow.add((Component)this.jLabel85, new AbsoluteConstraints(320, 290, -1, -1));
        this.jLabelFollowOffset.setHorizontalAlignment(0);
        this.jLabelFollowOffset.setText(resourceMap.getString("jLabelFollowOffset.text", new Object[0]));
        this.jLabelFollowOffset.setName("jLabelFollowOffset");
        this.panelFollow.add((Component)this.jLabelFollowOffset, new AbsoluteConstraints(340, 210, 130, -1));
        this.jSpinnerOffsetRoll.setModel(SimpleBGC_GUIView.spinnerModel_127s());
        this.jSpinnerOffsetRoll.setToolTipText(resourceMap.getString("jSpinnerOffsetPitch.toolTipText", new Object[0]));
        this.jSpinnerOffsetRoll.setName("jSpinnerOffsetRoll");
        this.panelFollow.add((Component)this.jSpinnerOffsetRoll, new AbsoluteConstraints(380, 230, 50, -1));
        this.jCheckBoxFrameAngleFromMotors.setText(resourceMap.getString("jCheckBoxFrameAngleFromMotors.text", new Object[0]));
        this.jCheckBoxFrameAngleFromMotors.setToolTipText(resourceMap.getString("jCheckBoxFrameAngleFromMotors.toolTipText", new Object[0]));
        this.jCheckBoxFrameAngleFromMotors.setName("jCheckBoxFrameAngleFromMotors");
        this.panelFollow.add((Component)this.jCheckBoxFrameAngleFromMotors, new AbsoluteConstraints(50, 50, -1, -1));
        this.jSpinnerFollowRollLPF.setModel(SimpleBGC_GUIView.spinnerModel_16u());
        this.jSpinnerFollowRollLPF.setToolTipText(resourceMap.getString("jSpinnerFollowRollLPF.toolTipText", new Object[0]));
        this.jSpinnerFollowRollLPF.setName("jSpinnerFollowRollLPF");
        this.panelFollow.add((Component)this.jSpinnerFollowRollLPF, new AbsoluteConstraints(610, 230, 50, -1));
        this.jSpinnerFollowPitchLPF.setModel(SimpleBGC_GUIView.spinnerModel_16u());
        this.jSpinnerFollowPitchLPF.setToolTipText(resourceMap.getString("jSpinnerFollowRollLPF.toolTipText", new Object[0]));
        this.jSpinnerFollowPitchLPF.setName("jSpinnerFollowPitchLPF");
        this.panelFollow.add((Component)this.jSpinnerFollowPitchLPF, new AbsoluteConstraints(610, 260, 50, -1));
        this.jSpinnerFollowYawLPF.setModel(SimpleBGC_GUIView.spinnerModel_16u());
        this.jSpinnerFollowYawLPF.setToolTipText(resourceMap.getString("jSpinnerFollowRollLPF.toolTipText", new Object[0]));
        this.jSpinnerFollowYawLPF.setName("jSpinnerFollowYawLPF");
        this.panelFollow.add((Component)this.jSpinnerFollowYawLPF, new AbsoluteConstraints(610, 290, 50, -1));
        this.jLabelFollowLPF.setHorizontalAlignment(0);
        this.jLabelFollowLPF.setText(resourceMap.getString("labelRcSettingsLpfSpd.text", new Object[0]));
        this.jLabelFollowLPF.setName("jLabelFollowLPF");
        this.panelFollow.add((Component)this.jLabelFollowLPF, new AbsoluteConstraints(600, 210, 80, -1));
        this.tabbedPaneMain.addTab(resourceMap.getString("panelFollow.TabConstraints.tabTitle", new Object[0]), this.panelFollow);
        this.panelMonitoring.setName("panelRealtimeData");
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel11.setName("jPanel11");
        this.jPanel11.setLayout((LayoutManager)new AbsoluteLayout());
        this.jSpinnerFrameRate.setModel(new SpinnerNumberModel(20, 1, 50, 1));
        this.jSpinnerFrameRate.setName("jSpinnerFrameRate");
        this.jSpinnerFrameRate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimpleBGC_GUIView.this.jSpinnerFrameRateStateChanged(evt);
            }
        });
        this.jPanel11.add((Component)this.jSpinnerFrameRate, new AbsoluteConstraints(130, 10, -1, -1));
        this.jLabel15.setText(resourceMap.getString("jLabel15.text", new Object[0]));
        this.jLabel15.setName("jLabel15");
        this.jPanel11.add((Component)this.jLabel15, new AbsoluteConstraints(20, 10, -1, -1));
        this.jSliderScale.setMaximum(500);
        this.jSliderScale.setValue(100);
        this.jSliderScale.setName("jSliderScale");
        this.jSliderScale.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimpleBGC_GUIView.this.jSliderScaleStateChanged(evt);
            }
        });
        this.jPanel11.add((Component)this.jSliderScale, new AbsoluteConstraints(190, 10, 170, -1));
        this.jToggleButtonPause.setText(resourceMap.getString("jToggleButtonPause.text", new Object[0]));
        this.jToggleButtonPause.setName("jToggleButtonPause");
        this.jToggleButtonPause.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimpleBGC_GUIView.this.jToggleButtonPauseStateChanged(evt);
            }
        });
        this.jPanel11.add((Component)this.jToggleButtonPause, new AbsoluteConstraints(280, 40, -1, -1));
        this.jCheckBoxDebugVars.setText(resourceMap.getString("jCheckBoxDebugVars.text", new Object[0]));
        this.jCheckBoxDebugVars.setName("jCheckBoxDebugVars");
        this.jCheckBoxDebugVars.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimpleBGC_GUIView.this.jCheckBoxDebugVarsStateChanged(evt);
            }
        });
        this.jPanel11.add((Component)this.jCheckBoxDebugVars, new AbsoluteConstraints(20, 40, -1, -1));
        this.jPanel1.add((Component)this.jPanel11, new AbsoluteConstraints(0, 0, 360, 80));
        this.jPanelRCData.setName("jPanelRCData");
        this.jPanel1.add((Component)this.jPanelRCData, new AbsoluteConstraints(365, 0, 370, 80));
        this.jChart.setBorder(BorderFactory.createBevelBorder(1));
        this.jChart.setMaximumSize(new Dimension(0, 0));
        this.jChart.setMinimumSize(new Dimension(0, 0));
        this.jChart.setName("jChart");
        this.jChart.setLayout(new BoxLayout(this.jChart, 2));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setName("jScrollPane1");
        this.jPanelChartToggle.setName("jPanelChartToggle");
        this.jPanelChartToggle.setPreferredSize(new Dimension(130, 400));
        this.jScrollPane1.setViewportView(this.jPanelChartToggle);
        GroupLayout panelMonitoringLayout = new GroupLayout(this.panelMonitoring);
        this.panelMonitoring.setLayout(panelMonitoringLayout);
        panelMonitoringLayout.setHorizontalGroup(panelMonitoringLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMonitoringLayout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 162, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jChart, -1, 567, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        panelMonitoringLayout.setVerticalGroup(panelMonitoringLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMonitoringLayout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelMonitoringLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 276, Short.MAX_VALUE).addComponent(this.jChart, -1, 276, Short.MAX_VALUE))));
        this.tabbedPaneMain.addTab(resourceMap.getString("panelRealtimeData.TabConstraints.tabTitle", new Object[0]), this.panelMonitoring);
        this.panelFirmwareUpgrade.setName("panelFirmwareUpgrade");
        this.panelFirmwareUpgrade.setLayout(new BorderLayout());
        this.tabbedPaneFirmwareUpdateWay.setName("tabbedPaneFirmwareUpdateWay");
        this.panelFirmwareUpgradeAutomatic.setName("panelFirmwareUpgradeAutomatic");
        this.panelFirmwareUpgradeAutomatic.setLayout(new BorderLayout());
        this.panelFirmwareUpgradeOptions.setName("panelFirmwareUpgradeOptions");
        this.panelFirmwareUpgradeOptions.setPreferredSize(new Dimension(698, 140));
        this.labelDeviceSN.setText(resourceMap.getString("labelDeviceSN.text", new Object[0]));
        this.labelDeviceSN.setName("labelDeviceSN");
        this.textFieldDeviceSN.setEditable(false);
        this.textFieldDeviceSN.setText(resourceMap.getString("textFieldDeviceSN.text", new Object[0]));
        this.textFieldDeviceSN.setCursor(new Cursor(2));
        this.textFieldDeviceSN.setName("textFieldDeviceSN");
        this.buttonReadDeviceSN.setAction(actionMap.get("updateDeviceSN"));
        this.buttonReadDeviceSN.setText(resourceMap.getString("buttonReadDeviceSN.text", new Object[0]));
        this.buttonReadDeviceSN.setName("buttonReadDeviceSN");
        this.labelCurrentVersion2.setText(resourceMap.getString("labelCurrentVersion2.text", new Object[0]));
        this.labelCurrentVersion2.setName("labelCurrentVersion2");
        this.labelLatestVersion2.setText(resourceMap.getString("labelLatestVersion2.text", new Object[0]));
        this.labelLatestVersion2.setName("labelLatestVersion2");
        this.labelCurrentVersionValue.setHorizontalAlignment(2);
        this.labelCurrentVersionValue.setText(resourceMap.getString("labelCurrentVersionValue.text", new Object[0]));
        this.labelCurrentVersionValue.setName("labelCurrentVersionValue");
        this.labelLatestVersion.setHorizontalAlignment(2);
        this.labelLatestVersion.setText(resourceMap.getString("labelLatestVersion.text", new Object[0]));
        this.labelLatestVersion.setName("labelLatestVersion");
        this.buttonCheckVersion.setAction(actionMap.get("checkLatestVersions"));
        this.buttonCheckVersion.setText(resourceMap.getString("buttonCheckVersion.text", new Object[0]));
        this.buttonCheckVersion.setName("buttonCheckVersion");
        this.checkBoxCheckOnStartup.setAction(actionMap.get("latestVersionAutocheckChanged"));
        this.checkBoxCheckOnStartup.setText(resourceMap.getString("checkBoxCheckOnStartup.text", new Object[0]));
        this.checkBoxCheckOnStartup.setName("checkBoxCheckOnStartup");
        this.labelUpgradeToVersion.setText(resourceMap.getString("labelUpgradeToVersion.text", new Object[0]));
        this.labelUpgradeToVersion.setName("labelUpgradeToVersion");
        this.comboBoxVersionTitle.setName("comboBoxVersionTitle");
        this.buttonFirmwareUpgradeStart.setAction(actionMap.get("upgradeFirmwareVersion"));
        this.buttonFirmwareUpgradeStart.setText(resourceMap.getString("buttonFirmwareUpgradeStart.text", new Object[0]));
        this.buttonFirmwareUpgradeStart.setName("buttonFirmwareUpgradeStart");
        GroupLayout panelFirmwareUpgradeOptionsLayout = new GroupLayout(this.panelFirmwareUpgradeOptions);
        this.panelFirmwareUpgradeOptions.setLayout(panelFirmwareUpgradeOptionsLayout);
        panelFirmwareUpgradeOptionsLayout.setHorizontalGroup(panelFirmwareUpgradeOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFirmwareUpgradeOptionsLayout.createSequentialGroup().addContainerGap().addGroup(panelFirmwareUpgradeOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelDeviceSN).addComponent(this.labelCurrentVersion2).addComponent(this.labelLatestVersion2).addComponent(this.labelUpgradeToVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelFirmwareUpgradeOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelFirmwareUpgradeOptionsLayout.createSequentialGroup().addComponent(this.comboBoxVersionTitle, 0, 515, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonFirmwareUpgradeStart)).addGroup(panelFirmwareUpgradeOptionsLayout.createSequentialGroup().addComponent(this.textFieldDeviceSN, -2, 209, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonReadDeviceSN, -2, 101, -2)).addGroup(panelFirmwareUpgradeOptionsLayout.createSequentialGroup().addGroup(panelFirmwareUpgradeOptionsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.labelLatestVersion, -1, -1, Short.MAX_VALUE).addComponent(this.labelCurrentVersionValue, -1, 62, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCheckVersion, -2, 106, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkBoxCheckOnStartup))).addContainerGap()));
        panelFirmwareUpgradeOptionsLayout.setVerticalGroup(panelFirmwareUpgradeOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFirmwareUpgradeOptionsLayout.createSequentialGroup().addContainerGap().addGroup(panelFirmwareUpgradeOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelDeviceSN).addComponent(this.textFieldDeviceSN, -2, -1, -2).addComponent(this.buttonReadDeviceSN)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelFirmwareUpgradeOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelCurrentVersion2).addComponent(this.labelCurrentVersionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelFirmwareUpgradeOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelLatestVersion2).addComponent(this.labelLatestVersion).addComponent(this.buttonCheckVersion).addComponent(this.checkBoxCheckOnStartup)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelFirmwareUpgradeOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelUpgradeToVersion).addComponent(this.comboBoxVersionTitle, -2, -1, -2).addComponent(this.buttonFirmwareUpgradeStart)).addContainerGap(23, Short.MAX_VALUE)));
        this.panelFirmwareUpgradeAutomatic.add((Component)this.panelFirmwareUpgradeOptions, "North");
        this.panelFirmwareUpgradeLog.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelFirmwareUpgradeLog.setName("panelFirmwareUpgradeLog");
        this.panelFirmwareUpgradeLog.setLayout(new BorderLayout());
        this.scrollPaneVersionDetails.setName("scrollPaneVersionDetails");
        this.textAreaVersionDetails.setColumns(20);
        this.textAreaVersionDetails.setEditable(false);
        this.textAreaVersionDetails.setRows(5);
        this.textAreaVersionDetails.setName("textAreaVersionDetails");
        this.scrollPaneVersionDetails.setViewportView(this.textAreaVersionDetails);
        this.panelFirmwareUpgradeLog.add((Component)this.scrollPaneVersionDetails, "Center");
        this.panelFirmwareUpgradeAutomatic.add((Component)this.panelFirmwareUpgradeLog, "Center");
        this.tabbedPaneFirmwareUpdateWay.addTab(resourceMap.getString("panelFirmwareUpgradeAutomatic.TabConstraints.tabTitle", new Object[0]), this.panelFirmwareUpgradeAutomatic);
        this.panelFirmwareUpgradeManual.setName("panelFirmwareUpgradeManual");
        this.panelFirmwareUpgradeManual.setLayout(new BorderLayout());
        this.jPanel28.setName("jPanel28");
        this.buttonCheckLatestVersion.setAction(actionMap.get("checkLatestVersions"));
        this.buttonCheckLatestVersion.setText(resourceMap.getString("buttonCheckLatestVersion.text", new Object[0]));
        this.buttonCheckLatestVersion.setName("buttonCheckLatestVersion");
        this.checkBoxCheckLatestVersionsAtStartup.setAction(actionMap.get("latestVersionAutocheckChanged"));
        this.checkBoxCheckLatestVersionsAtStartup.setText(resourceMap.getString("checkBoxCheckLatestVersionsAtStartup.text", new Object[0]));
        this.checkBoxCheckLatestVersionsAtStartup.setName("checkBoxCheckLatestVersionsAtStartup");
        this.labelCurrentFirmwareVersionValue.setFont(resourceMap.getFont("labelCurrentFirmwareVersionValue.font"));
        this.labelCurrentFirmwareVersionValue.setText(resourceMap.getString("labelCurrentFirmwareVersionValue.text", new Object[0]));
        this.labelCurrentFirmwareVersionValue.setName("labelCurrentFirmwareVersionValue");
        this.labelLatestFirmwareVersionTitle.setText(resourceMap.getString("labelLatestFirmwareVersionTitle.text", new Object[0]));
        this.labelLatestFirmwareVersionTitle.setName("labelLatestFirmwareVersionTitle");
        this.labelCurrentVersionTitle.setText(resourceMap.getString("labelCurrentVersionTitle.text", new Object[0]));
        this.labelCurrentVersionTitle.setName("labelCurrentVersionTitle");
        this.labelCurrentGuiVersionTitle.setText(resourceMap.getString("labelCurrentGuiVersionTitle.text", new Object[0]));
        this.labelCurrentGuiVersionTitle.setName("labelCurrentGuiVersionTitle");
        this.labelCurrentGuiVersionValue.setFont(resourceMap.getFont("labelCurrentGuiVersionValue.font"));
        this.labelCurrentGuiVersionValue.setText(resourceMap.getString("labelCurrentGuiVersionValue.text", new Object[0]));
        this.labelCurrentGuiVersionValue.setName("labelCurrentGuiVersionValue");
        this.labelLatestGuiVersionTitle.setText(resourceMap.getString("labelLatestGuiVersionTitle.text", new Object[0]));
        this.labelLatestGuiVersionTitle.setName("labelLatestGuiVersionTitle");
        this.buttonFirmwareUpgrade.setAction(actionMap.get("upgradeFirmware"));
        this.buttonFirmwareUpgrade.setText(resourceMap.getString("buttonFirmwareUpgrade.text", new Object[0]));
        this.buttonFirmwareUpgrade.setName("buttonFirmwareUpgrade");
        this.buttonFirmwareUpgrade.setPreferredSize(new Dimension(131, 29));
        this.buttonGuiDownload.setAction(actionMap.get("downloadGui"));
        this.buttonGuiDownload.setText(resourceMap.getString("buttonGuiDownload.text", new Object[0]));
        this.buttonGuiDownload.setName("buttonGuiDownload");
        this.labelLatestFirmwareVersionValue.setFont(resourceMap.getFont("labelLatestFirmwareVersionValue.font"));
        this.labelLatestFirmwareVersionValue.setText(resourceMap.getString("labelLatestFirmwareVersionValue.text", new Object[0]));
        this.labelLatestFirmwareVersionValue.setName("labelLatestFirmwareVersionValue");
        this.labelLatestGuiVersionValue.setFont(resourceMap.getFont("labelLatestGuiVersionValue.font"));
        this.labelLatestGuiVersionValue.setText(resourceMap.getString("labelLatestGuiVersionValue.text", new Object[0]));
        this.labelLatestGuiVersionValue.setName("labelLatestGuiVersionValue");
        GroupLayout jPanel28Layout = new GroupLayout(this.jPanel28);
        this.jPanel28.setLayout(jPanel28Layout);
        jPanel28Layout.setHorizontalGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel28Layout.createSequentialGroup().addGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel28Layout.createSequentialGroup().addContainerGap().addGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelCurrentVersionTitle).addComponent(this.labelCurrentGuiVersionTitle)).addGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel28Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.labelCurrentFirmwareVersionValue, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(jPanel28Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.labelCurrentGuiVersionValue, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelLatestFirmwareVersionTitle).addComponent(this.labelLatestGuiVersionTitle)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel28Layout.createSequentialGroup().addComponent(this.labelLatestFirmwareVersionValue, -2, 82, -2).addGap(18, 18, 18).addComponent(this.buttonFirmwareUpgrade, -2, 149, -2)).addGroup(jPanel28Layout.createSequentialGroup().addComponent(this.labelLatestGuiVersionValue, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.buttonGuiDownload, -2, 149, -2)))).addGroup(jPanel28Layout.createSequentialGroup().addGap(78, 78, 78).addComponent(this.buttonCheckLatestVersion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxCheckLatestVersionsAtStartup))).addContainerGap()));
        jPanel28Layout.setVerticalGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel28Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCheckLatestVersion).addComponent(this.checkBoxCheckLatestVersionsAtStartup)).addGap(18, 18, 18).addGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonFirmwareUpgrade, -2, -1, -2).addComponent(this.labelCurrentVersionTitle).addComponent(this.labelLatestFirmwareVersionValue).addComponent(this.labelLatestFirmwareVersionTitle).addComponent(this.labelCurrentFirmwareVersionValue)).addGap(18, 18, 18).addGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelCurrentGuiVersionTitle).addComponent(this.labelLatestGuiVersionTitle).addComponent(this.labelLatestGuiVersionValue).addComponent(this.buttonGuiDownload).addComponent(this.labelCurrentGuiVersionValue)).addGap(77, 77, 77)));
        this.panelFirmwareUpgradeManual.add((Component)this.jPanel28, "Center");
        this.panelUpgradeFromFile.setName("panelUpgradeFromFile");
        this.panelUpgradeFromFile.setPreferredSize(new Dimension(698, 50));
        this.labelFirmwareUpgradeHex.setText(resourceMap.getString("labelFirmwareUpgradeHex.text", new Object[0]));
        this.labelFirmwareUpgradeHex.setName("labelFirmwareUpgradeHex");
        this.textFieldFirmwareHexFile.setName("textFieldFirmwareHexFile");
        this.buttonFirmwareHexFileBrowse.setAction(actionMap.get("selectFirmwareHexFile"));
        this.buttonFirmwareHexFileBrowse.setText(resourceMap.getString("buttonFirmwareHexFileBrowse.text", new Object[0]));
        this.buttonFirmwareHexFileBrowse.setName("buttonFirmwareHexFileBrowse");
        this.buttonFirmwareHexFileFlash.setAction(actionMap.get("upgradeFirmwareFromHexFile"));
        this.buttonFirmwareHexFileFlash.setText(resourceMap.getString("buttonFirmwareHexFileFlash.text", new Object[0]));
        this.buttonFirmwareHexFileFlash.setName("buttonFirmwareHexFileFlash");
        this.comboBoxBoardType.setModel(new DefaultComboBoxModel<String>(new String[]{"v.1.x (8bit) through Virtual COM Port", "v.3.x (32bit) through Virtual COM Port", "v.3.x (32bit) through USB in DFU mode"}));
        this.comboBoxBoardType.setName("comboBoxBoardType");
        this.labelFirmwareUpgradeHex1.setText(resourceMap.getString("labelFirmwareUpgradeHex1.text", new Object[0]));
        this.labelFirmwareUpgradeHex1.setName("labelFirmwareUpgradeHex1");
        this.jLabel39.setText(resourceMap.getString("jLabel39.text", new Object[0]));
        this.jLabel39.setVerticalAlignment(1);
        this.jLabel39.setName("jLabel39");
        GroupLayout panelUpgradeFromFileLayout = new GroupLayout(this.panelUpgradeFromFile);
        this.panelUpgradeFromFile.setLayout(panelUpgradeFromFileLayout);
        panelUpgradeFromFileLayout.setHorizontalGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelUpgradeFromFileLayout.createSequentialGroup().addContainerGap().addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel39, -1, 710, Short.MAX_VALUE).addGroup(panelUpgradeFromFileLayout.createSequentialGroup().addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelFirmwareUpgradeHex).addComponent(this.labelFirmwareUpgradeHex1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelUpgradeFromFileLayout.createSequentialGroup().addComponent(this.textFieldFirmwareHexFile, -2, 340, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonFirmwareHexFileBrowse).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonFirmwareHexFileFlash)).addComponent(this.comboBoxBoardType, -2, -1, -2)))).addContainerGap()));
        panelUpgradeFromFileLayout.setVerticalGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelUpgradeFromFileLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelFirmwareUpgradeHex, -2, 20, -2).addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonFirmwareHexFileFlash).addComponent(this.buttonFirmwareHexFileBrowse).addComponent(this.textFieldFirmwareHexFile, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelFirmwareUpgradeHex1, -2, 20, -2).addComponent(this.comboBoxBoardType, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel39, -2, 56, -2).addContainerGap(201, Short.MAX_VALUE)));
        this.panelFirmwareUpgradeManual.add((Component)this.panelUpgradeFromFile, "Center");
        this.tabbedPaneFirmwareUpdateWay.addTab(resourceMap.getString("panelFirmwareUpgradeManual.TabConstraints.tabTitle", new Object[0]), this.panelFirmwareUpgradeManual);
        this.panelFirmwareUpgrade.add((Component)this.tabbedPaneFirmwareUpdateWay, "Center");
        this.tabbedPaneMain.addTab(resourceMap.getString("panelFirmwareUpgrade.TabConstraints.tabTitle", new Object[0]), this.panelFirmwareUpgrade);
        this.panelDebug.setName("panelDebug");
        this.panelDebug.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel77.setText("Serial command:");
        this.jLabel77.setName("jLabel77");
        this.panelDebug.add((Component)this.jLabel77, new AbsoluteConstraints(20, 50, -1, -1));
        this.jTextFieldDebugCmd.setName("jTextFieldDebugCmd");
        this.panelDebug.add((Component)this.jTextFieldDebugCmd, new AbsoluteConstraints(130, 50, 40, -1));
        this.jTextFieldDebugCmdData.setName("jTextFieldDebugCmdData");
        this.panelDebug.add((Component)this.jTextFieldDebugCmdData, new AbsoluteConstraints(270, 50, 290, -1));
        this.jButtonDebugCmd.setText("SEND");
        this.jButtonDebugCmd.setName("jButtonDebugCmd");
        this.jButtonDebugCmd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimpleBGC_GUIView.this.jButtonDebugCmdActionPerformed(evt);
            }
        });
        this.panelDebug.add((Component)this.jButtonDebugCmd, new AbsoluteConstraints(570, 50, -1, -1));
        this.jScrollPane2.setName("jScrollPane2");
        this.jTextAreaDebugCmd.setColumns(20);
        this.jTextAreaDebugCmd.setRows(5);
        this.jTextAreaDebugCmd.setName("jTextAreaDebugCmd");
        this.jScrollPane2.setViewportView(this.jTextAreaDebugCmd);
        this.panelDebug.add((Component)this.jScrollPane2, new AbsoluteConstraints(20, 80, 690, 220));
        this.jButtonDebugClear.setText("CLEAR");
        this.jButtonDebugClear.setName("jButtonDebugClear");
        this.jButtonDebugClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimpleBGC_GUIView.this.jButtonDebugClearActionPerformed(evt);
            }
        });
        this.panelDebug.add((Component)this.jButtonDebugClear, new AbsoluteConstraints(640, 50, -1, -1));
        this.jLabel78.setText("data (hex):");
        this.jLabel78.setName("jLabel78");
        this.panelDebug.add((Component)this.jLabel78, new AbsoluteConstraints(190, 50, -1, -1));
        this.jButtonDebugConnect.setAction(actionMap.get("debugConnect"));
        this.jButtonDebugConnect.setText(resourceMap.getString("jButtonDebugConnect.text", new Object[0]));
        this.jButtonDebugConnect.setName("jButtonDebugConnect");
        this.panelDebug.add((Component)this.jButtonDebugConnect, new AbsoluteConstraints(190, 10, 80, -1));
        this.jCheckBoxParity.setText(resourceMap.getString("jCheckBoxParity.text", new Object[0]));
        this.jCheckBoxParity.setName("jCheckBoxParity");
        this.panelDebug.add((Component)this.jCheckBoxParity, new AbsoluteConstraints(20, 10, -1, -1));
        this.jLabel81.setText(resourceMap.getString("jLabel81.text", new Object[0]));
        this.jLabel81.setName("jLabel81");
        this.panelDebug.add((Component)this.jLabel81, new AbsoluteConstraints(120, 10, -1, -1));
        this.jButtonDebugRequestState.setAction(actionMap.get("buttonDebugRequestState"));
        this.jButtonDebugRequestState.setText(resourceMap.getString("jButtonDebugRequestState.text", new Object[0]));
        this.jButtonDebugRequestState.setName("jButtonDebugRequestState");
        this.panelDebug.add((Component)this.jButtonDebugRequestState, new AbsoluteConstraints(280, 10, -1, -1));
        this.jComboBoxBodeTestAxis.setModel(new DefaultComboBoxModel<String>(new String[]{"ROLL", "PITCH", "YAW"}));
        this.jComboBoxBodeTestAxis.setName("jComboBoxBodeTestAxis");
        this.panelDebug.add((Component)this.jComboBoxBodeTestAxis, new AbsoluteConstraints(20, 310, 90, -1));
        this.jComboBoxBodeTestStimulus.setModel(new DefaultComboBoxModel<String>(new String[]{"white noise", "sine sweep (lin.gain)", "sine speep (exp.gain)"}));
        this.jComboBoxBodeTestStimulus.setName("jComboBoxBodeTestStimulus");
        this.panelDebug.add((Component)this.jComboBoxBodeTestStimulus, new AbsoluteConstraints(120, 310, 150, -1));
        this.jSpinnerBodeTestGain.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f)));
        this.jSpinnerBodeTestGain.setName("jSpinnerBodeTestGain");
        this.jSpinnerBodeTestGain.setValue(100);
        this.panelDebug.add((Component)this.jSpinnerBodeTestGain, new AbsoluteConstraints(280, 310, 60, -1));
        this.jComboBoxBodeTestSystem.setModel(new DefaultComboBoxModel<String>(new String[]{"Controller+Plant (open loop)", "Controller+Plant (closed loop)", "Controller only (open loop)", "Controller only (closed loop)", "Plant only (open loop)", "Overall system response"}));
        this.jComboBoxBodeTestSystem.setName("jComboBoxBodeTestSystem");
        this.panelDebug.add((Component)this.jComboBoxBodeTestSystem, new AbsoluteConstraints(350, 310, 230, -1));
        this.jButtonBodeTestStart.setAction(actionMap.get("buttonBodeTestStart"));
        this.jButtonBodeTestStart.setText(resourceMap.getString("jButtonBodeTestStart.text", new Object[0]));
        this.jButtonBodeTestStart.setName("jButtonBodeTestStart");
        this.panelDebug.add((Component)this.jButtonBodeTestStart, new AbsoluteConstraints(590, 310, 120, -1));
        this.tabbedPaneMain.addTab("Debug", this.panelDebug);
        this.panelEncoders.setName("panelEncoders");
        this.panelEncoders.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelManualSetTime.setText(resourceMap.getString("jLabelManualSetTime.text", new Object[0]));
        this.jLabelManualSetTime.setName("jLabelManualSetTime");
        this.panelEncoders.add((Component)this.jLabelManualSetTime, new AbsoluteConstraints(20, 90, -1, -1));
        this.jSpinnerManualSetTimeYaw.setModel(SimpleBGC_GUIView.spinnerModel_255f());
        this.jSpinnerManualSetTimeYaw.setName("jSpinnerManualSetTimeYaw");
        this.panelEncoders.add((Component)this.jSpinnerManualSetTimeYaw, new AbsoluteConstraints(380, 90, 70, -1));
        this.jLabel63.setHorizontalAlignment(0);
        this.jLabel63.setText(resourceMap.getString("jLabel63.text", new Object[0]));
        this.jLabel63.setName("jLabel63");
        this.panelEncoders.add((Component)this.jLabel63, new AbsoluteConstraints(370, 70, 80, -1));
        this.jLabel82.setHorizontalAlignment(0);
        this.jLabel82.setText(resourceMap.getString("jLabel82.text", new Object[0]));
        this.jLabel82.setName("jLabel82");
        this.panelEncoders.add((Component)this.jLabel82, new AbsoluteConstraints(190, 70, 80, -1));
        this.jLabel86.setHorizontalAlignment(0);
        this.jLabel86.setText(resourceMap.getString("jLabel86.text", new Object[0]));
        this.jLabel86.setName("jLabel86");
        this.panelEncoders.add((Component)this.jLabel86, new AbsoluteConstraints(280, 70, 90, -1));
        this.jSpinnerManualSetTimeRoll.setModel(SimpleBGC_GUIView.spinnerModel_255f());
        this.jSpinnerManualSetTimeRoll.setName("jSpinnerManualSetTimeRoll");
        this.panelEncoders.add((Component)this.jSpinnerManualSetTimeRoll, new AbsoluteConstraints(200, 90, 70, -1));
        this.jSpinnerManualSetTimePitch.setModel(SimpleBGC_GUIView.spinnerModel_255f());
        this.jSpinnerManualSetTimePitch.setName("jSpinnerManualSetTimePitch");
        this.panelEncoders.add((Component)this.jSpinnerManualSetTimePitch, new AbsoluteConstraints(290, 90, 70, -1));
        this.jLabelHeatModelHeating.setText(resourceMap.getString("jLabelHeatModelHeating.text", new Object[0]));
        this.jLabelHeatModelHeating.setName("jLabelHeatModelHeating");
        this.panelEncoders.add((Component)this.jLabelHeatModelHeating, new AbsoluteConstraints(20, 120, -1, -1));
        this.jSpinnerHeatingRoll.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerHeatingRoll.setName("jSpinnerHeatingRoll");
        this.panelEncoders.add((Component)this.jSpinnerHeatingRoll, new AbsoluteConstraints(200, 120, 70, -1));
        this.jSpinnerHeatingPitch.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerHeatingPitch.setName("jSpinnerHeatingPitch");
        this.panelEncoders.add((Component)this.jSpinnerHeatingPitch, new AbsoluteConstraints(290, 120, 70, -1));
        this.jSpinnerHeatingYaw.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerHeatingYaw.setName("jSpinnerHeatingYaw");
        this.panelEncoders.add((Component)this.jSpinnerHeatingYaw, new AbsoluteConstraints(380, 120, 70, -1));
        this.jLabelHeatModelCooling.setText(resourceMap.getString("jLabelHeatModelCooling.text", new Object[0]));
        this.jLabelHeatModelCooling.setName("jLabelHeatModelCooling");
        this.panelEncoders.add((Component)this.jLabelHeatModelCooling, new AbsoluteConstraints(20, 150, -1, -1));
        this.jSpinnerCoolingRoll.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerCoolingRoll.setName("jSpinnerCoolingRoll");
        this.panelEncoders.add((Component)this.jSpinnerCoolingRoll, new AbsoluteConstraints(200, 150, 70, -1));
        this.jSpinnerCoolingPitch.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerCoolingPitch.setName("jSpinnerCoolingPitch");
        this.panelEncoders.add((Component)this.jSpinnerCoolingPitch, new AbsoluteConstraints(290, 150, 70, -1));
        this.jSpinnerCoolingYaw.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerCoolingYaw.setName("jSpinnerCoolingYaw");
        this.panelEncoders.add((Component)this.jSpinnerCoolingYaw, new AbsoluteConstraints(380, 150, 70, -1));
        this.jButtonEncodersCalibOffset.setAction(actionMap.get("buttonEncodersCalibOffset"));
        this.jButtonEncodersCalibOffset.setText(resourceMap.getString("jButtonEncodersCalibOffset.text", new Object[0]));
        this.jButtonEncodersCalibOffset.setName("jButtonEncodersCalibOffset");
        this.panelEncoders.add((Component)this.jButtonEncodersCalibOffset, new AbsoluteConstraints(470, 210, 170, -1));
        this.jButtonCalibFldOffset.setAction(actionMap.get("buttonEncodersCalibFldOffset"));
        this.jButtonCalibFldOffset.setText(resourceMap.getString("jButtonCalibFldOffset.text", new Object[0]));
        this.jButtonCalibFldOffset.setName("jButtonCalibFldOffset");
        this.panelEncoders.add((Component)this.jButtonCalibFldOffset, new AbsoluteConstraints(470, 180, 170, -1));
        this.jLabelEncoderOffset.setText(resourceMap.getString("jLabelEncoderOffset.text", new Object[0]));
        this.jLabelEncoderOffset.setName("jLabelEncoderOffset");
        this.panelEncoders.add((Component)this.jLabelEncoderOffset, new AbsoluteConstraints(20, 210, -1, -1));
        this.jSpinnerEncoderOffsetRoll.setModel(SimpleBGC_GUIView.spinnerModel_word());
        this.jSpinnerEncoderOffsetRoll.setName("jSpinnerEncoderOffsetRoll");
        this.panelEncoders.add((Component)this.jSpinnerEncoderOffsetRoll, new AbsoluteConstraints(200, 210, 70, -1));
        this.jSpinnerEncoderOffsetPitch.setModel(SimpleBGC_GUIView.spinnerModel_word());
        this.jSpinnerEncoderOffsetPitch.setName("jSpinnerEncoderOffsetPitch");
        this.panelEncoders.add((Component)this.jSpinnerEncoderOffsetPitch, new AbsoluteConstraints(290, 210, 70, -1));
        this.jSpinnerEncoderOffsetYaw.setModel(SimpleBGC_GUIView.spinnerModel_word());
        this.jSpinnerEncoderOffsetYaw.setName("jSpinnerEncoderOffsetYaw");
        this.panelEncoders.add((Component)this.jSpinnerEncoderOffsetYaw, new AbsoluteConstraints(380, 210, 70, -1));
        this.jLabelEncoderOffset1.setText(resourceMap.getString("jLabelEncoderOffset1.text", new Object[0]));
        this.jLabelEncoderOffset1.setName("jLabelEncoderOffset1");
        this.panelEncoders.add((Component)this.jLabelEncoderOffset1, new AbsoluteConstraints(20, 180, -1, -1));
        this.jSpinnerEncoderFldOffsetRoll.setModel(SimpleBGC_GUIView.spinnerModel_word());
        this.jSpinnerEncoderFldOffsetRoll.setName("jSpinnerEncoderFldOffsetRoll");
        this.panelEncoders.add((Component)this.jSpinnerEncoderFldOffsetRoll, new AbsoluteConstraints(200, 180, 70, -1));
        this.jSpinnerEncoderFldOffsetPitch.setModel(SimpleBGC_GUIView.spinnerModel_word());
        this.jSpinnerEncoderFldOffsetPitch.setName("jSpinnerEncoderFldOffsetPitch");
        this.panelEncoders.add((Component)this.jSpinnerEncoderFldOffsetPitch, new AbsoluteConstraints(290, 180, 70, -1));
        this.jSpinnerEncoderFldOffsetYaw.setModel(SimpleBGC_GUIView.spinnerModel_word());
        this.jSpinnerEncoderFldOffsetYaw.setName("jSpinnerEncoderFldOffsetYaw");
        this.panelEncoders.add((Component)this.jSpinnerEncoderFldOffsetYaw, new AbsoluteConstraints(380, 180, 70, -1));
        this.jLabelEncType.setText(resourceMap.getString("jLabelEncType.text", new Object[0]));
        this.jLabelEncType.setName("jLabelEncType");
        this.panelEncoders.add((Component)this.jLabelEncType, new AbsoluteConstraints(30, 20, -1, -1));
        this.jComboBoxEncoderType.setModel(new DefaultComboBoxModel<String>(new String[]{"Disabled", "AS5048A (SPI)", "AS5048B (I2C)", "AS5048A,B (PWM)", "AMT203 (SPI)", "MA3 (10bit PWM)", "MA3 (12bit PWM)"}));
        this.jComboBoxEncoderType.setName("jComboBoxEncoderType");
        this.jComboBoxEncoderType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SimpleBGC_GUIView.this.jComboBoxEncoderTypeItemStateChanged(evt);
            }
        });
        this.panelEncoders.add((Component)this.jComboBoxEncoderType, new AbsoluteConstraints(200, 10, 180, -1));
        this.jCheckBoxEncoderForce.setText(resourceMap.getString("jCheckBoxEncoderForce.text", new Object[0]));
        this.jCheckBoxEncoderForce.setName("jCheckBoxEncoderForce");
        this.panelEncoders.add((Component)this.jCheckBoxEncoderForce, new AbsoluteConstraints(400, 10, -1, -1));
        this.jComboBoxEncoderSPI.setModel(new DefaultComboBoxModel<String>(new String[]{"SPI speed 1MHz (default)", "SPI speed 2MHz", "SPI speed 4MHz", "SPI speed 500kHz (debug only)"}));
        this.jComboBoxEncoderSPI.setEnabled(false);
        this.jComboBoxEncoderSPI.setName("jComboBoxEncoderSPI");
        this.panelEncoders.add((Component)this.jComboBoxEncoderSPI, new AbsoluteConstraints(200, 40, 180, -1));
        this.jLabelEncoderFFLPF.setText(resourceMap.getString("jLabelEncoderFFLPF.text", new Object[0]));
        this.jLabelEncoderFFLPF.setEnabled(false);
        this.jLabelEncoderFFLPF.setName("jLabelEncoderFFLPF");
        this.panelEncoders.add((Component)this.jLabelEncoderFFLPF, new AbsoluteConstraints(470, 240, -1, -1));
        this.jSpinnerEncoderFFLPF.setModel(SimpleBGC_GUIView.spinnerModel_16u());
        this.jSpinnerEncoderFFLPF.setEnabled(false);
        this.jSpinnerEncoderFFLPF.setName("jSpinnerEncoderFFLPF");
        this.panelEncoders.add((Component)this.jSpinnerEncoderFFLPF, new AbsoluteConstraints(580, 240, 60, -1));
        this.jLabelEncoderMagneticLinkage.setText(resourceMap.getString("jLabelEncoderMagneticLinkage.text", new Object[0]));
        this.jLabelEncoderMagneticLinkage.setName("jLabelEncoderMagneticLinkage");
        this.panelEncoders.add((Component)this.jLabelEncoderMagneticLinkage, new AbsoluteConstraints(20, 240, -1, -1));
        this.jSpinnerEncoderMagLinkRoll.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerEncoderMagLinkRoll.setName("jSpinnerEncoderMagLinkRoll");
        this.panelEncoders.add((Component)this.jSpinnerEncoderMagLinkRoll, new AbsoluteConstraints(200, 240, 70, -1));
        this.jSpinnerEncoderMagLinkPitch.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerEncoderMagLinkPitch.setName("jSpinnerEncoderMagLinkPitch");
        this.panelEncoders.add((Component)this.jSpinnerEncoderMagLinkPitch, new AbsoluteConstraints(290, 240, 70, -1));
        this.jSpinnerEncoderMagLinkYaw.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerEncoderMagLinkYaw.setName("jSpinnerEncoderMagLinkYaw");
        this.panelEncoders.add((Component)this.jSpinnerEncoderMagLinkYaw, new AbsoluteConstraints(380, 240, 70, -1));
        this.jLabelEncoderGear.setText(resourceMap.getString("jLabelEncoderGear.text", new Object[0]));
        this.jLabelEncoderGear.setName("jLabelEncoderGear");
        this.panelEncoders.add((Component)this.jLabelEncoderGear, new AbsoluteConstraints(20, 270, -1, -1));
        this.jSpinnerMotorGearRoll.setModel(new SpinnerNumberModel(0.0, 0.0, 255.999, 0.01));
        this.jSpinnerMotorGearRoll.setName("jSpinnerMotorGearRoll");
        this.panelEncoders.add((Component)this.jSpinnerMotorGearRoll, new AbsoluteConstraints(200, 270, 70, -1));
        this.jSpinnerMotorGearPitch.setModel(new SpinnerNumberModel(0.0, 0.0, 255.999, 0.01));
        this.jSpinnerMotorGearPitch.setName("jSpinnerMotorGearPitch");
        this.panelEncoders.add((Component)this.jSpinnerMotorGearPitch, new AbsoluteConstraints(290, 270, 70, -1));
        this.jSpinnerMotorGearYaw.setModel(new SpinnerNumberModel(0.0, 0.0, 255.999, 0.01));
        this.jSpinnerMotorGearYaw.setName("jSpinnerMotorGearYaw");
        this.panelEncoders.add((Component)this.jSpinnerMotorGearYaw, new AbsoluteConstraints(380, 270, 70, -1));
        this.tabbedPaneMain.addTab(resourceMap.getString("panelEncoders.TabConstraints.tabTitle", new Object[0]), this.panelEncoders);
        this.panelFilters.setName("panelFilters");
        this.panelFilters.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel30.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel30.border.title", new Object[0])));
        this.jPanel30.setName("jPanel30");
        this.jPanel30.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelRoll.setText(resourceMap.getString("jLabelRoll.text", new Object[0]));
        this.jLabelRoll.setName("jLabelRoll");
        this.jPanel30.add((Component)this.jLabelRoll, new AbsoluteConstraints(20, 80, -1, -1));
        this.jLabel88.setHorizontalAlignment(0);
        this.jLabel88.setText(resourceMap.getString("jLabel88.text", new Object[0]));
        this.jLabel88.setName("jLabel88");
        this.jPanel30.add((Component)this.jLabel88, new AbsoluteConstraints(70, 30, 100, -1));
        this.jLabel89.setHorizontalAlignment(0);
        this.jLabel89.setText(resourceMap.getString("jLabel89.text", new Object[0]));
        this.jLabel89.setName("jLabel89");
        this.jPanel30.add((Component)this.jLabel89, new AbsoluteConstraints(170, 30, 80, -1));
        this.jLabel90.setHorizontalAlignment(0);
        this.jLabel90.setText(resourceMap.getString("jLabel90.text", new Object[0]));
        this.jLabel90.setName("jLabel90");
        this.jPanel30.add((Component)this.jLabel90, new AbsoluteConstraints(250, 30, 60, -1));
        this.jSpinnerNotchRollWidth1.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerNotchRollWidth1.setName("jSpinnerNotchRollWidth1");
        this.jPanel30.add((Component)this.jSpinnerNotchRollWidth1, new AbsoluteConstraints(180, 50, 60, -1));
        this.jSpinnerNotchRollFreq1.setModel(SimpleBGC_GUIView.spinnerModel_500u());
        this.jSpinnerNotchRollFreq1.setName("jSpinnerNotchRollFreq1");
        this.jPanel30.add((Component)this.jSpinnerNotchRollFreq1, new AbsoluteConstraints(100, 50, 60, -1));
        this.jCheckBoxNotchRollEnabled1.setName("jCheckBoxNotchRollEnabled1");
        this.jPanel30.add((Component)this.jCheckBoxNotchRollEnabled1, new AbsoluteConstraints(260, 50, -1, -1));
        this.jSpinnerNotchRollFreq2.setModel(SimpleBGC_GUIView.spinnerModel_500u());
        this.jSpinnerNotchRollFreq2.setName("jSpinnerNotchRollFreq2");
        this.jPanel30.add((Component)this.jSpinnerNotchRollFreq2, new AbsoluteConstraints(100, 80, 60, -1));
        this.jSpinnerNotchRollWidth2.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerNotchRollWidth2.setName("jSpinnerNotchRollWidth2");
        this.jPanel30.add((Component)this.jSpinnerNotchRollWidth2, new AbsoluteConstraints(180, 80, 60, -1));
        this.jCheckBoxNotchRollEnabled2.setName("jCheckBoxNotchRollEnabled2");
        this.jPanel30.add((Component)this.jCheckBoxNotchRollEnabled2, new AbsoluteConstraints(260, 80, -1, -1));
        this.jSpinnerNotchRollFreq3.setModel(SimpleBGC_GUIView.spinnerModel_500u());
        this.jSpinnerNotchRollFreq3.setName("jSpinnerNotchRollFreq3");
        this.jPanel30.add((Component)this.jSpinnerNotchRollFreq3, new AbsoluteConstraints(100, 110, 60, -1));
        this.jSpinnerNotchRollWidth3.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerNotchRollWidth3.setName("jSpinnerNotchRollWidth3");
        this.jPanel30.add((Component)this.jSpinnerNotchRollWidth3, new AbsoluteConstraints(180, 110, 60, -1));
        this.jCheckBoxNotchRollEnabled3.setName("jCheckBoxNotchRollEnabled3");
        this.jPanel30.add((Component)this.jCheckBoxNotchRollEnabled3, new AbsoluteConstraints(260, 110, -1, -1));
        this.jSeparator6.setOrientation(1);
        this.jSeparator6.setName("jSeparator6");
        this.jPanel30.add((Component)this.jSeparator6, new AbsoluteConstraints(80, 60, 10, 60));
        this.jLabelPitch.setText(resourceMap.getString("jLabelPitch.text", new Object[0]));
        this.jLabelPitch.setName("jLabelPitch");
        this.jPanel30.add((Component)this.jLabelPitch, new AbsoluteConstraints(20, 170, -1, -1));
        this.jSpinnerNotchPitchFreq1.setModel(SimpleBGC_GUIView.spinnerModel_500u());
        this.jSpinnerNotchPitchFreq1.setName("jSpinnerNotchPitchFreq1");
        this.jPanel30.add((Component)this.jSpinnerNotchPitchFreq1, new AbsoluteConstraints(100, 140, 60, -1));
        this.jSpinnerNotchPitchWidth1.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerNotchPitchWidth1.setName("jSpinnerNotchPitchWidth1");
        this.jPanel30.add((Component)this.jSpinnerNotchPitchWidth1, new AbsoluteConstraints(180, 140, 60, -1));
        this.jCheckBoxNotchPitchEnabled1.setName("jCheckBoxNotchPitchEnabled1");
        this.jPanel30.add((Component)this.jCheckBoxNotchPitchEnabled1, new AbsoluteConstraints(260, 140, -1, -1));
        this.jSeparator7.setOrientation(1);
        this.jSeparator7.setName("jSeparator7");
        this.jPanel30.add((Component)this.jSeparator7, new AbsoluteConstraints(80, 150, 10, 60));
        this.jSpinnerNotchPitchFreq2.setModel(SimpleBGC_GUIView.spinnerModel_500u());
        this.jSpinnerNotchPitchFreq2.setName("jSpinnerNotchPitchFreq2");
        this.jPanel30.add((Component)this.jSpinnerNotchPitchFreq2, new AbsoluteConstraints(100, 170, 60, -1));
        this.jSpinnerNotchPitchWidth2.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerNotchPitchWidth2.setName("jSpinnerNotchPitchWidth2");
        this.jPanel30.add((Component)this.jSpinnerNotchPitchWidth2, new AbsoluteConstraints(180, 170, 60, -1));
        this.jCheckBoxNotchPitchEnabled2.setName("jCheckBoxNotchPitchEnabled2");
        this.jPanel30.add((Component)this.jCheckBoxNotchPitchEnabled2, new AbsoluteConstraints(260, 170, -1, -1));
        this.jSpinnerNotchPitchFreq3.setModel(SimpleBGC_GUIView.spinnerModel_500u());
        this.jSpinnerNotchPitchFreq3.setName("jSpinnerNotchPitchFreq3");
        this.jPanel30.add((Component)this.jSpinnerNotchPitchFreq3, new AbsoluteConstraints(100, 200, 60, -1));
        this.jSpinnerNotchPitchWidth3.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerNotchPitchWidth3.setName("jSpinnerNotchPitchWidth3");
        this.jPanel30.add((Component)this.jSpinnerNotchPitchWidth3, new AbsoluteConstraints(180, 200, 60, -1));
        this.jCheckBoxNotchPitchEnabled3.setName("jCheckBoxNotchPitchEnabled3");
        this.jPanel30.add((Component)this.jCheckBoxNotchPitchEnabled3, new AbsoluteConstraints(260, 200, -1, -1));
        this.jLabelYaw.setText(resourceMap.getString("jLabelYaw.text", new Object[0]));
        this.jLabelYaw.setName("jLabelYaw");
        this.jPanel30.add((Component)this.jLabelYaw, new AbsoluteConstraints(20, 260, -1, -1));
        this.jSeparator8.setOrientation(1);
        this.jSeparator8.setName("jSeparator8");
        this.jPanel30.add((Component)this.jSeparator8, new AbsoluteConstraints(80, 240, 10, 60));
        this.jSpinnerNotchYawFreq1.setModel(SimpleBGC_GUIView.spinnerModel_500u());
        this.jSpinnerNotchYawFreq1.setName("jSpinnerNotchYawFreq1");
        this.jPanel30.add((Component)this.jSpinnerNotchYawFreq1, new AbsoluteConstraints(100, 230, 60, -1));
        this.jSpinnerNotchYawWidth1.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerNotchYawWidth1.setName("jSpinnerNotchYawWidth1");
        this.jPanel30.add((Component)this.jSpinnerNotchYawWidth1, new AbsoluteConstraints(180, 230, 60, -1));
        this.jCheckBoxNotchYawEnabled1.setName("jCheckBoxNotchYawEnabled1");
        this.jPanel30.add((Component)this.jCheckBoxNotchYawEnabled1, new AbsoluteConstraints(260, 230, -1, -1));
        this.jSpinnerNotchYawFreq2.setModel(SimpleBGC_GUIView.spinnerModel_500u());
        this.jSpinnerNotchYawFreq2.setName("jSpinnerNotchYawFreq2");
        this.jPanel30.add((Component)this.jSpinnerNotchYawFreq2, new AbsoluteConstraints(100, 260, 60, -1));
        this.jSpinnerNotchYawWidth2.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerNotchYawWidth2.setName("jSpinnerNotchYawWidth2");
        this.jPanel30.add((Component)this.jSpinnerNotchYawWidth2, new AbsoluteConstraints(180, 260, 60, -1));
        this.jCheckBoxNotchYawEnabled2.setName("jCheckBoxNotchYawEnabled2");
        this.jPanel30.add((Component)this.jCheckBoxNotchYawEnabled2, new AbsoluteConstraints(260, 260, -1, -1));
        this.jSpinnerNotchYawFreq3.setModel(SimpleBGC_GUIView.spinnerModel_500u());
        this.jSpinnerNotchYawFreq3.setName("jSpinnerNotchYawFreq3");
        this.jPanel30.add((Component)this.jSpinnerNotchYawFreq3, new AbsoluteConstraints(100, 290, 60, -1));
        this.jSpinnerNotchYawWidth3.setModel(SimpleBGC_GUIView.spinnerModel_255u());
        this.jSpinnerNotchYawWidth3.setName("jSpinnerNotchYawWidth3");
        this.jPanel30.add((Component)this.jSpinnerNotchYawWidth3, new AbsoluteConstraints(180, 290, 60, -1));
        this.jCheckBoxNotchYawEnabled3.setName("jCheckBoxNotchYawEnabled3");
        this.jPanel30.add((Component)this.jCheckBoxNotchYawEnabled3, new AbsoluteConstraints(260, 290, -1, -1));
        this.panelFilters.add((Component)this.jPanel30, new AbsoluteConstraints(10, 10, 330, 330));
        this.jPanel31.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel31.border.title", new Object[0])));
        this.jPanel31.setName("jPanel31");
        this.jPanel31.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel93.setText(resourceMap.getString("jLabel93.text", new Object[0]));
        this.jLabel93.setName("jLabel93");
        this.jPanel31.add((Component)this.jLabel93, new AbsoluteConstraints(20, 50, -1, -1));
        this.jLabel94.setText(resourceMap.getString("jLabel94.text", new Object[0]));
        this.jLabel94.setName("jLabel94");
        this.jPanel31.add((Component)this.jLabel94, new AbsoluteConstraints(70, 30, -1, -1));
        this.jSpinnerLPFRollFreq.setModel(SimpleBGC_GUIView.spinnerModel_1000u());
        this.jSpinnerLPFRollFreq.setName("jSpinnerLPFRollFreq");
        this.jPanel31.add((Component)this.jSpinnerLPFRollFreq, new AbsoluteConstraints(80, 50, 60, -1));
        this.jCheckBoxLPFRollEnabled.setName("jCheckBoxLPFRollEnabled");
        this.jPanel31.add((Component)this.jCheckBoxLPFRollEnabled, new AbsoluteConstraints(170, 50, -1, -1));
        this.jLabel95.setText(resourceMap.getString("jLabel95.text", new Object[0]));
        this.jLabel95.setName("jLabel95");
        this.jPanel31.add((Component)this.jLabel95, new AbsoluteConstraints(160, 30, -1, -1));
        this.jLabel96.setText(resourceMap.getString("jLabel96.text", new Object[0]));
        this.jLabel96.setName("jLabel96");
        this.jPanel31.add((Component)this.jLabel96, new AbsoluteConstraints(20, 80, -1, -1));
        this.jSpinnerLPFPitchFreq.setModel(SimpleBGC_GUIView.spinnerModel_1000u());
        this.jSpinnerLPFPitchFreq.setName("jSpinnerLPFPitchFreq");
        this.jPanel31.add((Component)this.jSpinnerLPFPitchFreq, new AbsoluteConstraints(80, 80, 60, -1));
        this.jCheckBoxLPFPitchEnabled.setName("jCheckBoxLPFPitchEnabled");
        this.jPanel31.add((Component)this.jCheckBoxLPFPitchEnabled, new AbsoluteConstraints(170, 80, -1, -1));
        this.jLabel97.setText(resourceMap.getString("jLabel97.text", new Object[0]));
        this.jLabel97.setName("jLabel97");
        this.jPanel31.add((Component)this.jLabel97, new AbsoluteConstraints(20, 110, -1, -1));
        this.jSpinnerLPFYawFreq.setModel(SimpleBGC_GUIView.spinnerModel_1000u());
        this.jSpinnerLPFYawFreq.setName("jSpinnerLPFYawFreq");
        this.jPanel31.add((Component)this.jSpinnerLPFYawFreq, new AbsoluteConstraints(80, 110, 60, -1));
        this.jCheckBoxLPFYawEnabled.setName("jCheckBoxLPFYawEnabled");
        this.jPanel31.add((Component)this.jCheckBoxLPFYawEnabled, new AbsoluteConstraints(170, 110, -1, -1));
        this.panelFilters.add((Component)this.jPanel31, new AbsoluteConstraints(340, 10, 220, 330));
        this.tabbedPaneMain.addTab(resourceMap.getString("panelFilters.TabConstraints.tabTitle", new Object[0]), this.panelFilters);
        this.panelScriptEditor.setName("panelScriptEditor");
        this.panelScriptEditor.setLayout((LayoutManager)new AbsoluteLayout());
        this.jButtonScriptLoadFile.setText(resourceMap.getString("jButtonScriptLoadFile.text", new Object[0]));
        this.jButtonScriptLoadFile.setName("jButtonScriptLoadFile");
        this.panelScriptEditor.add((Component)this.jButtonScriptLoadFile, new AbsoluteConstraints(70, 10, 80, -1));
        this.jLabel98.setHorizontalAlignment(0);
        this.jLabel98.setText(resourceMap.getString("jLabel98.text", new Object[0]));
        this.jLabel98.setName("jLabel98");
        this.panelScriptEditor.add((Component)this.jLabel98, new AbsoluteConstraints(0, 10, 70, 20));
        this.jButtonScriptSaveFile.setText(resourceMap.getString("jButtonScriptSaveFile.text", new Object[0]));
        this.jButtonScriptSaveFile.setName("jButtonScriptSaveFile");
        this.panelScriptEditor.add((Component)this.jButtonScriptSaveFile, new AbsoluteConstraints(160, 10, 80, -1));
        this.jLabel99.setHorizontalAlignment(0);
        this.jLabel99.setText(resourceMap.getString("jLabel99.text", new Object[0]));
        this.jLabel99.setName("jLabel99");
        this.panelScriptEditor.add((Component)this.jLabel99, new AbsoluteConstraints(280, 10, 100, 20));
        this.jButtonScriptWrite.setText(resourceMap.getString("jButtonScriptWrite.text", new Object[0]));
        this.jButtonScriptWrite.setName("jButtonScriptWrite");
        this.panelScriptEditor.add((Component)this.jButtonScriptWrite, new AbsoluteConstraints(650, 10, 80, -1));
        this.jButtonScriptRead.setText(resourceMap.getString("jButtonScriptRead.text", new Object[0]));
        this.jButtonScriptRead.setName("jButtonScriptRead");
        this.panelScriptEditor.add((Component)this.jButtonScriptRead, new AbsoluteConstraints(560, 10, 80, -1));
        this.jComboBoxScriptSlot.setName("jComboBoxScriptSlot");
        this.panelScriptEditor.add((Component)this.jComboBoxScriptSlot, new AbsoluteConstraints(390, 10, 160, -1));
        this.jButtonScriptValidate.setText(resourceMap.getString("jButtonScriptValidate.text", new Object[0]));
        this.jButtonScriptValidate.setName("jButtonScriptValidate");
        this.panelScriptEditor.add((Component)this.jButtonScriptValidate, new AbsoluteConstraints(600, 50, 130, -1));
        this.jButtonScriptPanorama.setText(resourceMap.getString("jButtonScriptPanorama.text", new Object[0]));
        this.jButtonScriptPanorama.setEnabled(false);
        this.jButtonScriptPanorama.setName("jButtonScriptPanorama");
        this.panelScriptEditor.add((Component)this.jButtonScriptPanorama, new AbsoluteConstraints(600, 80, 130, -1));
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setDividerSize(4);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jScrollPane3.setName("jScrollPane3");
        this.jTextPaneScript.setBackground(resourceMap.getColor("jTextPaneScript.background"));
        this.jTextPaneScript.setForeground(resourceMap.getColor("jTextPaneScript.foreground"));
        this.jTextPaneScript.setCaretColor(resourceMap.getColor("jTextPaneScript.caretColor"));
        this.jTextPaneScript.setName("jTextPaneScript");
        this.jScrollPane3.setViewportView(this.jTextPaneScript);
        this.jSplitPane1.setTopComponent(this.jScrollPane3);
        this.jScrollPane4.setName("jScrollPane4");
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Row 1, col. 34: Unknow command \"D\""};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList1.setSelectionMode(0);
        this.jList1.setName("jList1");
        this.jScrollPane4.setViewportView(this.jList1);
        this.jSplitPane1.setRightComponent(this.jScrollPane4);
        this.panelScriptEditor.add((Component)this.jSplitPane1, new AbsoluteConstraints(1, 40, 590, 310));
        this.tabbedPaneMain.addTab(resourceMap.getString("panelScriptEditor.TabConstraints.tabTitle", new Object[0]), this.panelScriptEditor);
        this.jPanelMain.add((Component)this.tabbedPaneMain, new AbsoluteConstraints(0, 90, 740, 390));
        this.jPanel4.setBackground(resourceMap.getColor("JPanelInfo.background"));
        this.jPanel4.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel4.setName("JPanelInfo");
        this.jLabelErrorTitle.setFont(resourceMap.getFont("labelErrorTitle.font"));
        this.jLabelErrorTitle.setForeground(resourceMap.getColor("labelErrorTitle.foreground"));
        this.jLabelErrorTitle.setText(resourceMap.getString("labelErrorTitle.text", new Object[0]));
        this.jLabelErrorTitle.setName("labelErrorTitle");
        this.jLabel14.setForeground(resourceMap.getColor("labelErrorsCount.foreground"));
        this.jLabel14.setText(resourceMap.getString("labelErrorsCount.text", new Object[0]));
        this.jLabel14.setName("labelErrorsCount");
        this.jLabelErrorDescr.setForeground(resourceMap.getColor("labelErrorDescr.foreground"));
        this.jLabelErrorDescr.setText(resourceMap.getString("labelErrorDescr.text", new Object[0]));
        this.jLabelErrorDescr.setName("labelErrorDescr");
        this.jLabelI2CErrors.setText(resourceMap.getString("jLabelI2CErrors.text", new Object[0]));
        this.jLabelI2CErrors.setName("jLabelI2CErrors");
        this.jLabelCycleTime.setText(resourceMap.getString("jLabelCycleTime.text", new Object[0]));
        this.jLabelCycleTime.setName("jLabelCycleTime");
        this.jLabel13.setForeground(resourceMap.getColor("jLabel13.foreground"));
        this.jLabel13.setText(resourceMap.getString("jLabel13.text", new Object[0]));
        this.jLabel13.setName("jLabel13");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabelErrorDescr, -2, 690, -2).addGap(27, 27, 27)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabelErrorTitle, -1, 448, Short.MAX_VALUE).addGap(67, 67, 67).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelCycleTime, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelI2CErrors, -2, 46, -2)))));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelI2CErrors).addComponent(this.jLabel14).addComponent(this.jLabelCycleTime).addComponent(this.jLabel13).addComponent(this.jLabelErrorTitle)).addGap(5, 5, 5).addComponent(this.jLabelErrorDescr, -1, 78, Short.MAX_VALUE).addContainerGap()));
        this.jPanelMain.add((Component)this.jPanel4, new AbsoluteConstraints(0, 520, 740, 110));
        this.jPanel5.setName("jPanel5");
        this.jPanel5.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanelYawAngle.setName("jPanelYawAngle");
        this.jPanelYawAngle.setPreferredSize(new Dimension(171, 171));
        this.jPanelYawAngle.setLayout(new BoxLayout(this.jPanelYawAngle, 2));
        this.jPanel5.add((Component)this.jPanelYawAngle, new AbsoluteConstraints(0, 10, -1, -1));
        this.jPanelRollAngle.setName("jPanelRollAngle");
        this.jPanelRollAngle.setPreferredSize(new Dimension(171, 171));
        this.jPanelRollAngle.setLayout(new BoxLayout(this.jPanelRollAngle, 2));
        this.jPanel5.add((Component)this.jPanelRollAngle, new AbsoluteConstraints(0, 180, -1, -1));
        this.jPanelPitchAngle.setName("jPanelPitchAngle");
        this.jPanelPitchAngle.setPreferredSize(new Dimension(171, 171));
        this.jPanelPitchAngle.setLayout(new BoxLayout(this.jPanelPitchAngle, 2));
        this.jPanel5.add((Component)this.jPanelPitchAngle, new AbsoluteConstraints(0, 360, -1, -1));
        this.jPanelMain.add((Component)this.jPanel5, new AbsoluteConstraints(750, 100, -1, -1));
        this.jButtonRead.setAction(actionMap.get("buttonReadParams"));
        this.jButtonRead.setText(resourceMap.getString("buttonRead.text", new Object[0]));
        this.jButtonRead.setToolTipText(resourceMap.getString("buttonRead.toolTipText", new Object[0]));
        this.jButtonRead.setName("buttonRead");
        this.jPanelMain.add((Component)this.jButtonRead, new AbsoluteConstraints(450, 485, 140, 30));
        this.jButtonWrite.setAction(actionMap.get("buttonWriteParams"));
        this.jButtonWrite.setText(resourceMap.getString("buttonWrite.text", new Object[0]));
        this.jButtonWrite.setToolTipText(resourceMap.getString("buttonWrite.toolTipText", new Object[0]));
        this.jButtonWrite.setName("buttonWrite");
        this.jPanelMain.add((Component)this.jButtonWrite, new AbsoluteConstraints(600, 485, 140, 30));
        this.jToggleButtonMotors.setAction(actionMap.get("buttonMotorsOn"));
        this.jToggleButtonMotors.setText(resourceMap.getString("jToggleButtonMotors.text", new Object[0]));
        this.jToggleButtonMotors.setName("jToggleButtonMotors");
        this.jPanelMain.add((Component)this.jToggleButtonMotors, new AbsoluteConstraints(7, 485, 180, 30));
        this.jProgressBarMain.setName("jProgressBarMain");
        this.jProgressBarMain.setStringPainted(true);
        this.jPanelMain.add((Component)this.jProgressBarMain, new AbsoluteConstraints(200, 490, 240, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.jPanelMain, gridBagConstraints);
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("menuFile.text", new Object[0]));
        fileMenu.setName("menuFile");
        this.menuLoadProfile.setAction(actionMap.get("loadProfile"));
        this.menuLoadProfile.setText(resourceMap.getString("menuLoadProfile.text", new Object[0]));
        this.menuLoadProfile.setName("menuLoadProfile");
        fileMenu.add(this.menuLoadProfile);
        this.menuSaveProfile.setAction(actionMap.get("saveProfile"));
        this.menuSaveProfile.setText(resourceMap.getString("menuSaveProfile.text", new Object[0]));
        this.menuSaveProfile.setName("menuSaveProfile");
        fileMenu.add(this.menuSaveProfile);
        this.menuSaveAllProfiles.setAction(actionMap.get("saveAllProfiles"));
        this.menuSaveAllProfiles.setText(resourceMap.getString("menuSaveAllProfiles.text", new Object[0]));
        this.menuSaveAllProfiles.setName("menuSaveAllProfiles");
        fileMenu.add(this.menuSaveAllProfiles);
        this.jSeparator5.setName("jSeparator5");
        fileMenu.add(this.jSeparator5);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setText(resourceMap.getString("menuItemExit.text", new Object[0]));
        exitMenuItem.setName("menuItemExit");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.boardMenu.setText(resourceMap.getString("boardMenu.text", new Object[0]));
        this.boardMenu.setName("boardMenu");
        this.menuReadParams.setAction(actionMap.get("buttonReadParams"));
        this.menuReadParams.setText(resourceMap.getString("menuReadParams.text", new Object[0]));
        this.menuReadParams.setName("menuReadParams");
        this.boardMenu.add(this.menuReadParams);
        this.menuWriteParams.setAction(actionMap.get("buttonWriteParams"));
        this.menuWriteParams.setText(resourceMap.getString("menuWriteParams.text", new Object[0]));
        this.menuWriteParams.setName("menuWriteParams");
        this.boardMenu.add(this.menuWriteParams);
        this.menuWriteParamsAll.setAction(actionMap.get("buttonWriteAllProfiles"));
        this.menuWriteParamsAll.setText(resourceMap.getString("menuWriteParamsAll.text", new Object[0]));
        this.menuWriteParamsAll.setName("menuWriteParamsAll");
        this.boardMenu.add(this.menuWriteParamsAll);
        this.jSeparator4.setName("jSeparator4");
        this.boardMenu.add(this.jSeparator4);
        this.sensorMenu.setText(resourceMap.getString("sensorMenu.text", new Object[0]));
        this.sensorMenu.setName("sensorMenu");
        this.menuCalibAcc.setAction(actionMap.get("buttonCalibACCAction"));
        this.menuCalibAcc.setText(resourceMap.getString("menuCalibAcc.text", new Object[0]));
        this.menuCalibAcc.setToolTipText(resourceMap.getString("jButtonCalibACC.toolTipText", new Object[0]));
        this.menuCalibAcc.setName("menuCalibAcc");
        this.sensorMenu.add(this.menuCalibAcc);
        this.menuCalibrateGyro.setAction(actionMap.get("buttonCalibGyroAction"));
        this.menuCalibrateGyro.setText(resourceMap.getString("menuCalibrateGyro.text", new Object[0]));
        this.menuCalibrateGyro.setToolTipText(resourceMap.getString("jButtonCalibGyro.toolTipText", new Object[0]));
        this.menuCalibrateGyro.setName("menuCalibrateGyro");
        this.sensorMenu.add(this.menuCalibrateGyro);
        this.boardMenu.add(this.sensorMenu);
        this.jSeparator3.setName("jSeparator3");
        this.boardMenu.add(this.jSeparator3);
        this.menuUseDefaults.setAction(actionMap.get("buttonUseDefaults"));
        this.menuUseDefaults.setText(resourceMap.getString("menuUseDefaults.text", new Object[0]));
        this.menuUseDefaults.setName("menuUseDefaults");
        this.boardMenu.add(this.menuUseDefaults);
        this.menuEraseEEPROM.setAction(actionMap.get("eraseEEPROM"));
        this.menuEraseEEPROM.setText(resourceMap.getString("menuEraseEEPROM.text", new Object[0]));
        this.menuEraseEEPROM.setName("menuEraseEEPROM");
        this.boardMenu.add(this.menuEraseEEPROM);
        this.jSeparator9.setName("jSeparator9");
        this.boardMenu.add(this.jSeparator9);
        this.menBackupEEPROM.setAction(actionMap.get("backupEEPROM"));
        this.menBackupEEPROM.setText(resourceMap.getString("menBackupEEPROM.text", new Object[0]));
        this.menBackupEEPROM.setName("menBackupEEPROM");
        this.boardMenu.add(this.menBackupEEPROM);
        this.menuRestoreEEPROM.setAction(actionMap.get("restoreEEPROM"));
        this.menuRestoreEEPROM.setText(resourceMap.getString("menuRestoreEEPROM.text", new Object[0]));
        this.menuRestoreEEPROM.setName("menuRestoreEEPROM");
        this.boardMenu.add(this.menuRestoreEEPROM);
        this.menuBar.add(this.boardMenu);
        this.languageMenu.setText("Language");
        this.languageMenu.setName("menuLanguage");
        this.menuEN.setAction(actionMap.get("changeEnglishLocale"));
        this.buttonGroupLang.add(this.menuEN);
        this.menuEN.setText(resourceMap.getString("menuEN.text", new Object[0]));
        this.menuEN.setName("menuEN");
        this.languageMenu.add(this.menuEN);
        this.menuRU.setAction(actionMap.get("changeRussianLocale"));
        this.buttonGroupLang.add(this.menuRU);
        this.menuRU.setText(resourceMap.getString("menuRU.text", new Object[0]));
        this.menuRU.setName("menuRU");
        this.languageMenu.add(this.menuRU);
        this.menuDE.setAction(actionMap.get("changeDeutscheLocale"));
        this.buttonGroupLang.add(this.menuDE);
        this.menuDE.setText(resourceMap.getString("menuDE.text", new Object[0]));
        this.menuDE.setName("menuDE");
        this.languageMenu.add(this.menuDE);
        this.menuFR.setAction(actionMap.get("changeFrenchLocale"));
        this.buttonGroupLang.add(this.menuFR);
        this.menuFR.setText(resourceMap.getString("menuFR.text", new Object[0]));
        this.menuFR.setName("menuFR");
        this.languageMenu.add(this.menuFR);
        this.menuCN.setAction(actionMap.get("changeChineseLocale"));
        this.buttonGroupLang.add(this.menuCN);
        this.menuCN.setText(resourceMap.getString("menuCN.text", new Object[0]));
        this.menuCN.setName("menuCN");
        this.languageMenu.add(this.menuCN);
        this.menuPL.setAction(actionMap.get("changePolishLocale"));
        this.buttonGroupLang.add(this.menuPL);
        this.menuPL.setText(resourceMap.getString("menuPL.text", new Object[0]));
        this.menuPL.setName("menuPL");
        this.languageMenu.add(this.menuPL);
        this.menuIT.setAction(actionMap.get("changeItalianLocale"));
        this.buttonGroupLang.add(this.menuIT);
        this.menuIT.setText(resourceMap.getString("menuIT.text", new Object[0]));
        this.menuIT.setName("menuIT");
        this.languageMenu.add(this.menuIT);
        this.menuCZ.setAction(actionMap.get("changeCZLocale"));
        this.buttonGroupLang.add(this.menuCZ);
        this.menuCZ.setText(resourceMap.getString("menuCZ.text", new Object[0]));
        this.menuCZ.setName("menuCZ");
        this.languageMenu.add(this.menuCZ);
        this.menuSE.setAction(actionMap.get("changeSElocale"));
        this.menuSE.setText(resourceMap.getString("menuSE.text", new Object[0]));
        this.menuSE.setName("menuSE");
        this.languageMenu.add(this.menuSE);
        this.menuJP.setAction(actionMap.get("changeJPLocale"));
        this.menuJP.setText(resourceMap.getString("menuJP.text", new Object[0]));
        this.menuJP.setName("menuJP");
        this.languageMenu.add(this.menuJP);
        this.menuBar.add(this.languageMenu);
        this.viewMenu.setText(resourceMap.getString("viewMenu.text", new Object[0]));
        this.viewMenu.setName("viewMenu");
        this.menuViewClassic.setAction(actionMap.get("menuSetThemeClassic"));
        this.buttonGroupView.add(this.menuViewClassic);
        this.menuViewClassic.setText(resourceMap.getString("menuViewClassic.text", new Object[0]));
        this.menuViewClassic.setName("menuViewClassic");
        this.viewMenu.add(this.menuViewClassic);
        this.menuViewHighContrastDark.setAction(actionMap.get("menuSetThemeHighContrastDark"));
        this.buttonGroupView.add(this.menuViewHighContrastDark);
        this.menuViewHighContrastDark.setText(resourceMap.getString("menuViewHighContrastDark.text", new Object[0]));
        this.menuViewHighContrastDark.setName("menuViewHighContrastDark");
        this.viewMenu.add(this.menuViewHighContrastDark);
        this.menuViewHighContrastLight.setAction(actionMap.get("menuSetThemeHighContrastLight"));
        this.buttonGroupView.add(this.menuViewHighContrastLight);
        this.menuViewHighContrastLight.setText(resourceMap.getString("menuViewHighContrastLight.text", new Object[0]));
        this.menuViewHighContrastLight.setName("menuViewHighContrastLight");
        this.viewMenu.add(this.menuViewHighContrastLight);
        this.jSeparator2.setName("jSeparator2");
        this.viewMenu.add(this.jSeparator2);
        this.jMenuItem1.setAction(actionMap.get("fullScreen"));
        this.jMenuItem1.setText(resourceMap.getString("jMenuItem1.text", new Object[0]));
        this.jMenuItem1.setName("jMenuItem1");
        this.viewMenu.add(this.jMenuItem1);
        this.menuBar.add(this.viewMenu);
        helpMenu.setText(resourceMap.getString("menuHelp.text", new Object[0]));
        helpMenu.setName("menuHelp");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("menuItemAbout");
        helpMenu.add(aboutMenuItem);
        this.jSeparator1.setName("jSeparator1");
        helpMenu.add(this.jSeparator1);
        this.bugReportMenuItem.setAction(actionMap.get("actionBugReport"));
        this.bugReportMenuItem.setText(resourceMap.getString("bugReportMenuItem.text", new Object[0]));
        this.bugReportMenuItem.setName("bugReportMenuItem");
        helpMenu.add(this.bugReportMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        this.statusPanel.setPreferredSize(new Dimension(944, 30));
        statusPanelSeparator.setName("statusPanelSeparator");
        this.jLabelStatus.setName("jLabelStatus");
        this.jPanelBat.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("jPanelBat.border.lineColor")));
        this.jPanelBat.setName("jPanelBat");
        this.jPanelBat.setLayout(new BoxLayout(this.jPanelBat, 2));
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelStatus, -1, 738, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelBat, -2, 176, -2).addContainerGap()).addComponent(statusPanelSeparator, GroupLayout.Alignment.TRAILING, -1, 944, Short.MAX_VALUE));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelBat, -2, 17, -2).addComponent(this.jLabelStatus, -2, 20, -2)).addContainerGap()));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void jCBPortListPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.setPortList();
    }

    private void jComboBoxProfileItemStateChanged(ItemEvent evt) {
        int profile;
        if (evt.getStateChange() == 1 && (profile = this.jComboBoxProfile.getSelectedIndex()) != this.oldProfile) {
            logger.info("New profile selected: " + profile);
            BoardParams params = BoardParams.getCurParams();
            if (params != null) {
                this.applyBoardParams(params);
                params.curProfile = profile;
                this.updateBoardParams();
            }
            this.oldProfile = profile;
        }
    }

    private void jToggleButtonPauseStateChanged(ChangeEvent evt) {
        RealtimeDataThread.pause(this.jToggleButtonPause.isSelected());
        Settings.set("realtime.data.paused", new Boolean(this.jToggleButtonPause.isSelected()).toString());
        Settings.save();
    }

    private void jSliderScaleStateChanged(ChangeEvent evt) {
        this.chart.setZoomY((float)this.jSliderScale.getValue() / 500.0f);
    }

    private void jSpinnerFrameRateStateChanged(ChangeEvent evt) {
        RealtimeDataThread.setFrameRate(((Number)this.jSpinnerFrameRate.getValue()).intValue());
    }

    private void jSpinnerExpoRateStateChanged(ChangeEvent evt) {
        this.expoCurvePanel.setRate(((Number)this.jSpinnerExpoRate.getModel().getValue()).intValue());
    }

    private void jSpinnerDeadbandStateChanged(ChangeEvent evt) {
        this.expoCurvePanel.setDeadband(((Number)this.jSpinnerDeadband.getModel().getValue()).intValue());
    }

    private void jSpinnerFollowDeadbandStateChanged(ChangeEvent evt) {
        this.followExpoCurvePanel.setDeadband(((Number)this.jSpinnerFollowDeadband.getModel().getValue()).intValue());
    }

    private void jSpinnerFollowExpoRateStateChanged(ChangeEvent evt) {
        this.followExpoCurvePanel.setRate(((Number)this.jSpinnerFollowExpoRate.getModel().getValue()).intValue());
    }

    private void jComboBoxBatDefaultItemStateChanged(ItemEvent evt) {
        BatInfo bat = ((BatComboBoxModel)this.jComboBoxBatDefault.getModel()).getCurrent();
        if (bat != null) {
            this.jSpinnerBatThresholdAlarm.setValue(Float.valueOf((float)bat.alarm_threshold / 100.0f));
            this.jSpinnerBatThresholdMotors.setValue(Float.valueOf((float)bat.cutoff_threshold / 100.0f));
            this.jSpinnerBatCompRef.setValue(Float.valueOf((float)bat.full_charge / 100.0f));
        }
    }

    private void jCheckBoxAngleAccLimitStateChanged(ChangeEvent evt) {
        this.jSpinnerAngleAccLimit.setEnabled(this.jCheckBoxAngleAccLimit.isSelected());
    }

    private void jButtonDebugCmdActionPerformed(ActionEvent evt) {
        byte[] data = DatatypeConverter.parseHexBinary((String)this.jTextFieldDebugCmdData.getText().replace(" ", ""));
        int id = this.jTextFieldDebugCmd.getText().charAt(0);
        if (id < 65) {
            id = Integer.parseInt(this.jTextFieldDebugCmd.getText());
        }
        SerialCommand cmd = new SerialCommand(id, data.length);
        try {
            cmd.write(data);
            SerialCommandProcessor.sendCommand(cmd);
            this.debugMessage("out: " + cmd.toString());
        }
        catch (Exception e) {
            this.debugMessage("err: " + e.toString());
        }
    }

    public void debugSerialCommand(SerialCommand cmd) {
        this.debugMessage("in: " + cmd.toString());
    }

    private void jButtonDebugClearActionPerformed(ActionEvent evt) {
        this.jTextAreaDebugCmd.setText(null);
    }

    private void jCheckBoxDebugVarsStateChanged(ChangeEvent evt) {
        if (this.jCheckBoxDebugVars.isSelected()) {
            Settings.set("realtime.debug_vars", "true");
            SerialCommandProcessor.requestDebugVarsInfo();
        } else {
            Settings.set("realtime.debug_vars", "false");
            DebugVars.setVars(null);
        }
        Settings.save();
    }

    private void jComboBoxEncoderTypeItemStateChanged(ItemEvent evt) {
        int type = this.jComboBoxEncoderType.getSelectedIndex();
        if (BoardParams.is_encoder_SPI(type)) {
            this.jComboBoxEncoderSPI.setEnabled(true);
        } else {
            this.jComboBoxEncoderSPI.setEnabled(false);
        }
    }

    private void jCheckBoxLogRTDataRewriteActionPerformed(ActionEvent evt) {
        this.jCheckBoxLogRTDataActionPerformed(evt);
    }

    private void jCheckBoxLogRTDataActionPerformed(ActionEvent evt) {
        Settings.set("realtime.log_to_file", this.jCheckBoxLogRTData.isSelected() ? "true" : "false");
        Settings.set("realtime.log_rewrite", this.jCheckBoxLogRTDataRewrite.isSelected() ? "true" : "false");
        Settings.save();
    }

    private void tabbedPaneMainStateChanged(ChangeEvent evt) {
        RealtimeDataThread.setAdjVarsVisible(this.tabbedPaneMain.getSelectedComponent() == this.panelAdjVars);
        RealtimeDataThread.setMonitoringVisible(this.tabbedPaneMain.getSelectedComponent() == this.panelMonitoring);
    }

    public void debugMessage(String msg) {
        this.jTextAreaDebugCmd.append(msg + "\n");
    }

    private void changeLocaleMenuSelection() {
        Component[] menuElements;
        Locale locale = Settings.getLocale();
        for (Component menuItem : menuElements = this.languageMenu.getMenuComponents()) {
            JCheckBoxMenuItem item;
            if (!(menuItem instanceof JCheckBoxMenuItem) || !(item = (JCheckBoxMenuItem)menuItem).getName().equalsIgnoreCase("menu" + locale.getCountry())) continue;
            item.setSelected(true);
        }
    }

    private void changeViewMenuSelection() {
        Component[] menuElements;
        for (Component menuItem : menuElements = this.viewMenu.getMenuComponents()) {
            JCheckBoxMenuItem item;
            if (!(menuItem instanceof JCheckBoxMenuItem) || !(item = (JCheckBoxMenuItem)menuItem).getName().equalsIgnoreCase("menuView" + SimpleBGC_GUIApp.theme)) continue;
            item.setSelected(true);
        }
    }

    private void setToolTipListener(Container parent, MouseListener ttl) {
        for (Component c : parent.getComponents()) {
            if (c instanceof JComponent && ((JComponent)c).getToolTipText() != null && ((JComponent)c).getToolTipText().length() > 0) {
                c.addMouseListener(ttl);
            }
            if (!(c instanceof Container)) continue;
            this.setToolTipListener((Container)c, ttl);
        }
    }

    private void MyInitComponents() {
        this.labelCurrentGuiVersionValue.setText(SimpleBGC_GUIApp.version.toString());
        this.checkBoxCheckOnStartup.setSelected(Settings.is("latest.versions.autocheck"));
        this.changeLocaleMenuSelection();
        this.changeViewMenuSelection();
        this.isPortConnected = false;
        this.jButtonConnect.setText(resourceMap.getString("jButtonConnect.connect.text", new Object[0]));
        try {
            SerialPortService.initSerialPortService();
            this.setPortList();
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
        SimpleBGC_GUIView.setProjectLink(this.jLabel3, null);
        this.spinnerP = new JSpinner[]{this.jSpinnerRollP, this.jSpinnerPitchP, this.jSpinnerYawP};
        this.spinnerI = new JSpinner[]{this.jSpinnerRollI, this.jSpinnerPitchI, this.jSpinnerYawI};
        this.spinnerD = new JSpinner[]{this.jSpinnerRollD, this.jSpinnerPitchD, this.jSpinnerYawD};
        this.spinnerPower = new JSpinner[]{this.jSpinnerRollPower, this.jSpinnerPitchPower, this.jSpinnerYawPower};
        this.spinnerBooster = new JSpinner[]{this.jSpinnerRollBooster, this.jSpinnerPitchBooster, this.jSpinnerYawBooster};
        this.checkBoxInvert = new JCheckBox[]{this.jCheckBoxRollInvert, this.jCheckBoxPitchInvert, this.jCheckBoxYawInvert};
        this.spinnerPoles = new JSpinner[]{this.jSpinnerRollPoles, this.jSpinnerPitchPoles, this.jSpinnerYawPoles};
        this.spinnerExtGain = new JSpinner[]{this.jSpinnerRollExtGain, this.jSpinnerPitchExtGain};
        this.spinnerRCMin = new JSpinner[]{this.jSpinnerRCRollMin, this.jSpinnerRCPitchMin, this.jSpinnerRCYawMin};
        this.spinnerRCMax = new JSpinner[]{this.jSpinnerRCRollMax, this.jSpinnerRCPitchMax, this.jSpinnerRCYawMax};
        this.spinnerRCLPF = new JSpinner[]{this.jSpinnerRCRollLPF, this.jSpinnerRCPitchLPF, this.jSpinnerRCYawLPF};
        this.spinnerRCSpeed = new JSpinner[]{this.jSpinnerRCRollSpeed, this.jSpinnerRCPitchSpeed, this.jSpinnerRCYawSpeed};
        this.spinnerFollowSpeed = new JSpinner[]{this.jSpinnerFollowRollSpeed, this.jSpinnerFollowPitchSpeed, this.jSpinnerFollowYawSpeed};
        this.spinnerRCFollow = new JSpinner[]{this.jSpinnerRCRollFollow, this.jSpinnerRCPitchFollow};
        this.rbRCModeAngle = new JRadioButton[]{this.jRButtonRollModeAbs, this.jRButtonPitchModeAbs, this.jRButtonYawModeAbs};
        this.rbRCModeSpeed = new JRadioButton[]{this.jRButtonRollModeInc, this.jRButtonPitchModeInc, this.jRButtonYawModeInc};
        this.spinnerRCMemory = new JSpinner[]{this.jSpinnerRCRollMemory, this.jSpinnerRCPitchMemory, this.jSpinnerRCYawMemory};
        this.checkBoxRCInverse = new JCheckBox[]{this.jCheckBoxRCRollInverse, this.jCheckBoxRCPitchInverse, this.jCheckBoxRCYawInverse};
        this.spinnerFollowLPF = new JSpinner[]{this.jSpinnerFollowRollLPF, this.jSpinnerFollowPitchLPF, this.jSpinnerFollowYawLPF};
        this.rollList = new JComponent[]{this.jLabel4, this.jSpinnerRollP, this.jSpinnerRollI, this.jSpinnerRollD, this.jLabel12, this.jSpinnerRollPower, this.jSpinnerRollBooster, this.jCheckBoxRollInvert, this.jSpinnerRollPoles, this.jLabel25, this.jComboBoxRCRollCh, this.jLabel33, this.jSpinnerRCRollMin, this.jSpinnerRCRollMax, this.jRButtonRollModeAbs, this.jRButtonRollModeInc, this.jSpinnerRCRollLPF, this.jSpinnerRCRollFollow, this.jSpinnerTrimRoll};
        this.pitchList = new JComponent[]{this.jLabel6, this.jSpinnerPitchP, this.jSpinnerPitchI, this.jSpinnerPitchD, this.jLabel19, this.jSpinnerPitchPower, this.jSpinnerPitchBooster, this.jCheckBoxPitchInvert, this.jSpinnerPitchPoles, this.jLabel26, this.jComboBoxRCPitchCh, this.jLabel40, this.jSpinnerRCPitchMin, this.jSpinnerRCPitchMax, this.jRButtonPitchModeAbs, this.jRButtonPitchModeInc, this.jSpinnerRCPitchLPF, this.jSpinnerRCPitchFollow, this.jSpinnerTrimPitch};
        this.yawList = new JComponent[]{this.jLabel7, this.jSpinnerYawP, this.jSpinnerYawI, this.jSpinnerYawD, this.jLabel20, this.jSpinnerYawPower, this.jSpinnerYawBooster, this.jCheckBoxYawInvert, this.jSpinnerYawPoles, this.jLabel27, this.jComboBoxRCYawCh, this.jLabel41, this.jSpinnerRCYawMin, this.jSpinnerRCYawMax, this.jRButtonYawModeAbs, this.jRButtonYawModeInc, this.jSpinnerRCYawLPF, this.jCheckBoxFollowYaw, this.jSpinnerTrimYaw};
        this.comboBoxRCCmd = new JComboBox[]{this.jComboBoxRCLowCmd, this.jComboBoxRCMidCmd, this.jComboBoxRCHighCmd};
        this.comboBoxRCMap = new JComboBox[]{this.jComboBoxRCRollCh, this.jComboBoxRCPitchCh, this.jComboBoxRCYawCh, this.jComboBoxRCCmdCh, this.jComboBoxFCRollCh, this.jComboBoxFCPitchCh};
        this.comboBoxRCMix = new JComboBox[]{this.jComboBoxMixRoll, this.jComboBoxMixPitch};
        this.comboBoxRCOut = new JComboBox[]{this.jComboBoxRCOut1, this.jComboBoxRCOut2, this.jComboBoxRCOut3, this.jComboBoxRCOut4};
        this.spinnerRCMix = new JSpinner[]{this.jSpinnerMixRoll, this.jSpinnerMixPitch};
        this.comboBoxMenu = new JComboBox[]{this.jComboBoxMenu1, this.jComboBoxMenu2, this.jComboBoxMenu3, this.jComboBoxMenu4, this.jComboBoxMenu5, this.jComboBoxMenuLong};
        this.comboBoxOutput = new JComboBox[]{this.jComboBoxOutputRoll, this.jComboBoxOutputPitch, this.jComboBoxOutputYaw};
        this.spinnerRCTrim = new JSpinner[]{this.jSpinnerTrimRoll, this.jSpinnerTrimPitch, this.jSpinnerTrimYaw};
        this.spinnerManualSetTime = new JSpinner[]{this.jSpinnerManualSetTimeRoll, this.jSpinnerManualSetTimePitch, this.jSpinnerManualSetTimeYaw};
        this.spinnerHeating = new JSpinner[]{this.jSpinnerHeatingRoll, this.jSpinnerHeatingPitch, this.jSpinnerHeatingYaw};
        this.spinnerCooling = new JSpinner[]{this.jSpinnerCoolingRoll, this.jSpinnerCoolingPitch, this.jSpinnerCoolingYaw};
        this.spinnerEncoderOffset = new JSpinner[]{this.jSpinnerEncoderOffsetRoll, this.jSpinnerEncoderOffsetPitch, this.jSpinnerEncoderOffsetYaw};
        this.spinnerEncoderFldOffset = new JSpinner[]{this.jSpinnerEncoderFldOffsetRoll, this.jSpinnerEncoderFldOffsetPitch, this.jSpinnerEncoderFldOffsetYaw};
        this.spinnerEncoderMagLink = new JSpinner[]{this.jSpinnerEncoderMagLinkRoll, this.jSpinnerEncoderMagLinkPitch, this.jSpinnerEncoderMagLinkYaw};
        this.spinnerMotorGear = new JSpinner[]{this.jSpinnerMotorGearRoll, this.jSpinnerMotorGearPitch, this.jSpinnerMotorGearYaw};
        this.spinnerNotchFreq1 = new JSpinner[]{this.jSpinnerNotchRollFreq1, this.jSpinnerNotchPitchFreq1, this.jSpinnerNotchYawFreq1};
        this.spinnerNotchFreq2 = new JSpinner[]{this.jSpinnerNotchRollFreq2, this.jSpinnerNotchPitchFreq2, this.jSpinnerNotchYawFreq2};
        this.spinnerNotchFreq3 = new JSpinner[]{this.jSpinnerNotchRollFreq3, this.jSpinnerNotchPitchFreq3, this.jSpinnerNotchYawFreq3};
        this.spinnerNotchWidth1 = new JSpinner[]{this.jSpinnerNotchRollWidth1, this.jSpinnerNotchPitchWidth1, this.jSpinnerNotchYawWidth1};
        this.spinnerNotchWidth2 = new JSpinner[]{this.jSpinnerNotchRollWidth2, this.jSpinnerNotchPitchWidth2, this.jSpinnerNotchYawWidth2};
        this.spinnerNotchWidth3 = new JSpinner[]{this.jSpinnerNotchRollWidth3, this.jSpinnerNotchPitchWidth3, this.jSpinnerNotchYawWidth3};
        this.checkBoxNotchEnabled1 = new JCheckBox[]{this.jCheckBoxNotchRollEnabled1, this.jCheckBoxNotchPitchEnabled1, this.jCheckBoxNotchYawEnabled1};
        this.checkBoxNotchEnabled2 = new JCheckBox[]{this.jCheckBoxNotchRollEnabled2, this.jCheckBoxNotchPitchEnabled2, this.jCheckBoxNotchYawEnabled2};
        this.checkBoxNotchEnabled3 = new JCheckBox[]{this.jCheckBoxNotchRollEnabled3, this.jCheckBoxNotchPitchEnabled3, this.jCheckBoxNotchYawEnabled3};
        this.spinnerLPFFreq = new JSpinner[]{this.jSpinnerLPFRollFreq, this.jSpinnerLPFPitchFreq, this.jSpinnerLPFYawFreq};
        this.checkBoxLPFEnabled = new JCheckBox[]{this.jCheckBoxLPFRollEnabled, this.jCheckBoxLPFPitchEnabled, this.jCheckBoxLPFYawEnabled};
        this.ver3Components = new JComponent[]{this.jToggleImuFrame, this.jToggleImuMain, this.jLabelToggleImu, this.jLabelFrameIMUPlace, this.jComboBoxFrameIMU, this.jSpinnerRCRollMemory, this.jSpinnerRCPitchMemory, this.jSpinnerRCYawMemory, this.jCheckBoxRCRollInverse, this.jCheckBoxRCPitchInverse, this.jCheckBoxRCYawInverse, this.jSpinnerFollowRollLPF, this.jSpinnerFollowPitchLPF, this.jSpinnerFollowYawLPF, this.jCheckBoxBeepMotors, this.jCheckBoxAdaptivePIDRoll, this.jCheckBoxAdaptivePIDPitch, this.jCheckBoxAdaptivePIDYaw, this.jCheckBoxRememberLastUsedProfile};
        MouseListener toolTipMouseListener = new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                SimpleBGC_GUIView.this.jLabelErrorDescr.setText("<html>" + ((JComponent)e.getSource()).getToolTipText() + "</html>");
            }

            public void mouseExited(MouseEvent e) {
                SimpleBGC_GUIView.this.jLabelErrorDescr.setText(errorDescr);
            }
        };
        this.setToolTipListener(this.mainPanel, toolTipMouseListener);
        this.setToolTipListener(this.menuBar, toolTipMouseListener);
        ToolTipManager.sharedInstance().setEnabled(false);
        this.panelAdjVars = new JPanelAdjVars(this);
        this.updateBoardVerUI(null);
        try {
            this.anglePanels[0] = new AnglePanel(this.getClass().getResource("/simplebgc_gui/resources/roll.png"), this.getClass().getResource("/simplebgc_gui/resources/circle_bg3.png"));
            this.anglePanels[1] = new AnglePanel(this.getClass().getResource("/simplebgc_gui/resources/pitch.png"), this.getClass().getResource("/simplebgc_gui/resources/circle_bg3.png"));
            this.anglePanels[2] = new AnglePanel(this.getClass().getResource("/simplebgc_gui/resources/compass_arrow.png"), this.getClass().getResource("/simplebgc_gui/resources/compass_bg3.png"));
            this.jPanelRollAngle.add(this.anglePanels[0]);
            this.jPanelPitchAngle.add(this.anglePanels[1]);
            this.jPanelYawAngle.add(this.anglePanels[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.chart = new JRealChart();
        this.chartToggles = new ArrayList();
        this.chartLabels = new ArrayList();
        this.addChartTrace(new JRealTrace("ACC_X", !SimpleBGC_GUIApp.debugMode));
        this.addChartTrace(new JRealTrace("ACC_Y", !SimpleBGC_GUIApp.debugMode));
        this.addChartTrace(new JRealTrace("ACC_Z", !SimpleBGC_GUIApp.debugMode));
        this.addChartTrace(new JRealTrace("GYRO_X", !SimpleBGC_GUIApp.debugMode));
        this.addChartTrace(new JRealTrace("GYRO_Y", !SimpleBGC_GUIApp.debugMode));
        this.addChartTrace(new JRealTrace("GYRO_Z", !SimpleBGC_GUIApp.debugMode));
        this.addChartTrace(new JRealTrace("ERR_ROLL", false));
        this.addChartTrace(new JRealTrace("ERR_PITCH", false));
        this.addChartTrace(new JRealTrace("ERR_YAW", false));
        this.addChartTrace(new JRealTrace("POWER_ROLL", false));
        this.addChartTrace(new JRealTrace("POWER_PITCH", false));
        this.addChartTrace(new JRealTrace("POWER_YAW", false));
        if (SimpleBGC_GUIApp.debugMode) {
            this.addChartTrace(new JRealTrace("DEBUG_1", false));
            this.addChartTrace(new JRealTrace("DEBUG_2", false));
            this.addChartTrace(new JRealTrace("DEBUG_3", false));
            this.addChartTrace(new JRealTrace("DEBUG_4", false));
        }
        this.jChart.add(this.chart);
        for (int i = 0; i < this.rcPanels.length; ++i) {
            this.rcPanels[i] = new RCDataPanel(RealtimeData.RC_DATA_NAMES[i], 150, 20);
            this.jPanelRCData.add(this.rcPanels[i]);
        }
        this.rcCmdPanel = new RCDataPanel(null);
        this.rcCmdPanel.addMarker(1300);
        this.rcCmdPanel.addMarker(1700);
        this.jPanelRCCmd.add(this.rcCmdPanel);
        this.expoCurvePanel = new ExpoCurvePanel();
        this.jPanelExpoCurve.add(this.expoCurvePanel);
        this.followExpoCurvePanel = new ExpoCurvePanel();
        this.jPanelFollowExpo.add(this.followExpoCurvePanel);
        this.updateProfileNames();
        DefaultComboBoxModel tmp = (DefaultComboBoxModel)this.jComboBoxSerialSpeed.getModel();
        tmp.removeAllElements();
        for (int i = 0; i < SerialPortService.SERIAL_BAUD_RATES.length; ++i) {
            tmp.addElement(SerialPortService.SERIAL_BAUD_RATES[i]);
        }
        this.textFieldFirmwareHexFile.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.checkFlashButtonEnabled();
            }

            public void removeUpdate(DocumentEvent e) {
                this.checkFlashButtonEnabled();
            }

            public void insertUpdate(DocumentEvent e) {
                this.checkFlashButtonEnabled();
            }

            public void checkFlashButtonEnabled() {
                SimpleBGC_GUIView.this.buttonFirmwareHexFileFlash.setEnabled(SimpleBGC_GUIView.this.textFieldFirmwareHexFile.getText() != null && SimpleBGC_GUIView.this.textFieldFirmwareHexFile.getText().trim().length() > 0);
            }
        });
        this.jComboBoxBatDefault.setModel(new BatComboBoxModel(ParamsUIFactory.getBatInfoList()));
        this.jComboBoxBatDefault.setSelectedIndex(-1);
        this.batPanel = new RCDataPanel("BAT", "%.1f");
        this.jPanelBat.add(this.batPanel);
        this.updateError();
        this.updateStatus("");
        this.setConnected(false);
        this.comboBoxVersionTitle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1 && event.getItem() != null) {
                    final String details = ((IFirmwareInfo)event.getItem()).getDescription();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DefaultCaret caret = (DefaultCaret)SimpleBGC_GUIView.this.textAreaVersionDetails.getCaret();
                            caret.setUpdatePolicy(1);
                            SimpleBGC_GUIView.this.textAreaVersionDetails.setText(details);
                            SimpleBGC_GUIView.this.buttonFirmwareUpgradeStart.setEnabled(true);
                        }
                    });
                }
            }
        });
        this.comboBoxVersionTitle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1 && event.getItem() != null) {
                    final String description = ((IFirmwareInfo)event.getItem()).getDescription();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SimpleBGC_GUIView.this.textAreaVersionDetails.setText(null);
                            SimpleBGC_GUIView.this.textAreaVersionDetails.setText(description);
                        }
                    });
                }
            }
        });
        boolean realtimeDataPaused = Settings.is("realtime.data.paused");
        this.jToggleButtonPause.setSelected(realtimeDataPaused);
        RealtimeDataThread.pause(realtimeDataPaused);
        this.jCheckBoxDebugVars.setSelected(Settings.is("realtime.debug_vars"));
        this.jCheckBoxLogRTData.setSelected(Settings.is("realtime.log_to_file"));
        this.jCheckBoxLogRTDataRewrite.setSelected(Settings.get("realtime.log_rewrite", "true").equals("true"));
        this.jProgressBarMain.setVisible(false);
    }

    public void addChartTrace(final JRealTrace t) {
        this.chart.addTrace(t);
        AbstractAction chartListener = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JToggleButton toggle = (JToggleButton)e.getSource();
                t.setEnabled(toggle.isSelected());
                SimpleBGC_GUIView.this.chart.redraw();
            }
        };
        t.setStroke(new BasicStroke(2.0f));
        JToggleButton toggle = new JToggleButton(t.getName(), t.isEnabled());
        toggle.setVisible(true);
        toggle.setPreferredSize(new Dimension(90, 20));
        toggle.setMargin(new Insets(2, 2, 2, 2));
        toggle.setHorizontalAlignment(4);
        toggle.addActionListener(chartListener);
        this.jPanelChartToggle.add(toggle);
        this.chartToggles.add(toggle);
        JLabel label = new JLabel("0");
        label.setForeground(Color.WHITE);
        label.setBackground(t.getColor());
        label.setVisible(true);
        label.setHorizontalAlignment(4);
        label.setOpaque(true);
        label.setFont(new Font(this.jLabel1.getFont().getName(), 1, this.jLabel1.getFont().getSize()));
        label.setPreferredSize(new Dimension(40, 20));
        this.jPanelChartToggle.add(label);
        this.chartLabels.add(label);
        Dimension d = this.jPanelChartToggle.getPreferredSize();
        d.height = this.chartToggles.size() * (20 + ((FlowLayout)this.jPanelChartToggle.getLayout()).getVgap());
        this.jPanelChartToggle.setPreferredSize(d);
    }

    public void addDebugVar(DebugVar v) {
        JRealTrace trace = null;
        for (JRealTrace t : this.chart.traces) {
            if (!t.getName().equals(v.name)) continue;
            trace = t;
            break;
        }
        if (trace == null) {
            trace = new JRealTrace(v.name, false);
            this.addChartTrace(trace);
        }
        v.id = trace.id;
        v.color = trace.getColor();
    }

    public static String getProfileName(int id) {
        BoardParams params = BoardParams.getCurParams();
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (params != null && id < params.profiles.length && params.profiles[id].profileName != null) {
            return params.profiles[id].profileName;
        }
        if (boardInfo != null && boardInfo.profileNames != null && boardInfo.profileNames[id] != null) {
            return boardInfo.profileNames[id];
        }
        String profileTitle = Settings.get("profile." + id + ".name");
        if (profileTitle == null) {
            profileTitle = "Profile" + (id + 1);
        }
        return profileTitle;
    }

    public void updateProfileNames() {
        ItemListener ls = this.jComboBoxProfile.getItemListeners()[0];
        this.jComboBoxProfile.removeItemListener(ls);
        this.jComboBoxProfile.removeAllItems();
        for (int i = 0; i < BoardInfo.getNumProfiles(); ++i) {
            String name = SimpleBGC_GUIView.getProfileName(i);
            this.jComboBoxProfile.addItem(name);
        }
        this.jComboBoxProfile.addItemListener(ls);
    }

    public static void setProjectLink(JLabel jLabel, final String path) {
        jLabel.setText("<html><u>basecamelectronics.com</u></html>");
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    StringBuffer uri = new StringBuffer("http://www.basecamelectronics.com");
                    if (path != null) {
                        uri.append(path);
                    }
                    SimpleBGC_GUIView.browseURI(uri.toString());
                }
            }
        });
    }

    public static void browseURI(String link) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                URI uri = new URI(link);
                desktop.browse(uri);
            }
            catch (IOException ex) {
                logger.error(ex.toString());
            }
            catch (URISyntaxException ex) {
                logger.error(ex.toString());
            }
        }
    }

    private void setPortList() {
        ArrayList<Sprav> portList;
        if (!this.isPortConnected && (portList = SerialPortService.getPortList()) != null) {
            SpravComboBoxModel model = new SpravComboBoxModel(portList);
            this.jCBPortList.setModel(model);
            String lastUsedPortName = Settings.get("last.used.port");
            Sprav lastUsedPort = null;
            if (lastUsedPortName != null) {
                for (Sprav port : portList) {
                    if (!port.getName().equals(lastUsedPortName)) continue;
                    lastUsedPort = port;
                    break;
                }
            }
            if (lastUsedPort != null) {
                this.jCBPortList.setSelectedItem(lastUsedPort.getName());
            }
        }
    }

    @Action
    public void connect(String port, boolean findBoard) {
        this.connect(port, findBoard, "error.serial_connect");
    }

    public void connect(String port, boolean findBoard, String errorLabel) {
        block6: {
            try {
                SerialPortService.setBaudIndex(Integer.parseInt(Settings.get("latest.serial.baud")));
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                SerialPortService.connect(port);
                if (SerialPortService.isPortOpened()) {
                    this.jButtonConnect.setText(resourceMap.getString("jButtonConnect.disconnect.text", new Object[0]));
                    this.jButtonDebugConnect.setText("Disconnect");
                    this.jLabelConnState.setText(resourceMap.getString("jLabelConnState.connecting", port.toString()));
                    this.isPortConnected = true;
                    SerialCommandProcessor.setSerialPort(SerialPortService.getSerialPort());
                    if (findBoard) {
                        ConnectThread.initConnection();
                    }
                    break block6;
                }
                throw new Exception("Failed to connect for unknown reason");
            }
            catch (Exception ex) {
                logger.error(ex.toString());
                JOptionPane.showMessageDialog(null, resourceMap.getString(errorLabel, ex.getMessage()), resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            }
        }
    }

    public synchronized void stopSerialCommunication() {
        if (this.serialCommunicationActive) {
            ConnectThread.stopConnection();
            RealtimeDataThread.stop();
            SerialCommandProcessor.stopSerialCommunication();
            this.serialCommunicationActive = false;
        }
    }

    public synchronized void disconnect() {
        try {
            this.stopSerialCommunication();
            SerialPortService.disconnect();
            if (!SerialPortService.isPortOpened()) {
                this.jButtonConnect.setText(resourceMap.getString("jButtonConnect.connect.text", new Object[0]));
                this.jButtonDebugConnect.setText("Connect");
                this.isPortConnected = false;
                SerialCommandProcessor.setSerialPort(null);
                this.setConnected(false);
            }
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
    }

    @Action
    public void connectDisconnect() {
        if (!this.isPortConnected) {
            if (this.jCBPortList.getSelectedIndex() != -1) {
                String port = (String)this.jCBPortList.getSelectedItem();
                this.connect(port, true);
            } else {
                JOptionPane.showMessageDialog(null, resourceMap.getString("error.select_port", new Object[0]), resourceMap.getString("messageDialog.error.title", new Object[0]), 2);
            }
        } else {
            this.disconnect();
        }
    }

    private File createProfilesDirectory() {
        File workingDirectory = null;
        try {
            File lastUsedProfilesDirectory;
            workingDirectory = new File(Settings.getWorkingDirectory());
            if (Settings.get("last_used_profiles_directory") != null && (lastUsedProfilesDirectory = new File(Settings.get("last_used_profiles_directory"))).exists() && lastUsedProfilesDirectory.isDirectory()) {
                return lastUsedProfilesDirectory;
            }
            File profilesDirectory = new File(workingDirectory.getPath() + File.separatorChar + "profiles");
            if (!profilesDirectory.exists()) {
                logger.debug("Creating \"profiles\" directory...");
                profilesDirectory.mkdirs();
            }
            return profilesDirectory;
        }
        catch (Exception e) {
            logger.error("Error creating \"profiles\" directory: " + e.toString());
            return workingDirectory;
        }
    }

    @Action
    public void upgradeFirmwareFromHexFile() {
        File firmwareHexFile = new File("test.hex");
        if (this.textFieldFirmwareHexFile.getText() == null || this.textFieldFirmwareHexFile.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("error.firmware_is_not_specified", new Object[0]), resourceMap.getString("messageDialog.firmware_error.title", new Object[0]), 0);
            return;
        }
        firmwareHexFile = new File(this.textFieldFirmwareHexFile.getText().trim());
        if (!firmwareHexFile.exists()) {
            JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("error.firmware_file_does_not_exist", new Object[0]), resourceMap.getString("messageDialog.firmware_error.title", new Object[0]), 0);
            return;
        }
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo == null) {
            boardInfo = new BoardInfo();
            switch (this.comboBoxBoardType.getSelectedIndex()) {
                case 0: {
                    boardInfo.boardVer = 10;
                    break;
                }
                case 1: {
                    boardInfo.boardVer = 30;
                    break;
                }
                case 2: {
                    boardInfo.boardVer = 30;
                    boardInfo.connectionFlags = 1;
                }
            }
        }
        if (this.jCBPortList.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("error.port_is_not_selected", new Object[0]), resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            return;
        }
        DialogFirmwareUpgrade.flash(0, 0, this, (String)this.jCBPortList.getSelectedItem(), firmwareHexFile, boardInfo);
    }

    @Action
    public void selectFirmwareHexFile() {
        JFileChooser fileChooser = new JFileChooser();
        if (Settings.get("last_used_firmware_directory") != null) {
            String lastUsedFirmwareDirectory = Settings.get("last_used_firmware_directory");
            fileChooser.setCurrentDirectory(new File(lastUsedFirmwareDirectory));
        } else {
            try {
                fileChooser.setCurrentDirectory(new File(Settings.getWorkingDirectory() + File.separatorChar + "firmware"));
            }
            catch (Exception e) {
                logger.error(resourceMap.getString("error.firmware.cant_set_default_directory", e.toString()));
            }
        }
        if (OSUtil.isWindows()) {
            fileChooser.setFileFilter(new FileNameExtensionFilter(resourceMap.getString("messageDialog.firmware_hex_file.title", new Object[0]), "hex", "bin"));
        } else {
            fileChooser.setFileFilter(new FileNameExtensionFilter(resourceMap.getString("messageDialog.firmware_bin_file.title", new Object[0]), "bin"));
        }
        if (fileChooser.showOpenDialog(this.getFrame()) == 0) {
            Settings.set("last_used_firmware_directory", fileChooser.getCurrentDirectory().getPath());
            Settings.save();
            File firmware = fileChooser.getSelectedFile();
            this.textFieldFirmwareHexFile.setText(firmware.getAbsolutePath());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleBGC_GUIView.this.buttonFirmwareHexFileFlash.setEnabled(true);
                }
            });
        }
    }

    @Action
    public void loadProfile() {
        int profileId = this.jComboBoxProfile.getSelectedIndex();
        if (5 < profileId + 1) {
            JOptionPane.showMessageDialog(this.getFrame(), "Current board params implementation does not support more than 5 profiles!", resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            return;
        }
        File f = this.showProfileLoadDialog("Profile file", "profile");
        if (this.isSaved() && f != null) {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8")){

                protected MapperWrapper wrapMapper(MapperWrapper next) {
                    return new MapperWrapper((Mapper)next){

                        public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                            if (definedIn == Object.class) {
                                return false;
                            }
                            return super.shouldSerializeMember(definedIn, fieldName);
                        }
                    };
                }
            };
            xstream.registerConverter((Converter)new DefaultConstructorConverter(xstream.getMapper(), xstream.getReflectionProvider()));
            xstream.processAnnotations(BoardParams.class);
            xstream.processAnnotations(BoardParamsSavedData.class);
            xstream.processAnnotations(BoardProfile.class);
            xstream.processAnnotations(AdjVarAnalogCfg.class);
            xstream.processAnnotations(AdjVarTriggerCfg.class);
            logger.trace("Reading saved data from \"" + f.getPath() + "\"...");
            String content = null;
            try {
                content = FileUtil.read(f.getPath()).toString();
                logger.debug("File was loaded. Parsing..");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("error.reading_file", f.getPath(), e.toString()), resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            }
            try {
                Object o = xstream.fromXML(content);
                logger.debug("XStream parsing done.");
                if (o == null) {
                    throw new Exception("Read object is null!");
                }
                if (!(o instanceof BoardParamsSavedData)) {
                    throw new Exception("Unknown class \"" + o.getClass().getName() + "\"!");
                }
                BoardParams copy = BoardParams.getCurParams().clone();
                BoardParams loaded = ((BoardParamsSavedData)o).join(copy, profileId);
                BoardParams.setCurParams(loaded);
                this.updateBoardParams();
                this.updateStatus(resourceMap.getString("status.profile_loaded_from_file", new Object[0]));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("error.parsing_profile", e.toString()), resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            }
        }
    }

    @Action
    public void saveProfile() {
        int profileId = this.jComboBoxProfile.getSelectedIndex();
        if (5 < profileId + 1) {
            JOptionPane.showMessageDialog(this.getFrame(), "Current board params implementatiuon does not support more than 5 profiles!", resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            return;
        }
        this._saveProfile(profileId, (String)this.jComboBoxProfile.getSelectedItem());
    }

    @Action
    public void saveAllProfiles() {
        this._saveProfile(-1, "all_profiles");
    }

    public void _saveProfile(int profileId, String profileName) {
        File f = this.showProfileSaveDialog("Profile file", "profile", profileName + ".profile");
        if (f != null) {
            BoardParams copy;
            BoardParams params = BoardParams.getCurParams();
            try {
                copy = params.clone();
                this.applyBoardParams(copy);
            }
            catch (Exception e) {
                logger.error("Error applying params: " + e.toString());
                return;
            }
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            xstream.processAnnotations(BoardParams.class);
            xstream.processAnnotations(BoardParamsSavedData.class);
            xstream.processAnnotations(BoardProfile.class);
            xstream.processAnnotations(AdjVarAnalogCfg.class);
            xstream.processAnnotations(AdjVarTriggerCfg.class);
            logger.trace("Converting board params into xml...");
            String xml = null;
            try {
                xml = xstream.toXML((Object)new BoardParamsSavedData(copy, profileId, BoardInfo.getBoardInfo()));
                logger.debug("Board params are converted into xml.");
            }
            catch (Exception e) {
                logger.error("Error converting board params into xml: " + e.toString());
            }
            if (xml != null) {
                logger.trace("Saving xml into file...");
                try {
                    FileUtil.save(f.getAbsolutePath(), xml);
                    this.updateStatus(resourceMap.getString("status.params_saved", new Object[0]));
                    logger.debug("Xml was saved.");
                }
                catch (Exception e) {
                    logger.error("Error saving xml into profile: " + e.toString());
                    JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("error.saving_profile", e.toString()), resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
                }
            }
        }
    }

    @Action(enabledProperty="connected")
    public void buttonReadParams() {
        if (this.isSaved()) {
            SerialCommandProcessor.readAllParams(-1);
        }
    }

    public void setConnected(final boolean state) {
        boolean old = this.isConnected;
        this.isConnected = state;
        this.firePropertyChange("connected", old, this.isConnected);
        this.serialCommunicationActive = state;
        Runnable updater = new Runnable(){

            public void run() {
                if (state) {
                    logger.trace("Saving successully connected port \"" + SimpleBGC_GUIView.this.jCBPortList.getSelectedItem().toString() + "\"...");
                    Settings.set("last.used.port", SimpleBGC_GUIView.this.jCBPortList.getSelectedItem().toString());
                    Settings.save();
                    SimpleBGC_GUIView.this.curIMUset = -1;
                    SimpleBGC_GUIView.this.setDeviceSN();
                } else {
                    SimpleBGC_GUIView.this.jLabelConnState.setText(resourceMap.getString("jLabelConnState.not_connected", new Object[0]));
                    SimpleBGC_GUIView.this.labelFirmwareVersionValue.setText("-");
                    SimpleBGC_GUIView.this.labelCurrentVersionValue.setText("-");
                    SimpleBGC_GUIView.this.labelLatestVersion.setText("-");
                    SimpleBGC_GUIView.this.textFieldDeviceSN.setText(null);
                    SimpleBGC_GUIView.this.buttonCheckVersion.setEnabled(false);
                    BoardInfo.setBoardInfo(null);
                    SimpleBGC_GUIView.this.updateBoardVerUI(null);
                }
                SimpleBGC_GUIView.this.jButtonAutoPoles.setEnabled(state);
                SimpleBGC_GUIView.this.jButtonAutoExtFCGain.setEnabled(state);
                SimpleBGC_GUIView.this.jButtonAutoTrim.setEnabled(state);
                SimpleBGC_GUIView.this.jToggleButtonMotors.setEnabled(state);
                SimpleBGC_GUIView.this.jToggleButtonMotors.setSelected(state);
                SimpleBGC_GUIView.this.jButtonOffsetAuto.setSelected(state);
                SimpleBGC_GUIView.this.jToggleImuFrame.setEnabled(state);
                SimpleBGC_GUIView.this.jToggleImuMain.setEnabled(state);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            updater.run();
        } else {
            try {
                SwingUtilities.invokeLater(updater);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public void updateBoardVerUI(BoardInfo info) {
        int i;
        int boardVer = 0;
        if (info != null) {
            boardVer = info.boardVer;
        }
        for (i = 0; i < this.comboBoxRCMap.length; ++i) {
            this.comboBoxRCMap[i].setModel(new SpravComboBoxModel(ParamsUIFactory.getRCMapList(info)));
        }
        this.jComboBoxRCVirtMode.setModel(new SpravComboBoxModel(ParamsUIFactory.getRCVirtModeList(boardVer)));
        this.jComboBoxRCVirtMode.setSelectedIndex(0);
        for (i = 0; i < this.comboBoxOutput.length; ++i) {
            this.comboBoxOutput[i].setModel(new DefaultComboBoxModel<String>(ParamsUIFactory.getOutputList(boardVer)));
        }
        for (i = 0; i < this.comboBoxRCCmd.length; ++i) {
            this.comboBoxRCCmd[i].setModel(new SpravComboBoxModel(ParamsUIFactory.getCmdList(boardVer)));
            this.comboBoxRCCmd[i].setSelectedIndex(0);
        }
        for (i = 0; i < this.comboBoxMenu.length; ++i) {
            this.comboBoxMenu[i].setModel(new SpravComboBoxModel(ParamsUIFactory.getCmdList(boardVer)));
            this.comboBoxMenu[i].setSelectedIndex(0);
        }
        for (JComponent c : this.ver3Components) {
            c.setEnabled(boardVer >= 30);
        }
        this.updateProfileNames();
        if (BoardInfo.hasBoardFeature(4)) {
            this.tabbedPaneMain.addTab(resourceMap.getString("panelEncoders.TabConstraints.tabTitle", new Object[0]), this.panelEncoders);
        } else {
            this.tabbedPaneMain.remove(this.panelEncoders);
        }
        if (BoardInfo.hasFilters()) {
            this.tabbedPaneMain.addTab(resourceMap.getString("panelFilters.TabConstraints.tabTitle", new Object[0]), this.panelFilters);
        } else {
            this.tabbedPaneMain.remove(this.panelFilters);
        }
        if (BoardInfo.hasScripting()) {
            this.tabbedPaneMain.addTab(resourceMap.getString("panelScriptEditor.TabConstraints.tabTitle", new Object[0]), this.panelScriptEditor);
        } else {
            this.tabbedPaneMain.remove(this.panelScriptEditor);
        }
        if (BoardInfo.hasAdjVars()) {
            this.panelAdjVars.updateBoardVerUI(info);
            this.tabbedPaneMain.addTab(resourceMap.getString("panelAdjVars.TabConstraints.tabTitle", new Object[0]), this.panelAdjVars);
        } else {
            this.tabbedPaneMain.remove(this.panelAdjVars);
        }
        this.showBatteryMonitoring(BoardInfo.hasBatterryMonitoring());
        for (int i2 = 0; i2 < this.comboBoxRCOut.length; ++i2) {
            this.comboBoxRCOut[i2].setModel(new SpravComboBoxModel(ParamsUIFactory.getRCOutList(boardVer)));
        }
    }

    public void updateBoardInfo() {
        BoardInfo info = BoardInfo.getBoardInfo();
        if (info != null) {
            IVersion version;
            logger.debug("Updating board info in main view..");
            this.jLabelConnState.setText(resourceMap.getString("jLabelConnState.boardVersion", VersionFactory.formatBoardVersion(info.boardVer)));
            this.updateBoardVerUI(info);
            this.currentVersionFirmware = version = VersionFactory.getVersion(info.frwVerOrig);
            this.labelFirmwareVersionValue.setText(version.toString());
            this.labelCurrentFirmwareVersionValue.setText(version.toString());
            this.labelCurrentVersionValue.setText(version.toString());
            if (this.latestVersionFirmware != null && this.latestVersionFirmware.compareTo(version) > 0) {
                this.buttonFirmwareUpgrade.setEnabled(true);
                if (!this.latestVersionFirmware.toString().equals(Settings.get("latest.version.firmware"))) {
                    JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("info.new_firmware_available", this.latestVersionFirmware.toString()), resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
                    Settings.set("latest.version.firmware", this.latestVersionFirmware.toString());
                    Settings.save();
                    this.tabbedPaneMain.setSelectedComponent(this.panelFirmwareUpgrade);
                }
            }
            if (Settings.is("latest.versions.autocheck")) {
                String lastCheckedDate = "";
                if (Settings.get("last.version.check.date") != null) {
                    lastCheckedDate = Settings.get("last.version.check.date");
                }
                if (!DateUtil.format(new Date(), "yyyy.MM.dd").equals(lastCheckedDate)) {
                    this.checkLatestVersionsWithoutWaiting();
                }
            }
        } else {
            this.jLabelConnState.setText(resourceMap.getString("jLabelConnState.connected", new Object[0]));
        }
    }

    public void setSelectedProfile(int profile) {
        this.oldProfile = profile;
        logger.info("Current profile: " + profile);
        this.jComboBoxProfile.setSelectedIndex(Math.min(profile, this.jComboBoxProfile.getItemCount() - 1));
    }

    private void updatePIDParams(BoardProfile p) {
        for (int axis = 0; axis < 3; ++axis) {
            this.spinnerP[axis].setValue(p.P[axis]);
            this.spinnerI[axis].setValue(Float.valueOf((float)p.I[axis] / 100.0f));
            this.spinnerD[axis].setValue(p.D[axis]);
        }
    }

    public void updateBoardParams() {
        try {
            int i;
            int i2;
            int axis;
            BoardParams params = BoardParams.getCurParams();
            if (params == null) {
                return;
            }
            this.updateNumAxis(params);
            this.setSelectedProfile(params.curProfile);
            BoardProfile p = params.profiles[params.curProfile];
            this.updatePIDParams(p);
            for (axis = 0; axis < 3; ++axis) {
                this.spinnerPower[axis].setValue(p.power[axis]);
                this.spinnerBooster[axis].setValue(p.boosterPower[axis]);
                this.checkBoxInvert[axis].getModel().setSelected(p.invert[axis]);
                this.spinnerPoles[axis].setValue(p.poles[axis]);
                if (axis >= 2) continue;
                this.spinnerExtGain[axis].setValue(p.extFCGain[axis]);
            }
            this.jCheckBoxAngleAccLimit.setSelected(p.angleAccLimit > 0);
            this.jSpinnerAngleAccLimit.setValue(p.angleAccLimit * 5);
            this.updateCurIMU(params);
            this.jSpinnerGyroLPF.setValue(params.gyroLPF);
            this.jCheckBoxGyroSens.setSelected(params.gyroSens > 0);
            this.jCheckBox_i2c_pullups.setSelected(params.i2c_pullups);
            this.jCheckBoxSkipGyroCal.setSelected(params.skip_gyro_cal);
            this.jComboBoxFrameIMU.setSelectedIndex(params.frame_imu_pos);
            this.jToggleImuFrame.setEnabled(params.frame_imu_pos > 0);
            for (i2 = 0; i2 < Math.min(this.comboBoxRCCmd.length, params.rcCmd.length); ++i2) {
                ((SpravComboBoxModel)this.comboBoxRCCmd[i2].getModel()).setCurrent(params.rcCmd[i2]);
            }
            ((SpravComboBoxModel)this.jComboBoxRCVirtMode.getModel()).setCurrent(p.rcVirtMode);
            for (i2 = 0; i2 < this.comboBoxRCMap.length; ++i2) {
                ((SpravComboBoxModel)this.comboBoxRCMap[i2].getModel()).setCurrent(p.rcMap[i2]);
            }
            for (i2 = 0; i2 < this.comboBoxRCMix.length; ++i2) {
                this.comboBoxRCMix[i2].setSelectedIndex(p.rcMix[i2] >> 6);
                this.spinnerRCMix[i2].setValue((p.rcMix[i2] & 0x3F) * 100 / 63);
            }
            for (axis = 0; axis < 3; ++axis) {
                this.spinnerRCMin[axis].setValue(p.rcMinAngle[axis]);
                this.spinnerRCMax[axis].setValue(p.rcMaxAngle[axis]);
                this.spinnerRCLPF[axis].setValue(p.rcLPF[axis]);
                this.spinnerRCSpeed[axis].setValue(p.rcSpeed[axis]);
                if ((p.rcMode[axis] & 7) == 0) {
                    this.rbRCModeAngle[axis].setSelected(true);
                } else if ((p.rcMode[axis] & 7) == 1) {
                    this.rbRCModeSpeed[axis].setSelected(true);
                }
                this.checkBoxRCInverse[axis].setSelected((p.rcMode[axis] & 8) != 0);
                this.spinnerFollowSpeed[axis].setValue(p.followSpeed[axis]);
                this.spinnerRCMemory[axis].setValue(Float.valueOf((float)Math.round((float)params.rcMemory[axis] * 0.021972656f * 100.0f) / 100.0f));
                this.spinnerFollowLPF[axis].setValue(p.followLPF[axis]);
            }
            for (axis = 0; axis < 2; ++axis) {
                this.spinnerRCFollow[axis].setValue(p.rcFollow[axis]);
            }
            this.jCheckBoxFollowYaw.setSelected(p.rcFollow[2] > 0);
            if (p.followMode == 1) {
                this.jRBFollowFC.setSelected(true);
            } else if (p.followMode == 2) {
                this.jRBFollowPitch.setSelected(true);
            } else {
                this.jRBFollowDisabled.setSelected(true);
            }
            this.jSpinnerFollowDeadband.setValue(Float.valueOf((float)p.followDeadband / 10.0f));
            this.jSpinnerFollowExpoRate.setValue(p.followExpoRate);
            this.jSpinnerOffsetPitch.setValue(params.followOffset[1]);
            this.jSpinnerOffsetRoll.setValue(params.followOffset[0]);
            this.jSpinnerOffsetYaw.setValue(params.followOffset[2]);
            this.jSpinnerFollowRollMixStart.setValue(p.follow_roll_mix_start);
            this.jSpinnerFollowRollMixRange.setValue(p.follow_roll_mix_range);
            for (i2 = 0; i2 < Math.min(this.comboBoxMenu.length, params.menuCmd.length); ++i2) {
                ((SpravComboBoxModel)this.comboBoxMenu[i2].getModel()).setCurrent(params.menuCmd[i2]);
            }
            for (i2 = 0; i2 < this.comboBoxOutput.length; ++i2) {
                this.comboBoxOutput[i2].setSelectedIndex(Math.min(params.outputMap[i2], this.comboBoxOutput[i2].getItemCount() - 1));
            }
            for (i2 = 0; i2 < this.spinnerRCTrim.length; ++i2) {
                this.spinnerRCTrim[i2].setValue(p.rcTrim[i2]);
            }
            this.jSpinnerDeadband.setValue(p.rcDeadband);
            this.jCheckBoxUseModel.setSelected(p.useModel);
            this.jSpinnerGyroTrust.setValue(p.gyroTrust);
            this.jComboBoxSerialSpeed.setSelectedIndex(Math.min(p.serialSpeed, this.jComboBoxSerialSpeed.getItemCount() - 1));
            this.jComboBoxPWMFreq.setSelectedIndex(Math.min(p.pwmFreq, this.jComboBoxPWMFreq.getItemCount() - 1));
            this.jSpinnerExpoRate.setValue(p.rcExpoRate);
            this.jCheckBoxADC1Auto.setSelected((p.profile_flags1 & 1) > 0);
            this.jCheckBoxADC2Auto.setSelected((p.profile_flags1 & 2) > 0);
            this.jCheckBoxADC3Auto.setSelected((p.profile_flags1 & 4) > 0);
            this.jCheckBoxBatAlarm.setSelected(params.bat_threshold_alarm > 0);
            this.jSpinnerBatThresholdAlarm.setValue(Float.valueOf((float)Math.abs(params.bat_threshold_alarm) / 100.0f));
            this.jCheckBoxBatMotors.setSelected(params.bat_threshold_motors > 0);
            this.jSpinnerBatThresholdMotors.setValue(Float.valueOf((float)Math.abs(params.bat_threshold_motors) / 100.0f));
            this.jCheckBoxBatComp.setSelected(params.bat_comp_ref > 0);
            this.jSpinnerBatCompRef.setValue(Float.valueOf((float)Math.abs(params.bat_comp_ref) / 100.0f));
            this.jCheckBoxBeeperConfirm.setSelected((params.beeper_modes & 2) > 0);
            this.jCheckBoxBeeperCalibration.setSelected((params.beeper_modes & 1) > 0);
            this.jCheckBoxBeeperError.setSelected((params.beeper_modes & 4) > 0);
            this.jCheckBoxBeeperAlarm.setSelected((params.beeper_modes & 8) > 0);
            this.jCheckBoxBeepMotors.setSelected((params.beeper_modes & 0x80) > 0);
            this.jCheckBoxFrameAngleFromMotors.setSelected(p.frameAngleFromMotors);
            int type = params.encoder_type & 0xF;
            this.jComboBoxEncoderType.setSelectedIndex(type);
            this.jCheckBoxEncoderForce.setSelected((params.encoder_type & 0x10) > 0);
            if (BoardParams.is_encoder_SPI(type)) {
                this.jComboBoxEncoderSPI.setSelectedIndex(params.encoder_cfg);
            }
            for (i = 0; i < 3; ++i) {
                this.spinnerManualSetTime[i].setValue(Float.valueOf((float)params.manual_set_time[i] / 100.0f));
                this.spinnerHeating[i].setValue(params.motor_heating_factor[i]);
                this.spinnerCooling[i].setValue(params.motor_cooling_factor[i]);
                this.spinnerEncoderOffset[i].setValue(params.encoder_offset[i]);
                this.spinnerEncoderFldOffset[i].setValue(params.encoder_fld_offset[i]);
                this.spinnerEncoderMagLink[i].setValue(params.encoder_mag_link[i]);
                this.spinnerMotorGear[i].setValue((double)params.motor_gear[i] / 256.0);
            }
            this.jSpinnerEncoderFFLPF.setValue(params.encoder_lpf);
            for (int axis2 = 0; axis2 < 3; ++axis2) {
                this.spinnerNotchFreq1[axis2].setValue(p.notchFreq1[axis2]);
                this.spinnerNotchFreq2[axis2].setValue(p.notchFreq2[axis2]);
                this.spinnerNotchFreq3[axis2].setValue(p.notchFreq3[axis2]);
                this.spinnerNotchWidth1[axis2].setValue(p.notchWidth1[axis2]);
                this.spinnerNotchWidth2[axis2].setValue(p.notchWidth2[axis2]);
                this.spinnerNotchWidth3[axis2].setValue(p.notchWidth3[axis2]);
                this.checkBoxNotchEnabled1[axis2].setSelected(p.notchEnabled1[axis2]);
                this.checkBoxNotchEnabled2[axis2].setSelected(p.notchEnabled2[axis2]);
                this.checkBoxNotchEnabled3[axis2].setSelected(p.notchEnabled3[axis2]);
                this.spinnerLPFFreq[axis2].setValue(p.lpfFreq[axis2]);
                this.checkBoxLPFEnabled[axis2].setSelected(p.lpfEnabled[axis2]);
            }
            this.jCheckBoxAdaptivePIDRoll.setSelected((p.adaptivePIDEnabled & 1) != 0);
            this.jCheckBoxAdaptivePIDPitch.setSelected((p.adaptivePIDEnabled & 2) != 0);
            this.jCheckBoxAdaptivePIDYaw.setSelected((p.adaptivePIDEnabled & 4) != 0);
            this.jSpinnerAdaptivePIDThreshold.setValue(p.adaptivePIDThreshold);
            this.jSpinnerAdaptivePIDRate.setValue(p.adaptivePIDRate);
            this.jSpinnerAdaptivePIDRecoveryFactor.setValue(p.adaptivePIDRecoveryFactor);
            for (i = 0; i < Math.min(this.comboBoxRCOut.length, p.servoOut.length); ++i) {
                ((SpravComboBoxModel)this.comboBoxRCOut[i].getModel()).setCurrent(p.servoOut[i]);
            }
            this.jSpinnerRCOutRate.setValue(p.servoRate);
            this.jCheckBoxRememberLastUsedProfile.setSelected((params.general_flags1 & 1) > 0);
            this.panelAdjVars.updateBoardParams();
        }
        catch (Exception e) {
            this.showErrorMessage("Error updating UI values: " + e.toString() + Log.formatStackTrace(e), null);
        }
    }

    public void updateStatus(String text) {
        this.jLabelStatus.setText(text);
    }

    public void updateError() {
        errorTitle = ErrorInfo.getCurErrors();
        errorDescr = "<html>" + ErrorInfo.getCurErrorsDescr() + "</html>";
        this.jLabelErrorTitle.setText(errorTitle);
        this.jLabelErrorDescr.setText(errorDescr);
    }

    public void updateRealtimeData() {
        DebugVar[] vars;
        int i;
        BoardParams params = BoardParams.getCurParams();
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        RealtimeData d = RealtimeData.getRealtimeData();
        this.jLabelI2CErrors.setText(Integer.toString(d.i2cErrorCount));
        if (d.i2cErrorCount > 100) {
            this.jLabelI2CErrors.setForeground(Color.red);
        }
        this.jLabelCycleTime.setText(Integer.toString(d.cycleTime));
        for (i = 0; i < 3; ++i) {
            float angle = d.curIMU == 1 ? d.angle[i] : d.frameIMUAngle[i];
            this.anglePanels[i].setRotationAngle(angle, d.rc_angle[i]);
            this.anglePanels[i].setPower(d.power[i]);
            if (d.encoderEnabled[i]) {
                this.anglePanels[i].setBalanceError(d.balanceError[i]);
            }
            this.anglePanels[i].setFrameAngle(d.frameAngle[i]);
            this.setChartData(i, d.acc[i]);
            this.setChartData(i + 3, d.gyro[i]);
            this.setChartData(i + 6, (int)((d.angle[i] - d.rc_angle[i]) * 100.0f));
            this.setChartData(i + 9, d.power[i]);
        }
        if (SimpleBGC_GUIApp.debugMode) {
            for (i = 0; i < 4; ++i) {
                this.setChartData(i + 12, d.debug[i]);
            }
        }
        if ((vars = DebugVars.getVars()) != null) {
            for (DebugVar v : vars) {
                this.setChartData(v.id, v.value);
                if (!v.testFlag(64) || v.axis < 0) continue;
                this.anglePanels[v.axis].setDebugVar(v);
            }
        }
        this.chart.update();
        for (int i2 = 0; i2 < d.rcData.length; ++i2) {
            this.rcPanels[i2].setData(d.rcData[i2] > -8500 ? Integer.valueOf(d.rcData[i2]) : null);
        }
        this.rcCmdPanel.setData(this.rcPanels[3].getData());
        if (this.cycleCnt++ % 10 == 0) {
            if (boardInfo != null) {
                if (boardInfo.hasBatterryMonitoring()) {
                    this.jLabelBatVal.setText(String.format("%.2f V", Float.valueOf((float)d.bat_val / 100.0f)));
                    this.batPanel.setMax((float)Math.abs(params.bat_comp_ref) / 100.0f);
                    this.batPanel.setMin((float)Math.abs(params.bat_threshold_motors) / 100.0f);
                    this.batPanel.setAlert(Float.valueOf((float)Math.abs(params.bat_threshold_alarm) / 100.0f));
                    this.batPanel.setData(Float.valueOf((float)d.bat_val / 100.0f));
                }
            }
            this.jToggleButtonMotors.setSelected(d.isPowered);
            params.curIMU = d.curIMU;
            if (params.curIMU != this.curIMUset) {
                this.updateCurIMU(params);
            }
        }
    }

    public void setChartData(int id, int data) {
        if (id < this.chart.traces.size()) {
            this.chart.traces.get(id).addData(data);
            this.chartLabels.get(id).setText(Integer.toString(data));
        }
    }

    private void updateCurIMU(BoardParams params) {
        if (params.curIMU == 1) {
            this.jToggleImuMain.setSelected(true);
            this.jComboBoxAxisTop.setSelectedIndex(BoardParams.axisMapToIndex(params.axisTop));
            this.jComboBoxAxisRight.setSelectedIndex(BoardParams.axisMapToIndex(params.axisRight));
        } else if (params.curIMU == 2) {
            this.jToggleImuFrame.setSelected(true);
            this.jComboBoxAxisTop.setSelectedIndex(BoardParams.axisMapToIndex(params.frameAxisTop));
            this.jComboBoxAxisRight.setSelectedIndex(BoardParams.axisMapToIndex(params.frameAxisRight));
        }
        this.curIMUset = params.curIMU;
    }

    public void updateNumAxis(BoardParams params) {
        int i;
        for (i = 0; i < this.yawList.length; ++i) {
            this.yawList[i].setEnabled(params.outputMap[2] != 0);
        }
        for (i = 0; i < this.rollList.length; ++i) {
            this.rollList[i].setEnabled(params.outputMap[0] != 0);
        }
        for (i = 0; i < this.pitchList.length; ++i) {
            this.pitchList[i].setEnabled(params.outputMap[1] != 0);
        }
    }

    public void applyBoardParams(BoardParams params) {
        try {
            int axis;
            int i;
            int axis2;
            BoardProfile p = params.profiles[params.curProfile];
            for (axis2 = 0; axis2 < 3; ++axis2) {
                p.P[axis2] = ((Number)this.spinnerP[axis2].getValue()).intValue();
                p.I[axis2] = Math.round(((Number)this.spinnerI[axis2].getValue()).floatValue() * 100.0f);
                p.D[axis2] = ((Number)this.spinnerD[axis2].getValue()).intValue();
                p.power[axis2] = ((Number)this.spinnerPower[axis2].getValue()).intValue();
                p.boosterPower[axis2] = ((Number)this.spinnerBooster[axis2].getValue()).intValue();
                p.invert[axis2] = this.checkBoxInvert[axis2].getModel().isSelected();
                p.poles[axis2] = ((Number)this.spinnerPoles[axis2].getValue()).intValue();
                if (axis2 >= 2) continue;
                p.extFCGain[axis2] = ((Number)this.spinnerExtGain[axis2].getValue()).intValue();
            }
            int n = p.angleAccLimit = this.jCheckBoxAngleAccLimit.isSelected() ? Math.max(((Number)this.jSpinnerAngleAccLimit.getValue()).intValue() / 5, 1) : 0;
            if (params.curIMU == 1) {
                params.axisTop = BoardParams.axisIndexToMap(this.jComboBoxAxisTop.getSelectedIndex());
                params.axisRight = BoardParams.axisIndexToMap(this.jComboBoxAxisRight.getSelectedIndex());
            } else if (params.curIMU == 2) {
                params.frameAxisTop = BoardParams.axisIndexToMap(this.jComboBoxAxisTop.getSelectedIndex());
                params.frameAxisRight = BoardParams.axisIndexToMap(this.jComboBoxAxisRight.getSelectedIndex());
            }
            params.gyroLPF = ((Number)this.jSpinnerGyroLPF.getValue()).intValue();
            params.gyroSens = this.jCheckBoxGyroSens.isSelected() ? 1 : 0;
            params.i2c_pullups = this.jCheckBox_i2c_pullups.isSelected();
            params.skip_gyro_cal = this.jCheckBoxSkipGyroCal.isSelected();
            params.frame_imu_pos = this.jComboBoxFrameIMU.getSelectedIndex();
            this.jToggleImuFrame.setEnabled(params.frame_imu_pos > 0);
            for (i = 0; i < this.comboBoxRCCmd.length; ++i) {
                params.rcCmd[i] = ((SpravComboBoxModel)this.comboBoxRCCmd[i].getModel()).getCurrentId();
            }
            p.rcVirtMode = ((SpravComboBoxModel)this.jComboBoxRCVirtMode.getModel()).getCurrentId();
            for (i = 0; i < this.comboBoxRCMap.length; ++i) {
                p.rcMap[i] = ((SpravComboBoxModel)this.comboBoxRCMap[i].getModel()).getCurrentId();
            }
            for (i = 0; i < this.comboBoxRCMix.length; ++i) {
                p.rcMix[i] = (this.comboBoxRCMix[i].getSelectedIndex() << 6) + (((Number)this.spinnerRCMix[i].getValue()).intValue() + 1) * 63 / 100;
            }
            for (axis2 = 0; axis2 < 3; ++axis2) {
                p.rcMinAngle[axis2] = ((Number)this.spinnerRCMin[axis2].getValue()).intValue();
                p.rcMaxAngle[axis2] = ((Number)this.spinnerRCMax[axis2].getValue()).intValue();
                p.rcLPF[axis2] = ((Number)this.spinnerRCLPF[axis2].getValue()).intValue();
                p.rcSpeed[axis2] = ((Number)this.spinnerRCSpeed[axis2].getValue()).intValue();
                int n2 = p.rcMode[axis2] = this.rbRCModeAngle[axis2].isSelected() ? 0 : 1;
                if (this.checkBoxRCInverse[axis2].isSelected()) {
                    int n3 = axis2;
                    p.rcMode[n3] = p.rcMode[n3] | 8;
                }
                p.followSpeed[axis2] = ((Number)this.spinnerFollowSpeed[axis2].getValue()).intValue();
                params.rcMemory[axis2] = Math.round(((Number)this.spinnerRCMemory[axis2].getValue()).floatValue() / 0.021972656f);
                p.followLPF[axis2] = ((Number)this.spinnerFollowLPF[axis2].getValue()).intValue();
            }
            p.followMode = this.jRBFollowFC.isSelected() ? 1 : (this.jRBFollowPitch.isSelected() ? 2 : 0);
            for (axis2 = 0; axis2 < 2; ++axis2) {
                p.rcFollow[axis2] = ((Number)this.spinnerRCFollow[axis2].getValue()).intValue();
            }
            p.rcFollow[2] = this.jCheckBoxFollowYaw.isSelected() ? 1 : 0;
            p.followDeadband = Math.round(((Number)this.jSpinnerFollowDeadband.getValue()).floatValue() * 10.0f);
            p.followExpoRate = ((Number)this.jSpinnerFollowExpoRate.getValue()).intValue();
            params.followOffset[0] = ((Number)this.jSpinnerOffsetRoll.getValue()).intValue();
            params.followOffset[1] = ((Number)this.jSpinnerOffsetPitch.getValue()).intValue();
            params.followOffset[2] = ((Number)this.jSpinnerOffsetYaw.getValue()).intValue();
            p.follow_roll_mix_start = ((Number)this.jSpinnerFollowRollMixStart.getValue()).intValue();
            p.follow_roll_mix_range = ((Number)this.jSpinnerFollowRollMixRange.getValue()).intValue();
            for (i = 0; i < Math.min(this.comboBoxMenu.length, params.menuCmd.length); ++i) {
                params.menuCmd[i] = ((SpravComboBoxModel)this.comboBoxMenu[i].getModel()).getCurrentId();
            }
            for (i = 0; i < this.comboBoxOutput.length; ++i) {
                params.outputMap[i] = this.comboBoxOutput[i].getSelectedIndex();
            }
            p.useModel = this.jCheckBoxUseModel.isSelected();
            p.gyroTrust = ((Number)this.jSpinnerGyroTrust.getValue()).intValue();
            p.serialSpeed = this.jComboBoxSerialSpeed.getSelectedIndex();
            p.pwmFreq = this.jComboBoxPWMFreq.getSelectedIndex();
            for (axis2 = 0; axis2 < this.spinnerRCTrim.length; ++axis2) {
                p.rcTrim[axis2] = ((Number)this.spinnerRCTrim[axis2].getValue()).intValue();
            }
            p.rcDeadband = ((Number)this.jSpinnerDeadband.getValue()).intValue();
            p.rcExpoRate = ((Number)this.jSpinnerExpoRate.getValue()).intValue();
            p.profile_flags1 = (this.jCheckBoxADC1Auto.isSelected() ? 1 : 0) | (this.jCheckBoxADC2Auto.isSelected() ? 2 : 0) | (this.jCheckBoxADC3Auto.isSelected() ? 4 : 0);
            params.bat_threshold_alarm = Math.round(((Number)this.jSpinnerBatThresholdAlarm.getValue()).floatValue() * 100.0f);
            if (!this.jCheckBoxBatAlarm.isSelected()) {
                params.bat_threshold_alarm *= -1;
            }
            params.bat_threshold_motors = Math.round(((Number)this.jSpinnerBatThresholdMotors.getValue()).floatValue() * 100.0f);
            if (!this.jCheckBoxBatMotors.isSelected()) {
                params.bat_threshold_motors *= -1;
            }
            params.bat_comp_ref = Math.round(((Number)this.jSpinnerBatCompRef.getValue()).floatValue() * 100.0f);
            if (!this.jCheckBoxBatComp.isSelected()) {
                params.bat_comp_ref *= -1;
            }
            params.beeper_modes = (this.jCheckBoxBeeperConfirm.isSelected() ? 2 : 0) | (this.jCheckBoxBeeperCalibration.isSelected() ? 1 : 0) | (this.jCheckBoxBeeperError.isSelected() ? 4 : 0) | (this.jCheckBoxBeeperAlarm.isSelected() ? 8 : 0) | (this.jCheckBoxBeepMotors.isSelected() ? 128 : 0);
            p.frameAngleFromMotors = this.jCheckBoxFrameAngleFromMotors.isSelected();
            int type = this.jComboBoxEncoderType.getSelectedIndex();
            params.encoder_type = type & 0xF | (this.jCheckBoxEncoderForce.isSelected() ? 16 : 0);
            if (BoardParams.is_encoder_SPI(type)) {
                params.encoder_cfg = this.jComboBoxEncoderSPI.getSelectedIndex();
            }
            for (axis = 0; axis < 3; ++axis) {
                params.manual_set_time[axis] = Math.round(((Number)this.spinnerManualSetTime[axis].getValue()).floatValue() * 100.0f);
                params.motor_heating_factor[axis] = ((Number)this.spinnerHeating[axis].getValue()).intValue();
                params.motor_cooling_factor[axis] = ((Number)this.spinnerCooling[axis].getValue()).intValue();
                params.encoder_offset[axis] = ((Number)this.spinnerEncoderOffset[axis].getValue()).intValue();
                params.encoder_fld_offset[axis] = ((Number)this.spinnerEncoderFldOffset[axis].getValue()).intValue();
                params.encoder_mag_link[axis] = ((Number)this.spinnerEncoderMagLink[axis].getValue()).intValue();
                params.motor_gear[axis] = (int)Math.round(((Number)this.spinnerMotorGear[axis].getValue()).doubleValue() * 256.0);
            }
            params.encoder_lpf = ((Number)this.jSpinnerEncoderFFLPF.getValue()).intValue();
            for (axis = 0; axis < 3; ++axis) {
                p.notchFreq1[axis] = ((Number)this.spinnerNotchFreq1[axis].getValue()).intValue();
                p.notchFreq2[axis] = ((Number)this.spinnerNotchFreq2[axis].getValue()).intValue();
                p.notchFreq3[axis] = ((Number)this.spinnerNotchFreq3[axis].getValue()).intValue();
                p.notchWidth1[axis] = ((Number)this.spinnerNotchWidth1[axis].getValue()).intValue();
                p.notchWidth2[axis] = ((Number)this.spinnerNotchWidth2[axis].getValue()).intValue();
                p.notchWidth3[axis] = ((Number)this.spinnerNotchWidth3[axis].getValue()).intValue();
                p.notchEnabled1[axis] = this.checkBoxNotchEnabled1[axis].isSelected();
                p.notchEnabled2[axis] = this.checkBoxNotchEnabled2[axis].isSelected();
                p.notchEnabled3[axis] = this.checkBoxNotchEnabled3[axis].isSelected();
                p.lpfFreq[axis] = ((Number)this.spinnerLPFFreq[axis].getValue()).intValue();
                p.lpfEnabled[axis] = this.checkBoxLPFEnabled[axis].isSelected();
            }
            p.adaptivePIDEnabled = (this.jCheckBoxAdaptivePIDRoll.isSelected() ? 1 : 0) + (this.jCheckBoxAdaptivePIDPitch.isSelected() ? 2 : 0) + (this.jCheckBoxAdaptivePIDYaw.isSelected() ? 4 : 0);
            p.adaptivePIDThreshold = ((Number)this.jSpinnerAdaptivePIDThreshold.getValue()).intValue();
            p.adaptivePIDRate = ((Number)this.jSpinnerAdaptivePIDRate.getValue()).intValue();
            p.adaptivePIDRecoveryFactor = ((Number)this.jSpinnerAdaptivePIDRecoveryFactor.getValue()).intValue();
            for (int i2 = 0; i2 < Math.min(this.comboBoxRCOut.length, p.servoOut.length); ++i2) {
                p.servoOut[i2] = ((SpravComboBoxModel)this.comboBoxRCOut[i2].getModel()).getCurrentId();
            }
            p.servoRate = ((Number)this.jSpinnerRCOutRate.getValue()).intValue();
            params.general_flags1 = this.jCheckBoxRememberLastUsedProfile.isSelected() ? 1 : 0;
            this.panelAdjVars.applyBoardParams(params);
        }
        catch (Exception e) {
            this.showErrorMessage("Error applying UI values: " + e.toString() + Log.formatStackTrace(e), null);
        }
    }

    public boolean isSaved() {
        try {
            BoardParams params = BoardParams.getCurParams();
            BoardParams copy = params.clone();
            this.applyBoardParams(copy);
            if (!copy.compare(params, params.curProfile)) {
                Object[] options = new Object[]{resourceMap.getString("option.discard_changes", new Object[0]), resourceMap.getString("option.cancel", new Object[0])};
                int res = JOptionPane.showOptionDialog(null, resourceMap.getString("confirm.changes_not_saved", new Object[0]), resourceMap.getString("messageDialog.confirm.title", new Object[0]), 0, 3, null, options, options[1]);
                return res == 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Action(enabledProperty="connected")
    public void buttonWriteParams() {
        this.writeParams(false);
    }

    @Action(enabledProperty="connected")
    public void buttonWriteAllProfiles() {
        this.writeParams(true);
    }

    public void writeParams(boolean allProfiles) {
        BoardParams params = BoardParams.getCurParams();
        if (params != null) {
            int oldSerialSpeed = params.profiles[params.curProfile].serialSpeed;
            this.applyBoardParams(params);
            SerialCommandProcessor.writeAllParams(params, allProfiles ? -1 : params.curProfile);
            this.updateNumAxis(params);
            final int newSerialSpeed = params.profiles[params.curProfile].serialSpeed;
            if (oldSerialSpeed != newSerialSpeed) {
                final boolean rt_pause_state = RealtimeDataThread.pause(true);
                Timer t = new Timer(3000, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            SerialPortService.setBaudIndex(newSerialSpeed);
                        }
                        catch (Exception ignore) {
                            logger.error(ignore.toString());
                        }
                        RealtimeDataThread.pause(rt_pause_state);
                    }
                });
                t.setRepeats(false);
                t.start();
            }
        }
    }

    @Action
    public void buttonAutoPolesAction() {
        SerialCommandProcessor.sendCommand(new SerialCommand(80));
    }

    @Action(enabledProperty="connected")
    public void buttonCalibACCAction() {
        SerialCommandProcessor.sendCommand(new SerialCommand(65));
    }

    @Action(enabledProperty="connected")
    public void buttonUseDefaults() {
        SerialCommandProcessor.useDefaults(this.jComboBoxProfile.getSelectedIndex());
    }

    @Action
    public void buttonCalibExtGain() {
        SerialCommandProcessor.sendCommand(new SerialCommand(71));
    }

    @Action
    public void buttonAutoTrim() {
        JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("info.rc_auto_trim", new Object[0]), resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
        RealtimeData rd = RealtimeData.getRealtimeData();
        BoardParams params = BoardParams.getCurParams();
        BoardProfile p = params.profiles[params.curProfile];
        for (int axis = 0; axis < 3; ++axis) {
            if (rd.rcData[axis] > -8500) {
                this.spinnerRCTrim[axis].setValue(1500 + p.rcTrim[axis] - rd.rcData[axis]);
                continue;
            }
            this.spinnerRCTrim[axis].setValue(0);
        }
    }

    @Action
    public void actionBugReport() {
        SimpleBGC_GUIView.browseURI("http://forum.basecamelectronics.com/index.php?p=/categories/new-ideas");
    }

    @Action
    public void changeChineseLocale() {
        this.changeLocale("zh", "CN");
    }

    @Action
    public void changePolishLocale() {
        this.changeLocale("pl", "PL");
    }

    @Action
    public void changeItalianLocale() {
        this.changeLocale("it", "IT");
    }

    @Action(enabledProperty="connected")
    public void buttonCalibGyroAction() {
        SerialCommandProcessor.sendCommand(new SerialCommand(103));
    }

    @Action
    public void buttonOffsetAuto() {
        JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("info.offset_auto", new Object[0]), resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
        SerialCommandProcessor.sendCommand(new SerialCommand(79));
    }

    @Action
    public void fullScreen() {
        logger.debug("Changing full screen mode");
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode displayMode = device.getDisplayMode();
        this.inFullScreen = !this.inFullScreen;
        JFrame frame = this.getFrame();
        if (!this.inFullScreen) {
            frame.setVisible(false);
            frame.dispose();
            frame.setUndecorated(false);
            device.setFullScreenWindow(null);
            this.setStatusBar(this.statusPanel);
            frame.setVisible(true);
        } else {
            frame.setVisible(false);
            frame.dispose();
            frame.setUndecorated(true);
            device.setFullScreenWindow(frame);
            frame.setResizable(false);
            frame.setAlwaysOnTop(false);
            frame.setVisible(true);
        }
    }

    @Action
    public void buttonBatCalibrate() {
        String res = JOptionPane.showInputDialog(this.getFrame(), resourceMap.getString("question.bat_calibrate", new Object[0]), "0.00");
        if (res != null) {
            try {
                int val = Math.round(Float.parseFloat(res) * 100.0f);
                if (val <= 0) {
                    throw new NumberFormatException("Voltage should be greater than zero!");
                }
                SerialCommand cmd = new SerialCommand(66, 2);
                cmd.writeWord(val);
                SerialCommandProcessor.sendCommand(cmd);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this.getFrame(), resourceMap.getString("error.wrong_value", new Object[0]) + ": " + e.getMessage(), resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setEnabledTree(Container obj, boolean enabled) {
        obj.setEnabled(enabled);
        for (Component c : obj.getComponents()) {
            if (c instanceof Container) {
                SimpleBGC_GUIView.setEnabledTree((Container)c, enabled);
                continue;
            }
            c.setEnabled(enabled);
        }
    }

    public void showBatteryMonitoring(boolean state) {
        SimpleBGC_GUIView.setEnabledTree(this.jPanelBatControls, state);
        this.jPanelBat.setVisible(state);
    }

    @Action
    public void buttonMotorsOn() {
        try {
            SerialCommand cmd = new SerialCommand(this.jToggleButtonMotors.isSelected() ? 77 : 109, 0);
            SerialCommandProcessor.sendCommand(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Action
    public void changeCZLocale() {
        this.changeLocale("cz", "CZ");
    }

    @Action
    public void menuSetThemeClassic() {
        SimpleBGC_GUIApp.setTheme("Classic", true);
    }

    @Action
    public void menuSetThemeHighContrastDark() {
        SimpleBGC_GUIApp.setTheme("HighContrastDark", true);
    }

    @Action
    public void menuSetThemeHighContrastLight() {
        SimpleBGC_GUIApp.setTheme("HighContrastLight", true);
    }

    @Action
    public void debugConnect() {
        if (!this.isPortConnected) {
            if (this.jCBPortList.getSelectedIndex() != -1) {
                String port = (String)this.jCBPortList.getSelectedItem();
                this.connect(port, false);
                if (SerialPortService.isPortOpened()) {
                    SerialPortService.setBaudIndex(0);
                    SerialPortService.setParity(this.jCheckBoxParity.isSelected() ? 2 : 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, resourceMap.getString("error.select_port", new Object[0]), resourceMap.getString("messageDialog.error.title", new Object[0]), 2);
            }
        } else {
            this.disconnect();
        }
    }

    public void setCurIMU(int type) {
        BoardParams params = BoardParams.getCurParams();
        params.curIMU = type;
        SerialCommandProcessor.sendCommand(new SerialCommand(24, new byte[]{(byte)type}));
        this.updateCurIMU(params);
    }

    @Action
    public void buttonCameraIMU() {
        this.setCurIMU(1);
    }

    @Action
    public void buttonFrameIMU() {
        this.setCurIMU(2);
    }

    @Action
    public void changeSElocale() {
        this.changeLocale("se", "SE");
    }

    @Action
    public void upgradeFirmwareVersion() {
        if (this.comboBoxVersionTitle.getSelectedIndex() != -1) {
            IFirmwareInfo frw = (IFirmwareInfo)this.comboBoxVersionTitle.getSelectedItem();
            if (DialogRegistrationData.isSuccessfull(this.getFrame())) {
                DialogFirmwareUpgrade.upgrade(frw.getVersion(), frw.getVersionId(), this, (String)this.jCBPortList.getSelectedItem());
            }
        } else {
            JOptionPane.showMessageDialog(null, resourceMap.getString("error.select_firmware_version", new Object[0]), resourceMap.getString("messageDialog.error.title", new Object[0]), 2);
        }
    }

    @Action(enabledProperty="connected")
    public void eraseEEPROM() {
        if (JOptionPane.showConfirmDialog(this.getFrame(), resourceMap.getString("confirm.erase_EEPROM", new Object[0]), resourceMap.getString("messageDialog.confirm.title", new Object[0]), 0) == 0) {
            SerialCommandProcessor.useDefaults(253);
        }
    }

    @Action(enabledProperty="connected")
    public void buttonEncodersCalibOffset() {
        SerialCommandProcessor.sendCommand(new SerialCommand(26));
    }

    @Action(enabledProperty="connected")
    public void buttonEncodersCalibFldOffset() {
        SerialCommandProcessor.sendCommand(new SerialCommand(27));
    }

    @Action(enabledProperty="connected")
    public void buttonDebugRequestState() {
        SerialCommandProcessor.sendCommand(new SerialCommand(52));
    }

    @Action(enabledProperty="connected")
    public void buttonAutoPID() {
        if (this.dialogAutoPID == null) {
            this.dialogAutoPID = new DialogAutoPID((Frame)this.getFrame(), true);
        }
        this.dialogAutoPID.setLocationRelativeTo(this.getFrame());
        SimpleBGC_GUIApp.getApplication().show(this.dialogAutoPID);
        try {
            SerialCommand cmd = new SerialCommand(35);
            cmd.writeByte(BoardParams.getCurParams().curProfile);
            switch (this.dialogAutoPID.getResult()) {
                case 1: {
                    cmd.writeByte(this.dialogAutoPID.getCfg());
                    cmd.writeByte(this.dialogAutoPID.getGain());
                    if (this.autoPIDLog != null) {
                        this.autoPIDLog.finish();
                    }
                    this.autoPIDLog = null;
                    if (!this.dialogAutoPID.logFileSelected()) break;
                    try {
                        this.autoPIDLog = new DataLogger("auto_pid_log.csv", false);
                        AutoPIDInfo.log_header(this.autoPIDLog);
                    }
                    catch (Exception e) {
                        logger.error("Failed to open log file " + e.getMessage());
                    }
                    break;
                }
                case 2: {
                    cmd.writeByte(0);
                    cmd.writeByte(0);
                    break;
                }
                case -1: {
                    return;
                }
            }
            cmd.writeEmptyArr(16);
            SerialCommandProcessor.sendCommand(cmd);
        }
        catch (Exception e) {
            logger.error("Failed to send CMD_AUTOPID: " + e.toString());
        }
    }

    public void updateAutoPIDInfo(AutoPIDInfo info) {
        BoardProfile p = BoardParams.getCurParams().getCurProfile();
        for (int axis = 0; axis < 3; ++axis) {
            p.P[axis] = info.P[axis];
            p.I[axis] = info.I[axis];
            p.D[axis] = info.D[axis];
        }
        this.updatePIDParams(p);
        if (this.autoPIDLog != null) {
            info.log_data(this.autoPIDLog);
            this.autoPIDLog.flush();
        }
    }

    @Action
    public void changeJPLocale() {
        this.changeLocale("ja", "JP");
    }

    @Action(enabledProperty="connected")
    public void buttonBodeTestStart() {
        if (BodeTest.isActive()) {
            BodeTest.stop();
            this.jToggleButtonPause.setSelected(this.realtimeDataThreadPaused);
        } else {
            int axis = this.jComboBoxBodeTestAxis.getSelectedIndex();
            int stimulus = this.jComboBoxBodeTestStimulus.getSelectedIndex();
            int gain = Math.round(((Number)this.jSpinnerBodeTestGain.getValue()).floatValue() * 10.0f);
            int system = this.jComboBoxBodeTestSystem.getSelectedIndex() + 1;
            if (this.jToggleButtonPause.isSelected()) {
                this.realtimeDataThreadPaused = true;
            } else {
                this.jToggleButtonPause.setSelected(true);
                this.realtimeDataThreadPaused = false;
            }
            try {
                BodeTest.start(axis, stimulus, gain, system);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Failed to start test: " + e.getMessage(), resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            }
        }
    }

    public void progressStart(final String action, final boolean modal) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SimpleBGC_GUIView.this.progressDialog != null) {
                    SimpleBGC_GUIView.this.progressDialog.dispose();
                }
                if (modal) {
                    SimpleBGC_GUIView.this.progressDialog = new DialogProgress((Frame)SimpleBGC_GUIApp.mainView.getFrame(), action);
                    SimpleBGC_GUIView.this.progressDialog.showDialog();
                } else {
                    SimpleBGC_GUIView.this.jProgressBarMain.setVisible(true);
                    SimpleBGC_GUIView.this.jProgressBarMain.setValue(0);
                }
            }
        });
    }

    public void progressFinish() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SimpleBGC_GUIView.this.progressDialog != null) {
                    SimpleBGC_GUIView.this.progressDialog.dispose();
                    SimpleBGC_GUIView.this.progressDialog = null;
                } else {
                    SimpleBGC_GUIView.this.jProgressBarMain.setVisible(false);
                }
            }
        });
    }

    @Override
    public boolean onProgressChange(int val) {
        if (this.progressDialog != null) {
            return this.progressDialog.onProgressChange(val);
        }
        this.jProgressBarMain.setValue(val);
        return true;
    }

    public void showErrorMessage(String msg, String statusMsg) {
        JOptionPane.showMessageDialog(this.getFrame(), msg, resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
        if (statusMsg != null) {
            this.updateStatus(statusMsg);
        }
    }

    public int getRTFrameRate() {
        return ((Number)this.jSpinnerFrameRate.getValue()).intValue();
    }

    public File showProfileSaveDialog(String fileTypeName, String fileExt, String fileName) {
        JFileChooser fileChooser = new JFileChooser();
        File profilesDirectory = this.createProfilesDirectory();
        fileChooser.setCurrentDirectory(profilesDirectory);
        fileChooser.setFileFilter(new FileNameExtensionFilter(fileTypeName, fileExt));
        fileChooser.setSelectedFile(new File(profilesDirectory.getPath() + File.separatorChar + fileName));
        if (fileChooser.showSaveDialog(this.getFrame()) == 0) {
            Settings.set("last_used_profiles_directory", fileChooser.getCurrentDirectory().getPath());
            Settings.save();
            File f = fileChooser.getSelectedFile();
            String filePath = f.getAbsolutePath();
            if (!filePath.endsWith("." + fileExt)) {
                f = new File(filePath + "." + fileExt);
            }
            Object[] options = new Object[]{resourceMap.getString("option.replace_file", new Object[0]), resourceMap.getString("option.cancel", new Object[0])};
            if (!f.exists() || JOptionPane.showOptionDialog(this.getFrame(), resourceMap.getString("confirm.replace_file", new Object[0]), resourceMap.getString("messageDialog.confirm.title", new Object[0]), 0, 3, null, options, options[1]) == 0) {
                return f;
            }
        }
        return null;
    }

    public File showProfileLoadDialog(String fileTypeName, String fileExt) {
        JFileChooser fileChooser = new JFileChooser();
        File profilesDirectory = this.createProfilesDirectory();
        fileChooser.setCurrentDirectory(profilesDirectory);
        fileChooser.setFileFilter(new FileNameExtensionFilter(fileTypeName, fileExt));
        if (this.isSaved() && fileChooser.showOpenDialog(this.getFrame()) == 0) {
            Settings.set("last_used_profiles_directory", fileChooser.getCurrentDirectory().getPath());
            Settings.save();
            File f = fileChooser.getSelectedFile();
            if (f.exists()) {
                return f;
            }
        }
        return null;
    }

    @Action(enabledProperty="connected")
    public void backupEEPROM() {
        final File f = this.showProfileSaveDialog("Backup data file", "data", "simplebgc_EEPROM_backup.data");
        if (f != null) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    SimpleBGC_GUIView.this.progressStart(resourceMap.getString("progress.reading_eeprom", new Object[0]), true);
                    try {
                        byte[] data = SerialCommandProcessor.readEEPROM(SimpleBGC_GUIApp.mainView);
                        FileUtil.saveBackupData(1, f, data);
                        ErrorInfo.updateStatus(resourceMap.getString("status.backup_EEPROM.done", new Object[0]));
                    }
                    catch (Exception e) {
                        SimpleBGC_GUIView.this.showErrorMessage(e.getMessage(), null);
                    }
                    finally {
                        SimpleBGC_GUIView.this.progressFinish();
                    }
                }
            }).start();
        }
    }

    @Action(enabledProperty="connected")
    public void restoreEEPROM() {
        final File f = this.showProfileLoadDialog("Backup data file", "data");
        if (f != null && JOptionPane.showConfirmDialog(this.getFrame(), resourceMap.getString("confirm.restore_EEPROM", new Object[0]), resourceMap.getString("messageDialog.confirm.title", new Object[0]), 0) == 0) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        byte[] data = FileUtil.readBackupData(1, f);
                        SimpleBGC_GUIView.this.progressStart(resourceMap.getString("progress.writing_eeprom", new Object[0]), true);
                        SerialCommandProcessor.writeEEPROM(data, SimpleBGC_GUIApp.mainView);
                        ErrorInfo.updateStatus(resourceMap.getString("status.restore_EEPROM.done", new Object[0]));
                    }
                    catch (Exception e) {
                        SimpleBGC_GUIView.this.showErrorMessage(e.getMessage(), null);
                        return;
                    }
                    finally {
                        SimpleBGC_GUIView.this.progressFinish();
                    }
                    SimpleBGC_GUIView.this.progressStart(resourceMap.getString("progress.restarting_board", new Object[0]), true);
                    try {
                        SerialCommandProcessor.sendCommand(new SerialCommand(114));
                        SerialCommandProcessor.waitForReset(SimpleBGC_GUIApp.mainView);
                    }
                    catch (Exception e) {
                        SimpleBGC_GUIView.this.showErrorMessage(e.getMessage(), null);
                        return;
                    }
                    finally {
                        SimpleBGC_GUIView.this.progressFinish();
                    }
                    SerialCommandProcessor.readAllParams(-1);
                }
            }).start();
        }
    }
}

