/*
 * Decompiled with CFR 0.152.
 */
package sbgc.STM32;

import java.util.Arrays;
import sbgc.service.IDataPort;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.Log;

public class STM32Boot {
    final IDataPort port;
    static final Log logger = Log.getLogger(STM32Boot.class.getName());
    public static final int STM32_TIMEOUT_MS = 3000;
    public static final int STM32_INFINITE_TIMEOUT_MS = 60000;
    public static final int STM32_ERASE_FLASH_TIMEOUT_MS = 15000;
    public static final byte STM32_ACK = 121;
    public static final byte STM32_NACK = 31;
    public static final int STM32_FLASH_START_ADDRESS = 0x8000000;
    public static final int WRITE_BUF_SIZE = 192;
    public static final byte CMD_GET_VER = 0;
    public static final byte CMD_GET_ID = 2;
    public static final byte CMD_READ_FLASH = 17;
    public static final byte CMD_GO = 33;
    public static final byte CMD_WRITE_FLASH = 49;
    public static final byte CMD_ERASE_FLASH = 67;
    public static final byte CMD_EXTENDED_ERASE_FLASH = 68;
    public static final byte CMD_WRITE_UNPROTECT = 115;
    public static final byte CMD_INIT = 127;
    public static final int SERIAL_BAUD = 115200;
    public static final int SERIAL_BAUD_HS = 256000;
    int timeout = 3000;
    int[] supported_commands;

    public STM32Boot(IDataPort port) {
        this.port = port;
    }

    public void init(boolean high_speed) throws Exception {
        int baud = high_speed ? 256000 : 115200;
        logger.debug("Configuring port to " + baud + " even parity " + 3000 + "ms timeout..");
        this.port.configure(baud, 2);
        this.port.enableReceiveTimeout(1);
        while (this.port.read() != -1) {
        }
        this.setTimeout(3000);
        this.bootloader_connect();
    }

    public void setTimeout(int timeout_ms) throws Exception {
        this.timeout = timeout_ms;
        this.port.enableReceiveTimeout(this.timeout);
    }

    void bootloader_connect() throws Exception {
        byte[] data = new byte[]{127};
        this.port.sendData(data, 0, data.length);
        int res = this.port.read();
        if (res != -1 && res != 121) {
            res = this.port.read();
        }
        if (res != 121) {
            if (res == 31) {
                throw new Exception("Bootloader initialization error");
            }
            throw new Exception("No answer from bootloader");
        }
        logger.debug("Bootloader initialization OK");
    }

    void send_command(byte cmd) throws Exception {
        byte[] data = new byte[]{(byte)(cmd & 0xFF), (byte)(~cmd & 0xFF)};
        this.port.sendData(data, 0, data.length);
    }

    void check_response(byte expect) throws Exception {
        int res = this.port.read();
        if (res == -1) {
            throw new Exception("Timeout waiting answer from bootloader!");
        }
        if (res == 31) {
            throw new Exception("Command refused: NACK answer");
        }
        if (res != expect) {
            throw new Exception("Unexpected answer: 0x" + Integer.toHexString(res));
        }
    }

    int read_byte() throws Exception {
        int res = this.port.read();
        if (res == -1) {
            throw new Exception("Timeout waiting answer from bootloader!");
        }
        return res & 0xFF;
    }

    void send_data_and_checksum(byte[] data, int length) throws Exception {
        byte[] buf = new byte[length + 1];
        byte cs = 0;
        for (int i = 0; i < length; ++i) {
            cs = (byte)(cs ^ data[i]);
            buf[i] = data[i];
        }
        buf[length] = cs;
        this.port.sendData(buf, 0, buf.length);
    }

    void send_address(int address) throws Exception {
        byte[] data = new byte[]{(byte)(address >> 24 & 0xFF), (byte)(address >> 16 & 0xFF), (byte)(address >> 8 & 0xFF), (byte)(address & 0xFF)};
        this.send_data_and_checksum(data, data.length);
    }

    public int get_version() throws Exception {
        logger.trace("Sending CMD_GET_VER..");
        this.send_command((byte)0);
        this.check_response((byte)121);
        int total = this.read_byte();
        int ver = 0;
        try {
            this.supported_commands = new int[total];
            for (int i = 0; i < total + 1; ++i) {
                int tmp = this.read_byte();
                if (i == 0) {
                    ver = (tmp & 0xF0) << 4 | tmp & 0xF;
                    continue;
                }
                logger.trace("Supported command: " + tmp);
                this.supported_commands[i - 1] = tmp;
            }
            this.check_response((byte)121);
        }
        catch (Exception e) {
            throw new Exception("Unexpected response or " + e.getMessage());
        }
        return ver;
    }

    public int get_chip_id() throws Exception {
        logger.trace("Sending CMD_GET_ID..");
        this.send_command((byte)2);
        this.check_response((byte)121);
        try {
            this.check_response((byte)1);
            int high = this.read_byte();
            int low = this.read_byte();
            this.check_response((byte)121);
            return (high << 16) + low;
        }
        catch (Exception e) {
            throw new Exception("Unexpected response or " + e.getMessage());
        }
    }

    public void write_unprotect() throws Exception {
        logger.trace("Sending CMD_WRITE_UPROTECT..");
        this.send_command((byte)115);
        this.check_response((byte)121);
        this.check_response((byte)121);
        Thread.sleep(200L);
        this.bootloader_connect();
    }

    public void erase_flash() throws Exception {
        logger.trace("Sending CMD_ERASE_FLASH..");
        this.send_command((byte)67);
        this.check_response((byte)121);
        byte[] data = new byte[]{-1, 0};
        this.port.sendData(data, 0, data.length);
        this.check_response((byte)121);
    }

    public void erase_pages(int[] pages) throws Exception {
        throw new Exception("Operation is not yet implemented!");
    }

    public void extended_erase_flash() throws Exception {
        logger.trace("Sending CMD_EXTENDED_ERASE_FLASH..");
        this.send_command((byte)68);
        this.check_response((byte)121);
        byte[] data = new byte[]{-1, -1, 0};
        this.port.sendData(data, 0, data.length);
        this.port.enableReceiveTimeout(15000);
        this.check_response((byte)121);
        this.port.enableReceiveTimeout(this.timeout);
    }

    public void extended_erase_pages(int[] pages) throws Exception {
        logger.trace("Sending CMD_EXTENDED_ERASE_FLASH..");
        this.send_command((byte)68);
        this.check_response((byte)121);
        byte[] data = new byte[2 + pages.length * 2];
        data[0] = (byte)(pages.length - 1 >> 8 & 0xFF);
        data[1] = (byte)(pages.length - 1 & 0xFF);
        for (int i = 0; i < pages.length; ++i) {
            data[i * 2 + 2] = (byte)(pages[i] >> 8 & 0xFF);
            data[i * 2 + 3] = (byte)(pages[i] & 0xFF);
        }
        this.send_data_and_checksum(data, data.length);
        this.port.enableReceiveTimeout(15000);
        this.check_response((byte)121);
        this.port.enableReceiveTimeout(this.timeout);
    }

    public void write_flash(byte[] data, int address, IProgressListener progressListener) throws Exception {
        logger.debug("Writing FLASH " + data.length + " bytes starting at 0x" + Integer.toHexString(address) + "..");
        byte[] buf = new byte[193];
        for (int pos = 0; pos < data.length; pos += 192) {
            int len = Math.min(data.length - pos, 192);
            buf[0] = (byte)(len - 1 & 0xFF);
            for (int i = 0; i < len; ++i) {
                buf[i + 1] = data[pos + i];
            }
            logger.trace("Sending CMD_WRITE_FLASH (0x" + Integer.toHexString(address) + ", " + len + ")..");
            this.send_command((byte)49);
            this.check_response((byte)121);
            this.send_address(address);
            this.check_response((byte)121);
            this.send_data_and_checksum(buf, len + 1);
            this.check_response((byte)121);
            if (progressListener != null) {
                progressListener.onProgressChange(pos * 100 / data.length);
            }
            address += len;
        }
    }

    public void go_cmd(int address) throws Exception {
        logger.debug("Executing program at address 0x" + Integer.toHexString(address) + "..");
        this.send_command((byte)33);
        this.check_response((byte)121);
        this.send_address(address);
        this.check_response((byte)121);
    }

    public boolean is_command_supported(int cmd) {
        return this.supported_commands != null && Arrays.binarySearch(this.supported_commands, cmd) >= 0;
    }
}

