/*
 * Decompiled with CFR 0.152.
 */
package sbgc.bode_plot;

import ddf.minim.analysis.FFT;
import java.io.IOException;
import org.apache.log4j.Logger;
import sbgc.bode_plot.BodeConfig;
import sbgc.bode_plot.BodeResult;
import sbgc.bode_plot.Complex;
import sbgc.bode_plot.TestDataReader;
import sbgc.object.BoardParams;
import sbgc.utils.Log;

public class BodeCalculation {
    private static final Log logger = new Log(Logger.getLogger((String)BodeCalculation.class.getName()));
    private static FFT fft = null;

    public BodeCalculation() throws IOException {
        if (fft == null) {
            fft = new FFT(2048, 1250.0f);
            fft.window(BodeConfig.WINDOW_FUNCTION);
            fft.noAverages();
        }
    }

    private void calcFftArr(float[][] dataBuffer, Complex[][] resArr) {
        for (int i = 0; i < resArr.length; ++i) {
            this.calcFftResult(dataBuffer, i, resArr[i]);
        }
    }

    public void calcBode(TestDataReader dataReader, BodeResult bodeResult) throws Exception {
        float[][] dataBuffer = dataReader.readBuffer(null);
        if (dataBuffer == null) {
            throw new Exception("Empty buffer!");
        }
        int respSize = 1024;
        int size = Math.min(respSize, Math.round(819.2f));
        if (bodeResult.type == 1) {
            Complex[] fftIn = new Complex[respSize];
            Complex[] fftOut = new Complex[respSize];
            Complex[][] fftInOut = new Complex[][]{fftIn, fftOut};
            this.calcFftArr(dataBuffer, fftInOut);
            Complex[] resp = new Complex[size];
            Complex.fillArr(resp, Complex.complex0);
            double[] psd_in = new double[size];
            while (true) {
                this.calcCPSDAvg(fftIn, fftOut, resp, psd_in);
                dataBuffer = dataReader.readBuffer(dataBuffer);
                if (dataBuffer == null) break;
                this.calcFftArr(dataBuffer, fftInOut);
            }
            for (int i = 0; i < resp.length; ++i) {
                resp[i].div(Float.valueOf((float)psd_in[i]));
            }
            resp[0] = resp[1];
            bodeResult.setResponse(resp);
        } else if (bodeResult.type == 2) {
            Complex[][] fftVect = new Complex[3][respSize];
            this.calcFftArr(dataBuffer, fftVect);
            double[][] psd = new double[3][size];
            Complex[][] resp = new Complex[3][size];
            int cnt = 0;
            while (true) {
                for (int axis = 0; axis < 3; ++axis) {
                    this.calcPSDAvg(fftVect[axis], psd[axis]);
                }
                if ((dataBuffer = dataReader.readBuffer(dataBuffer)) == null) break;
                this.calcFftArr(dataBuffer, fftVect);
                ++cnt;
            }
            double cntD = (double)cnt * (double)((long)fft.specSize() * (long)fft.specSize());
            String origName = bodeResult.getName() + ".";
            for (int axis = 0; axis < 3; ++axis) {
                for (int i = 0; i < resp[axis].length; ++i) {
                    resp[axis][i] = new Complex((float)Math.sqrt(psd[axis][i] / cntD), 0.0f);
                }
                resp[axis][0] = resp[axis][1];
                if (axis == 0) {
                    bodeResult.setResponse(resp[axis]);
                    bodeResult.setName(origName + BoardParams.getXYZName(axis));
                    continue;
                }
                BodeResult res = bodeResult.clone();
                res.setResponse(resp[axis]);
                res.setName(origName + BoardParams.getXYZName(axis));
                bodeResult.addSubResult(res);
            }
        } else {
            throw new Exception("Unsupported type: " + bodeResult.type);
        }
    }

    private void calcFftResult(float[][] data, int col, Complex[] res) {
        float[] arrayCopy = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            arrayCopy[i] = data[i][col];
        }
        fft.forward(arrayCopy);
        float[] spectrumRe = fft.getSpectrumReal();
        float[] spectrumIm = fft.getSpectrumImaginary();
        assert (res.length <= spectrumRe.length);
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Complex(spectrumRe[i], spectrumIm[i]);
        }
    }

    private void calcCPSDAvg(Complex[] fftIn, Complex[] fftOut, Complex[] cpsd, double[] psd_in) {
        assert (fftIn.length == fftOut.length && cpsd.length <= fftIn.length);
        for (int i = 0; i < cpsd.length; ++i) {
            double abs_in = fftIn[i].abs();
            int n = i;
            psd_in[n] = psd_in[n] + abs_in * abs_in;
            Complex cpsd_in_out = fftIn[i].conjugate().times(fftOut[i]);
            cpsd[i].inc(cpsd_in_out);
        }
    }

    private void calcPSDAvg(Complex[] fftData, double[] psd) {
        assert (psd.length <= fftData.length);
        int i = 0;
        while (i < psd.length) {
            double abs_in = fftData[i].abs();
            int n = i++;
            psd[n] = psd[n] + abs_in * abs_in;
        }
    }

    public static float[] calcSensitivity(Complex[] response) {
        if (response != null) {
            float[] sensitivity = new float[response.length];
            for (int i = 0; i < response.length; ++i) {
                sensitivity[i] = -10.0f * (float)Math.log10(Complex.complex1.plus(response[i]).pow2());
            }
            return sensitivity;
        }
        return null;
    }

    public static float[] makeGaussianWindow(int width) {
        float[] window = new float[width];
        float sum = 0.0f;
        for (int i = 0; i < width; ++i) {
            float val;
            float x = 2.1213202f * (float)i / (float)width;
            window[i] = val = -((float)Math.exp(-(x * x)));
            sum += val;
        }
        float k = 1.0f / sum;
        int i = 0;
        while (i < window.length) {
            int n = i++;
            window[n] = window[n] * k;
        }
        return window;
    }

    public static Complex[] applyGaussianWindow(Complex[] resp, int width) {
        float[] window = BodeCalculation.makeGaussianWindow(width);
        Complex[] smooth_resp = new Complex[resp.length];
        for (int pos = 0; pos < resp.length; ++pos) {
            Complex sum = new Complex(0.0f, 0.0f);
            for (int j = 0; j < window.length; ++j) {
                int idx = Math.min(pos + j, resp.length - 1);
                sum.inc(resp[idx].times(window[j]));
                if (j <= 0) continue;
                idx = Math.max(pos - j, 0);
                sum.inc(resp[idx].times(window[j]));
            }
            smooth_resp[pos] = sum;
        }
        return smooth_resp;
    }
}

