/*
 * Decompiled with CFR 0.152.
 */
package sbgc.bode_plot;

import org.apache.log4j.Logger;
import sbgc.bode_plot.BodeResult;
import sbgc.bode_plot.Complex;
import sbgc.bode_plot.ControllerParams;
import sbgc.bode_plot.ExtendedResp;
import sbgc.bode_plot.SFunc2;
import sbgc.object.AutoPIDCfg2;
import sbgc.optimizer.IOptimizable;
import sbgc.optimizer.IOptimizedParams;
import sbgc.optimizer.RndOptimizerImpl;
import sbgc.optimizer.SimplexOptimizerImpl;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.Log;
import sbgc.utils.LogScale;
import sbgc.utils.MathUtils;

public class ControllerOptimizer
implements IOptimizable {
    private static final Log logger = new Log(Logger.getLogger((String)ControllerOptimizer.class.getName()));
    public static final float NOMINAL_START_FREQ = 1.0f;
    public static final float MIN_START_FREQ = 0.1f;
    static final float NEGATIVE_ERROR_WEIGHT = 0.3f;
    public static final int FREQ_RESP_SIZE = 256;
    static final float SENS_THRESHOLD_EXCEED_AMPLIFY = 76800.0f;
    static final float PROBLEM_FREQ_PHASE_TRUST_MIX_FREQ_RANGE = 50.0f;
    static final int ITERATIONS_NUM_MAX_FROM_ZERO = 800;
    static final int ITERATIONS_NUM_MAX_FROM_CURRENT = 400;
    static final int ITERATIONS_NUM_MAX_GAIN_ONLY = 100;
    static final float GAIN_RND_STEP_SIZE = 0.1f;
    private BodeResult[] bodeResultArr;
    private IProgressListener progressListener;
    public final AutoPIDCfg2 cfg;
    public ExtendedResp[] G_resp;
    public float[] expol_ab;
    public float[] freqLUT;
    private LogScale freqLogScale;
    float[] G_extra_gain;
    float[] thresholdLUT;
    Complex[] timeDelayLUT;
    public final float startFreq;
    public final float endFreq;
    float effective_freq_log;
    float PROFILE_SENS_SLEW_RATE;
    float OUTSIDE_EFFECTIVE_FREQ_WEIGHT;
    float PROBLEM_FREQ_PHASE_TRUST_F1;
    final int ctrlVer;
    final int axis;

    public ControllerOptimizer(int ctrlVer, BodeResult[] bodeResultArr, AutoPIDCfg2 cfg, int axis) throws Exception {
        this.ctrlVer = ctrlVer;
        this.bodeResultArr = bodeResultArr;
        this.progressListener = this.progressListener;
        this.cfg = cfg;
        this.axis = axis;
        this.startFreq = MathUtils.constrain(cfg.freqFrom, 0.1f, 1.0f);
        this.endFreq = cfg.freqTo;
        this.fillTestFrequencies();
        this.G_resp = new ExtendedResp[bodeResultArr.length];
        this.G_extra_gain = new float[bodeResultArr.length];
        for (int i = 0; i < bodeResultArr.length; ++i) {
            this.G_resp[i] = new ExtendedResp(1.0f, this.responseToLogScaleConversion(bodeResultArr[i].getResponse()), this.freqLogScale);
            this.G_extra_gain[i] = 1.0f;
        }
    }

    public BodeResult[] getBodeResultArr() {
        return this.bodeResultArr;
    }

    public float optimize(ControllerParams p, IProgressListener progressListener) throws Exception {
        float cost_best;
        boolean startFromCurrent = false;
        int iterNumMax = 800;
        if (this.cfg.isGainOnly()) {
            startFromCurrent = true;
            iterNumMax = 100;
        } else if (this.cfg.isStartFromCurrent()) {
            startFromCurrent = true;
            iterNumMax = 400;
        }
        try {
            SimplexOptimizerImpl optimizer = new SimplexOptimizerImpl(this, progressListener, startFromCurrent, 2000, this.cfg.rnd_seed_num);
            cost_best = optimizer.optimize(p);
        }
        catch (IllegalStateException e) {
            RndOptimizerImpl optimizer = new RndOptimizerImpl(this, progressListener, startFromCurrent, iterNumMax);
            cost_best = optimizer.optimize(p);
        }
        return cost_best;
    }

    @Override
    public void iteration_step(IOptimizedParams op, float progress) throws Exception {
        ControllerParams p = (ControllerParams)op;
        if (this.cfg.allow_gain_variation && this.G_resp.length > 1 && !this.cfg.isGainOnly()) {
            for (int k = 0; k < this.G_resp.length; ++k) {
                float best_gain_cost = 1000000.0f;
                float best_gain = this.G_extra_gain[k];
                float n_gain = p.toLog(3, this.G_extra_gain[k]);
                Complex[] C = this.getControllerResp(p);
                for (int n = 0; n < 5; ++n) {
                    this.G_extra_gain[k] = p.fromLog(3, n_gain);
                    Complex[] GC = this.applyController(k, C, p.getExtraGain());
                    float cost = this.cost_function(GC, progress);
                    if (cost < best_gain_cost) {
                        best_gain_cost = cost;
                        best_gain = this.G_extra_gain[k];
                    }
                    n_gain = RndOptimizerImpl.make_rnd_step(n_gain, 0.1f * progress);
                }
                this.G_extra_gain[k] = best_gain;
            }
            ControllerOptimizer.arrayMultVar(this.G_extra_gain, 1.0f / ControllerOptimizer.arrayMinVal(this.G_extra_gain));
        }
    }

    public Complex[] responseToLogScaleConversion(Complex[] G) {
        return ControllerOptimizer.responseToLogScaleConversion(G, this.freqLUT);
    }

    public static Complex[] responseToLogScaleConversion(Complex[] G, float[] freqLUT) {
        Complex[] G_ext = new Complex[freqLUT.length];
        for (int i = 0; i < freqLUT.length; ++i) {
            float width = i > 0 ? freqLUT[i] - freqLUT[i - 1] : freqLUT[i + 1] - freqLUT[i];
            G_ext[i] = BodeResult.getValAtFreq(freqLUT[i], width, G);
        }
        return G_ext;
    }

    public static Complex[] applyController(Complex[] G, Complex[] C, float gain) {
        Complex[] GC = new Complex[Math.min(G.length, C.length)];
        for (int i = 0; i < GC.length; ++i) {
            GC[i] = C[i].times(G[i]);
            GC[i].mult(gain);
        }
        return GC;
    }

    public Complex[] applyController(int G_idx, Complex[] C, float gain) {
        return ControllerOptimizer.applyController(this.G_resp[G_idx].resp, C, gain * this.G_extra_gain[G_idx]);
    }

    public Complex[] getControllerResp(ControllerParams p) {
        return ControllerOptimizer.getControllerResp(p, this.freqLUT, this.timeDelayLUT);
    }

    public static Complex[] getControllerResp(ControllerParams p, float[] freqLUT, Complex[] timeDelayLUT) {
        Complex[] C = new Complex[freqLUT.length];
        SFunc2 pid_sf = p.pid_to_SFunc2();
        SFunc2 lpf_sf = p.lpf_to_SFunc2();
        SFunc2[] notch_sf = new SFunc2[3];
        for (int notch_idx = 0; notch_idx < 3; ++notch_idx) {
            notch_sf[notch_idx] = p.notch_to_SFunc2(notch_idx);
        }
        for (int i = 0; i < freqLUT.length; ++i) {
            float w = (float)Math.PI * 2 * freqLUT[i];
            C[i] = pid_sf.getVal(w).times(lpf_sf.getVal(w));
            if (timeDelayLUT != null) {
                C[i].mult(timeDelayLUT[i]);
            }
            for (int notch_idx = 0; notch_idx < 3; ++notch_idx) {
                if (notch_sf[notch_idx] == null) continue;
                C[i] = C[i].times(notch_sf[notch_idx].getVal(w));
            }
        }
        return C;
    }

    public static void fillFreqLUT(float _startFreq, float _endFreq, float[] freqLUT, Complex[] timeDelayLUT) {
        ControllerOptimizer.fillFreqLUT(new LogScale(freqLUT.length, _startFreq, _endFreq), freqLUT, timeDelayLUT);
    }

    public static void fillFreqLUT(LogScale freqLogScale, float[] freqLUT, Complex[] timeDelayLUT) {
        for (int i = 0; i < freqLUT.length; ++i) {
            freqLUT[i] = freqLogScale.from_log(i);
            if (timeDelayLUT == null) continue;
            float w = (float)Math.PI * 2 * freqLUT[i];
            float dw = -2.0E-4f * w;
            timeDelayLUT[i] = new Complex((float)Math.cos(dw), (float)Math.sin(dw));
        }
    }

    public void fillTestFrequencies() {
        this.freqLogScale = new LogScale(256.0f, this.startFreq, this.endFreq);
        this.freqLUT = new float[256];
        this.timeDelayLUT = new Complex[this.freqLUT.length];
        ControllerOptimizer.fillFreqLUT(this.freqLogScale, this.freqLUT, this.timeDelayLUT);
        float effective_freq = this.cfg.effective_freq[this.axis];
        float target_gain = this.cfg.gain[this.axis];
        float SENS_THRESHOLD_DB = 2.0f + target_gain * 0.03137255f;
        float PROBLEM_FREQ_F1 = (float)this.cfg.problem_freq[this.axis] * 0.8f;
        this.PROBLEM_FREQ_PHASE_TRUST_F1 = (float)this.cfg.problem_freq[this.axis] * 0.9f;
        this.thresholdLUT = new float[this.freqLUT.length];
        this.effective_freq_log = this.freqLogScale.to_log(effective_freq);
        this.PROFILE_SENS_SLEW_RATE = (50.0f + (target_gain - 127.0f) * 10.0f / 255.0f) / this.effective_freq_log;
        this.OUTSIDE_EFFECTIVE_FREQ_WEIGHT = 0.1f * this.effective_freq_log / 256.0f;
        for (int idx = 0; idx < this.freqLUT.length; ++idx) {
            float freq = this.freqLUT[idx];
            this.thresholdLUT[idx] = SENS_THRESHOLD_DB;
            if (!(freq > PROBLEM_FREQ_F1)) continue;
            float margin = this.cfg.problem_margin[this.axis] * Math.min(freq / PROBLEM_FREQ_F1 - 1.0f, 1.0f);
            this.thresholdLUT[idx] = -LogScale.linear_to_dB(1.0f - LogScale.dB_to_linear(-margin) * (1.0f - LogScale.dB_to_linear(-SENS_THRESHOLD_DB)));
        }
    }

    @Override
    public float cost_function(IOptimizedParams op, float progress) throws Exception {
        ControllerParams p = (ControllerParams)op;
        Complex[] C = this.getControllerResp(p);
        float err_sum_all = p.checkValuesAllowed();
        if (err_sum_all == 1000000.0f) {
            return 1000000.0f;
        }
        for (int i = 0; i < this.G_resp.length; ++i) {
            Complex[] GC = this.applyController(i, C, p.getExtraGain());
            float err = this.cost_function(GC, progress);
            if (err == 1000000.0f) {
                return 1000000.0f;
            }
            err_sum_all += err;
        }
        return Math.min(err_sum_all, 1000000.0f);
    }

    public float cost_function(Complex[] GC, float progress) {
        float err_sum = 0.0f;
        for (int idx = 0; idx < this.freqLUT.length; ++idx) {
            float diff;
            float sens;
            float diff_thr;
            float y_cross;
            Complex x = GC[idx];
            Complex x_next = idx < GC.length - 1 ? GC[idx + 1] : x;
            float idx_f = idx;
            if (x.re() < -1.0f && x_next.re() >= -1.0f && (y_cross = x_next.im() + (x_next.re() + 1.0f) * (x.im() - x_next.im()) / (x_next.re() - x.re())) > -0.1f) {
                return 1000000.0f;
            }
            float x_mod = (float)x.abs();
            if (idx > this.freqLUT.length - 5 && x_mod > 1.0f) {
                return 1000000.0f;
            }
            float dist = (float)Complex.complex1.plus(x).abs();
            if (this.freqLUT[idx] > this.PROBLEM_FREQ_PHASE_TRUST_F1) {
                float phaseTrust = 50.0f - (this.freqLUT[idx] - this.PROBLEM_FREQ_PHASE_TRUST_F1);
                float dist_no_phase = Math.max(1.0f - x_mod, 0.0f);
                dist = phaseTrust > 0.0f ? dist * (phaseTrust *= 0.02f) + dist_no_phase * (1.0f - phaseTrust) : dist_no_phase;
            }
            if ((diff_thr = (sens = dist > 1.0E-5f ? -LogScale.linear_to_dB(dist) : 100.0f) - this.thresholdLUT[idx]) > 0.0f) {
                err_sum += (diff_thr /= 1.0f + progress * 100.0f) * diff_thr * 8533.333f;
                continue;
            }
            if (idx_f < this.effective_freq_log) {
                float profile_sens = (idx_f - this.effective_freq_log) * this.PROFILE_SENS_SLEW_RATE;
                diff = sens - profile_sens;
                if (diff < 0.0f) {
                    diff *= 0.3f;
                }
            } else {
                diff = Math.max(0.0f, sens - this.thresholdLUT[idx] * 0.5f) * this.OUTSIDE_EFFECTIVE_FREQ_WEIGHT;
            }
            err_sum += diff;
        }
        return err_sum *= 1.0f / (float)this.freqLUT.length;
    }

    public static void copyArray(float[] to, float[] from) throws Exception {
        if (to.length != from.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(from, 0, to, 0, to.length);
    }

    public static float arrayMinVal(float[] arr) throws Exception {
        float minVal = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] < minVal)) continue;
            minVal = arr[i];
        }
        return minVal;
    }

    public static void arrayMultVar(float[] arr, float val) {
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                int n = i++;
                arr[n] = arr[n] * val;
            }
        }
    }
}

