/*
 * Decompiled with CFR 0.152.
 */
package sbgc.bode_plot;

import sbgc.bode_plot.PlainParamsConstraints;
import sbgc.bode_plot.SFunc2;
import sbgc.object.BoardProfile;
import sbgc.optimizer.IOptimizedParams;
import sbgc.utils.LogScale;
import sbgc.utils.MathUtils;
import sbgc.utils.Settings;

public class ControllerParams
implements IOptimizedParams {
    public static final float TIME_DELAY = 2.0E-4f;
    static final float GYRO_EL_ANGLE_SCALE = 149.80115f;
    static final float PID_POWER_GAIN = 0.86956525f;
    static final float _CYCLE_TIME = 800.0f;
    static final float SAMPLING_TIME = 8.0E-4f;
    public static final float[] P_SCALE_V1 = new float[]{0.37151337f, 1.1609793E-4f, 2.972107f};
    public static final float[] P_SCALE_V3 = new float[]{2.972107f, 0.04643917f, 130.26187f};
    public static final float[] P_RANGE_TO_S_PID_SCALE_V1 = new float[]{P_SCALE_V1[0], P_SCALE_V1[1] / 8.0E-4f, P_SCALE_V1[2] * 8.0E-4f};
    public static final float[] P_RANGE_TO_S_PID_SCALE_V3 = new float[]{P_SCALE_V3[0], P_SCALE_V3[1] / 8.0E-4f, P_SCALE_V3[2] * 8.0E-4f};
    public static final int PARAM_IDX_Kp = 0;
    public static final int PARAM_IDX_Ki = 1;
    public static final int PARAM_IDX_Kd = 2;
    public static final int PARAM_IDX_GAIN = 3;
    public static final int PARAM_IDX_D_LPF_FREQ = 4;
    public static final int PARAM_IDX_LPF_FREQ = 5;
    public static final int PARAM_IDX_LPF_Q_INV = 6;
    public static final int NOTCH_NUM = 3;
    public static final int PARAM_IDX_NOTCH1_FREQ = 7;
    public static final int PARAM_IDX_NOTCH1_WIDTH = 8;
    public static final int PARAM_IDX_NOTCH1_GAIN = 9;
    public static final int PARAM_IDX_NOTCH2_FREQ = 10;
    public static final int PARAM_IDX_NOTCH2_WIDTH = 11;
    public static final int PARAM_IDX_NOTCH2_GAIN = 12;
    public static final int PARAM_IDX_NOTCH3_FREQ = 13;
    public static final int PARAM_IDX_NOTCH3_WIDTH = 14;
    public static final int PARAM_IDX_NOTCH3_GAIN = 15;
    public static final int NOTCH_PARAM_TYPE_FREQ = 0;
    public static final int NOTCH_PARAM_TYPE_WIDTH = 1;
    public static final int NOTCH_PARAM_TYPE_GAIN = 2;
    public static final float NOTCH_GAIN_MIN_THRESHOLD_DB = 1.0f;
    public static final float LPF_FREQ_MAX_EFFECTIVE = 600.0f;
    public static final float D_LPF_FREQ_MAX_EFFECTIVE = 500.0f;
    static final float[][] S_PARAMS_CONSTRAINTS_V1;
    static final float[][] S_PARAMS_CONSTRAINTS_V1_EXT;
    static final float[][] S_PARAMS_CONSTRAINTS_V3;
    static final float[][] _NOTCH_CONSTRAINTS;
    static final PlainParamsConstraints PLAIN_PARAMS_CONSTR_V1;
    static final PlainParamsConstraints PLAIN_PARAMS_CONSTR_V1_EXT_V3;
    public static final int PARAMS_NUM = 16;
    final float[][] s_params_constraints;
    final PlainParamsConstraints plainParamsConstraints;
    public static final int LPF_TYPE_1ST_ORDER = 0;
    public static final int LPF_TYPE_2ND_ORDER = 1;
    public int lpf_type = 1;
    public static final float LPF_Q_INV_BUTTERWORTH = 1.4142f;
    public static final float[] NORMALIZED_RANGE;
    public final int version;
    public final int axis;
    public float gain_old;
    float maxFreq;
    float[] p_vect = new float[16];
    int[] param_n_to_p_idx = new int[16];
    int[] param_p_to_n_idx = new int[16];
    LogScale[] params_log_scale = new LogScale[16];
    protected int tuned_params_num = 0;
    public static final float COST_RESTRICTED_VALUES = 1000.0f;

    public ControllerParams(int version, int axis, float maxFreq) {
        int i;
        this.version = version;
        this.axis = axis;
        this.maxFreq = maxFreq;
        if (version == 1 || version == 2) {
            this.setKp(10.0f);
            this.setKi(0.0f);
            this.setKd(0.1f);
            this.setDLpfFreq(250.0f);
            this.setLpfFreq(600.0f);
        } else {
            this.setKp(100.0f);
            this.setKi(100.0f);
            this.setKd(1.0f);
            this.setDLpfFreq(60.0f);
            this.setLpfFreq(30.0f);
        }
        this.setGain(1.0f);
        this.gain_old = 1.0f;
        this.setLpfQInv(1.4142f);
        for (i = 0; i < 3; ++i) {
            this.setNotchFreqRel(i, 0.4f + (float)i * 0.2f);
            this.setNotchWidthRel(i, 0.1f);
            this.setNotchGain(i, 0.0f);
        }
        this.s_params_constraints = version == 1 ? S_PARAMS_CONSTRAINTS_V1 : (version == 2 ? S_PARAMS_CONSTRAINTS_V1_EXT : S_PARAMS_CONSTRAINTS_V3);
        this.plainParamsConstraints = version == 1 ? PLAIN_PARAMS_CONSTR_V1 : PLAIN_PARAMS_CONSTR_V1_EXT_V3;
        for (i = 0; i < 16; ++i) {
            if (this.s_params_constraints[i] == null) continue;
            float min = this.s_params_constraints[i][0];
            float max = this.s_params_constraints[i][1];
            float offset = this.s_params_constraints[i].length > 2 ? this.s_params_constraints[i][2] : 0.0f;
            this.params_log_scale[i] = new LogScale(1.0f, min, max, offset);
        }
    }

    public void setParamsToTune(boolean[] is_tuned) {
        this.tuned_params_num = 0;
        for (int i = 0; i < 16; ++i) {
            if (is_tuned[i]) {
                this.param_n_to_p_idx[this.tuned_params_num] = i;
                this.param_p_to_n_idx[i] = this.tuned_params_num++;
                continue;
            }
            this.param_p_to_n_idx[i] = -1;
        }
    }

    @Override
    public void getNormalizedParams(float[] n_params) {
        for (int n_idx = 0; n_idx < this.tuned_params_num; ++n_idx) {
            int p_idx = this.param_n_to_p_idx[n_idx];
            n_params[n_idx] = this.params_log_scale[p_idx].to_log(this.p_vect[p_idx]);
        }
    }

    @Override
    public void setNormalizedParams(float[] n_params, int update_n_idx) throws Exception {
        for (int n_idx = 0; n_idx < this.tuned_params_num; ++n_idx) {
            int p_idx = this.param_n_to_p_idx[n_idx];
            this.p_vect[p_idx] = this.params_log_scale[p_idx].from_log(n_params[n_idx]);
        }
    }

    public float fromLog(int p_idx, float normalized_val) {
        return this.params_log_scale[p_idx].from_log(normalized_val);
    }

    public float toLog(int p_idx, float linear_val) {
        return this.params_log_scale[p_idx].to_log(linear_val);
    }

    @Override
    public boolean applyConstraints() {
        boolean isChanged = false;
        for (int i = 0; i < 16; ++i) {
            float new_val;
            if (!this.isParamTuned(i) || this.s_params_constraints[i] == null || (new_val = MathUtils.constrain(this.p_vect[i], this.s_params_constraints[i][0], this.s_params_constraints[i][1])) == this.p_vect[i]) continue;
            this.p_vect[i] = new_val;
            isChanged = true;
        }
        return isChanged;
    }

    public String toString() {
        return String.format("Kp=%.2f, Ki=%.2f, Kd=%.2f, gain=%.2f, D-LPF=%.2f, LPF=%.2f, LPF_Q_inv=%.2f", Float.valueOf(this.getKp()), Float.valueOf(this.getKi()), Float.valueOf(this.getKd()), Float.valueOf(this.getExtraGain()), Float.valueOf(this.getDLpfFreq()), Float.valueOf(this.getLpfFreq()), Float.valueOf(this.getLpfQInv()));
    }

    public float getKp() {
        return this.p_vect[0];
    }

    public void setKp(float val) {
        this.p_vect[0] = val;
    }

    public float getKi() {
        return this.p_vect[1];
    }

    public void setKi(float val) {
        this.p_vect[1] = val;
    }

    public float getKd() {
        return this.p_vect[2];
    }

    public void setKd(float val) {
        this.p_vect[2] = val;
    }

    public float getExtraGain() {
        return this.p_vect[3];
    }

    public void setGain(float val) {
        this.p_vect[3] = val;
    }

    public float getDLpfFreq() {
        float val = this.p_vect[4];
        return val > 500.0f ? 0.0f : val;
    }

    public void setDLpfFreq(float val) {
        this.p_vect[4] = val != 0.0f ? val : 525.0f;
    }

    public float getLpfFreq() {
        float val = this.p_vect[5];
        return val > 600.0f ? 0.0f : val;
    }

    public void setLpfFreq(float val) {
        this.p_vect[5] = val != 0.0f ? val : 630.0f;
    }

    public float getLpfQInv() {
        return this.p_vect[6];
    }

    public void setLpfQInv(float val) {
        this.p_vect[6] = val;
    }

    public float getNotchFreqRel(int idx) {
        return this.p_vect[7 + idx * 3];
    }

    public void setNotchFreqRel(int idx, float val) {
        this.p_vect[7 + idx * 3] = val;
    }

    public float getNotchFreq(int idx) {
        return this.getNotchFreqRel(idx) * this.maxFreq;
    }

    public void setNotchFreq(int idx, float val) {
        this.setNotchFreqRel(idx, val / this.maxFreq);
    }

    public float getNotchWidthRel(int idx) {
        return this.p_vect[8 + idx * 3];
    }

    public void setNotchWidthRel(int idx, float val) {
        this.p_vect[8 + idx * 3] = val;
    }

    public float getNotchWidth(int idx) {
        return this.getNotchFreq(idx) * this.getNotchWidthRel(idx);
    }

    public void setNotchWidth(int idx, float val) {
        float freq = this.getNotchFreq(idx);
        this.setNotchWidthRel(idx, freq > 0.0f ? val / freq : 0.0f);
    }

    public float getNotchGain(int idx) {
        return this.p_vect[9 + idx * 3];
    }

    public void setNotchGain(int idx, float val) {
        this.p_vect[9 + idx * 3] = val;
    }

    public boolean isNotchTuned(int idx) {
        return this.isParamTuned(9 + idx * 3);
    }

    public boolean isNotchEffective(int idx) {
        return this.getNotchGain(idx) >= 1.0f;
    }

    public static int getNotchIdx(int p_idx) {
        return (p_idx - 7) / 3;
    }

    public static int getNotchParamType(int p_idx) {
        return (p_idx - 7) % 3;
    }

    public void configureNotchFromProfile(BoardProfile p, int axis, int idx) {
        this.setNotchFreq(idx, p.getNotchFreq(axis, idx));
        this.setNotchWidth(idx, p.getNotchWidth(axis, idx));
        this.setNotchGain(idx, p.getNotchGain(axis, idx));
    }

    public boolean isParamTuned(int p_idx) {
        return this.param_p_to_n_idx[p_idx] >= 0;
    }

    public boolean isGainOnly() {
        return this.isParamTuned(3);
    }

    @Override
    public boolean isParamEffective(int n_idx) {
        int p_idx = this.n_to_p_idx(n_idx);
        return p_idx < 7 || p_idx > 15 || this.isNotchEffective(ControllerParams.getNotchIdx(p_idx));
    }

    public float checkValuesAllowed() {
        float err = 0.0f;
        for (int notch_idx = 0; notch_idx < 3; ++notch_idx) {
            int p_idx = 7 + notch_idx * 3;
            if (!this.isParamTuned(p_idx) || !this.isNotchEffective(notch_idx)) continue;
            float freq = this.getNotchFreq(notch_idx);
            float width = this.getNotchWidth(notch_idx);
            for (int n = 0; n < 3; ++n) {
                float dist_threshold;
                float exceed;
                if (n == notch_idx || !this.isNotchEffective(n) || !((exceed = (dist_threshold = (this.getNotchWidth(n) + width) / 4.0f) - Math.abs(freq - this.getNotchFreq(n))) > 0.0f)) continue;
                err += exceed / dist_threshold * 1000.0f;
            }
        }
        return err;
    }

    public SFunc2 pid_to_SFunc2() {
        SFunc2 f = new SFunc2();
        float dlpf_freq = this.getDLpfFreq();
        float w_inv = dlpf_freq == 0.0f || dlpf_freq > 500.0f ? 0.0f : 0.15915494f / dlpf_freq;
        f.p[0] = this.getKi();
        f.p[1] = this.getKp() + this.getKi() * (w_inv += 4.0E-4f);
        f.p[2] = this.getKd() + this.getKp() * w_inv;
        f.q[0] = 0.0f;
        f.q[1] = 1.0f;
        f.q[2] = w_inv;
        return f;
    }

    public SFunc2 lpf_to_SFunc2() {
        SFunc2 f = new SFunc2();
        float lpf_freq = this.getLpfFreq();
        float w_inv = lpf_freq == 0.0f || lpf_freq > 600.0f ? 0.0f : 0.15915494f / lpf_freq;
        f.p[0] = 1.0f;
        f.p[1] = 0.0f;
        f.p[2] = 0.0f;
        f.q[0] = 1.0f;
        if (this.version == 1 || this.version == 2 || this.lpf_type == 1) {
            f.q[1] = (this.version != 1 ? this.getLpfQInv() : 1.4142f) * w_inv;
            f.q[2] = w_inv * w_inv;
        } else {
            f.q[1] = w_inv;
            f.q[2] = 0.0f;
        }
        return f;
    }

    public SFunc2 notch_to_SFunc2(int idx) {
        float gain = this.getNotchGain(idx);
        if (gain == 0.0f) {
            return null;
        }
        SFunc2 f = new SFunc2();
        float freq = this.getNotchFreq(idx);
        float w = (float)Math.PI * 2 * freq;
        float w2 = w * w;
        float d = this.getNotchWidth(idx) / freq;
        float k2 = (d * d + 2.0f * d) / (1.0f + d) * w;
        float k1 = k2 / (float)Math.exp(Math.abs(gain) * 0.115129255f);
        f.p[0] = w2;
        f.p[1] = k1;
        f.p[2] = 1.0f;
        f.q[0] = w2;
        f.q[1] = k2;
        f.q[2] = 1.0f;
        if (gain < 0.0f) {
            f.inverse();
        }
        return f;
    }

    float[] get_pid_s_scale() throws IllegalArgumentException {
        if (this.version == 1 || this.version == 2) {
            return P_RANGE_TO_S_PID_SCALE_V1;
        }
        if (this.version == 3) {
            return P_RANGE_TO_S_PID_SCALE_V3;
        }
        throw new IllegalArgumentException();
    }

    public float[] toParamsRange() throws IllegalArgumentException {
        int i;
        float[] pids = new float[4];
        float extra_gain = this.getExtraGain();
        float[] pid_s_scale = this.get_pid_s_scale();
        for (i = 0; i < 3; ++i) {
            pids[i] = this.p_vect[i] / pid_s_scale[i];
        }
        if (this.version == 1 || this.version == 2) {
            pids[1] = pids[1] / Math.max(pids[0], 1.0f);
        }
        i = 0;
        while (i < 3) {
            int n = i++;
            pids[n] = pids[n] / this.gain_old;
        }
        float gain_new = this.gain_old * extra_gain;
        float gain_corr = 1.0f;
        if (!this.isGainOnly()) {
            float p_max = 0.0f;
            for (int i2 = 0; i2 < 3; ++i2) {
                if (!(pids[i2] > p_max)) continue;
                p_max = pids[i2];
            }
            float big = this.plainParamsConstraints.pid_range * 0.7f;
            float small = this.plainParamsConstraints.pid_range * 0.1f;
            float tiny = this.plainParamsConstraints.pid_range * 0.01f;
            if (p_max > big) {
                gain_corr = p_max / big;
            } else if (p_max < small) {
                gain_corr = Math.max(p_max, tiny) / small;
            }
        }
        pids[3] = MathUtils.constrain(gain_new * gain_corr, this.plainParamsConstraints.gain[0], this.plainParamsConstraints.gain[1]);
        gain_corr = pids[3] / gain_new;
        for (int i3 = 0; i3 < 3; ++i3) {
            pids[i3] = MathUtils.constrain(pids[i3] / gain_corr, 0.0f, this.plainParamsConstraints.pid_range);
        }
        return pids;
    }

    public void fromParamsRange(float[] pids) throws IllegalArgumentException {
        float[] pid_s_scale = this.get_pid_s_scale();
        for (int i = 0; i < 3; ++i) {
            this.p_vect[i] = pids[i] * pid_s_scale[i] * pids[3];
        }
        if (this.version == 1 || this.version == 2) {
            this.p_vect[1] = this.p_vect[1] * pids[0];
        }
    }

    public String toParamsString() {
        float[] pids = this.toParamsRange();
        StringBuffer s = new StringBuffer();
        s.append(String.format("P=%.2f, I=%.2f, D=%.2f, Gain=%.2f, D-LPF=%.2f, LPF=%.2f, LPF_Q_inv=%.2f", Float.valueOf(pids[0]), Float.valueOf(pids[1]), Float.valueOf(pids[2]), Float.valueOf(pids[3]), Float.valueOf(this.getDLpfFreq()), Float.valueOf(this.getLpfFreq()), Float.valueOf(this.getLpfQInv())));
        StringBuffer s2 = new StringBuffer();
        for (int idx = 0; idx < 3; ++idx) {
            if (!this.isNotchTuned(idx)) continue;
            s2.append(" Notch#" + (idx + 1) + ": ");
            if (this.isNotchEffective(idx)) {
                s2.append(String.format("freq=%.1f, width=%.1f, gain=%.1f;", Float.valueOf(this.getNotchFreq(idx)), Float.valueOf(this.getNotchWidth(idx)), Float.valueOf(this.getNotchGain(idx))));
                continue;
            }
            s2.append("not used;");
        }
        if (s2.length() > 0) {
            s.append("\n");
            s.append(s2);
        }
        return s.toString();
    }

    public int getAxis() {
        return this.axis;
    }

    public int n_to_p_idx(int n_idx) {
        return this.param_n_to_p_idx[n_idx];
    }

    @Override
    public int getOptimizedParamsNum() {
        return this.tuned_params_num;
    }

    public void fillFromProfile(BoardProfile p, boolean useNotch) {
        float[] pids = new float[]{p.P_f[this.axis], p.I_f[this.axis], p.D_f[this.axis], p.getPIDGain(this.axis)};
        this.gain_old = p.getPIDGain(this.axis);
        this.fromParamsRange(pids);
        this.setDLpfFreq(p.d_lpfFreq[this.axis]);
        this.setLpfFreq(p.lpfEnabled[this.axis] ? (float)p.lpfFreq[this.axis] : 0.0f);
        this.setLpfQInv(p.get_LPF_Q_inv(this.axis));
        for (int idx = 0; idx < 3; ++idx) {
            if (p.isNotchEnabled(this.axis, idx) && useNotch) {
                this.configureNotchFromProfile(p, this.axis, idx);
                continue;
            }
            this.setNotchGain(idx, 0.0f);
        }
    }

    @Override
    public boolean increaseStability(float step) {
        float gain_mult = 1.0f - step;
        if (this.isGainOnly()) {
            this.p_vect[3] = this.p_vect[3] * gain_mult;
        } else {
            this.p_vect[0] = this.p_vect[0] * gain_mult;
            this.p_vect[2] = this.p_vect[2] * gain_mult;
            this.p_vect[1] = this.p_vect[1] * gain_mult;
        }
        return true;
    }

    static {
        _NOTCH_CONSTRAINTS = new float[][]{{0.05f, 1.0f, 0.0f}, {0.1f, 1.5f, 0.0f}, {0.0f, 50.0f, Float.NaN}, {0.05f, 1.0f, 0.0f}, {0.1f, 1.0f, 0.0f}, {0.0f, 50.0f, Float.NaN}, {0.05f, 1.0f, 0.0f}, {0.1f, 1.0f, 0.0f}, {0.0f, 50.0f, Float.NaN}};
        S_PARAMS_CONSTRAINTS_V1 = (float[][])Settings.concatArrays(new float[][]{{0.0f, P_RANGE_TO_S_PID_SCALE_V1[0] * 255.0f * 5.2f, P_RANGE_TO_S_PID_SCALE_V1[0] * 5.0f}, {0.0f, P_RANGE_TO_S_PID_SCALE_V1[1] * 255.0f * 5.2f, P_RANGE_TO_S_PID_SCALE_V1[1] * 5.0f}, {0.0f, P_RANGE_TO_S_PID_SCALE_V1[2] * 255.0f * 5.2f, P_RANGE_TO_S_PID_SCALE_V1[2] * 5.0f}, {0.2f, 5.0f}, {10.0f, 250.0f}, {3.0f, 630.0f}, null}, new float[][][]{_NOTCH_CONSTRAINTS});
        S_PARAMS_CONSTRAINTS_V1_EXT = (float[][])Settings.concatArrays(new float[][]{{0.0f, P_RANGE_TO_S_PID_SCALE_V1[0] * 255.0f * 50.0f, P_RANGE_TO_S_PID_SCALE_V1[0] * 5.0f}, {0.0f, P_RANGE_TO_S_PID_SCALE_V1[1] * 255.0f * 50.0f, P_RANGE_TO_S_PID_SCALE_V1[1] * 5.0f}, {0.0f, P_RANGE_TO_S_PID_SCALE_V1[2] * 255.0f * 50.0f, P_RANGE_TO_S_PID_SCALE_V1[2] * 5.0f}, {0.2f, 5.0f}, {10.0f, 525.0f}, {3.0f, 630.0f}, {0.2f, 5.2999997f}}, new float[][][]{_NOTCH_CONSTRAINTS});
        S_PARAMS_CONSTRAINTS_V3 = (float[][])Settings.concatArrays(new float[][]{{10.0f, P_RANGE_TO_S_PID_SCALE_V3[0] * 255.0f * 50.0f, 0.0f}, {10.0f, P_RANGE_TO_S_PID_SCALE_V3[1] * 255.0f * 50.0f, 0.0f}, {0.1f, P_RANGE_TO_S_PID_SCALE_V3[2] * 255.0f * 50.0f, 0.0f}, {0.2f, 5.0f}, {10.0f, 525.0f}, {3.0f, 630.0f}, {0.2f, 5.2999997f}}, new float[][][]{_NOTCH_CONSTRAINTS});
        PLAIN_PARAMS_CONSTR_V1 = new PlainParamsConstraints(255.0f, new float[]{0.12f, 5.2f});
        PLAIN_PARAMS_CONSTR_V1_EXT_V3 = new PlainParamsConstraints(255.0f, new float[]{0.02f, 50.0f});
        NORMALIZED_RANGE = new float[]{0.0f, 1.0f};
    }
}

