/*
 * Decompiled with CFR 0.152.
 */
package sbgc.bode_plot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.text.AttributedString;
import java.util.ArrayList;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.panel.CrosshairOverlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;

public class MultiAxisCrosshairOverlay
extends CrosshairOverlay {
    public String[] selectedSeriesName = new String[2];
    private ArrayList<CrosshairIdx> rangeCrosshairList = new ArrayList();

    public void addRangeCrosshair(Crosshair crosshair) {
        this.addRangeCrosshair(0, crosshair);
    }

    public void addRangeCrosshair(int idx, Crosshair crosshair) {
        this.rangeCrosshairList.add(new CrosshairIdx(crosshair, idx));
        crosshair.addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public void clearRangeCrosshairs() {
        for (CrosshairIdx crosshairIdx : this.rangeCrosshairList) {
            crosshairIdx.crosshair.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.rangeCrosshairList.clear();
    }

    public void paintOverlay(Graphics2D g2, ChartPanel chartPanel) {
        Shape savedClip = g2.getClip();
        Rectangle2D dataArea = chartPanel.getScreenDataArea();
        g2.clip(dataArea);
        JFreeChart chart = chartPanel.getChart();
        XYPlot plot = (XYPlot)chart.getPlot();
        ValueAxis xAxis = plot.getDomainAxis();
        RectangleEdge xAxisEdge = plot.getDomainAxisEdge();
        for (Crosshair ch : this.getDomainCrosshairs()) {
            if (!ch.isVisible()) continue;
            double x = ch.getValue();
            double xx = xAxis.valueToJava2D(x, dataArea, xAxisEdge);
            if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawVerticalCrosshair(g2, dataArea, xx, ch);
                continue;
            }
            this.drawHorizontalCrosshair(g2, dataArea, xx, ch);
        }
        for (CrosshairIdx c : this.rangeCrosshairList) {
            ValueAxis yAxis = plot.getRangeAxis(c.idx);
            RectangleEdge yAxisEdge = plot.getRangeAxisEdge(c.idx);
            Crosshair ch = c.crosshair;
            if (!ch.isVisible()) continue;
            double y = ch.getValue();
            double yy = yAxis.valueToJava2D(y, dataArea, yAxisEdge);
            if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawHorizontalCrosshair(g2, dataArea, yy, ch);
            } else {
                this.drawVerticalCrosshair(g2, dataArea, yy, ch);
            }
            if (c.idx >= this.selectedSeriesName.length || this.selectedSeriesName[c.idx] == null) continue;
            String name = this.selectedSeriesName[c.idx];
            int cutIdx = name.lastIndexOf("#");
            if (cutIdx != -1) {
                name = name.substring(0, cutIdx);
            }
            g2.setPaint(ch.getLabelPaint());
            g2.setFont(ch.getLabelFont());
            AttributedString a_name = new AttributedString(name);
            a_name.addAttribute(TextAttribute.BACKGROUND, Color.LIGHT_GRAY);
            g2.drawString(a_name.getIterator(), 70.0f, (float)yy - 5.0f);
        }
        g2.setClip(savedClip);
    }

    class CrosshairIdx {
        public Crosshair crosshair;
        public int idx;

        public CrosshairIdx(Crosshair crosshair, int idx) {
            this.crosshair = crosshair;
            this.idx = idx;
        }
    }
}

