/*
 * Decompiled with CFR 0.152.
 */
package sbgc.bode_plot;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import sbgc.bode_plot.BodeResult;
import sbgc.bode_plot.TestDataReader;

public class TestDataReaderCSVImpl
implements TestDataReader {
    BufferedReader reader;
    int dataCols = -1;

    public TestDataReaderCSVImpl(Reader rdr) throws IOException {
        this.reader = new BufferedReader(rdr);
    }

    @Override
    public void readHeader(BodeResult bodeResult) throws Exception {
        String line = this.reader.readLine();
        if (line == null || line.indexOf("%sbgc_test_data") != 0) {
            throw new Exception("Header line is missed!");
        }
        String[] arr = line.split(";");
        try {
            bodeResult.system = Integer.parseInt(arr[1]);
            if (bodeResult.system == 32768) {
                bodeResult.type = 2;
                this.dataCols = 3;
                bodeResult.sensor = Integer.parseInt(arr[2]);
            } else {
                bodeResult.type = 1;
                this.dataCols = 2;
                if (arr.length < 5) {
                    throw new Exception("Incomplete data.");
                }
                bodeResult.axis = Integer.parseInt(arr[2]);
                bodeResult.stimulus = Integer.parseInt(arr[3]);
                bodeResult.stimulus_gain = Integer.parseInt(arr[4]);
                if (arr.length > 6) {
                    bodeResult.startFreq = Float.parseFloat(arr[5]);
                    bodeResult.endFreq = Float.parseFloat(arr[6]);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Wrong header line: " + e.toString());
        }
    }

    @Override
    public float[] readNextRow() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        String[] lineArr = line.split(";");
        assert (lineArr.length == this.dataCols);
        float[] res = new float[this.dataCols];
        for (int i = 0; i < this.dataCols; ++i) {
            res[i] = Float.parseFloat(lineArr[i]);
        }
        return res;
    }

    @Override
    public float[][] readBuffer(float[][] lastBuf) throws IOException {
        float[][] dataBuf = new float[2048][];
        int overlapSize = lastBuf == null ? 0 : 1024;
        int lastBufStart = 2048 - overlapSize;
        if (overlapSize != 0) {
            System.arraycopy(lastBuf, lastBufStart, dataBuf, 0, overlapSize);
        }
        for (int i = overlapSize; i < 2048; ++i) {
            float[] rowArray = this.readNextRow();
            if (rowArray == null) {
                return null;
            }
            dataBuf[i] = rowArray;
        }
        return dataBuf;
    }
}

